/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.web.controller.regexp;

import org.exoplatform.component.test.BaseGateInTest;
import org.exoplatform.web.controller.regexp.RENode;
import org.exoplatform.web.controller.regexp.REParser;
import org.exoplatform.web.controller.regexp.RERenderer;

public class TestRegExpAnalyser
extends BaseGateInTest {
    private void assertAnalyse(String expectedPattern, String pattern) {
        try {
            RENode.Disjunction disjunction = new REParser((CharSequence)pattern).parseDisjunction();
            TestRegExpAnalyser.assertEquals((String)expectedPattern, (String)((StringBuilder)RERenderer.render((RENode)disjunction, (Appendable)new StringBuilder())).toString());
        }
        catch (Exception e) {
            TestRegExpAnalyser.fail((Throwable)e);
        }
    }

    public void testCharacterClass() {
        this.assertAnalyse("[a]", "[a]");
        this.assertAnalyse("[ab]", "[ab]");
        this.assertAnalyse("[ab]", "[a[b]]");
        this.assertAnalyse("[abc]", "[abc]");
        this.assertAnalyse("[abc]", "[[a]bc]");
        this.assertAnalyse("[abc]", "[a[b]c]");
        this.assertAnalyse("[abc]", "[ab[c]]");
        this.assertAnalyse("[abc]", "[[ab]c]");
        this.assertAnalyse("[abc]", "[a[bc]]");
        this.assertAnalyse("[abc]", "[[abc]]");
        this.assertAnalyse("[^a]", "[^a]");
    }

    public void testGroupContainer() {
        this.assertAnalyse("(a)", "(a)");
        this.assertAnalyse("(a(?:b))", "(a(?:b))");
        this.assertAnalyse("(?:a(b))", "(?:a(b))");
        this.assertAnalyse("(a)(?:b)", "(a)(?:b)");
        this.assertAnalyse("(a(b))", "(a(b))");
        this.assertAnalyse("(a)(b)", "(a)(b)");
        this.assertAnalyse("(?=a)", "(?=a)");
        this.assertAnalyse("(?!a)", "(?!a)");
        this.assertAnalyse("(?<=a)", "(?<=a)");
        this.assertAnalyse("(?<!a)", "(?<!a)");
    }

    public void testBilto() {
        this.assertAnalyse("[a]+", "[a]+");
    }
}

