/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.web.controller.router;

import java.util.Collections;
import org.exoplatform.web.controller.metadata.DescriptorBuilder;
import org.exoplatform.web.controller.metadata.ParamDescriptor;
import org.exoplatform.web.controller.metadata.RouteDescriptor;
import org.exoplatform.web.controller.router.AbstractTestController;
import org.exoplatform.web.controller.router.Names;
import org.exoplatform.web.controller.router.Router;

public class TestPathEncoding
extends AbstractTestController {
    public void testSegment1() throws Exception {
        Router router = DescriptorBuilder.router().add(new RouteDescriptor[]{DescriptorBuilder.route((String)"/?")}).build();
        TestPathEncoding.assertEquals((String)"/%3F", (String)router.render(Collections.emptyMap()));
    }

    public void testSegment2() throws Exception {
        Router router = DescriptorBuilder.router().add(new RouteDescriptor[]{DescriptorBuilder.route((String)"/?{p}?")}).build();
        TestPathEncoding.assertEquals((String)"/%3Fa%3F", (String)router.render(Collections.singletonMap(Names.P, "a")));
    }

    public void testSegment3() throws Exception {
        Router router = DescriptorBuilder.router().add(new RouteDescriptor[]{DescriptorBuilder.route((String)"/{p}")}).build();
        TestPathEncoding.assertEquals((String)"/%C2%A2", (String)router.render(Collections.singletonMap(Names.P, "\u00a2")));
    }

    public void testParamDefaultForm() throws Exception {
        Router router = DescriptorBuilder.router().add(new RouteDescriptor[]{DescriptorBuilder.route((String)"/{p}").with(new ParamDescriptor[]{DescriptorBuilder.pathParam((String)"p").matchedBy(".+")})}).build();
        TestPathEncoding.assertEquals(Collections.singletonMap(Names.P, "/"), router.route("/_"));
        TestPathEncoding.assertEquals(Collections.singletonMap(Names.P, "_"), router.route("/%5F"));
        TestPathEncoding.assertEquals(Collections.singletonMap(Names.P, "_/"), router.route("/%5F_"));
        TestPathEncoding.assertEquals(Collections.singletonMap(Names.P, "/_"), router.route("/_%5F"));
        TestPathEncoding.assertEquals(Collections.singletonMap(Names.P, "?"), router.route("/%3F"));
        TestPathEncoding.assertEquals((String)"/_", (String)router.render(Collections.singletonMap(Names.P, "/")));
        TestPathEncoding.assertEquals((String)"/%5F", (String)router.render(Collections.singletonMap(Names.P, "_")));
        TestPathEncoding.assertEquals((String)"/%5F_", (String)router.render(Collections.singletonMap(Names.P, "_/")));
        TestPathEncoding.assertEquals((String)"/_%5F", (String)router.render(Collections.singletonMap(Names.P, "/_")));
        TestPathEncoding.assertEquals((String)"/%3F", (String)router.render(Collections.singletonMap(Names.P, "?")));
    }

    public void testAlternativeSepartorEscape() throws Exception {
        Router router = DescriptorBuilder.router().separatorEscapedBy(':').add(new RouteDescriptor[]{DescriptorBuilder.route((String)"/{p}").with(new ParamDescriptor[]{DescriptorBuilder.pathParam((String)"p").matchedBy(".+")})}).build();
        TestPathEncoding.assertEquals(Collections.singletonMap(Names.P, "/"), router.route("/:"));
        TestPathEncoding.assertEquals(Collections.singletonMap(Names.P, "_"), router.route("/_"));
        TestPathEncoding.assertEquals(Collections.singletonMap(Names.P, ":"), router.route("/%3A"));
        TestPathEncoding.assertEquals((String)"/:", (String)router.render(Collections.singletonMap(Names.P, "/")));
        TestPathEncoding.assertEquals((String)"/_", (String)router.render(Collections.singletonMap(Names.P, "_")));
        TestPathEncoding.assertEquals((String)"/%3A", (String)router.render(Collections.singletonMap(Names.P, ":")));
    }

    public void testBug() throws Exception {
        Router router = DescriptorBuilder.router().add(new RouteDescriptor[]{DescriptorBuilder.route((String)"/{p}").with(new ParamDescriptor[]{DescriptorBuilder.pathParam((String)"p").matchedBy("[^_]+")})}).build();
        TestPathEncoding.assertNull((Object)router.route("/_"));
        TestPathEncoding.assertEquals((String)"/_", (String)router.render(Collections.singletonMap(Names.P, "/")));
        TestPathEncoding.assertNull((Object)router.route("/%5F"));
        TestPathEncoding.assertEquals((String)"", (String)router.render(Collections.singletonMap(Names.P, "_")));
    }

    public void testParamPreservePath() throws Exception {
        Router router = DescriptorBuilder.router().add(new RouteDescriptor[]{DescriptorBuilder.route((String)"/{p}").with(new ParamDescriptor[]{DescriptorBuilder.pathParam((String)"p").matchedBy("[^/]+").preservePath()})}).build();
        TestPathEncoding.assertEquals(Collections.singletonMap(Names.P, "_"), router.route("/_"));
        TestPathEncoding.assertNull((Object)router.route("//"));
        TestPathEncoding.assertEquals((String)"", (String)router.render(Collections.singletonMap(Names.P, "/")));
    }

    public void testD() throws Exception {
        Router router = DescriptorBuilder.router().add(new RouteDescriptor[]{DescriptorBuilder.route((String)"/{p}").with(new ParamDescriptor[]{DescriptorBuilder.pathParam((String)"p").matchedBy("/[a-z]+/[a-z]+/?")})}).build();
        TestPathEncoding.assertEquals(Collections.singletonMap(Names.P, "/platform/administrator"), router.route("/_platform_administrator"));
        TestPathEncoding.assertEquals(Collections.singletonMap(Names.P, "/platform/administrator"), router.route("/_platform_administrator/"));
        TestPathEncoding.assertEquals(Collections.singletonMap(Names.P, "/platform/administrator/"), router.route("/_platform_administrator_"));
        TestPathEncoding.assertEquals(Collections.singletonMap(Names.P, "/platform/administrator/"), router.route("/_platform_administrator_/"));
        TestPathEncoding.assertEquals((String)"/_platform_administrator", (String)router.render(Collections.singletonMap(Names.P, "/platform/administrator")));
        TestPathEncoding.assertEquals((String)"/_platform_administrator_", (String)router.render(Collections.singletonMap(Names.P, "/platform/administrator/")));
        TestPathEncoding.assertEquals((String)"", (String)router.render(Collections.singletonMap(Names.P, "/platform/administrator//")));
    }

    public void testWildcardPathParamWithPreservePath() throws Exception {
        Router router = DescriptorBuilder.router().add(new RouteDescriptor[]{DescriptorBuilder.route((String)"/{p}").with(new ParamDescriptor[]{DescriptorBuilder.pathParam((String)"p").matchedBy(".*").preservePath()})}).build();
        TestPathEncoding.assertEquals((String)"/", (String)router.render(Collections.singletonMap(Names.P, "")));
        TestPathEncoding.assertEquals((String)"//", (String)router.render(Collections.singletonMap(Names.P, "/")));
        TestPathEncoding.assertEquals((String)"/a", (String)router.render(Collections.singletonMap(Names.P, "a")));
        TestPathEncoding.assertEquals((String)"/a/b", (String)router.render(Collections.singletonMap(Names.P, "a/b")));
        TestPathEncoding.assertEquals(Collections.singletonMap(Names.P, ""), router.route("/"));
        TestPathEncoding.assertEquals(Collections.singletonMap(Names.P, "/"), router.route("//"));
        TestPathEncoding.assertEquals(Collections.singletonMap(Names.P, "a"), router.route("/a"));
        TestPathEncoding.assertEquals(Collections.singletonMap(Names.P, "a/b"), router.route("/a/b"));
    }

    public void testWildcardParamPathWithDefaultForm() throws Exception {
        Router router = DescriptorBuilder.router().add(new RouteDescriptor[]{DescriptorBuilder.route((String)"/{p}").with(new ParamDescriptor[]{DescriptorBuilder.pathParam((String)"p").matchedBy(".*")})}).build();
        TestPathEncoding.assertEquals((String)"/_", (String)router.render(Collections.singletonMap(Names.P, "/")));
    }
}

