/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.resource.config.tasks;

import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public abstract class AbstractSkinModule {
    protected static final Log LOG = ExoLogger.getLogger(AbstractSkinModule.class);
    protected String skinName;
    protected String cssPath;
    protected boolean overwrite;
    protected String cssPriority;

    AbstractSkinModule(String name) {
        this.skinName = name;
    }

    protected void bindingSkinName(Element element) {
        NodeList nodes = element.getElementsByTagName("skin-name");
        if (nodes == null || nodes.getLength() < 1) {
            return;
        }
        this.skinName = nodes.item(0).getFirstChild().getNodeValue();
    }

    protected void bindingCSSPath(Element element) {
        NodeList nodes = element.getElementsByTagName("css-path");
        if (nodes == null || nodes.getLength() < 1) {
            return;
        }
        this.cssPath = nodes.item(0).getFirstChild().getNodeValue();
    }

    protected void bindingOverwrite(Element element) {
        NodeList nodes = element.getElementsByTagName("overwrite");
        if (nodes == null || nodes.getLength() < 1) {
            this.setOverwrite(false);
        } else {
            this.setOverwrite("true".equals(nodes.item(0).getFirstChild().getNodeValue()));
        }
    }

    protected void bindingCSSPriority(Element element) {
        NodeList nodes = element.getElementsByTagName("css-priority");
        if (nodes == null || nodes.getLength() < 1) {
            return;
        }
        this.cssPriority = nodes.item(0).getFirstChild().getNodeValue();
    }

    public void setSkinName(String name) {
        this.skinName = name;
    }

    public void setCSSPath(String cssPath) {
        this.cssPath = cssPath;
    }

    public void setOverwrite(boolean overwrite) {
        this.overwrite = overwrite;
    }

    public void setCSSPriority(String cssPriority) {
        this.cssPriority = cssPriority;
    }
}

