/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.resource;

import jakarta.servlet.ServletContext;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.portal.resource.AbstractWebResourceTest;
import org.exoplatform.test.mocks.servlet.MockServletContext;
import org.exoplatform.web.application.JavascriptManager;
import org.exoplatform.web.application.RequireJS;
import org.exoplatform.web.application.javascript.JavascriptConfigParser;
import org.exoplatform.web.application.javascript.JavascriptConfigService;
import org.gatein.portal.controller.resource.ResourceId;
import org.gatein.portal.controller.resource.ResourceScope;
import org.gatein.portal.controller.resource.script.FetchMap;

public class TestJavascriptManager
extends AbstractWebResourceTest {
    private JavascriptManager jsManager;
    private static boolean isFirstStartup = true;

    protected void setUp() throws Exception {
        super.setUp();
        PortalContainer portalContainer = this.getContainer();
        JavascriptConfigService jsService = (JavascriptConfigService)portalContainer.getComponentInstanceOfType(JavascriptConfigService.class);
        if (isFirstStartup) {
            URL url = portalContainer.getPortalClassLoader().getResource("mockwebapp/gatein-resources.xml");
            JavascriptConfigParser.processConfigResource((InputStream)url.openStream(), (JavascriptConfigService)jsService, (ServletContext)new MockServletContext(this){

                public String getContextPath() {
                    return "mockwebapp";
                }
            });
            isFirstStartup = false;
        }
        this.jsManager = new JavascriptManager();
    }

    public void testAddingScriptResources() throws IOException {
        FetchMap scriptResources = this.jsManager.getScriptResources();
        TestJavascriptManager.assertEquals((int)0, (int)scriptResources.size());
        this.jsManager.loadScriptResource(ResourceScope.SHARED, "script1");
        scriptResources = this.jsManager.getScriptResources();
        TestJavascriptManager.assertEquals((int)1, (int)scriptResources.size());
        this.jsManager.loadScriptResource(ResourceScope.SHARED, "script1");
        scriptResources = this.jsManager.getScriptResources();
        TestJavascriptManager.assertEquals((int)1, (int)scriptResources.size());
        TestJavascriptManager.assertTrue((boolean)scriptResources.containsKey((Object)new ResourceId(ResourceScope.SHARED, "script1")));
    }

    public void testRequireJS() {
        RequireJS require = this.jsManager.require("SHARED/jquery", "$");
        require.addScripts("$('body').css('color : red');");
        String expected = "window.require([\"SHARED/base\",\"SHARED/jquery\"],function(base,$) {\ntry {$('body').css('color : red');} catch(unhandledError) { console.error(unhandledError); }});";
        TestJavascriptManager.assertEquals((String)expected, (String)require.toString());
    }

    public void testNoAlias() {
        RequireJS require = this.jsManager.require("SHARED/webui");
        require.require("SHARED/jquery", "$");
        String expected = "window.require([\"SHARED/base\",\"SHARED/jquery\",\"SHARED/webui\"],function(base,$) {\n});";
        TestJavascriptManager.assertEquals((String)expected, (String)require.toString());
    }

    public void testAddOnLoadJavascript() {
        this.jsManager.require("foo", "bar").addScripts("bar.zoo;");
        String onload = "eXo.core.Browser.init";
        this.jsManager.addOnLoadJavascript((CharSequence)onload);
        String expected = "window.require([\"SHARED/base\",\"foo\"],function(base,bar) {\ntry {bar.zoo;} catch(unhandledError) { console.error(unhandledError); }try {base.Browser.addOnLoadCallback('mid" + Math.abs(onload.hashCode()) + "'," + onload + ");} catch(unhandledError) { console.error(unhandledError); }try {typeof base !== 'undefined' && base?.Browser && base.Browser.onLoad();} catch(unhandledError) { console.error(unhandledError); }try {} catch(unhandledError) { console.error(unhandledError); }});";
        TestJavascriptManager.assertEquals((String)expected, (String)this.jsManager.getJavaScripts());
    }
}

