/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.resource;

import java.io.InputStream;
import java.security.MessageDigest;
import junit.framework.TestCase;
import org.gatein.common.io.IOTools;

public class TestXSDCorruption
extends TestCase {
    private void assertHash(String expected, String resourcePath) throws Exception {
        InputStream in = Thread.currentThread().getContextClassLoader().getResourceAsStream(resourcePath);
        TestXSDCorruption.assertNotNull((Object)in);
        byte[] bytes = IOTools.getBytes((InputStream)in);
        MessageDigest digester = MessageDigest.getInstance("MD5");
        digester.update(bytes);
        StringBuilder sb = new StringBuilder();
        for (byte b : digester.digest()) {
            String hex = Integer.toHexString(b);
            if (hex.length() == 1) {
                sb.append('0');
                sb.append(hex.charAt(0));
                continue;
            }
            sb.append(hex.substring(hex.length() - 2));
        }
        TestXSDCorruption.assertEquals((String)expected, (String)sb.toString());
    }

    public void testGateInResources1_x() throws Exception {
        this.assertHash("a5df21458f0bea86789f5bfb264ee099", "gatein_resources_1_0.xsd");
        this.assertHash("f5e48fdbfd1631ab0278a097447a3892", "gatein_resources_1_1.xsd");
        this.assertHash("7925f1cd0a91dcb6a95f8dcb87973792", "gatein_resources_1_2.xsd");
        this.assertHash("5a8602c916aee90249d7e5b8885de56e", "gatein_resources_1_3.xsd");
        this.assertHash("2c088070b254bc324a29fcf91aef382a", "gatein_resources_1_4.xsd");
    }
}

