/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.resource;

import java.util.Arrays;
import org.exoplatform.portal.resource.AbstractSkinServiceTest;
import org.exoplatform.portal.resource.Skin;
import org.exoplatform.portal.resource.SkinConfig;
import org.exoplatform.portal.resource.SkinURL;
import org.exoplatform.services.resources.Orientation;
import org.exoplatform.web.controller.metadata.DescriptorBuilder;
import org.exoplatform.web.controller.metadata.ParamDescriptor;
import org.exoplatform.web.controller.metadata.RouteDescriptor;
import org.exoplatform.web.controller.router.Router;
import org.exoplatform.web.controller.router.RouterConfigException;

public class TestSkinServiceInDevelopingMode
extends AbstractSkinServiceTest {
    private static boolean isFirstStartup = true;

    @Override
    boolean isDevelopingMode() {
        return true;
    }

    @Override
    boolean setUpTestEnvironment() {
        return isFirstStartup;
    }

    @Override
    Router getRouter() {
        try {
            Router router = DescriptorBuilder.router().add(new RouteDescriptor[]{DescriptorBuilder.route((String)"/skins/{gtn:version}/{gtn:resource}{gtn:compress}{gtn:orientation}.css").with(new ParamDescriptor[]{DescriptorBuilder.routeParam((String)"gtn:handler").withValue("skin")}).with(new ParamDescriptor[]{DescriptorBuilder.pathParam((String)"gtn:version").matchedBy("[^/]*").preservePath()}).with(new ParamDescriptor[]{DescriptorBuilder.pathParam((String)"gtn:orientation").matchedBy("-(lt)|-(rt)|").captureGroup(true)}).with(new ParamDescriptor[]{DescriptorBuilder.pathParam((String)"gtn:compress").matchedBy("-(min)|").captureGroup(true)}).with(new ParamDescriptor[]{DescriptorBuilder.pathParam((String)"gtn:resource").matchedBy(".+?").preservePath()})}).build();
            return router;
        }
        catch (RouterConfigException e) {
            return null;
        }
    }

    @Override
    void touchSetUp() {
        isFirstStartup = false;
    }

    public void testCompositeSkin() throws Exception {
        SkinConfig fSkin = this.skinService.getSkin("mockwebapp/FirstPortlet", "TestSkin");
        SkinConfig sSkin = this.skinService.getSkin("mockwebapp/SecondPortlet", "TestSkin");
        TestSkinServiceInDevelopingMode.assertNotNull((Object)fSkin);
        TestSkinServiceInDevelopingMode.assertNotNull((Object)sSkin);
        Skin merged = this.skinService.merge(Arrays.asList(fSkin, sSkin));
        SkinURL url = merged.createURL(this.controllerCtx);
        url.setOrientation(Orientation.LT);
        TestSkinServiceInDevelopingMode.assertEquals((String)"@import url(/portal/skins/PORTAL-VERSION/mockwebapp/skin/FirstPortlet-lt.css);\n@import url(/portal/skins/PORTAL-VERSION/mockwebapp/skin/SecondPortlet-lt.css);", (String)this.skinService.getCSS(TestSkinServiceInDevelopingMode.newControllerContext(this.getRouter(), url.toString()), false));
        url.setOrientation(Orientation.RT);
        TestSkinServiceInDevelopingMode.assertEquals((String)"@import url(/portal/skins/PORTAL-VERSION/mockwebapp/skin/FirstPortlet-rt.css);\n@import url(/portal/skins/PORTAL-VERSION/mockwebapp/skin/SecondPortlet-rt.css);", (String)this.skinService.getCSS(TestSkinServiceInDevelopingMode.newControllerContext(this.getRouter(), url.toString()), false));
    }

    public void testCache() throws Exception {
        String resource = "/path/to/test/caching.css";
        String url = this.newSimpleSkin(resource).createURL(this.controllerCtx).toString();
        resResolver.addResource(resource, "foo");
        TestSkinServiceInDevelopingMode.assertEquals((String)"foo", (String)this.skinService.getCSS(TestSkinServiceInDevelopingMode.newControllerContext(this.getRouter(), url), false));
        resResolver.addResource(resource, "bar");
        TestSkinServiceInDevelopingMode.assertEquals((String)"bar", (String)this.skinService.getCSS(TestSkinServiceInDevelopingMode.newControllerContext(this.getRouter(), url), false));
    }

    public void testProcessImportCSS() throws Exception {
        String parent = "/process/import/css.css";
        String parentURL = this.newSimpleSkin(parent).createURL(this.controllerCtx).toString();
        resResolver.addResource(parent, "@import url(Portlet/Stylesheet.css); aaa;");
        TestSkinServiceInDevelopingMode.assertEquals((String)"@import url(/portal/skins/PORTAL-VERSION/process/import/Portlet/Stylesheet-lt.css); aaa;", (String)this.skinService.getCSS(TestSkinServiceInDevelopingMode.newControllerContext(this.getRouter(), parentURL), false));
        resResolver.addResource(parent, "@import url('/Portlet/Stylesheet.css'); aaa;");
        TestSkinServiceInDevelopingMode.assertEquals((String)"@import url('/portal/skins/PORTAL-VERSION/Portlet/Stylesheet-lt.css'); aaa;", (String)this.skinService.getCSS(TestSkinServiceInDevelopingMode.newControllerContext(this.getRouter(), parentURL), false));
        resResolver.addResource(parent, "@import url(childCSS/child.css);  background:url(images/foo.gif);");
        String child = "/process/import/childCSS/child.css";
        resResolver.addResource(child, "background:url(bar.gif);");
        TestSkinServiceInDevelopingMode.assertEquals((String)"@import url(/portal/skins/PORTAL-VERSION/process/import/childCSS/child-lt.css);  background:url(/process/import/images/foo.gif);", (String)this.skinService.getCSS(TestSkinServiceInDevelopingMode.newControllerContext(this.getRouter(), parentURL), false));
    }

    public void testLastModifiedSince() throws Exception {
        String resource = "/last/modify/since.css";
        SkinURL skinURL = this.newSimpleSkin(resource).createURL(this.controllerCtx);
        resResolver.addResource(resource, "foo");
        TestSkinServiceInDevelopingMode.assertTrue((this.skinService.getCSS(TestSkinServiceInDevelopingMode.newControllerContext(this.getRouter(), skinURL.toString()), false).length() > 0 ? 1 : 0) != 0);
        TestSkinServiceInDevelopingMode.assertTrue((this.skinService.getLastModified(TestSkinServiceInDevelopingMode.newControllerContext(this.getRouter(), skinURL.toString())) > 0L ? 1 : 0) != 0);
        skinURL.setOrientation(Orientation.RT);
        TestSkinServiceInDevelopingMode.assertTrue((this.skinService.getLastModified(TestSkinServiceInDevelopingMode.newControllerContext(this.getRouter(), skinURL.toString())) > 0L ? 1 : 0) != 0);
    }
}

