/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.resource.compressor;

import com.google.javascript.jscomp.CompilationLevel;
import com.google.javascript.jscomp.Compiler;
import com.google.javascript.jscomp.CompilerOptions;
import com.google.javascript.jscomp.SourceFile;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Field;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Map;
import org.exoplatform.container.component.ComponentPlugin;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.Parameter;
import org.exoplatform.container.xml.ValueParam;
import org.exoplatform.portal.resource.AbstractWebResourceTest;
import org.exoplatform.portal.resource.compressor.ResourceCompressor;
import org.exoplatform.portal.resource.compressor.ResourceCompressorException;
import org.exoplatform.portal.resource.compressor.ResourceCompressorPlugin;
import org.exoplatform.portal.resource.compressor.ResourceType;
import org.exoplatform.portal.resource.compressor.impl.ClosureCompressorPlugin;
import org.exoplatform.portal.resource.compressor.impl.JSMinCompressorPlugin;
import org.exoplatform.portal.resource.compressor.impl.ResourceCompressorService;

public class TestResourceCompressorService
extends AbstractWebResourceTest {
    public void testInitializing() {
        ResourceCompressorService compressor = (ResourceCompressorService)this.getContainer().getComponentInstanceOfType(ResourceCompressor.class);
        TestResourceCompressorService.assertNotNull((Object)compressor);
        TestResourceCompressorService.assertTrue((boolean)(compressor instanceof ResourceCompressorService));
        TestResourceCompressorService.assertNotNull((Object)compressor.getCompressorPlugin(ResourceType.JAVASCRIPT, "MockCompressorPlugin"));
        TestResourceCompressorService.assertNotNull((Object)compressor.getCompressorPlugin(ResourceType.JAVASCRIPT, "JSMinCompressorPlugin"));
    }

    public void testPriority() {
        ResourceCompressorService compressor = (ResourceCompressorService)this.getContainer().getComponentInstanceOfType(ResourceCompressor.class);
        ResourceCompressorPlugin plugin = compressor.getHighestPriorityCompressorPlugin(ResourceType.JAVASCRIPT);
        TestResourceCompressorService.assertTrue((boolean)(plugin instanceof JSMinCompressorPlugin));
    }

    public void testJSMinCompressing() throws IOException {
        File jsFile = new File("src/test/resources/javascript.js");
        File jsCompressedFile = new File("target/jsmin-compressed-file.js");
        FileReader reader = new FileReader(jsFile);
        FileWriter writer = new FileWriter(jsCompressedFile);
        ResourceCompressorService compressor = (ResourceCompressorService)this.getContainer().getComponentInstanceOfType(ResourceCompressor.class);
        try {
            compressor.compress((Reader)reader, (Writer)writer, ResourceType.JAVASCRIPT);
        }
        catch (Exception e) {
            TestResourceCompressorService.fail((String)e.getLocalizedMessage());
        }
        ((Writer)writer).close();
        TestResourceCompressorService.assertTrue((jsCompressedFile.length() > 0L ? 1 : 0) != 0);
        TestResourceCompressorService.assertTrue((jsFile.length() > jsCompressedFile.length() ? 1 : 0) != 0);
        this.log.info((Object)("The original javascript (" + this.getFileSize(jsFile) + ") is compressed by JSMIN into " + jsCompressedFile.getAbsolutePath() + " (" + this.getFileSize(jsCompressedFile) + ")"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testClosureCompressing() throws Exception {
        File jsFile = new File("src/test/resources/javascript.js");
        File jsCompressedFile = new File("target/closure-compressed-file.js");
        FileReader reader = new FileReader(jsFile);
        FileWriter writer = new FileWriter(jsCompressedFile);
        ResourceCompressorService compressor = (ResourceCompressorService)this.getContainer().getComponentInstanceOfType(ResourceCompressor.class);
        InitParams priorityParam = new InitParams();
        ValueParam param = new ValueParam();
        param.setName("plugin.priority");
        param.setValue("10");
        priorityParam.addParameter((Parameter)param);
        ClosureCompressorPlugin plugin = new ClosureCompressorPlugin(priorityParam);
        compressor.registerCompressorPlugin((ComponentPlugin)plugin);
        try {
            compressor.compress((Reader)reader, (Writer)writer, ResourceType.JAVASCRIPT);
        }
        catch (Exception e) {
            TestResourceCompressorService.fail((String)e.getLocalizedMessage());
        }
        finally {
            this.unregisterCompressorPlugin(compressor, (ResourceCompressorPlugin)plugin);
            ((Reader)reader).close();
            ((Writer)writer).close();
        }
        TestResourceCompressorService.assertTrue((jsCompressedFile.length() > 0L ? 1 : 0) != 0);
        TestResourceCompressorService.assertTrue((jsFile.length() > jsCompressedFile.length() ? 1 : 0) != 0);
        this.log.info((Object)("The original javascript (" + this.getFileSize(jsFile) + ") is compressed by CLOSURE COMPILER into " + jsCompressedFile.getAbsolutePath() + " (" + this.getFileSize(jsCompressedFile) + ")"));
        String expectedJS = this.closureCompress(jsFile);
        TestResourceCompressorService.assertEquals((long)expectedJS.length(), (long)jsCompressedFile.length());
    }

    private void unregisterCompressorPlugin(ResourceCompressorService compressor, ResourceCompressorPlugin plugin) throws Exception {
        Field pluginsField = compressor.getClass().getDeclaredField("plugins");
        pluginsField.setAccessible(true);
        Map plugins = (Map)pluginsField.get(compressor);
        ((List)plugins.get(plugin.getResourceType())).remove(plugin);
    }

    private String closureCompress(File input) throws Exception {
        SourceFile jsInput;
        Compiler compiler = new Compiler();
        CompilerOptions options = new CompilerOptions();
        options.setLanguageIn(CompilerOptions.LanguageMode.ECMASCRIPT_2016);
        options.setLanguageOut(CompilerOptions.LanguageMode.ECMASCRIPT5);
        CompilationLevel.SIMPLE_OPTIMIZATIONS.setOptionsForCompilationLevel(options);
        SourceFile extern = SourceFile.fromCode((String)"extern", (String)"");
        try {
            Path path = Paths.get(input.getPath(), new String[0]);
            jsInput = SourceFile.fromPath((Path)path, (Charset)StandardCharsets.UTF_8);
        }
        catch (Exception ex) {
            throw new ResourceCompressorException(ex);
        }
        compiler.compile(extern, jsInput, options);
        return compiler.toSource();
    }

    public void testYUICSSCompressing() throws IOException {
        File cssFile = new File("src/test/resources/Stylesheet.css");
        File compressedCssFile = new File("target/yui-compressed-file.css");
        FileReader reader = new FileReader(cssFile);
        FileWriter writer = new FileWriter(compressedCssFile);
        ResourceCompressorService compressor = (ResourceCompressorService)this.getContainer().getComponentInstanceOfType(ResourceCompressor.class);
        try {
            compressor.compress((Reader)reader, (Writer)writer, ResourceType.STYLESHEET);
        }
        catch (Exception e) {
            TestResourceCompressorService.fail((String)e.getLocalizedMessage());
        }
        ((Writer)writer).close();
        TestResourceCompressorService.assertTrue((compressedCssFile.length() > 0L ? 1 : 0) != 0);
        TestResourceCompressorService.assertTrue((cssFile.length() > compressedCssFile.length() ? 1 : 0) != 0);
        this.log.info((Object)("The original CSS (" + this.getFileSize(cssFile) + ") is compressed by YUI library into " + compressedCssFile.getAbsolutePath() + " (" + this.getFileSize(compressedCssFile) + ")"));
    }

    private String getFileSize(File file) {
        return file.length() / 1024L + " KB";
    }
}

