/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.resource;

import java.io.Closeable;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import junit.framework.TestCase;
import org.gatein.common.io.IOTools;
import org.xml.sax.SAXException;

public class TestXSDValidator
extends TestCase {
    private static final Validator VALIDATOR;
    private static final ClassLoader CTX_LOADER;
    private static final Map<String, Boolean> testScenarios;

    public static Validator createXSDValidator(URL xsdFile) {
        SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        try {
            factory.setFeature("http://apache.org/xml/features/validation/schema-full-checking", false);
            return factory.newSchema(xsdFile).newValidator();
        }
        catch (SAXException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void testXSDValidation() {
        for (Map.Entry<String, Boolean> testScene : testScenarios.entrySet()) {
            this.validateDocument(testScene.getKey(), testScene.getValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void validateDocument(String fileName, boolean failureExpect) {
        InputStream in = CTX_LOADER.getResourceAsStream("validator/" + fileName);
        try {
            VALIDATOR.validate(new StreamSource(in));
            if (failureExpect) {
                TestXSDValidator.fail();
            }
        }
        catch (Exception ex) {
            if (!failureExpect) {
                StringWriter sw = new StringWriter();
                PrintWriter out = new PrintWriter(sw);
                ex.printStackTrace(out);
                out.close();
                TestXSDValidator.fail((String)sw.toString());
            }
        }
        finally {
            IOTools.safeClose((Closeable)in);
            VALIDATOR.reset();
        }
    }

    static {
        testScenarios = new HashMap<String, Boolean>();
        CTX_LOADER = Thread.currentThread().getContextClassLoader();
        URL xsdFile = CTX_LOADER.getResource("gatein_resources_1_4.xsd");
        VALIDATOR = TestXSDValidator.createXSDValidator(xsdFile);
        testScenarios.put("f0.xml", false);
        testScenarios.put("f1.xml", false);
        testScenarios.put("f2.xml", true);
        testScenarios.put("f3.xml", true);
        testScenarios.put("f4.xml", true);
        testScenarios.put("f5.xml", false);
        testScenarios.put("f6.xml", false);
        testScenarios.put("f7.xml", true);
        testScenarios.put("f8.xml", true);
        testScenarios.put("f9.xml", false);
        testScenarios.put("differScopes.xml", false);
        testScenarios.put("duplicateShared.xml", true);
        testScenarios.put("duplicatePortal.xml", true);
        testScenarios.put("duplicatePortlet.xml", true);
    }
}

