/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.web.login.recovery;

import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.Parameter;
import org.exoplatform.container.xml.ValueParam;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.idm.PicketLinkIDMService;
import org.exoplatform.services.organization.idm.UserDAOImpl;
import org.exoplatform.services.organization.idm.UserImpl;
import org.exoplatform.services.organization.idm.externalstore.PicketLinkIDMExternalStoreService;
import org.exoplatform.web.login.recovery.DefaultChangePasswordConnector;
import org.exoplatform.web.security.security.CookieTokenService;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class DefaultChangePasswordConnectorTest {
    @Mock
    OrganizationService organizationService;
    @Mock
    CookieTokenService cookieTokenService;
    @Mock
    PicketLinkIDMService picketLinkIDMService;
    @Mock
    PicketLinkIDMExternalStoreService picketLinkIDMExternalStoreService;

    @Test
    public void testChangePasswordFromInternalStore() throws Exception {
        UserImpl userTest = new UserImpl("utest");
        userTest.setFirstName("User");
        userTest.setLastName("Test");
        userTest.setEmail("user.test@acme.com");
        userTest.setPassword("P@ssword123");
        userTest.setOriginatingStore("internal");
        UserDAOImpl userHandler = (UserDAOImpl)Mockito.mock(UserDAOImpl.class);
        Mockito.when((Object)userHandler.findUserByName(userTest.getUserName())).thenReturn((Object)userTest);
        Mockito.when((Object)this.organizationService.getUserHandler()).thenReturn((Object)userHandler);
        InitParams initParams = new InitParams();
        ((CookieTokenService)Mockito.doNothing().when((Object)this.cookieTokenService)).deleteTokensByUsernameAndType((String)ArgumentMatchers.any(), (String)ArgumentMatchers.any());
        DefaultChangePasswordConnector defaultChangePasswordConnector = new DefaultChangePasswordConnector(initParams, this.organizationService, this.cookieTokenService);
        String newPassword = "newPassword";
        defaultChangePasswordConnector.changePassword(userTest.getUserName(), newPassword);
        ArgumentCaptor argument = ArgumentCaptor.forClass(User.class);
        ((UserDAOImpl)Mockito.verify((Object)userHandler)).saveUser((User)argument.capture(), Mockito.anyBoolean());
        Assert.assertEquals((Object)newPassword, (Object)((User)argument.getValue()).getPassword());
        ((UserDAOImpl)Mockito.verify((Object)userHandler, (VerificationMode)Mockito.times((int)1))).saveUser((User)ArgumentMatchers.any(), Mockito.anyBoolean());
        ((CookieTokenService)Mockito.verify((Object)this.cookieTokenService, (VerificationMode)Mockito.times((int)1))).deleteTokensByUsernameAndType("utest", "");
    }

    @Test
    public void testChangePasswordFromExternalStoreAndNotAllowed() throws Exception {
        UserImpl userTest = new UserImpl("utest");
        userTest.setFirstName("User");
        userTest.setLastName("Test");
        userTest.setEmail("user.test@acme.com");
        userTest.setPassword("P@ssword123");
        userTest.setOriginatingStore("external");
        UserDAOImpl userHandler = (UserDAOImpl)Mockito.mock(UserDAOImpl.class);
        Mockito.when((Object)userHandler.findUserByName(userTest.getUserName())).thenReturn((Object)userTest);
        Mockito.when((Object)this.organizationService.getUserHandler()).thenReturn((Object)userHandler);
        InitParams initParams = new InitParams();
        ValueParam valueParam = new ValueParam();
        valueParam.setName("allowChangeExternalPassword");
        valueParam.setValue("false");
        initParams.addParameter((Parameter)valueParam);
        DefaultChangePasswordConnector defaultChangePasswordConnector = new DefaultChangePasswordConnector(initParams, this.organizationService, this.cookieTokenService);
        String newPassword = "newPassword";
        try {
            defaultChangePasswordConnector.changePassword(userTest.getUserName(), newPassword);
        }
        catch (Exception exception) {
            // empty catch block
        }
        ((UserDAOImpl)Mockito.verify((Object)userHandler, (VerificationMode)Mockito.times((int)0))).saveUser((User)ArgumentMatchers.any(), Mockito.anyBoolean());
        ((CookieTokenService)Mockito.verify((Object)this.cookieTokenService, (VerificationMode)Mockito.times((int)0))).deleteTokensByUsernameAndType("utest", "");
    }
}

