/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.spring.web.security;

import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletRequestWrapper;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpServletResponseWrapper;
import java.io.IOException;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.web.AbstractFilter;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.Authenticator;
import org.exoplatform.services.security.ConversationRegistry;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.security.IdentityRegistry;
import org.exoplatform.services.security.StateKey;
import org.exoplatform.services.security.web.HttpSessionStateKey;
import org.exoplatform.web.login.LoginUtils;
import org.exoplatform.web.security.security.CookieTokenService;
import org.gatein.wci.ServletContainerFactory;
import org.gatein.wci.security.Credentials;

public class PortalRememberMeFilter
extends AbstractFilter {
    private static final Log LOG = ExoLogger.getLogger(PortalRememberMeFilter.class);
    private static ConversationRegistry conversationRegistry;
    private static IdentityRegistry identityRegistry;
    private static Authenticator authenticator;

    public void doFilter(ServletRequest req, ServletResponse resp, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)req;
        HttpServletResponse response = (HttpServletResponse)resp;
        if (request.getRemoteUser() == null) {
            this.login(request, response);
        }
        chain.doFilter(req, resp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void login(HttpServletRequest request, HttpServletResponse response) {
        block6: {
            ExoContainer currentContainer = ExoContainerContext.getCurrentContainerIfPresent();
            ExoContainer container = this.getContainer();
            ExoContainerContext.setCurrentContainer((ExoContainer)container);
            try {
                String username = this.getRememberMeTokenUser(request);
                if (username == null) break block6;
                try {
                    Identity identity;
                    this.login(request, response, new Credentials(username, ""));
                    if (request.getRemoteUser() != null && (identity = this.getIdentity(container, username)) != null) {
                        ConversationState state = new ConversationState(identity);
                        PortalRememberMeFilter.getConversationRegistry(container).register((StateKey)new HttpSessionStateKey(request.getSession()), state);
                        ConversationState.setCurrent((ConversationState)state);
                    }
                }
                catch (Exception e) {
                    this.clearInvalidToken(request, response);
                    LOG.warn("Error while logging in user {} using rememberme token, invalidate token", new Object[]{username, e});
                }
            }
            finally {
                ExoContainerContext.setCurrentContainer((ExoContainer)currentContainer);
            }
        }
    }

    private void login(HttpServletRequest request, HttpServletResponse response, Credentials credentials) throws ServletException, IOException {
        HttpServletRequestWrapper wrappedRequest = new HttpServletRequestWrapper(this, request){

            public String getContextPath() {
                return "/portal";
            }

            public String getRequestURI() {
                return "/portal/login";
            }
        };
        HttpServletResponseWrapper wrappedResponse = new HttpServletResponseWrapper(this, response){

            public void sendRedirect(String location) throws IOException {
            }

            public void setStatus(int sc) {
            }
        };
        ServletContainerFactory.getServletContainer().login((HttpServletRequest)wrappedRequest, (HttpServletResponse)wrappedResponse, credentials);
    }

    private String getRememberMeTokenUser(HttpServletRequest request) {
        String token = LoginUtils.getRememberMeTokenCookie(request);
        if (token != null) {
            ExoContainer container = this.getContainer();
            CookieTokenService tokenservice = (CookieTokenService)container.getComponentInstanceOfType(CookieTokenService.class);
            return tokenservice.validateToken(token, false);
        }
        return null;
    }

    private void clearInvalidToken(HttpServletRequest request, HttpServletResponse response) {
        if (request.getRemoteUser() == null) {
            Cookie cookie = new Cookie("rememberme", "");
            cookie.setPath("/");
            cookie.setMaxAge(0);
            cookie.setHttpOnly(true);
            cookie.setSecure(request.isSecure());
            response.addCookie(cookie);
        }
    }

    private Identity getIdentity(ExoContainer container, String userId) {
        Identity identity = PortalRememberMeFilter.getIdentityRegistry(container).getIdentity(userId);
        if (identity == null) {
            try {
                identity = PortalRememberMeFilter.getAuthenticator(container).createIdentity(userId);
                identityRegistry.register(identity);
            }
            catch (Exception e) {
                LOG.warn("Unable restore identity of user {}", new Object[]{userId, e});
            }
        }
        return identity;
    }

    private static IdentityRegistry getIdentityRegistry(ExoContainer container) {
        if (identityRegistry == null) {
            identityRegistry = (IdentityRegistry)container.getComponentInstanceOfType(IdentityRegistry.class);
        }
        return identityRegistry;
    }

    private static ConversationRegistry getConversationRegistry(ExoContainer container) {
        if (conversationRegistry == null) {
            conversationRegistry = (ConversationRegistry)container.getComponentInstanceOfType(ConversationRegistry.class);
        }
        return conversationRegistry;
    }

    private static Authenticator getAuthenticator(ExoContainer container) {
        if (authenticator == null) {
            authenticator = (Authenticator)container.getComponentInstanceOfType(Authenticator.class);
        }
        return authenticator;
    }
}

