/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.web.security.security;

import java.util.concurrent.ConcurrentHashMap;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.web.security.PortalToken;
import org.exoplatform.web.security.security.PlainTokenService;

public class TransientTokenService
extends PlainTokenService<PortalToken, String> {
    protected final ConcurrentHashMap<String, PortalToken> tokens = new ConcurrentHashMap();

    public TransientTokenService(InitParams initParams) {
        super(initParams);
    }

    @Override
    public String createToken(String username) {
        if (this.validityMillis < 0L) {
            throw new IllegalArgumentException();
        }
        if (username == null) {
            throw new NullPointerException();
        }
        String tokenId = this.nextTokenId();
        long expirationTimeMillis = System.currentTimeMillis() + this.validityMillis;
        this.tokens.put(tokenId, new PortalToken(expirationTimeMillis, username));
        return tokenId;
    }

    @Override
    public PortalToken getToken(String id, String type) {
        return this.tokens.get(id);
    }

    @Override
    public PortalToken getToken(String id) {
        return this.getToken(id, "");
    }

    @Override
    protected String decodeKey(String stringKey) {
        return stringKey;
    }

    @Override
    public PortalToken deleteToken(String id, String tokenType) {
        PortalToken token = this.tokens.get(id);
        this.tokens.remove(id);
        return token;
    }

    @Override
    public PortalToken deleteToken(String id) {
        return this.deleteToken(id, "");
    }

    public String[] getAllTokens() {
        return ((ConcurrentHashMap.CollectionView)((Object)this.tokens.keySet())).toArray(new String[0]);
    }

    @Override
    public long size() {
        return this.tokens.size();
    }
}

