/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.web.login.recovery;

import jakarta.servlet.RequestDispatcher;
import jakarta.servlet.ServletContext;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import org.exoplatform.commons.utils.I18N;
import org.exoplatform.commons.utils.PropertyManager;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.portal.branding.BrandingService;
import org.exoplatform.portal.resource.SkinService;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.UserHandler;
import org.exoplatform.services.organization.UserStatus;
import org.exoplatform.services.resources.LocaleConfigService;
import org.exoplatform.services.resources.ResourceBundleService;
import org.exoplatform.services.resources.impl.LocaleConfigImpl;
import org.exoplatform.web.ControllerContext;
import org.exoplatform.web.WebAppController;
import org.exoplatform.web.application.javascript.JavascriptConfigService;
import org.exoplatform.web.controller.QualifiedName;
import org.exoplatform.web.controller.router.Router;
import org.exoplatform.web.login.recovery.PasswordRecoveryHandler;
import org.exoplatform.web.login.recovery.PasswordRecoveryService;
import org.json.JSONObject;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.Silent.class)
public class PasswordRecoveryHandlerTest {
    private static final Locale REQUEST_LOCALE = Locale.ENGLISH;
    private static final String CONTEXT_PATH = "/portal";
    private static final String INITIAL_URI = "initUri";
    private static final String TOKEN_VALUE = "tokenValue";
    @Mock
    private ServletContext servletContext;
    @Mock
    private PortalContainer container;
    @Mock
    private PasswordRecoveryService passwordRecoveryService;
    @Mock
    private ResourceBundleService resourceBundleService;
    @Mock
    private ResourceBundle resourceBundle;
    @Mock
    private OrganizationService organizationService;
    @Mock
    private UserHandler userHandler;
    @Mock
    private LocaleConfigService localeConfigService;
    @Mock
    private BrandingService brandingService;
    @Mock
    private JavascriptConfigService javascriptConfigService;
    @Mock
    private WebAppController controller;
    @Mock
    private Router router;
    @Mock
    private HttpServletRequest request;
    @Mock
    private HttpServletResponse response;
    @Mock
    private RequestDispatcher requestDispatcher;
    @Mock
    private SkinService skinService;
    private ControllerContext controllerContext;
    private PasswordRecoveryHandler passwordRecoveryHandler;
    private Map<String, Object> applicationParameters;

    @Before
    public void setUp() throws Exception {
        this.applicationParameters = null;
        ExoContainerContext.setCurrentContainer((ExoContainer)this.container);
        Mockito.lenient().when((Object)((ResourceBundleService)this.container.getComponentInstanceOfType(ResourceBundleService.class))).thenReturn((Object)this.resourceBundleService);
        Mockito.when((Object)this.container.getPortalContext()).thenReturn((Object)this.servletContext);
        Mockito.when((Object)this.request.getContextPath()).thenReturn((Object)CONTEXT_PATH);
        Mockito.when((Object)this.servletContext.getContextPath()).thenReturn((Object)CONTEXT_PATH);
        Mockito.when((Object)this.request.getLocale()).thenReturn((Object)REQUEST_LOCALE);
        LocaleConfigImpl localeConfig = new LocaleConfigImpl();
        localeConfig.setLocale(REQUEST_LOCALE);
        Mockito.when((Object)this.localeConfigService.getLocaleConfig(REQUEST_LOCALE.getLanguage())).thenReturn((Object)localeConfig);
        Mockito.when((Object)this.resourceBundleService.getSharedResourceBundleNames()).thenReturn((Object)new String[0]);
        Mockito.when((Object)this.resourceBundleService.getResourceBundle((String[])ArgumentMatchers.any(String[].class), (Locale)ArgumentMatchers.eq((Object)REQUEST_LOCALE))).thenReturn((Object)this.resourceBundle);
        Mockito.when((Object)this.resourceBundle.getString(ArgumentMatchers.anyString())).thenAnswer(invocation -> invocation.getArgument(0));
        Mockito.when((Object)this.javascriptConfigService.getJSConfig()).thenReturn((Object)new JSONObject());
        Mockito.when((Object)this.servletContext.getRequestDispatcher((String)ArgumentMatchers.any())).thenReturn((Object)this.requestDispatcher);
        Mockito.when((Object)this.passwordRecoveryService.getPasswordRecoverURL(null, I18N.toTagIdentifier((Locale)REQUEST_LOCALE))).thenReturn((Object)"/forgot-password");
        Mockito.when((Object)this.organizationService.getUserHandler()).thenReturn((Object)this.userHandler);
        this.passwordRecoveryHandler = new PasswordRecoveryHandler(this.container, this.passwordRecoveryService, this.resourceBundleService, this.organizationService, this.localeConfigService, this.brandingService, this.javascriptConfigService, this.skinService){

            protected void extendApplicationParameters(JSONObject applicationParameters, Map<String, Object> additionalParameters) {
                PasswordRecoveryHandlerTest.this.applicationParameters = additionalParameters;
                super.extendApplicationParameters(applicationParameters, additionalParameters);
            }
        };
    }

    @After
    public void teardown() throws Exception {
        ExoContainerContext.setCurrentContainer(null);
    }

    @Test
    public void testDisplayForgotPasswordPage() throws Exception {
        this.prepareResetFormContext();
        this.passwordRecoveryHandler.execute(this.controllerContext);
        Assert.assertNotNull(this.applicationParameters);
        Assert.assertEquals((Object)"/portal/forgot-password", (Object)this.applicationParameters.get("formUrl"));
        Assert.assertEquals((Object)INITIAL_URI, (Object)this.applicationParameters.get(PasswordRecoveryHandler.INITIAL_URI_PARAM));
        Assert.assertFalse((boolean)this.applicationParameters.containsKey("error"));
        Assert.assertFalse((boolean)this.applicationParameters.containsKey("success"));
        Assert.assertFalse((boolean)this.applicationParameters.containsKey("username"));
        ((PasswordRecoveryService)Mockito.verify((Object)this.passwordRecoveryService, (VerificationMode)Mockito.never())).changePass((String)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), (String)ArgumentMatchers.any());
        ((PasswordRecoveryService)Mockito.verify((Object)this.passwordRecoveryService, (VerificationMode)Mockito.never())).sendRecoverPasswordEmail((User)ArgumentMatchers.any(), (Locale)ArgumentMatchers.any(), (HttpServletRequest)ArgumentMatchers.any());
    }

    @Test
    public void testSendResetPasswordUrlWhenEmptyUsername() throws Exception {
        this.prepareResetFormContext();
        Mockito.when((Object)this.request.getParameter("action")).thenReturn((Object)"send");
        this.passwordRecoveryHandler.execute(this.controllerContext);
        Assert.assertNotNull(this.applicationParameters);
        Assert.assertEquals((Object)"/portal/forgot-password", (Object)this.applicationParameters.get("formUrl"));
        Assert.assertEquals((Object)INITIAL_URI, (Object)this.applicationParameters.get(PasswordRecoveryHandler.INITIAL_URI_PARAM));
        Assert.assertEquals((Object)"gatein.forgotPassword.emptyUserOrEmail", (Object)this.applicationParameters.get("error"));
        ((PasswordRecoveryService)Mockito.verify((Object)this.passwordRecoveryService, (VerificationMode)Mockito.never())).changePass((String)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), (String)ArgumentMatchers.any());
        ((PasswordRecoveryService)Mockito.verify((Object)this.passwordRecoveryService, (VerificationMode)Mockito.never())).sendRecoverPasswordEmail((User)ArgumentMatchers.any(), (Locale)ArgumentMatchers.any(), (HttpServletRequest)ArgumentMatchers.any());
    }

    @Test
    public void testSendResetPasswordUrlWhenUserNotFound() throws Exception {
        this.prepareResetFormContext();
        String username = "user";
        Mockito.when((Object)this.request.getParameter("action")).thenReturn((Object)"send");
        Mockito.when((Object)this.request.getParameter("username")).thenReturn((Object)username);
        this.passwordRecoveryHandler.execute(this.controllerContext);
        Assert.assertNotNull(this.applicationParameters);
        Assert.assertEquals((Object)"/portal/forgot-password", (Object)this.applicationParameters.get("formUrl"));
        Assert.assertEquals((Object)INITIAL_URI, (Object)this.applicationParameters.get(PasswordRecoveryHandler.INITIAL_URI_PARAM));
        Assert.assertFalse((boolean)this.applicationParameters.containsKey("error"));
        Assert.assertEquals((Object)"gatein.forgotPassword.emailSendSuccessful", (Object)this.applicationParameters.get("success"));
        Assert.assertEquals((Object)username, (Object)this.applicationParameters.get("username"));
        ((PasswordRecoveryService)Mockito.verify((Object)this.passwordRecoveryService, (VerificationMode)Mockito.never())).changePass((String)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), (String)ArgumentMatchers.any());
        ((PasswordRecoveryService)Mockito.verify((Object)this.passwordRecoveryService, (VerificationMode)Mockito.never())).sendRecoverPasswordEmail((User)ArgumentMatchers.any(), (Locale)ArgumentMatchers.any(), (HttpServletRequest)ArgumentMatchers.any());
    }

    @Test
    public void testSendResetPasswordUrlWhenUserNotEnabled() throws Exception {
        this.prepareResetFormContext();
        String username = "user";
        Mockito.when((Object)this.request.getParameter("action")).thenReturn((Object)"send");
        Mockito.when((Object)this.request.getParameter("username")).thenReturn((Object)username);
        User user = (User)Mockito.mock(User.class);
        Mockito.when((Object)user.isEnabled()).thenReturn((Object)false);
        Mockito.when((Object)this.userHandler.findUserByName((String)ArgumentMatchers.eq((Object)username), (UserStatus)ArgumentMatchers.any())).thenReturn((Object)user);
        this.passwordRecoveryHandler.execute(this.controllerContext);
        Assert.assertNotNull(this.applicationParameters);
        Assert.assertEquals((Object)"/portal/forgot-password", (Object)this.applicationParameters.get("formUrl"));
        Assert.assertEquals((Object)INITIAL_URI, (Object)this.applicationParameters.get(PasswordRecoveryHandler.INITIAL_URI_PARAM));
        Assert.assertFalse((boolean)this.applicationParameters.containsKey("error"));
        Assert.assertEquals((Object)"gatein.forgotPassword.emailSendSuccessful", (Object)this.applicationParameters.get("success"));
        Assert.assertEquals((Object)username, (Object)this.applicationParameters.get("username"));
        ((PasswordRecoveryService)Mockito.verify((Object)this.passwordRecoveryService, (VerificationMode)Mockito.never())).changePass((String)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), (String)ArgumentMatchers.any());
        ((PasswordRecoveryService)Mockito.verify((Object)this.passwordRecoveryService, (VerificationMode)Mockito.never())).sendRecoverPasswordEmail((User)ArgumentMatchers.any(), (Locale)ArgumentMatchers.any(), (HttpServletRequest)ArgumentMatchers.any());
    }

    @Test
    public void testSendResetPasswordUrlWhenUserEnabledAndSendFailure() throws Exception {
        this.prepareResetFormContext();
        String username = "user";
        Mockito.when((Object)this.request.getParameter("action")).thenReturn((Object)"send");
        Mockito.when((Object)this.request.getParameter("username")).thenReturn((Object)username);
        User user = (User)Mockito.mock(User.class);
        Mockito.when((Object)user.isEnabled()).thenReturn((Object)true);
        Mockito.when((Object)this.userHandler.findUserByName((String)ArgumentMatchers.eq((Object)username), (UserStatus)ArgumentMatchers.any())).thenReturn((Object)user);
        this.passwordRecoveryHandler.execute(this.controllerContext);
        Assert.assertNotNull(this.applicationParameters);
        Assert.assertEquals((Object)"/portal/forgot-password", (Object)this.applicationParameters.get("formUrl"));
        Assert.assertEquals((Object)INITIAL_URI, (Object)this.applicationParameters.get(PasswordRecoveryHandler.INITIAL_URI_PARAM));
        Assert.assertEquals((Object)username, (Object)this.applicationParameters.get("username"));
        ((PasswordRecoveryService)Mockito.verify((Object)this.passwordRecoveryService, (VerificationMode)Mockito.never())).changePass((String)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), (String)ArgumentMatchers.any());
        ((PasswordRecoveryService)Mockito.verify((Object)this.passwordRecoveryService, (VerificationMode)Mockito.times((int)1))).sendRecoverPasswordEmail((User)ArgumentMatchers.eq((Object)user), (Locale)ArgumentMatchers.eq((Object)REQUEST_LOCALE), (HttpServletRequest)ArgumentMatchers.any(HttpServletRequest.class));
        Assert.assertFalse((boolean)this.applicationParameters.containsKey("success"));
        Assert.assertEquals((Object)"gatein.forgotPassword.emailSendFailure", (Object)this.applicationParameters.get("error"));
    }

    @Test
    public void testGetRequiresLifeCycle() {
        Assert.assertTrue((boolean)this.passwordRecoveryHandler.getRequiresLifeCycle());
    }

    @Test
    public void testGetHandlerName() {
        Assert.assertEquals((Object)"forgot-password", (Object)this.passwordRecoveryHandler.getHandlerName());
    }

    @Test
    public void testSendResetPasswordUrlWhenUserEnabledAndSendSuccess() throws Exception {
        this.prepareResetFormContext();
        String username = "user";
        Mockito.when((Object)this.request.getParameter("action")).thenReturn((Object)"send");
        Mockito.when((Object)this.request.getParameter("username")).thenReturn((Object)username);
        User user = (User)Mockito.mock(User.class);
        Mockito.when((Object)user.isEnabled()).thenReturn((Object)true);
        Mockito.when((Object)this.userHandler.findUserByName((String)ArgumentMatchers.eq((Object)username), (UserStatus)ArgumentMatchers.any())).thenReturn((Object)user);
        Mockito.when((Object)this.passwordRecoveryService.sendRecoverPasswordEmail((User)ArgumentMatchers.any(), (Locale)ArgumentMatchers.any(), (HttpServletRequest)ArgumentMatchers.any())).thenReturn((Object)true);
        this.passwordRecoveryHandler.execute(this.controllerContext);
        Assert.assertNotNull(this.applicationParameters);
        Assert.assertEquals((Object)"/portal/forgot-password", (Object)this.applicationParameters.get("formUrl"));
        Assert.assertEquals((Object)INITIAL_URI, (Object)this.applicationParameters.get(PasswordRecoveryHandler.INITIAL_URI_PARAM));
        Assert.assertEquals((Object)username, (Object)this.applicationParameters.get("username"));
        ((PasswordRecoveryService)Mockito.verify((Object)this.passwordRecoveryService, (VerificationMode)Mockito.never())).changePass((String)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), (String)ArgumentMatchers.any());
        ((PasswordRecoveryService)Mockito.verify((Object)this.passwordRecoveryService, (VerificationMode)Mockito.times((int)1))).sendRecoverPasswordEmail((User)ArgumentMatchers.eq((Object)user), (Locale)ArgumentMatchers.eq((Object)REQUEST_LOCALE), (HttpServletRequest)ArgumentMatchers.any(HttpServletRequest.class));
        Assert.assertFalse((boolean)this.applicationParameters.containsKey("error"));
        Assert.assertEquals((Object)"gatein.forgotPassword.emailSendSuccessful", (Object)this.applicationParameters.get("success"));
    }

    @Test
    public void testDisplayTokenExpiredPage() throws Exception {
        this.prepareResetPasswordContext();
        this.passwordRecoveryHandler.execute(this.controllerContext);
        Assert.assertNotNull(this.applicationParameters);
        Assert.assertFalse((boolean)this.applicationParameters.containsKey("username"));
        Assert.assertFalse((boolean)this.applicationParameters.containsKey("error"));
        Assert.assertFalse((boolean)this.applicationParameters.containsKey("success"));
        Assert.assertEquals((Object)"expired", (Object)this.applicationParameters.get("action"));
        ((PasswordRecoveryService)Mockito.verify((Object)this.passwordRecoveryService, (VerificationMode)Mockito.never())).changePass((String)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), (String)ArgumentMatchers.any());
        ((PasswordRecoveryService)Mockito.verify((Object)this.passwordRecoveryService, (VerificationMode)Mockito.never())).sendRecoverPasswordEmail((User)ArgumentMatchers.any(), (Locale)ArgumentMatchers.any(), (HttpServletRequest)ArgumentMatchers.any());
    }

    @Test
    public void testDisplayResetPassword() throws Exception {
        this.prepareResetPasswordContext();
        String username = "user";
        Mockito.when((Object)this.passwordRecoveryService.verifyToken(TOKEN_VALUE, "forgot-password")).thenReturn((Object)username);
        this.passwordRecoveryHandler.execute(this.controllerContext);
        Assert.assertNotNull(this.applicationParameters);
        Assert.assertEquals((Object)username, (Object)this.applicationParameters.get("username"));
        Assert.assertEquals((Object)TOKEN_VALUE, (Object)this.applicationParameters.get("tokenId"));
        Assert.assertEquals((Object)"resetPassword", (Object)this.applicationParameters.get("action"));
        Assert.assertFalse((boolean)this.applicationParameters.containsKey("error"));
        Assert.assertFalse((boolean)this.applicationParameters.containsKey("success"));
        ((PasswordRecoveryService)Mockito.verify((Object)this.passwordRecoveryService, (VerificationMode)Mockito.never())).changePass((String)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), (String)ArgumentMatchers.any());
        ((PasswordRecoveryService)Mockito.verify((Object)this.passwordRecoveryService, (VerificationMode)Mockito.never())).sendRecoverPasswordEmail((User)ArgumentMatchers.any(), (Locale)ArgumentMatchers.any(), (HttpServletRequest)ArgumentMatchers.any());
    }

    @Test
    public void testDisplayResetPasswordUserNotMatch() throws Exception {
        this.prepareResetPasswordContext();
        String username = "user";
        String password = "pass1";
        String passwordConfirm = "pass2";
        Mockito.when((Object)this.passwordRecoveryService.verifyToken(TOKEN_VALUE, "forgot-password")).thenReturn((Object)username);
        Mockito.when((Object)this.request.getParameter("action")).thenReturn((Object)"resetPassword");
        Mockito.when((Object)this.request.getParameter("username")).thenReturn((Object)"user2");
        Mockito.when((Object)this.request.getParameter("password")).thenReturn((Object)password);
        Mockito.when((Object)this.request.getParameter("password2")).thenReturn((Object)passwordConfirm);
        this.passwordRecoveryHandler.execute(this.controllerContext);
        Assert.assertNotNull(this.applicationParameters);
        Assert.assertEquals((Object)username, (Object)this.applicationParameters.get("username"));
        Assert.assertEquals((Object)TOKEN_VALUE, (Object)this.applicationParameters.get("tokenId"));
        Assert.assertEquals((Object)"resetPassword", (Object)this.applicationParameters.get("action"));
        Assert.assertEquals((Object)"gatein.forgotPassword.usernameChanged", (Object)this.applicationParameters.get("error"));
        Assert.assertFalse((boolean)this.applicationParameters.containsKey("success"));
        Assert.assertEquals((Object)password, (Object)this.applicationParameters.get("password"));
        Assert.assertEquals((Object)passwordConfirm, (Object)this.applicationParameters.get("password2"));
        ((PasswordRecoveryService)Mockito.verify((Object)this.passwordRecoveryService, (VerificationMode)Mockito.never())).changePass((String)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), (String)ArgumentMatchers.any());
        ((PasswordRecoveryService)Mockito.verify((Object)this.passwordRecoveryService, (VerificationMode)Mockito.never())).sendRecoverPasswordEmail((User)ArgumentMatchers.any(), (Locale)ArgumentMatchers.any(), (HttpServletRequest)ArgumentMatchers.any());
    }

    @Test
    public void testDisplayResetPasswordWhenBothPasswordsNotMatch() throws Exception {
        this.prepareResetPasswordContext();
        String username = "user";
        String password = "pass1";
        String passwordConfirm = "pass2";
        Mockito.when((Object)this.passwordRecoveryService.verifyToken(TOKEN_VALUE, "forgot-password")).thenReturn((Object)username);
        Mockito.when((Object)this.request.getParameter("action")).thenReturn((Object)"resetPassword");
        Mockito.when((Object)this.request.getParameter("username")).thenReturn((Object)username);
        Mockito.when((Object)this.request.getParameter("password")).thenReturn((Object)password);
        Mockito.when((Object)this.request.getParameter("password2")).thenReturn((Object)passwordConfirm);
        this.passwordRecoveryHandler.execute(this.controllerContext);
        Assert.assertNotNull(this.applicationParameters);
        Assert.assertEquals((Object)username, (Object)this.applicationParameters.get("username"));
        Assert.assertEquals((Object)TOKEN_VALUE, (Object)this.applicationParameters.get("tokenId"));
        Assert.assertEquals((Object)"resetPassword", (Object)this.applicationParameters.get("action"));
        Assert.assertEquals((Object)"gatein.forgotPassword.confirmPasswordNotMatch", (Object)this.applicationParameters.get("error"));
        Assert.assertFalse((boolean)this.applicationParameters.containsKey("success"));
        Assert.assertEquals((Object)password, (Object)this.applicationParameters.get("password"));
        Assert.assertEquals((Object)passwordConfirm, (Object)this.applicationParameters.get("password2"));
        ((PasswordRecoveryService)Mockito.verify((Object)this.passwordRecoveryService, (VerificationMode)Mockito.never())).changePass((String)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), (String)ArgumentMatchers.any());
        ((PasswordRecoveryService)Mockito.verify((Object)this.passwordRecoveryService, (VerificationMode)Mockito.never())).sendRecoverPasswordEmail((User)ArgumentMatchers.any(), (Locale)ArgumentMatchers.any(), (HttpServletRequest)ArgumentMatchers.any());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDisplayResetPasswordWhenPasswordNotValid() throws Exception {
        String password;
        this.prepareResetPasswordContext();
        String username = "user";
        String passwordConfirm = password = "pass1";
        Mockito.when((Object)this.passwordRecoveryService.verifyToken(TOKEN_VALUE, "forgot-password")).thenReturn((Object)username);
        Mockito.when((Object)this.request.getParameter("action")).thenReturn((Object)"resetPassword");
        Mockito.when((Object)this.request.getParameter("username")).thenReturn((Object)username);
        Mockito.when((Object)this.request.getParameter("password")).thenReturn((Object)password);
        Mockito.when((Object)this.request.getParameter("password2")).thenReturn((Object)passwordConfirm);
        PropertyManager.setProperty((String)"gatein.validators.passwordpolicy.length.max", (String)"8");
        PropertyManager.setProperty((String)"gatein.validators.passwordpolicy.length.min", (String)"255");
        try {
            this.passwordRecoveryHandler.execute(this.controllerContext);
        }
        finally {
            PropertyManager.setProperty((String)"gatein.validators.passwordpolicy.length.max", (String)"");
            PropertyManager.setProperty((String)"gatein.validators.passwordpolicy.length.min", (String)"");
        }
        Assert.assertNotNull(this.applicationParameters);
        Assert.assertEquals((Object)username, (Object)this.applicationParameters.get("username"));
        Assert.assertEquals((Object)TOKEN_VALUE, (Object)this.applicationParameters.get("tokenId"));
        Assert.assertEquals((Object)"resetPassword", (Object)this.applicationParameters.get("action"));
        Assert.assertEquals((Object)"onboarding.login.passwordCondition", (Object)this.applicationParameters.get("error"));
        Assert.assertFalse((boolean)this.applicationParameters.containsKey("success"));
        ((PasswordRecoveryService)Mockito.verify((Object)this.passwordRecoveryService, (VerificationMode)Mockito.never())).changePass((String)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), (String)ArgumentMatchers.any());
        ((PasswordRecoveryService)Mockito.verify((Object)this.passwordRecoveryService, (VerificationMode)Mockito.never())).sendRecoverPasswordEmail((User)ArgumentMatchers.any(), (Locale)ArgumentMatchers.any(), (HttpServletRequest)ArgumentMatchers.any());
    }

    private void prepareResetFormContext() {
        this.controllerContext = new ControllerContext(this.controller, this.router, this.request, this.response, Collections.singletonMap(PasswordRecoveryHandler.INIT_URL, INITIAL_URI));
    }

    private void prepareResetPasswordContext() {
        HashMap<QualifiedName, String> parameters = new HashMap<QualifiedName, String>();
        parameters.put(PasswordRecoveryHandler.INIT_URL, INITIAL_URI);
        parameters.put(PasswordRecoveryHandler.TOKEN, TOKEN_VALUE);
        this.controllerContext = new ControllerContext(this.controller, this.router, this.request, this.response, parameters);
    }
}

