/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.web.register;

import io.meeds.portal.security.service.SecuritySettingService;
import jakarta.servlet.RequestDispatcher;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.WriteListener;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import nl.captcha.Captcha;
import org.exoplatform.commons.utils.PropertyManager;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.portal.branding.BrandingService;
import org.exoplatform.portal.resource.SkinService;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.GroupHandler;
import org.exoplatform.services.organization.MembershipHandler;
import org.exoplatform.services.organization.MembershipType;
import org.exoplatform.services.organization.MembershipTypeHandler;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.UserHandler;
import org.exoplatform.services.organization.idm.UserImpl;
import org.exoplatform.services.resources.LocaleConfigService;
import org.exoplatform.services.resources.ResourceBundleService;
import org.exoplatform.services.resources.impl.LocaleConfigImpl;
import org.exoplatform.web.ControllerContext;
import org.exoplatform.web.WebAppController;
import org.exoplatform.web.application.javascript.JavascriptConfigService;
import org.exoplatform.web.controller.QualifiedName;
import org.exoplatform.web.controller.router.Router;
import org.exoplatform.web.login.recovery.PasswordRecoveryService;
import org.exoplatform.web.register.ExternalRegisterHandler;
import org.exoplatform.web.security.security.RemindPasswordTokenService;
import org.gatein.wci.security.Credentials;
import org.json.JSONObject;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.Silent.class)
public class ExternalRegisterHandlerTest {
    private static final Locale REQUEST_LOCALE = Locale.ENGLISH;
    private static final String CONTEXT_PATH = "/portal";
    private static final String TOKEN_VALUE = "tokenValue";
    private static final String EMAIL = "email@test.com";
    private static final String LASTNAME = "lastName";
    private static final String FIRSTNAME = "firstName";
    private static final String CAPTCHA_VALUE = "captchaValue";
    @Mock
    private ServletContext servletContext;
    @Mock
    private PortalContainer container;
    @Mock
    private RemindPasswordTokenService remindPasswordTokenService;
    @Mock
    private PasswordRecoveryService passwordRecoveryService;
    @Mock
    private ResourceBundleService resourceBundleService;
    @Mock
    private ResourceBundle resourceBundle;
    @Mock
    private OrganizationService organizationService;
    @Mock
    private UserHandler userHandler;
    @Mock
    private GroupHandler groupHandler;
    @Mock
    private MembershipTypeHandler membershipTypeHandler;
    @Mock
    private MembershipHandler membershipHandler;
    @Mock
    private LocaleConfigService localeConfigService;
    @Mock
    private BrandingService brandingService;
    @Mock
    private JavascriptConfigService javascriptConfigService;
    @Mock
    private WebAppController controller;
    @Mock
    private SecuritySettingService securitySettingService;
    @Mock
    private Router router;
    @Mock
    private InitParams params;
    @Mock
    private HttpSession session;
    @Mock
    private HttpServletRequest request;
    @Mock
    private HttpServletResponse response;
    @Mock
    private RequestDispatcher requestDispatcher;
    @Mock
    private SkinService skinService;
    @Mock
    private Captcha captcha;
    @Mock
    private Credentials credentials;
    private ControllerContext controllerContext;
    private ExternalRegisterHandler externalRegisterHandler;
    private Map<String, Object> applicationParameters;

    @Before
    public void setUp() throws Exception {
        this.applicationParameters = null;
        ExoContainerContext.setCurrentContainer((ExoContainer)this.container);
        Mockito.lenient().when((Object)((ResourceBundleService)this.container.getComponentInstanceOfType(ResourceBundleService.class))).thenReturn((Object)this.resourceBundleService);
        Mockito.when((Object)this.container.getPortalContext()).thenReturn((Object)this.servletContext);
        Mockito.when((Object)this.request.getContextPath()).thenReturn((Object)CONTEXT_PATH);
        Mockito.when((Object)this.servletContext.getContextPath()).thenReturn((Object)CONTEXT_PATH);
        Mockito.when((Object)this.request.getSession()).thenReturn((Object)this.session);
        Mockito.when((Object)this.session.getAttribute("external-registration")).thenReturn((Object)this.captcha);
        Mockito.when((Object)this.captcha.isCorrect(CAPTCHA_VALUE)).thenReturn((Object)true);
        Mockito.when((Object)this.request.getParameter("captcha")).thenReturn((Object)CAPTCHA_VALUE);
        ServletOutputStream outputStream = new ServletOutputStream(this){

            public void write(int b) throws IOException {
            }

            public boolean isReady() {
                return false;
            }

            public void setWriteListener(WriteListener writeListener) {
            }
        };
        Mockito.when((Object)this.response.getOutputStream()).thenReturn((Object)outputStream);
        final int[] responseStatus = new int[]{0};
        Mockito.when((Object)this.response.getStatus()).thenAnswer((Answer)new Answer<Integer>(){

            public Integer answer(InvocationOnMock invocation) throws Throwable {
                return responseStatus[0];
            }
        });
        ((HttpServletResponse)Mockito.doAnswer((Answer)new Answer<Void>(){

            public Void answer(InvocationOnMock invocation) {
                int status;
                Object[] args = invocation.getArguments();
                responseStatus[0] = status = ((Integer)args[0]).intValue();
                return null;
            }
        }).when((Object)this.response)).setStatus(ArgumentMatchers.anyInt());
        final HashMap requestAttributes = new HashMap();
        Mockito.when((Object)this.request.getAttribute(ArgumentMatchers.anyString())).thenAnswer((Answer)new Answer<Object>(){

            public Object answer(InvocationOnMock invocation) {
                Object[] args = invocation.getArguments();
                String key = (String)args[0];
                return requestAttributes.get(key);
            }
        });
        Mockito.when((Object)this.request.getAttributeNames()).thenAnswer((Answer)new Answer<Object>(){

            public Object answer(InvocationOnMock invocation) {
                return Collections.enumeration(requestAttributes.keySet());
            }
        });
        ((HttpServletRequest)Mockito.doAnswer((Answer)new Answer<Void>(){

            public Void answer(InvocationOnMock invocation) {
                Object[] args = invocation.getArguments();
                String key = (String)args[0];
                Object value = args[1];
                requestAttributes.put(key, value);
                return null;
            }
        }).when((Object)this.request)).setAttribute(ArgumentMatchers.anyString(), ArgumentMatchers.any());
        Mockito.when((Object)this.request.getLocale()).thenReturn((Object)REQUEST_LOCALE);
        LocaleConfigImpl localeConfig = new LocaleConfigImpl();
        localeConfig.setLocale(REQUEST_LOCALE);
        Mockito.when((Object)this.localeConfigService.getLocaleConfig(REQUEST_LOCALE.getLanguage())).thenReturn((Object)localeConfig);
        Mockito.when((Object)this.resourceBundleService.getSharedResourceBundleNames()).thenReturn((Object)new String[0]);
        Mockito.when((Object)this.resourceBundleService.getResourceBundle((String[])ArgumentMatchers.any(String[].class), (Locale)ArgumentMatchers.eq((Object)REQUEST_LOCALE))).thenReturn((Object)this.resourceBundle);
        Mockito.when((Object)this.resourceBundle.getString(ArgumentMatchers.anyString())).thenAnswer(invocation -> invocation.getArgument(0));
        Mockito.when((Object)this.javascriptConfigService.getJSConfig()).thenReturn((Object)new JSONObject());
        Mockito.when((Object)this.servletContext.getRequestDispatcher((String)ArgumentMatchers.any())).thenReturn((Object)this.requestDispatcher);
        Mockito.when((Object)this.request.getRequestDispatcher((String)ArgumentMatchers.any())).thenReturn((Object)this.requestDispatcher);
        Mockito.when((Object)this.organizationService.getUserHandler()).thenReturn((Object)this.userHandler);
        Mockito.when((Object)this.organizationService.getGroupHandler()).thenReturn((Object)this.groupHandler);
        Mockito.when((Object)this.organizationService.getMembershipTypeHandler()).thenReturn((Object)this.membershipTypeHandler);
        Mockito.when((Object)this.organizationService.getMembershipHandler()).thenReturn((Object)this.membershipHandler);
        Mockito.when((Object)this.securitySettingService.getRegistrationGroupIds()).thenReturn((Object)new String[]{"/platform/external"});
        Mockito.when((Object)this.passwordRecoveryService.verifyToken(TOKEN_VALUE, "external-registration")).thenReturn((Object)EMAIL);
        this.externalRegisterHandler = new ExternalRegisterHandler(this.container, this.remindPasswordTokenService, this.passwordRecoveryService, this.resourceBundleService, this.organizationService, this.localeConfigService, this.brandingService, this.securitySettingService, this.javascriptConfigService, this.skinService){

            protected void extendApplicationParameters(JSONObject applicationParameters, Map<String, Object> additionalParameters) {
                ExternalRegisterHandlerTest.this.applicationParameters = additionalParameters;
                super.extendApplicationParameters(applicationParameters, additionalParameters);
            }
        };
    }

    @After
    public void teardown() {
        ExoContainerContext.setCurrentContainer(null);
    }

    @Test
    public void testGetRequiresLifeCycle() {
        Assert.assertTrue((boolean)this.externalRegisterHandler.getRequiresLifeCycle());
    }

    @Test
    public void testGetHandlerName() {
        Assert.assertEquals((Object)"external-registration", (Object)this.externalRegisterHandler.getHandlerName());
    }

    @Test
    public void testDisplayTokenExpiredPage() throws Exception {
        this.prepareResetPasswordContext();
        Mockito.reset((Object[])new PasswordRecoveryService[]{this.passwordRecoveryService});
        this.externalRegisterHandler.execute(this.controllerContext);
        Assert.assertFalse((boolean)Collections.list(this.controllerContext.getRequest().getAttributeNames()).contains("error"));
        Assert.assertEquals((Object)"expired", (Object)this.controllerContext.getRequest().getAttribute("action"));
        ((PasswordRecoveryService)Mockito.verify((Object)this.passwordRecoveryService, (VerificationMode)Mockito.never())).sendAccountCreatedConfirmationEmail((String)ArgumentMatchers.any(), (Locale)ArgumentMatchers.any(), (StringBuilder)ArgumentMatchers.any());
    }

    @Test
    public void testDisplayExternalRegistrationPage() throws Exception {
        this.prepareResetPasswordContext();
        this.externalRegisterHandler.execute(this.controllerContext);
        Assert.assertEquals((Object)EMAIL, (Object)this.controllerContext.getRequest().getAttribute("email"));
        Assert.assertEquals((Object)TOKEN_VALUE, (Object)this.controllerContext.getRequest().getAttribute("tokenId"));
        Assert.assertFalse((boolean)Collections.list(this.controllerContext.getRequest().getAttributeNames()).contains("error"));
        ((PasswordRecoveryService)Mockito.verify((Object)this.passwordRecoveryService, (VerificationMode)Mockito.never())).sendAccountCreatedConfirmationEmail((String)ArgumentMatchers.any(), (Locale)ArgumentMatchers.any(), (StringBuilder)ArgumentMatchers.any());
    }

    @Test
    public void testDisplayExternalRegistrationUserNotMatch() throws Exception {
        this.prepareResetPasswordContext();
        String password = "pass1";
        String passwordConfirm = "pass2";
        Mockito.when((Object)this.request.getParameter("action")).thenReturn((Object)"saveExternal");
        Mockito.when((Object)this.request.getParameter("email")).thenReturn((Object)"email2");
        Mockito.when((Object)this.request.getParameter("password")).thenReturn((Object)password);
        Mockito.when((Object)this.request.getParameter("password2")).thenReturn((Object)passwordConfirm);
        this.externalRegisterHandler.execute(this.controllerContext);
        this.externalRegisterHandler.execute(this.controllerContext);
        Assert.assertEquals((long)400L, (long)this.controllerContext.getResponse().getStatus());
        ((PasswordRecoveryService)Mockito.verify((Object)this.passwordRecoveryService, (VerificationMode)Mockito.never())).sendAccountCreatedConfirmationEmail((String)ArgumentMatchers.any(), (Locale)ArgumentMatchers.any(), (StringBuilder)ArgumentMatchers.any());
    }

    @Test
    public void testDisplayExternalRegistrationWhenBothPasswordsNotMatch() throws Exception {
        this.prepareResetPasswordContext();
        String password = "pass1234";
        String passwordConfirm = "pass123";
        Mockito.when((Object)this.request.getParameter("action")).thenReturn((Object)"saveExternal");
        Mockito.when((Object)this.request.getParameter("email")).thenReturn((Object)EMAIL);
        Mockito.when((Object)this.request.getParameter("password")).thenReturn((Object)password);
        Mockito.when((Object)this.request.getParameter("password2")).thenReturn((Object)passwordConfirm);
        this.externalRegisterHandler.execute(this.controllerContext);
        Assert.assertEquals((long)400L, (long)this.controllerContext.getResponse().getStatus());
        ((PasswordRecoveryService)Mockito.verify((Object)this.passwordRecoveryService, (VerificationMode)Mockito.never())).sendAccountCreatedConfirmationEmail((String)ArgumentMatchers.any(), (Locale)ArgumentMatchers.any(), (StringBuilder)ArgumentMatchers.any());
    }

    @Test
    public void testDisplayExternalRegistrationWhenPasswordNotValid() throws Exception {
        String password;
        this.prepareResetPasswordContext();
        String passwordConfirm = password = "pass1";
        Mockito.when((Object)this.request.getParameter("action")).thenReturn((Object)"saveExternal");
        Mockito.when((Object)this.request.getParameter("email")).thenReturn((Object)EMAIL);
        Mockito.when((Object)this.request.getParameter("password")).thenReturn((Object)password);
        Mockito.when((Object)this.request.getParameter("password2")).thenReturn((Object)passwordConfirm);
        PropertyManager.setProperty((String)"gatein.validators.passwordpolicy.length.max", (String)"8");
        PropertyManager.setProperty((String)"gatein.validators.passwordpolicy.length.min", (String)"255");
        try {
            this.externalRegisterHandler.execute(this.controllerContext);
        }
        finally {
            PropertyManager.setProperty((String)"gatein.validators.passwordpolicy.length.max", (String)"");
            PropertyManager.setProperty((String)"gatein.validators.passwordpolicy.length.min", (String)"");
        }
        this.externalRegisterHandler.execute(this.controllerContext);
        Assert.assertEquals((long)400L, (long)this.controllerContext.getResponse().getStatus());
        ((PasswordRecoveryService)Mockito.verify((Object)this.passwordRecoveryService, (VerificationMode)Mockito.never())).sendAccountCreatedConfirmationEmail((String)ArgumentMatchers.any(), (Locale)ArgumentMatchers.any(), (StringBuilder)ArgumentMatchers.any());
    }

    @Test
    public void testDisplayExternalRegistrationWhenFirstNameNotValid() throws Exception {
        String password;
        this.prepareResetPasswordContext();
        String passwordConfirm = password = "pass1234";
        Mockito.when((Object)this.request.getParameter("action")).thenReturn((Object)"saveExternal");
        Mockito.when((Object)this.request.getParameter("email")).thenReturn((Object)EMAIL);
        Mockito.when((Object)this.request.getParameter(LASTNAME)).thenReturn((Object)LASTNAME);
        Mockito.when((Object)this.request.getParameter("password")).thenReturn((Object)password);
        Mockito.when((Object)this.request.getParameter("password2")).thenReturn((Object)passwordConfirm);
        this.externalRegisterHandler.execute(this.controllerContext);
        Assert.assertEquals((long)400L, (long)this.controllerContext.getResponse().getStatus());
        ((PasswordRecoveryService)Mockito.verify((Object)this.passwordRecoveryService, (VerificationMode)Mockito.never())).sendAccountCreatedConfirmationEmail((String)ArgumentMatchers.any(), (Locale)ArgumentMatchers.any(), (StringBuilder)ArgumentMatchers.any());
    }

    @Test
    public void testDisplayExternalRegistrationWhenLastNameNotValid() throws Exception {
        String password;
        this.prepareResetPasswordContext();
        String passwordConfirm = password = "pass1234";
        Mockito.when((Object)this.request.getParameter("action")).thenReturn((Object)"saveExternal");
        Mockito.when((Object)this.request.getParameter("email")).thenReturn((Object)EMAIL);
        Mockito.when((Object)this.request.getParameter(FIRSTNAME)).thenReturn((Object)FIRSTNAME);
        Mockito.when((Object)this.request.getParameter("password")).thenReturn((Object)password);
        Mockito.when((Object)this.request.getParameter("password2")).thenReturn((Object)passwordConfirm);
        this.externalRegisterHandler.execute(this.controllerContext);
        Assert.assertEquals((long)400L, (long)this.controllerContext.getResponse().getStatus());
        ((PasswordRecoveryService)Mockito.verify((Object)this.passwordRecoveryService, (VerificationMode)Mockito.never())).sendAccountCreatedConfirmationEmail((String)ArgumentMatchers.any(), (Locale)ArgumentMatchers.any(), (StringBuilder)ArgumentMatchers.any());
    }

    @Test
    public void testDisplayExternalRegistrationWhenErrorCreatingUser() throws Exception {
        String password;
        this.prepareResetPasswordContext();
        String passwordConfirm = password = "pass1234";
        Mockito.when((Object)this.request.getParameter("action")).thenReturn((Object)"saveExternal");
        Mockito.when((Object)this.request.getParameter("email")).thenReturn((Object)EMAIL);
        Mockito.when((Object)this.request.getParameter(FIRSTNAME)).thenReturn((Object)FIRSTNAME);
        Mockito.when((Object)this.request.getParameter(LASTNAME)).thenReturn((Object)LASTNAME);
        Mockito.when((Object)this.request.getParameter("password")).thenReturn((Object)password);
        Mockito.when((Object)this.request.getParameter("password2")).thenReturn((Object)passwordConfirm);
        Mockito.when((Object)this.userHandler.createUserInstance((String)ArgumentMatchers.any())).thenThrow(IllegalStateException.class);
        this.externalRegisterHandler.execute(this.controllerContext);
        Assert.assertEquals((long)400L, (long)this.controllerContext.getResponse().getStatus());
        ((PasswordRecoveryService)Mockito.verify((Object)this.passwordRecoveryService, (VerificationMode)Mockito.never())).sendAccountCreatedConfirmationEmail((String)ArgumentMatchers.any(), (Locale)ArgumentMatchers.any(), (StringBuilder)ArgumentMatchers.any());
    }

    @Test
    public void testDisplayExternalRegistrationWithInfoWhenAlreadyLoggedIn() throws Exception {
        this.prepareResetPasswordContext();
        Mockito.when((Object)this.request.getRemoteUser()).thenReturn((Object)"username");
        this.externalRegisterHandler.execute(this.controllerContext);
        Assert.assertEquals((Object)"true", (Object)this.controllerContext.getRequest().getAttribute("authenticated"));
    }

    @Test
    public void testRedirectToLoginWhenValid() throws Exception {
        String password;
        this.prepareResetPasswordContext();
        String passwordConfirm = password = "pass1234";
        Mockito.when((Object)this.request.getParameter("action")).thenReturn((Object)"saveExternal");
        Mockito.when((Object)this.request.getParameter("email")).thenReturn((Object)EMAIL);
        Mockito.when((Object)this.request.getParameter(FIRSTNAME)).thenReturn((Object)FIRSTNAME);
        Mockito.when((Object)this.request.getParameter(LASTNAME)).thenReturn((Object)LASTNAME);
        Mockito.when((Object)this.request.getParameter("password")).thenReturn((Object)password);
        Mockito.when((Object)this.request.getParameter("password2")).thenReturn((Object)passwordConfirm);
        Mockito.when((Object)this.userHandler.createUserInstance((String)ArgumentMatchers.any())).thenAnswer(invocation -> new UserImpl((String)invocation.getArgument(0)));
        this.externalRegisterHandler.execute(this.controllerContext);
        Assert.assertNull(this.applicationParameters);
        ((PasswordRecoveryService)Mockito.verify((Object)this.passwordRecoveryService, (VerificationMode)Mockito.times((int)1))).sendAccountCreatedConfirmationEmail((String)ArgumentMatchers.any(), (Locale)ArgumentMatchers.any(), (StringBuilder)ArgumentMatchers.any());
        ((HttpServletResponse)Mockito.verify((Object)this.response, (VerificationMode)Mockito.times((int)1))).sendRedirect(this.servletContext.getContextPath() + "/login");
    }

    @Test
    public void testRegisterInternalWhenValid() throws Exception {
        String password;
        this.prepareResetPasswordContext();
        String passwordConfirm = password = "pass1234";
        Mockito.when((Object)this.request.getParameter("action")).thenReturn((Object)"saveExternal");
        Mockito.when((Object)this.request.getParameter("email")).thenReturn((Object)EMAIL);
        Mockito.when((Object)this.request.getParameter(FIRSTNAME)).thenReturn((Object)FIRSTNAME);
        Mockito.when((Object)this.request.getParameter(LASTNAME)).thenReturn((Object)LASTNAME);
        Mockito.when((Object)this.request.getParameter("password")).thenReturn((Object)password);
        Mockito.when((Object)this.request.getParameter("password2")).thenReturn((Object)passwordConfirm);
        Mockito.when((Object)this.userHandler.createUserInstance((String)ArgumentMatchers.any())).thenAnswer(invocation -> new UserImpl((String)invocation.getArgument(0)));
        this.externalRegisterHandler.execute(this.controllerContext);
        ((UserHandler)Mockito.verify((Object)this.organizationService.getUserHandler(), (VerificationMode)Mockito.times((int)1))).createUser((User)ArgumentMatchers.any(User.class), ArgumentMatchers.anyBoolean());
        ((MembershipHandler)Mockito.verify((Object)this.organizationService.getMembershipHandler(), (VerificationMode)Mockito.never())).removeMembership(ArgumentMatchers.anyString(), ArgumentMatchers.anyBoolean());
    }

    @Test
    public void testRegisterExternalWhenValid() throws Exception {
        String password;
        this.prepareResetPasswordContext();
        String passwordConfirm = password = "pass1234";
        Mockito.when((Object)this.request.getParameter("action")).thenReturn((Object)"saveExternal");
        Mockito.when((Object)this.request.getParameter("email")).thenReturn((Object)EMAIL);
        Mockito.when((Object)this.request.getParameter(FIRSTNAME)).thenReturn((Object)FIRSTNAME);
        Mockito.when((Object)this.request.getParameter(LASTNAME)).thenReturn((Object)LASTNAME);
        Mockito.when((Object)this.request.getParameter("password")).thenReturn((Object)password);
        Mockito.when((Object)this.request.getParameter("password2")).thenReturn((Object)passwordConfirm);
        Mockito.when((Object)this.userHandler.createUserInstance((String)ArgumentMatchers.any())).thenAnswer(invocation -> new UserImpl((String)invocation.getArgument(0)));
        Mockito.when((Object)this.securitySettingService.isRegistrationExternalUser()).thenReturn((Object)true);
        this.externalRegisterHandler.execute(this.controllerContext);
        ((UserHandler)Mockito.verify((Object)this.organizationService.getUserHandler(), (VerificationMode)Mockito.times((int)1))).createUser((User)ArgumentMatchers.any(User.class), ArgumentMatchers.anyBoolean());
        ((MembershipHandler)Mockito.verify((Object)this.organizationService.getMembershipHandler(), (VerificationMode)Mockito.times((int)1))).linkMembership((User)ArgumentMatchers.any(), (Group)ArgumentMatchers.any(), (MembershipType)ArgumentMatchers.any(), ArgumentMatchers.anyBoolean());
    }

    @Test
    public void testRedirectToRegistrationWhenValid() throws Exception {
        String password;
        this.prepareResetPasswordContext();
        String passwordConfirm = password = "pass1234";
        Mockito.when((Object)this.request.getParameter("action")).thenReturn((Object)"saveExternal");
        Mockito.when((Object)this.request.getParameter("email")).thenReturn((Object)EMAIL);
        Mockito.when((Object)this.request.getParameter(FIRSTNAME)).thenReturn((Object)FIRSTNAME);
        Mockito.when((Object)this.request.getParameter(LASTNAME)).thenReturn((Object)LASTNAME);
        Mockito.when((Object)this.request.getParameter("password")).thenReturn((Object)password);
        Mockito.when((Object)this.request.getParameter("password2")).thenReturn((Object)passwordConfirm);
        Mockito.when((Object)this.session.getAttribute("requireEmailValidation")).thenReturn((Object)"true");
        Mockito.when((Object)this.userHandler.createUserInstance((String)ArgumentMatchers.any())).thenAnswer(invocation -> new UserImpl((String)invocation.getArgument(0)));
        this.externalRegisterHandler.execute(this.controllerContext);
        Assert.assertEquals((Object)"emailVerificationSent", (Object)this.controllerContext.getRequest().getAttribute("success"));
        ((PasswordRecoveryService)Mockito.verify((Object)this.passwordRecoveryService, (VerificationMode)Mockito.times((int)1))).sendAccountVerificationEmail((String)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), (Locale)ArgumentMatchers.any(), (StringBuilder)ArgumentMatchers.any());
    }

    private void prepareResetPasswordContext() {
        HashMap<QualifiedName, String> parameters = new HashMap<QualifiedName, String>();
        parameters.put(ExternalRegisterHandler.TOKEN, TOKEN_VALUE);
        this.controllerContext = new ControllerContext(this.controller, this.router, this.request, this.response, parameters);
    }
}

