/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.web.security.codec;

import org.exoplatform.commons.api.settings.SettingService;
import org.exoplatform.component.test.AbstractKernelTest;
import org.exoplatform.component.test.ConfigurationUnit;
import org.exoplatform.component.test.ConfiguredBy;
import org.exoplatform.component.test.ContainerScope;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ValueParam;
import org.exoplatform.web.security.codec.CodecInitializer;
import org.exoplatform.web.security.codec.CodecKeyChangedException;
import org.junit.Assert;

@ConfiguredBy(value={@ConfigurationUnit(scope=ContainerScope.PORTAL, path="conf/exo.portal.component.security-configuration-local.xml")})
public class CodecInitializerTest
extends AbstractKernelTest {
    public void testStartFailsWhenKeyChanges() {
        CodecInitializer codecInitializer = (CodecInitializer)this.getContainer().getComponentInstanceOfType(CodecInitializer.class);
        codecInitializer.start();
        SettingService settingService = (SettingService)this.getContainer().getComponentInstanceOfType(SettingService.class);
        InitParams initParams = new InitParams();
        ValueParam valueParam = new ValueParam();
        valueParam.setName("gatein.conf.dir");
        valueParam.setValue(codecInitializer.getConfDir());
        initParams.addParam((Object)valueParam);
        valueParam = new ValueParam();
        valueParam.setName("codeckey.relative.path");
        valueParam.setValue("/codeckey_change.txt");
        initParams.addParam((Object)valueParam);
        CodecInitializer testCodecInitializer = new CodecInitializer(settingService, initParams);
        Assert.assertThrows(CodecKeyChangedException.class, () -> testCodecInitializer.start());
    }
}

