/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.webui.test;

import java.io.File;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import org.exoplatform.component.test.AbstractGateInTest;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.portal.webui.portal.UIPortal;
import org.exoplatform.portal.webui.test.MockApplication;
import org.exoplatform.webui.config.Event;

public class ComponentConfigConcurrentTest
extends AbstractGateInTest {
    private static final int WORKERS_COUNT = 50;
    private MockApplication mockApplication;

    public void testConcurrentReadOfComponentEventConfig() throws Exception {
        HashMap<String, String> initParams = new HashMap<String, String>();
        initParams.put("webui.configuration", "webui.configuration");
        HashMap<String, URL> resources = new HashMap<String, URL>();
        String webuiConfig = ((Object)((Object)this)).getClass().getClassLoader().getResource("webui-configuration.xml").getFile();
        URI uri = new File(webuiConfig).toURI();
        resources.put("webui.configuration", uri.toURL());
        initParams.put("webui.configuration", uri.toURL().toString());
        this.mockApplication = new MockApplication(initParams, resources, null);
        this.mockApplication.onInit();
        ArrayList<Worker> workers = new ArrayList<Worker>(50);
        PortalContainer container = PortalContainer.getInstance();
        for (int i = 0; i < 50; ++i) {
            Worker worker = new Worker(container, "Worker-" + i);
            workers.add(worker);
            worker.start();
        }
        for (Worker worker : workers) {
            worker.join(100L);
        }
        for (Worker worker : workers) {
            ComponentConfigConcurrentTest.assertNotNull((String)("event configuration is null in worker " + worker.getName()), (Object)worker.eventConfig);
        }
        this.mockApplication.onDestroy();
    }

    private class Worker
    extends Thread {
        private final PortalContainer container;
        private Event eventConfig;

        public Worker(PortalContainer container, String name) {
            super(name);
            this.eventConfig = null;
            this.container = container;
        }

        @Override
        public void run() {
            ExoContainerContext.setCurrentContainer((ExoContainer)this.container);
            try {
                UIPortal uiPortal = (UIPortal)ComponentConfigConcurrentTest.this.mockApplication.createUIComponent(UIPortal.class, null, null, null);
                this.eventConfig = uiPortal.getComponentConfig().getUIComponentEventConfig("Logout");
                if (this.eventConfig == null) {
                    ComponentConfigConcurrentTest.this.log.error((Object)("eventConfig is null for worker " + this.getName()));
                }
            }
            catch (Exception e) {
                ComponentConfigConcurrentTest.this.log.error((Object)("Exception occured during concurrent test in worker " + this.getName()), (Throwable)e);
            }
            finally {
                ExoContainerContext.setCurrentContainer(null);
            }
        }
    }
}

