/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.webui.utils;

import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import junit.framework.TestCase;
import org.exoplatform.webui.utils.TimeConvertUtils;

public class TestTimeConvertUtils
extends TestCase {
    public void testConvertDateTimeByCurrentDate() throws Exception {
        Calendar cal = Calendar.getInstance();
        long day = 86400000L;
        cal.setTimeInMillis(cal.getTimeInMillis() - 3L * (31L * day));
        TestTimeConvertUtils.assertEquals((String)"3 months", (String)TimeConvertUtils.convertXTimeAgoByTimeServer((Date)cal.getTime(), (String)"EE, dd yyyy", (Locale)Locale.ENGLISH, (int)TimeConvertUtils.YEAR));
        cal = Calendar.getInstance();
        cal.set(5, cal.get(5) - 9);
        TestTimeConvertUtils.assertEquals((String)"1 week", (String)TimeConvertUtils.convertXTimeAgoByTimeServer((Date)cal.getTime(), (String)"EE, dd yyyy", (Locale)Locale.ENGLISH, (int)TimeConvertUtils.YEAR));
        cal = Calendar.getInstance();
        cal.set(5, cal.get(5) - 5);
        TestTimeConvertUtils.assertEquals((String)"5 days", (String)TimeConvertUtils.convertXTimeAgoByTimeServer((Date)cal.getTime(), (String)"EE, dd yyyy", (Locale)Locale.ENGLISH, (int)TimeConvertUtils.YEAR));
        cal = Calendar.getInstance();
        cal.set(10, cal.get(10) - 1);
        TestTimeConvertUtils.assertEquals((String)"1 hour", (String)TimeConvertUtils.convertXTimeAgoByTimeServer((Date)cal.getTime(), (String)"EE, dd yyyy", (Locale)Locale.ENGLISH, (int)TimeConvertUtils.YEAR));
        cal = Calendar.getInstance();
        cal.set(12, cal.get(12) - 25);
        TestTimeConvertUtils.assertEquals((String)"25 minutes", (String)TimeConvertUtils.convertXTimeAgoByTimeServer((Date)cal.getTime(), (String)"EE, dd yyyy", (Locale)Locale.ENGLISH, (int)TimeConvertUtils.YEAR));
        cal = Calendar.getInstance();
        cal.set(13, cal.get(13) - 10);
        TestTimeConvertUtils.assertEquals((String)"justnow", (String)TimeConvertUtils.convertXTimeAgoByTimeServer((Date)cal.getTime(), (String)"EE, dd yyyy", (Locale)Locale.ENGLISH, (int)TimeConvertUtils.YEAR));
    }

    public void testConvertDateTime() throws Exception {
        long timeNow = TimeConvertUtils.getGreenwichMeanTime().getTimeInMillis();
        Calendar calendar = Calendar.getInstance();
        String format = "M-d-yyyy";
        long day = 86400000L;
        calendar.setTimeInMillis(timeNow - 366L * day);
        TestTimeConvertUtils.assertEquals((String)"1 year", (String)TimeConvertUtils.convertXTimeAgo((Date)calendar.getTime(), (String)format, null, (int)0));
        TestTimeConvertUtils.assertEquals((String)TimeConvertUtils.getFormatDate((Date)calendar.getTime(), (String)format), (String)TimeConvertUtils.convertXTimeAgo((Date)calendar.getTime(), (String)format, null, (int)TimeConvertUtils.YEAR));
        calendar.setTimeInMillis(timeNow - 732L * day);
        TestTimeConvertUtils.assertEquals((String)"2 years", (String)TimeConvertUtils.convertXTimeAgo((Date)calendar.getTime(), (String)format, null, (int)0));
        calendar.setTimeInMillis(timeNow - 31L * day);
        TestTimeConvertUtils.assertEquals((String)"1 month", (String)TimeConvertUtils.convertXTimeAgo((Date)calendar.getTime(), (String)format, null, (int)0));
        TestTimeConvertUtils.assertEquals((String)"1 month", (String)TimeConvertUtils.convertXTimeAgo((Date)calendar.getTime(), (String)format, null, (int)TimeConvertUtils.YEAR));
        calendar.setTimeInMillis(timeNow - 62L * day);
        TestTimeConvertUtils.assertEquals((String)"2 months", (String)TimeConvertUtils.convertXTimeAgo((Date)calendar.getTime(), (String)format, null, (int)0));
        TestTimeConvertUtils.assertEquals((String)TimeConvertUtils.getFormatDate((Date)calendar.getTime(), (String)format), (String)TimeConvertUtils.convertXTimeAgo((Date)calendar.getTime(), (String)format, null, (int)TimeConvertUtils.MONTH));
        calendar.setTimeInMillis(timeNow - 7L * day);
        TestTimeConvertUtils.assertEquals((String)"1 week", (String)TimeConvertUtils.convertXTimeAgo((Date)calendar.getTime(), (String)format, null, (int)0));
        TestTimeConvertUtils.assertEquals((String)"1 week", (String)TimeConvertUtils.convertXTimeAgo((Date)calendar.getTime(), (String)format, null, (int)TimeConvertUtils.MONTH));
        calendar.setTimeInMillis(timeNow - 14L * day);
        TestTimeConvertUtils.assertEquals((String)"2 weeks", (String)TimeConvertUtils.convertXTimeAgo((Date)calendar.getTime(), (String)format, null, (int)0));
        calendar.setTimeInMillis(timeNow - day);
        TestTimeConvertUtils.assertEquals((String)"1 day", (String)TimeConvertUtils.convertXTimeAgo((Date)calendar.getTime(), (String)format, null, (int)0));
        calendar.setTimeInMillis(timeNow - 2L * day);
        TestTimeConvertUtils.assertEquals((String)"2 days", (String)TimeConvertUtils.convertXTimeAgo((Date)calendar.getTime(), (String)format, null, (int)0));
        TestTimeConvertUtils.assertEquals((String)TimeConvertUtils.getFormatDate((Date)calendar.getTime(), (String)format), (String)TimeConvertUtils.convertXTimeAgo((Date)calendar.getTime(), (String)format, null, (int)TimeConvertUtils.DAY));
        calendar.setTimeInMillis(timeNow - 3600000L);
        TestTimeConvertUtils.assertEquals((String)"1 hour", (String)TimeConvertUtils.convertXTimeAgo((Date)calendar.getTime(), (String)format, null, (int)0));
        calendar.setTimeInMillis(timeNow - 0x6DDD00L);
        TestTimeConvertUtils.assertEquals((String)"2 hours", (String)TimeConvertUtils.convertXTimeAgo((Date)calendar.getTime(), (String)format, null, (int)0));
        TestTimeConvertUtils.assertEquals((String)"2 hours", (String)TimeConvertUtils.convertXTimeAgo((Date)calendar.getTime(), (String)format, null, (int)TimeConvertUtils.DAY));
        calendar.setTimeInMillis(timeNow - 60000L);
        TestTimeConvertUtils.assertEquals((String)"1 minute", (String)TimeConvertUtils.convertXTimeAgo((Date)calendar.getTime(), (String)format, null, (int)0));
        calendar.setTimeInMillis(timeNow - 120000L);
        TestTimeConvertUtils.assertEquals((String)"2 minutes", (String)TimeConvertUtils.convertXTimeAgo((Date)calendar.getTime(), (String)format, null, (int)0));
        calendar.setTimeInMillis(timeNow - 40000L);
        TestTimeConvertUtils.assertEquals((String)"justnow", (String)TimeConvertUtils.convertXTimeAgo((Date)calendar.getTime(), (String)format, null, (int)0));
    }

    public void testGetResourceBundle() {
    }

    public void testGetLocale() {
    }

    public void testGetFormatDate() {
        Locale locale = new Locale(Locale.ENGLISH.getLanguage(), Locale.UK.getCountry());
        Calendar calendar = Calendar.getInstance();
        calendar.set(2011, 7, 28, 15, 30);
        TestTimeConvertUtils.assertEquals((String)"", (String)TimeConvertUtils.getFormatDate(null, (String)"M-d-yyyy", (Locale)locale));
        TestTimeConvertUtils.assertEquals((String)"", (String)TimeConvertUtils.getFormatDate((Date)calendar.getTime(), (String)"", (Locale)locale));
        TestTimeConvertUtils.assertEquals((String)"8-28-2011", (String)TimeConvertUtils.getFormatDate((Date)calendar.getTime(), (String)"M-d-yyyy", (Locale)locale));
        TestTimeConvertUtils.assertEquals((String)"8-28-11", (String)TimeConvertUtils.getFormatDate((Date)calendar.getTime(), (String)"M-d-yy", (Locale)locale));
        TestTimeConvertUtils.assertEquals((String)"08-28-11", (String)TimeConvertUtils.getFormatDate((Date)calendar.getTime(), (String)"MM-dd-yy", (Locale)locale));
        TestTimeConvertUtils.assertEquals((String)"08-28-2011", (String)TimeConvertUtils.getFormatDate((Date)calendar.getTime(), (String)"MM-dd-yyyy", (Locale)locale));
        TestTimeConvertUtils.assertEquals((String)"2011-08-28", (String)TimeConvertUtils.getFormatDate((Date)calendar.getTime(), (String)"yyyy-MM-dd", (Locale)locale));
        TestTimeConvertUtils.assertEquals((String)"11-08-28", (String)TimeConvertUtils.getFormatDate((Date)calendar.getTime(), (String)"yy-MM-dd", (Locale)locale));
        TestTimeConvertUtils.assertEquals((String)"28-08-2011", (String)TimeConvertUtils.getFormatDate((Date)calendar.getTime(), (String)"dd-MM-yyyy", (Locale)locale));
        TestTimeConvertUtils.assertEquals((String)"28-08-11", (String)TimeConvertUtils.getFormatDate((Date)calendar.getTime(), (String)"dd-MM-yy", (Locale)locale));
        TestTimeConvertUtils.assertEquals((String)"8/28/2011", (String)TimeConvertUtils.getFormatDate((Date)calendar.getTime(), (String)"M/d/yyyy", (Locale)locale));
        TestTimeConvertUtils.assertEquals((String)"8/28/11", (String)TimeConvertUtils.getFormatDate((Date)calendar.getTime(), (String)"M/d/yy", (Locale)locale));
        TestTimeConvertUtils.assertEquals((String)"08/28/11", (String)TimeConvertUtils.getFormatDate((Date)calendar.getTime(), (String)"MM/dd/yy", (Locale)locale));
        TestTimeConvertUtils.assertEquals((String)"08/28/2011", (String)TimeConvertUtils.getFormatDate((Date)calendar.getTime(), (String)"MM/dd/yyyy", (Locale)locale));
        TestTimeConvertUtils.assertEquals((String)"2011/08/28", (String)TimeConvertUtils.getFormatDate((Date)calendar.getTime(), (String)"yyyy/MM/dd", (Locale)locale));
        TestTimeConvertUtils.assertEquals((String)"11/08/28", (String)TimeConvertUtils.getFormatDate((Date)calendar.getTime(), (String)"yy/MM/dd", (Locale)locale));
        TestTimeConvertUtils.assertEquals((String)"28/08/2011", (String)TimeConvertUtils.getFormatDate((Date)calendar.getTime(), (String)"dd/MM/yyyy", (Locale)locale));
        TestTimeConvertUtils.assertEquals((String)"28/08/11", (String)TimeConvertUtils.getFormatDate((Date)calendar.getTime(), (String)"dd/MM/yy", (Locale)locale));
        TestTimeConvertUtils.assertEquals((String)"Sun, August 28, 2011", (String)TimeConvertUtils.getFormatDate((Date)calendar.getTime(), (String)"EEE, MMMM dd, yyyy", (Locale)locale));
        TestTimeConvertUtils.assertEquals((String)"Sunday, August 28, 2011", (String)TimeConvertUtils.getFormatDate((Date)calendar.getTime(), (String)"EEEE, MMMM dd, yyyy", (Locale)locale));
        TestTimeConvertUtils.assertEquals((String)"Sunday, 28 August, 2011", (String)TimeConvertUtils.getFormatDate((Date)calendar.getTime(), (String)"EEEE, dd MMMM, yyyy", (Locale)locale));
        TestTimeConvertUtils.assertEquals((String)"Sun, Aug 28, 2011", (String)TimeConvertUtils.getFormatDate((Date)calendar.getTime(), (String)"EEE, MMM dd, yyyy", (Locale)locale));
        TestTimeConvertUtils.assertEquals((String)"Sunday, Aug 28, 2011", (String)TimeConvertUtils.getFormatDate((Date)calendar.getTime(), (String)"EEEE, MMM dd, yyyy", (Locale)locale));
        TestTimeConvertUtils.assertEquals((String)"Sunday, 28 Aug, 2011", (String)TimeConvertUtils.getFormatDate((Date)calendar.getTime(), (String)"EEEE, dd MMM, yyyy", (Locale)locale));
        TestTimeConvertUtils.assertEquals((String)"August 28, 2011", (String)TimeConvertUtils.getFormatDate((Date)calendar.getTime(), (String)"MMMM dd, yyyy", (Locale)locale));
        TestTimeConvertUtils.assertEquals((String)"28 August, 2011", (String)TimeConvertUtils.getFormatDate((Date)calendar.getTime(), (String)"dd MMMM, yyyy", (Locale)locale));
        TestTimeConvertUtils.assertEquals((String)"Aug 28, 2011", (String)TimeConvertUtils.getFormatDate((Date)calendar.getTime(), (String)"MMM dd, yyyy", (Locale)locale));
        TestTimeConvertUtils.assertEquals((String)"28 Aug, 2011", (String)TimeConvertUtils.getFormatDate((Date)calendar.getTime(), (String)"dd MMM, yyyy", (Locale)locale));
        TestTimeConvertUtils.assertEquals((String)"28 Aug, 2011, 03:30 PM".toLowerCase(), (String)TimeConvertUtils.getFormatDate((Date)calendar.getTime(), (String)"dd MMM, yyyy, hh:mm a", (Locale)locale).toLowerCase());
        TestTimeConvertUtils.assertEquals((String)"28 Aug, 2011, 15:30", (String)TimeConvertUtils.getFormatDate((Date)calendar.getTime(), (String)"dd MMM, yyyy, HH:mm", (Locale)locale));
    }

    public void testValidJavaVariable() {
        String input = "123 sdkjh s;:sdlkjh d";
        TestTimeConvertUtils.assertEquals((String)"_123_sdkjh_s__sdlkjh_d", (String)TimeConvertUtils.santializeJavaVariable((String)input));
    }
}

