/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.webui.ext.impl;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.exoplatform.component.test.AbstractKernelTest;
import org.exoplatform.component.test.ConfigurationUnit;
import org.exoplatform.component.test.ConfiguredBy;
import org.exoplatform.component.test.ContainerScope;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.ext.UIExtension;
import org.exoplatform.webui.ext.UIExtensionManager;
import org.exoplatform.webui.ext.filter.UIExtensionFilter;
import org.exoplatform.webui.ext.filter.UIExtensionFilterType;
import org.exoplatform.webui.ext.filter.UIExtensionFilters;
import org.exoplatform.webui.ext.impl.UIExtensionManagerImpl;

@ConfiguredBy(value={@ConfigurationUnit(scope=ContainerScope.PORTAL, path="conf/portal/test-configuration.xml")})
public class UIExtensionManagerTest
extends AbstractKernelTest {
    private static final Log LOG = ExoLogger.getLogger(UIExtensionManagerTest.class);
    private UIExtensionManagerImpl manager;
    private static boolean OK;

    public void setUp() throws Exception {
        this.manager = (UIExtensionManagerImpl)this.getContainer().getComponentInstanceOfType(UIExtensionManager.class);
    }

    public void testGetUIExtensions() {
        List extensions = this.manager.getUIExtensions(MyOwner.class.getName());
        UIExtensionManagerTest.assertEquals((int)extensions.size(), (int)36);
    }

    public void testGetUIExtensions2() {
        UIExtension extension1 = new UIExtension();
        extension1.setType("test");
        extension1.setName("b");
        this.manager.registerUIExtension(extension1);
        UIExtension extension2 = new UIExtension();
        extension2.setType("test");
        extension2.setName("a1");
        this.manager.registerUIExtension(extension2);
        UIExtension extension3 = new UIExtension();
        extension3.setType("test");
        extension3.setName("a2");
        extension3.setCategory("b");
        this.manager.registerUIExtension(extension3);
        UIExtension extension4 = new UIExtension();
        extension4.setType("test");
        extension4.setName("a3");
        extension4.setCategory("a");
        this.manager.registerUIExtension(extension4);
        UIExtension extension5 = new UIExtension();
        extension5.setType("test");
        extension5.setName("a4");
        extension5.setCategory("a");
        extension5.setRank(2);
        this.manager.registerUIExtension(extension5);
        UIExtension extension6 = new UIExtension();
        extension6.setType("test");
        extension6.setName("a5");
        extension6.setCategory("a");
        extension6.setRank(1);
        this.manager.registerUIExtension(extension6);
        UIExtension[] result = new UIExtension[]{extension6, extension5, extension4, extension3, extension2, extension1};
        List extensions = this.manager.getUIExtensions("test");
        UIExtensionManagerTest.assertEquals((int)extensions.size(), (int)6);
        int i = 0;
        for (UIExtension extension : extensions) {
            UIExtensionManagerTest.assertEquals((Object)extension, (Object)result[i++]);
        }
    }

    public void testGetUIExtension() {
        String extensionName = "Extension null-null";
        UIExtension extension = this.manager.getUIExtension(MyOwner.class.getName(), extensionName);
        UIExtensionManagerTest.assertEquals((String)extension.getName(), (String)extensionName);
    }

    public void testRegisterUIExtension() {
        String extensionName = "My Custom Extension";
        UIExtension extension = new UIExtension();
        extension.setType(MyOwner.class.getName());
        extension.setName(extensionName);
        this.manager.registerUIExtension(extension);
        UIExtension extension2 = this.manager.getUIExtension(MyOwner.class.getName(), extensionName);
        UIExtensionManagerTest.assertEquals((Object)extension, (Object)extension2);
    }

    public void testAccept() throws Exception {
        HashMap<String, Object> context = new HashMap<String, Object>();
        this.testAccept("Extension null-empty", context, true, true);
        this.testAccept("Extension null-empty", context, false, true);
        this.testAccept("Extension null-null", context, true, true);
        this.testAccept("Extension null-null", context, false, true);
        this.testAccept("Extension null-true", context, true, true);
        this.testAccept("Extension null-true", context, false, true);
        this.testAccept("Extension null-false", context, true, true);
        this.testAccept("Extension null-false", context, false, false);
        this.testAccept("Extension null-false2", context, true, true);
        this.testAccept("Extension null-false2", context, false, true);
        this.testAccept("Extension null-false3", context, true, true);
        this.testAccept("Extension null-false3", context, false, false);
        this.testAccept("Extension null-false4", context, true, false);
        this.testAccept("Extension null-false4", context, false, false);
        this.testAccept("Extension null-multiTrue", context, true, true);
        this.testAccept("Extension null-multiTrue", context, false, true);
        this.testAccept("Extension null-multiFalse", context, true, true);
        this.testAccept("Extension null-multiFalse", context, false, false);
        this.testAccept("Extension null-multiFalse2", context, true, true, Boolean.FALSE);
        this.testAccept("Extension null-multiFalse2", context, false, true, Boolean.TRUE);
        this.testAccept("Extension null-multiFalse3", context, true, true, Boolean.FALSE);
        this.testAccept("Extension null-multiFalse3", context, false, false, Boolean.FALSE);
        this.testAccept("Extension null-multiFalse4", context, true, false, Boolean.FALSE);
        this.testAccept("Extension null-multiFalse4", context, false, false, Boolean.FALSE);
        this.testAccept("Extension null-multiFalse5", context, true, true, Boolean.FALSE);
        this.testAccept("Extension null-multiFalse5", context, false, false, Boolean.TRUE);
        this.testAccept("Extension null-multiFalse6", context, true, true);
        this.testAccept("Extension null-multiFalse6", context, false, false);
        this.testAccept("Extension true-null", context, true, true);
        this.testAccept("Extension true-null", context, false, true);
        this.testAccept("Extension true-true", context, true, true);
        this.testAccept("Extension true-true", context, false, true);
        this.testAccept("Extension true-false", context, true, true);
        this.testAccept("Extension true-false", context, false, false);
        this.testAccept("Extension false-null", context, true, true);
        this.testAccept("Extension false-null", context, false, false);
        this.testAccept("Extension multiTrue-null", context, true, true);
        this.testAccept("Extension multiTrue-null", context, false, true);
        this.testAccept("Extension multiFalse-null", context, true, true);
        this.testAccept("Extension multiFalse-null", context, false, false);
        this.testAccept("Extension exception-null", context, true, true);
        this.testAccept("Extension null-exception", context, true, true);
        this.testAccept("Extension null-exception2", context, true, true);
        this.testAccept("Extension null-exception3", context, true, true);
        this.testAccept("Extension null-exception4", context, true, true);
        this.testAccept("Extension null-exception6", context, true, true);
        this.testAccept("Extension null-multiException", context, true, true);
        this.testAccept("Extension null-multiException2", context, true, true);
        this.testAccept("Extension null-multiException3", context, true, true, Boolean.FALSE);
        this.testAccept("Extension null-multiException4", context, true, true, Boolean.FALSE);
        this.testAccept("Extension null-multiException6", context, true, true, Boolean.FALSE);
        this.testAccept("Extension null-multiException7", context, true, true);
        this.testAccept("Extension null-multiException8", context, true, true, Boolean.FALSE);
        this.testAccept("Extension multiException-null", context, true, true);
        this.testAcceptWithException(context);
    }

    private void testAcceptWithException(Map<String, Object> context) throws Exception {
        this.testAccept("Extension exception-null", context, false, false);
        this.testAccept("Extension null-exception", context, false, false);
        this.testAccept("Extension null-exception2", context, false, false);
        this.testAccept("Extension null-exception3", context, false, true);
        this.testAccept("Extension null-exception4", context, false, false);
        this.testAccept("Extension null-exception5", context, true, false);
        this.testAccept("Extension null-exception5", context, false, false);
        this.testAccept("Extension null-exception6", context, false, true);
        this.testAccept("Extension null-multiException2", context, false, false);
        this.testAccept("Extension null-multiException3", context, false, true, Boolean.TRUE);
        this.testAccept("Extension null-multiException4", context, false, false, Boolean.FALSE);
        this.testAccept("Extension null-multiException5", context, true, false, Boolean.FALSE);
        this.testAccept("Extension null-multiException5", context, false, false, Boolean.FALSE);
        this.testAccept("Extension null-multiException6", context, false, false, Boolean.TRUE);
        this.testAccept("Extension null-multiException7", context, false, false);
        this.testAccept("Extension null-multiException8", context, false, true, Boolean.TRUE);
        this.testAccept("Extension null-multiException", context, false, false);
        this.testAccept("Extension multiException-null", context, false, false);
    }

    private void testAccept(String extensionName, Map<String, Object> context, boolean checkOnly, boolean expected) throws Exception {
        this.testAccept(extensionName, context, checkOnly, expected, null);
    }

    private void testAccept(String extensionName, Map<String, Object> context, boolean checkOnly, boolean expected, Boolean bOKValue) {
        String extensionType = MyOwner.class.getName();
        UIExtension extension = this.manager.getUIExtension(extensionType, extensionName);
        OK = false;
        UIExtensionManagerTest.assertEquals((boolean)expected, (boolean)this.manager.accept(extension, context, checkOnly));
        if (bOKValue != null) {
            UIExtensionManagerTest.assertEquals((boolean)bOKValue, (boolean)OK);
        }
    }

    public static class MyOwner
    extends UIContainer {
    }

    public static class UIExtensionFilterException6
    implements UIExtensionFilter {
        private UIExtensionFilterException6() {
        }

        public boolean accept(Map<String, Object> context) throws Exception {
            try {
                throw new Exception("My exception6");
            }
            catch (Exception e) {
                LOG.info((Object)("Filter exception raise: " + String.valueOf(e)));
                return false;
            }
        }

        public void onDeny(Map<String, Object> context) throws Exception {
        }

        public UIExtensionFilterType getType() {
            return UIExtensionFilterType.OPTIONAL;
        }
    }

    public static class UIExtensionFilterException5
    implements UIExtensionFilter {
        public boolean accept(Map<String, Object> context) throws Exception {
            try {
                throw new Exception("My exception5");
            }
            catch (Exception e) {
                LOG.info((Object)("Filter exception raise: " + String.valueOf(e)));
                return false;
            }
        }

        public void onDeny(Map<String, Object> context) throws Exception {
        }

        public UIExtensionFilterType getType() {
            return UIExtensionFilterType.MANDATORY;
        }
    }

    public static class UIExtensionFilterException4
    implements UIExtensionFilter {
        public boolean accept(Map<String, Object> context) throws Exception {
            try {
                throw new Exception("My exception4");
            }
            catch (Exception e) {
                LOG.info((Object)("Filter exception raise: " + String.valueOf(e)));
                return false;
            }
        }

        public void onDeny(Map<String, Object> context) throws Exception {
        }

        public UIExtensionFilterType getType() {
            return UIExtensionFilterType.REQUISITE;
        }
    }

    public static class UIExtensionFilterException3
    implements UIExtensionFilter {
        public boolean accept(Map<String, Object> context) throws Exception {
            try {
                throw new Exception("My exception3");
            }
            catch (Exception e) {
                LOG.info((Object)("Filter exception raise: " + String.valueOf(e)));
                return false;
            }
        }

        public void onDeny(Map<String, Object> context) throws Exception {
        }

        public UIExtensionFilterType getType() {
            return UIExtensionFilterType.OPTIONAL;
        }
    }

    public static class UIExtensionFilterException2
    implements UIExtensionFilter {
        private UIExtensionFilterException2() {
        }

        public boolean accept(Map<String, Object> context) throws Exception {
            try {
                throw new Exception("My exception2");
            }
            catch (Exception e) {
                LOG.info((Object)("Filter exception raise: " + String.valueOf(e)));
                return false;
            }
        }

        public void onDeny(Map<String, Object> context) throws Exception {
        }

        public UIExtensionFilterType getType() {
            return UIExtensionFilterType.REQUIRED;
        }
    }

    public static class UIExtensionFilterException
    implements UIExtensionFilter {
        public boolean accept(Map<String, Object> context) throws Exception {
            try {
                throw new Exception("My exception");
            }
            catch (Exception e) {
                LOG.info((Object)("Filter exception raise: " + String.valueOf(e)));
                return false;
            }
        }

        public void onDeny(Map<String, Object> context) throws Exception {
        }

        public UIExtensionFilterType getType() {
            return UIExtensionFilterType.REQUIRED;
        }
    }

    public static class UIExtensionFilterFalse4
    implements UIExtensionFilter {
        public boolean accept(Map<String, Object> context) {
            return false;
        }

        public void onDeny(Map<String, Object> context) throws Exception {
        }

        public UIExtensionFilterType getType() {
            return UIExtensionFilterType.MANDATORY;
        }
    }

    public static class UIExtensionFilterFalse3
    implements UIExtensionFilter {
        public boolean accept(Map<String, Object> context) {
            return false;
        }

        public void onDeny(Map<String, Object> context) throws Exception {
        }

        public UIExtensionFilterType getType() {
            return UIExtensionFilterType.REQUISITE;
        }
    }

    public static class UIExtensionFilterFalse2
    implements UIExtensionFilter {
        public boolean accept(Map<String, Object> context) {
            return false;
        }

        public void onDeny(Map<String, Object> context) throws Exception {
        }

        public UIExtensionFilterType getType() {
            return UIExtensionFilterType.OPTIONAL;
        }
    }

    public static class UIExtensionFilterFalse
    implements UIExtensionFilter {
        public boolean accept(Map<String, Object> context) {
            return false;
        }

        public void onDeny(Map<String, Object> context) throws Exception {
        }

        public UIExtensionFilterType getType() {
            return UIExtensionFilterType.REQUIRED;
        }
    }

    public static class UIExtensionFilterTrue2
    implements UIExtensionFilter {
        public boolean accept(Map<String, Object> context) {
            return true;
        }

        public void onDeny(Map<String, Object> context) throws Exception {
        }

        public UIExtensionFilterType getType() {
            return UIExtensionFilterType.MANDATORY;
        }
    }

    public static class UIExtensionFilterTrue
    implements UIExtensionFilter {
        public boolean accept(Map<String, Object> context) {
            OK = true;
            return true;
        }

        public void onDeny(Map<String, Object> context) throws Exception {
        }

        public UIExtensionFilterType getType() {
            return null;
        }
    }

    public static class MyUIExtensionComponentMultiException8
    extends UIComponent {
        @UIExtensionFilters
        public List<UIExtensionFilter> getFilters() {
            return Arrays.asList(new UIExtensionFilterException6(), new UIExtensionFilterTrue());
        }
    }

    public static class MyUIExtensionComponentMultiException7
    extends UIComponent {
        @UIExtensionFilters
        public List<UIExtensionFilter> getFilters() {
            return Arrays.asList(new UIExtensionFilterException(), new UIExtensionFilterTrue2());
        }
    }

    public static class MyUIExtensionComponentMultiException6
    extends UIComponent {
        @UIExtensionFilters
        public List<UIExtensionFilter> getFilters() {
            return Arrays.asList(new UIExtensionFilterException(), new UIExtensionFilterTrue());
        }
    }

    public static class MyUIExtensionComponentMultiException5
    extends UIComponent {
        @UIExtensionFilters
        public List<UIExtensionFilter> getFilters() {
            return Arrays.asList(new UIExtensionFilterException5(), new UIExtensionFilterTrue());
        }
    }

    public static class MyUIExtensionComponentMultiException4
    extends UIComponent {
        @UIExtensionFilters
        public List<UIExtensionFilter> getFilters() {
            return Arrays.asList(new UIExtensionFilterException4(), new UIExtensionFilterTrue());
        }
    }

    public static class MyUIExtensionComponentMultiException3
    extends UIComponent {
        @UIExtensionFilters
        public List<UIExtensionFilter> getFilters() {
            return Arrays.asList(new UIExtensionFilterException3(), new UIExtensionFilterTrue());
        }
    }

    public static class MyUIExtensionComponentMultiException2
    extends UIComponent {
        @UIExtensionFilters
        public List<UIExtensionFilter> getFilters() {
            return Arrays.asList(new UIExtensionFilterTrue(), new UIExtensionFilterException2());
        }
    }

    public static class MyUIExtensionComponentMultiException
    extends UIComponent {
        @UIExtensionFilters
        public List<UIExtensionFilter> getFilters() {
            return Arrays.asList(new UIExtensionFilterTrue(), new UIExtensionFilterException());
        }
    }

    public static class MyUIExtensionComponentMultiFalse6
    extends UIComponent {
        @UIExtensionFilters
        public List<UIExtensionFilter> getFilters() {
            return Arrays.asList(new UIExtensionFilterFalse(), new UIExtensionFilterTrue2());
        }
    }

    public static class MyUIExtensionComponentMultiFalse5
    extends UIComponent {
        @UIExtensionFilters
        public List<UIExtensionFilter> getFilters() {
            return Arrays.asList(new UIExtensionFilterFalse(), new UIExtensionFilterTrue());
        }
    }

    public static class MyUIExtensionComponentMultiFalse4
    extends UIComponent {
        @UIExtensionFilters
        public List<UIExtensionFilter> getFilters() {
            return Arrays.asList(new UIExtensionFilterFalse4(), new UIExtensionFilterTrue());
        }
    }

    public static class MyUIExtensionComponentMultiFalse3
    extends UIComponent {
        @UIExtensionFilters
        public List<UIExtensionFilter> getFilters() {
            return Arrays.asList(new UIExtensionFilterFalse3(), new UIExtensionFilterTrue());
        }
    }

    public static class MyUIExtensionComponentMultiFalse2
    extends UIComponent {
        @UIExtensionFilters
        public List<UIExtensionFilter> getFilters() {
            return Arrays.asList(new UIExtensionFilterFalse2(), new UIExtensionFilterTrue());
        }
    }

    public static class MyUIExtensionComponentMultiFalse
    extends UIComponent {
        @UIExtensionFilters
        public List<UIExtensionFilter> getFilters() {
            return Arrays.asList(new UIExtensionFilterTrue(), new UIExtensionFilterFalse());
        }
    }

    public static class MyUIExtensionComponentMultiTrue
    extends UIComponent {
        @UIExtensionFilters
        public List<UIExtensionFilter> getFilters() {
            return Arrays.asList(new UIExtensionFilterTrue(), new UIExtensionFilterTrue());
        }
    }

    public static class MyUIExtensionComponentException6
    extends UIComponent {
        @UIExtensionFilters
        public List<UIExtensionFilter> getFilters() {
            return Arrays.asList(new UIExtensionFilterException6());
        }
    }

    public static class MyUIExtensionComponentException5
    extends UIComponent {
        @UIExtensionFilters
        public List<UIExtensionFilter> getFilters() {
            return Arrays.asList(new UIExtensionFilterException5());
        }
    }

    public static class MyUIExtensionComponentException4
    extends UIComponent {
        @UIExtensionFilters
        public List<UIExtensionFilter> getFilters() {
            return Arrays.asList(new UIExtensionFilterException4());
        }
    }

    public static class MyUIExtensionComponentException3
    extends UIComponent {
        @UIExtensionFilters
        public List<UIExtensionFilter> getFilters() {
            return Arrays.asList(new UIExtensionFilterException3());
        }
    }

    public static class MyUIExtensionComponentException2
    extends UIComponent {
        @UIExtensionFilters
        public List<UIExtensionFilter> getFilters() {
            return Arrays.asList(new UIExtensionFilterException2());
        }
    }

    public static class MyUIExtensionComponentException
    extends UIComponent {
        @UIExtensionFilters
        public List<UIExtensionFilter> getFilters() {
            return Arrays.asList(new UIExtensionFilterException());
        }
    }

    public static class MyUIExtensionComponentFalse4
    extends UIComponent {
        @UIExtensionFilters
        public List<UIExtensionFilter> getFilters() {
            return Arrays.asList(new UIExtensionFilterFalse4());
        }
    }

    public static class MyUIExtensionComponentFalse3
    extends UIComponent {
        @UIExtensionFilters
        public List<UIExtensionFilter> getFilters() {
            return Arrays.asList(new UIExtensionFilterFalse3());
        }
    }

    public static class MyUIExtensionComponentFalse2
    extends UIComponent {
        @UIExtensionFilters
        public List<UIExtensionFilter> getFilters() {
            return Arrays.asList(new UIExtensionFilterFalse2());
        }
    }

    public static class MyUIExtensionComponentFalse
    extends UIComponent {
        @UIExtensionFilters
        public List<UIExtensionFilter> getFilters() {
            return Arrays.asList(new UIExtensionFilterFalse());
        }
    }

    public static class MyUIExtensionComponentTrue
    extends UIComponent {
        @UIExtensionFilters
        public List<UIExtensionFilter> getFilterTests() {
            return Arrays.asList(new UIExtensionFilterTrue());
        }
    }

    public static class MyUIExtensionComponentNull
    extends UIComponent {
        @UIExtensionFilters
        public List<UIExtensionFilter> getFilters() {
            return null;
        }
    }

    public static class MyUIExtensionComponentEmpty
    extends UIComponent {
    }

    public static class MyUIContainer
    extends UIContainer {
    }
}

