/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.application;

import java.util.List;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ObjectParameter;
import org.exoplatform.container.xml.Parameter;
import org.exoplatform.portal.page.PageTemplatePlugin;
import org.exoplatform.portal.page.PageTemplateService;
import org.exoplatform.webui.core.model.SelectItemCategory;
import org.exoplatform.webui.core.model.SelectItemOption;
import org.junit.Assert;
import org.junit.Test;

public class PageTemplateServiceTest {
    @Test
    public void testAddPageTemplatePlugin() {
        PageTemplateService pageTemplateService = new PageTemplateService();
        Assert.assertNotNull((Object)pageTemplateService.getPageTemplateCategories());
        Assert.assertTrue((boolean)pageTemplateService.getPageTemplateCategories().isEmpty());
        PageTemplatePlugin pageTemplatePlugin = new PageTemplatePlugin(null);
        Assert.assertNull((Object)pageTemplatePlugin.getCategory());
        pageTemplateService.addPageTemplate(pageTemplatePlugin);
        Assert.assertNotNull((Object)pageTemplateService.getPageTemplateCategories());
        Assert.assertTrue((boolean)pageTemplateService.getPageTemplateCategories().isEmpty());
        InitParams params = new InitParams();
        ObjectParameter categoryParameter = new ObjectParameter();
        categoryParameter.setName("category");
        SelectItemCategory category = new SelectItemCategory("testPageCategory");
        categoryParameter.setObject((Object)category);
        params.addParameter((Parameter)categoryParameter);
        pageTemplatePlugin = new PageTemplatePlugin(params);
        Assert.assertNotNull((Object)pageTemplatePlugin.getCategory());
        Assert.assertEquals((Object)category, (Object)pageTemplatePlugin.getCategory());
        pageTemplateService.addPageTemplate(pageTemplatePlugin);
        Assert.assertNotNull((Object)pageTemplateService.getPageTemplateCategories());
        Assert.assertTrue((pageTemplateService.getPageTemplateCategories().size() == 1 ? 1 : 0) != 0);
        Assert.assertEquals((Object)category, pageTemplateService.getPageTemplateCategories().get(0));
    }

    @Test
    public void testGetPageTemplates() {
        PageTemplateService pageTemplateService = new PageTemplateService();
        InitParams params = new InitParams();
        ObjectParameter category1Parameter = new ObjectParameter();
        category1Parameter.setName("category");
        SelectItemCategory category1 = new SelectItemCategory("category1");
        category1.addSelectItemOption(new SelectItemOption("page template 11", (Object)"pageTemplate11"));
        category1.addSelectItemOption(new SelectItemOption("page template 12", (Object)"pageTemplate12"));
        category1.addSelectItemOption(new SelectItemOption("page template 13", (Object)"pageTemplate13"));
        category1Parameter.setObject((Object)category1);
        params.addParameter((Parameter)category1Parameter);
        PageTemplatePlugin pageTemplatePlugin = new PageTemplatePlugin(params);
        pageTemplateService.addPageTemplate(pageTemplatePlugin);
        params = new InitParams();
        ObjectParameter category2Parameter = new ObjectParameter();
        category2Parameter.setName("category");
        SelectItemCategory category2 = new SelectItemCategory("category2");
        category2.addSelectItemOption(new SelectItemOption("page template 21", (Object)"pageTemplate21"));
        category2.addSelectItemOption(new SelectItemOption("page template 22", (Object)"pageTemplate22"));
        category2Parameter.setObject((Object)category2);
        params.addParameter((Parameter)category2Parameter);
        pageTemplatePlugin = new PageTemplatePlugin(params);
        pageTemplateService.addPageTemplate(pageTemplatePlugin);
        List pageTemplates = pageTemplateService.getPageTemplates();
        Assert.assertNotNull((Object)pageTemplates);
        Assert.assertEquals((long)5L, (long)pageTemplates.size());
        Assert.assertEquals((Object)"pageTemplate11", (Object)((SelectItemOption)pageTemplates.get(0)).getValue());
        Assert.assertEquals((Object)"page template 12", (Object)((SelectItemOption)pageTemplates.get(1)).getLabel());
        Assert.assertEquals((Object)"pageTemplate13", (Object)((SelectItemOption)pageTemplates.get(2)).getValue());
        Assert.assertEquals((Object)"page template 21", (Object)((SelectItemOption)pageTemplates.get(3)).getLabel());
        Assert.assertEquals((Object)"pageTemplate22", (Object)((SelectItemOption)pageTemplates.get(4)).getValue());
    }
}

