/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.webui.core;

import java.util.ArrayList;
import java.util.Iterator;
import junit.framework.TestCase;
import org.exoplatform.webui.core.MockUIComponent;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;

public class TestUIContainer
extends TestCase {
    public void testHasChildren() {
        UIContainer container = new UIContainer();
        TestUIContainer.assertNotNull((Object)container.getChildren());
        TestUIContainer.assertFalse((boolean)container.hasChildren());
        container = this.createUIContainer(5);
        TestUIContainer.assertNotNull((Object)container.getChildren());
        TestUIContainer.assertTrue((boolean)container.hasChildren());
    }

    public void testConcurrentModification() {
        UIContainer container = this.createUIContainer(5);
        ArrayList<String> list = new ArrayList<String>();
        for (UIComponent c : container.getChildren()) {
            list.add(c.getId());
            if (!c.getId().equals("c2")) continue;
            TestUIContainer.assertNotNull((Object)container.removeChildById("c4"));
        }
        TestUIContainer.assertEquals((int)5, (int)list.size());
        TestUIContainer.assertTrue((boolean)list.contains("c4"));
        String[] remain = new String[]{"c1", "c2", "c3", "c5"};
        this.assertChildren(remain, container);
        ArrayList<MockUIComponent> children = new ArrayList<MockUIComponent>();
        children.add(new MockUIComponent("c1"));
        children.add(new MockUIComponent("c2"));
        children.add(new MockUIComponent("c3"));
        container = new UIContainer();
        container.setChildren(children);
        list.clear();
        for (UIComponent c : container.getChildren()) {
            list.add(c.getId());
            if (!c.getId().equals("c2")) continue;
            container.addChild((UIComponent)new MockUIComponent("c_foo"));
        }
        TestUIContainer.assertEquals((int)3, (int)list.size());
        TestUIContainer.assertFalse((boolean)list.contains("c_foo"));
        String[] remain1 = new String[]{"c1", "c2", "c3", "c_foo"};
        this.assertChildren(remain1, container);
    }

    public void testMultiThreading() throws InterruptedException {
        int number = 10;
        final UIContainer container = this.createUIContainer(number);
        TestUIContainer.assertEquals((int)number, (int)container.getChildren().size());
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                container.addChild((UIComponent)new MockUIComponent("c_foo"));
            }
        });
        Iterator iterator = container.getChildren().iterator();
        ArrayList<String> list = new ArrayList<String>();
        boolean active = true;
        while (iterator.hasNext()) {
            if (active) {
                t.start();
                active = false;
            }
            list.add(((UIComponent)iterator.next()).getId());
            Thread.sleep(5L);
        }
        t.join();
        TestUIContainer.assertEquals((int)number, (int)list.size());
        TestUIContainer.assertFalse((boolean)list.contains("c_foo"));
        TestUIContainer.assertEquals((int)(number + 1), (int)container.getChildren().size());
        TestUIContainer.assertNotNull((Object)container.getChildById("c_foo"));
    }

    private void assertChildren(String[] ids, UIContainer container) {
        TestUIContainer.assertEquals((int)ids.length, (int)container.getChildren().size());
        for (String id : ids) {
            TestUIContainer.assertNotNull((Object)container.getChildById(id));
        }
    }

    private UIContainer createUIContainer(int number) {
        UIContainer container = new UIContainer();
        for (int i = 1; i <= number; ++i) {
            container.addChild((UIComponent)new MockUIComponent("c" + i));
        }
        return container;
    }
}

