/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.application.localization;

import jakarta.servlet.http.HttpServletRequest;
import java.util.Locale;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.application.localization.LocalizationLifecycle;
import org.exoplatform.portal.localization.LocaleContextInfoUtils;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.resources.LocaleConfigService;
import org.exoplatform.services.resources.LocaleContextInfo;
import org.exoplatform.services.resources.LocalePolicy;
import org.exoplatform.web.application.Application;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class LocalizationLifecycleTest {
    private static final MockedStatic<LocaleContextInfoUtils> LOCALE_CONTEXT_INFO_UTILS = Mockito.mockStatic(LocaleContextInfoUtils.class);
    @Mock
    LocaleContextInfo localeContext;
    @Mock
    Application app;
    @Mock
    ExoContainer container;
    @Mock
    LocalePolicy localePolicy;
    @Mock
    LocaleConfigService localeConfigService;
    @Mock
    OrganizationService organizationService;
    @Mock
    HttpServletRequest request;
    @Mock
    PortalRequestContext reqCtx;

    @Before
    public void setup() {
        LOCALE_CONTEXT_INFO_UTILS.when(() -> LocaleContextInfoUtils.buildLocaleContextInfo((HttpServletRequest)this.request)).thenReturn((Object)this.localeContext);
        Mockito.when((Object)this.app.getApplicationServiceContainer()).thenReturn((Object)this.container);
        Mockito.when((Object)((LocalePolicy)this.container.getComponentInstanceOfType(LocalePolicy.class))).thenReturn((Object)this.localePolicy);
        Mockito.when((Object)((LocaleConfigService)this.container.getComponentInstanceOfType(LocaleConfigService.class))).thenReturn((Object)this.localeConfigService);
        Mockito.when((Object)((OrganizationService)this.container.getComponentInstanceOfType(OrganizationService.class))).thenReturn((Object)this.organizationService);
        Mockito.when((Object)this.reqCtx.getRequest()).thenReturn((Object)this.request);
    }

    @AfterClass
    public static void afterTestClass() {
        LOCALE_CONTEXT_INFO_UTILS.close();
    }

    @Test
    public void testSaveLocaleWhenLogin() throws Exception {
        LocalizationLifecycle localizationLifecycle = new LocalizationLifecycle();
        localizationLifecycle.onInit(this.app);
        localizationLifecycle.onStartRequest(this.app, null);
        LOCALE_CONTEXT_INFO_UTILS.verifyNoInteractions();
        Mockito.when((Object)this.localePolicy.determineLocale(this.localeContext)).thenReturn((Object)Locale.FRENCH);
        localizationLifecycle.onStartRequest(this.app, (WebuiRequestContext)this.reqCtx);
        ((PortalRequestContext)Mockito.verify((Object)this.reqCtx, (VerificationMode)Mockito.never())).setAttribute(Mockito.anyString(), Mockito.any());
        Mockito.when((Object)this.request.getRemoteUser()).thenReturn((Object)"test");
        localizationLifecycle.onStartRequest(this.app, (WebuiRequestContext)this.reqCtx);
        ((PortalRequestContext)Mockito.verify((Object)this.reqCtx, (VerificationMode)Mockito.times((int)1))).setAttribute("SaveProfileLocale", (Object)true);
        Mockito.when((Object)this.localePolicy.determineLocale(this.localeContext)).thenReturn((Object)Locale.ENGLISH);
        Mockito.when((Object)this.localeContext.getUserProfileLocale()).thenReturn((Object)Locale.ENGLISH);
        localizationLifecycle.onStartRequest(this.app, (WebuiRequestContext)this.reqCtx);
        ((PortalRequestContext)Mockito.verify((Object)this.reqCtx, (VerificationMode)Mockito.times((int)1))).setAttribute("SaveProfileLocale", (Object)true);
        Mockito.when((Object)this.localePolicy.determineLocale(this.localeContext)).thenReturn((Object)Locale.FRENCH);
        localizationLifecycle.onStartRequest(this.app, (WebuiRequestContext)this.reqCtx);
        ((PortalRequestContext)Mockito.verify((Object)this.reqCtx, (VerificationMode)Mockito.times((int)2))).setAttribute("SaveProfileLocale", (Object)true);
    }
}

