/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.webui.ext.filter;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.exoplatform.webui.ext.filter.UIExtensionFilter;
import org.exoplatform.webui.ext.filter.UIExtensionORFilter;
import org.exoplatform.webui.ext.filter.impl.FileFilter;
import org.exoplatform.webui.ext.filter.impl.UserACLFilter;

public class UIExtensionORFilterTest
extends TestCase {
    public void setup() throws Exception {
        super.setUp();
    }

    public void testAcceptWhenNoFilters() {
        ArrayList<UIExtensionFilter> filters = new ArrayList<UIExtensionFilter>();
        UIExtensionORFilterDummy orFilter = new UIExtensionORFilterDummy(this, filters);
        HashMap<String, String> context = new HashMap<String, String>();
        context.put("mimeType", "application/pdf");
        try {
            boolean isAccepted = orFilter.accept(context);
            UIExtensionORFilterTest.assertEquals((boolean)true, (boolean)isAccepted);
        }
        catch (Exception e) {
            Assert.fail((String)"testAcceptWhenNoFilters is FAILED because of an unhandled excaption");
        }
    }

    public void testAcceptCasePass() {
        UserACLFilter userFilter = new UserACLFilter();
        FileFilterDummy fileFilter = new FileFilterDummy(this);
        ArrayList<String> mimetypes = new ArrayList<String>();
        mimetypes.add("image/gif");
        mimetypes.add("image/jpeg");
        mimetypes.add("image/png");
        fileFilter.setMimeTypes(mimetypes);
        ArrayList<UIExtensionFilter> filters = new ArrayList<UIExtensionFilter>();
        filters.add((UIExtensionFilter)fileFilter);
        filters.add((UIExtensionFilter)userFilter);
        UIExtensionORFilterDummy orFilter = new UIExtensionORFilterDummy(this, filters);
        HashMap<String, String> context = new HashMap<String, String>();
        context.put("mimeType", "image/gif");
        try {
            boolean isAccepted = orFilter.accept(context);
            UIExtensionORFilterTest.assertEquals((boolean)true, (boolean)isAccepted);
        }
        catch (Exception e) {
            Assert.fail((String)"testAcceptCasePass is FAILED because of an unhandled excaption");
        }
    }

    public void testAcceptCaseFail() {
        FileFilterDummy fileFilter = new FileFilterDummy(this);
        ArrayList<String> mimetypes = new ArrayList<String>();
        mimetypes.add("image/gif");
        mimetypes.add("image/jpeg");
        mimetypes.add("image/png");
        fileFilter.setMimeTypes(mimetypes);
        ArrayList<UIExtensionFilter> filters = new ArrayList<UIExtensionFilter>();
        filters.add((UIExtensionFilter)fileFilter);
        UIExtensionORFilterDummy orFilter = new UIExtensionORFilterDummy(this, filters, "Message");
        HashMap<String, String> context = new HashMap<String, String>();
        context.put("mimeType", "application/pdf");
        try {
            boolean isAccepted = orFilter.accept(context);
            UIExtensionORFilterTest.assertEquals((boolean)false, (boolean)isAccepted);
        }
        catch (Exception e) {
            Assert.fail((String)"testAcceptCaseFail is FAILED because of an unhandled excaption");
        }
    }

    public void tearDown() throws Exception {
        super.tearDown();
    }

    public class UIExtensionORFilterDummy
    extends UIExtensionORFilter {
        public UIExtensionORFilterDummy(UIExtensionORFilterTest this$0, List<UIExtensionFilter> filters) {
            super(filters);
        }

        public UIExtensionORFilterDummy(UIExtensionORFilterTest this$0, List<UIExtensionFilter> filters, String messageKey) {
            super(filters, messageKey);
        }

        public void onDeny(Map<String, Object> context) throws Exception {
        }
    }

    public class FileFilterDummy
    extends FileFilter {
        public FileFilterDummy(UIExtensionORFilterTest this$0) {
        }

        public void setMimeTypes(List<String> mimetypes) {
            this.mimeTypes = mimetypes;
        }
    }
}

