/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.webui.ext.filter.impl;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.exoplatform.component.test.AbstractKernelTest;
import org.exoplatform.component.test.ConfigurationUnit;
import org.exoplatform.component.test.ConfiguredBy;
import org.exoplatform.component.test.ContainerScope;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.security.IdentityConstants;
import org.exoplatform.services.security.MembershipEntry;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.ext.UIExtension;
import org.exoplatform.webui.ext.UIExtensionManager;
import org.exoplatform.webui.ext.filter.UIExtensionFilter;
import org.exoplatform.webui.ext.filter.UIExtensionFilters;
import org.exoplatform.webui.ext.impl.UIExtensionManagerImpl;

@ConfiguredBy(value={@ConfigurationUnit(scope=ContainerScope.PORTAL, path="conf/portal/test-configuration.xml")})
public class UserACLFilerTest
extends AbstractKernelTest {
    private UIExtension uiExtensionPrivate;
    private UIExtension uiExtensionPublic;

    public void setUp() throws Exception {
        UIExtensionManagerImpl manager = (UIExtensionManagerImpl)this.getContainer().getComponentInstanceOfType(UIExtensionManager.class);
        this.uiExtensionPrivate = manager.getUIExtension(MyOwner.class.getName(), "private-extension");
        this.uiExtensionPublic = manager.getUIExtension(MyOwner.class.getName(), "public-extension");
    }

    public void testAccept() {
        ConversationState state;
        UIExtensionFilter userACLFilterPrivate = (UIExtensionFilter)this.uiExtensionPrivate.getExtendedFilters().get(0);
        UIExtensionFilter userACLFilterPublic = (UIExtensionFilter)this.uiExtensionPublic.getExtendedFilters().get(0);
        try {
            state = new ConversationState(VUser.getGuest());
            ConversationState.setCurrent((ConversationState)state);
            UserACLFilerTest.assertEquals((boolean)false, (boolean)userACLFilterPrivate.accept(new HashMap()));
            UserACLFilerTest.assertEquals((boolean)true, (boolean)userACLFilterPublic.accept(new HashMap()));
        }
        catch (Exception e) {
            UserACLFilerTest.fail();
        }
        try {
            state = new ConversationState(VUser.getRoot());
            ConversationState.setCurrent((ConversationState)state);
            UserACLFilerTest.assertEquals((boolean)true, (boolean)userACLFilterPrivate.accept(new HashMap()));
            UserACLFilerTest.assertEquals((boolean)true, (boolean)userACLFilterPublic.accept(new HashMap()));
        }
        catch (Exception e) {
            UserACLFilerTest.fail();
        }
    }

    public static class MyOwner
    extends UIContainer {
    }

    private static class VUser {
        private VUser() {
        }

        public static Identity getRoot() {
            return new Identity("root");
        }

        public static Identity getJohn() {
            return new Identity("john", Arrays.asList(new MembershipEntry("/platform/administrators", "*")));
        }

        public static Identity getGuest() {
            return new Identity(IdentityConstants.ANONIM);
        }
    }

    public static class MyUIExtensionComponent
    extends UIComponent {
        @UIExtensionFilters
        public List<UIExtensionFilter> getFilterTests() {
            return null;
        }
    }
}

