/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.webui.form.wysiwyg;

import java.util.HashMap;
import java.util.Map;

public class XHtmlTagTool {
    private String name;
    private Map<String, String> attributes = new HashMap<String, String>();
    private String value = null;
    public static final String SPACE = " ";

    public XHtmlTagTool(String name, String value) {
        this.name = name;
        this.value = value;
    }

    public XHtmlTagTool(String name) {
        this(name, null);
    }

    public void setValue(String value) {
        this.value = value;
    }

    public void addAttribute(String key, String value) {
        this.attributes.put(key, value);
    }

    public String toString() {
        StringBuffer tag = new StringBuffer();
        tag.append("<").append(this.name);
        for (String key : this.attributes.keySet()) {
            String val = this.attributes.get(key);
            tag.append(' ').append(key).append('=').append('\"').append(val).append('\"');
        }
        if (this.value != null && this.value.length() > 0) {
            tag.append(">").append(this.value).append("</").append(this.name).append('>');
        } else {
            tag.append(" />");
        }
        return tag.toString();
    }

    public boolean equals(Object obj) {
        try {
            XHtmlTagTool tag = (XHtmlTagTool)obj;
            return this.value.equals(tag.value) && this.name.equals(tag.name) && this.attributes.equals(tag.attributes);
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    public int hashCode() {
        return this.name.hashCode() + this.value.hashCode() + this.attributes.hashCode();
    }
}

