/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.push.service.fcm;

import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.Parameter;
import org.exoplatform.container.xml.ValueParam;
import org.exoplatform.push.domain.Message;
import org.exoplatform.push.service.fcm.FCMLegacyAPIMessagePublisher;
import org.json.JSONObject;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class FCMLegacyAPIMessagePublisherTest {
    @Test
    public void shouldNotSendMessageWhenInitParamsAreNull() throws Exception {
        HttpClient httpClient = (HttpClient)Mockito.mock(HttpClient.class);
        FCMLegacyAPIMessagePublisher messagePublisher = new FCMLegacyAPIMessagePublisher(null, httpClient);
        messagePublisher.send(new Message("", "", "", "", "", ""));
        ((HttpClient)Mockito.verify((Object)httpClient, (VerificationMode)Mockito.never())).execute((HttpUriRequest)Mockito.any());
    }

    @Test
    public void shouldNotSendMessageWhenNoServerKey() throws Exception {
        HttpClient httpClient = (HttpClient)Mockito.mock(HttpClient.class);
        InitParams initParams = new InitParams();
        FCMLegacyAPIMessagePublisher messagePublisher = new FCMLegacyAPIMessagePublisher(initParams, httpClient);
        messagePublisher.send(new Message("", "", "", "", "", ""));
        ((HttpClient)Mockito.verify((Object)httpClient, (VerificationMode)Mockito.never())).execute((HttpUriRequest)Mockito.any());
    }

    @Test
    public void shouldSendMessageWhenServerKeyExists() throws Exception {
        HttpClient httpClient = (HttpClient)Mockito.mock(HttpClient.class);
        InitParams initParams = new InitParams();
        ValueParam serverKeyParam = new ValueParam();
        serverKeyParam.setName("serverKey");
        serverKeyParam.setValue("fakeServerKey");
        initParams.addParameter((Parameter)serverKeyParam);
        FCMLegacyAPIMessagePublisher messagePublisher = new FCMLegacyAPIMessagePublisher(initParams, httpClient);
        ArgumentCaptor reqArgs = ArgumentCaptor.forClass(HttpPost.class);
        messagePublisher.send(new Message("john", "token1", "android", "My Notification Title", "My Notification Body", ""));
        ((HttpClient)Mockito.verify((Object)httpClient, (VerificationMode)Mockito.times((int)1))).execute((HttpUriRequest)reqArgs.capture());
        HttpPost httpUriRequest = (HttpPost)reqArgs.getValue();
        Assert.assertNotNull((Object)httpUriRequest);
        String body = IOUtils.toString((InputStream)httpUriRequest.getEntity().getContent(), (String)"UTF-8");
        JSONObject jsonMessage = new JSONObject(body);
        Assert.assertEquals((Object)"token1", (Object)jsonMessage.getString("to"));
        Assert.assertEquals((Object)"My Notification Title", (Object)jsonMessage.getJSONObject("notification").getString("title"));
        Assert.assertEquals((Object)"My Notification Body", (Object)jsonMessage.getJSONObject("notification").getString("body"));
        Assert.assertFalse((boolean)jsonMessage.has("time_to_live"));
    }

    @Test
    public void shouldSendMessageWithTTLWhenServerKeyExists() throws Exception {
        HttpClient httpClient = (HttpClient)Mockito.mock(HttpClient.class);
        InitParams initParams = new InitParams();
        ValueParam serverKeyParam = new ValueParam();
        serverKeyParam.setName("serverKey");
        serverKeyParam.setValue("fakeServerKey");
        initParams.addParameter((Parameter)serverKeyParam);
        ValueParam messageExpirationTimeParam = new ValueParam();
        messageExpirationTimeParam.setName("messageExpirationTime");
        messageExpirationTimeParam.setValue("30");
        initParams.addParameter((Parameter)messageExpirationTimeParam);
        FCMLegacyAPIMessagePublisher messagePublisher = new FCMLegacyAPIMessagePublisher(initParams, httpClient);
        ArgumentCaptor reqArgs = ArgumentCaptor.forClass(HttpPost.class);
        messagePublisher.send(new Message("john", "token1", "android", "My Notification Title", "My Notification Body", ""));
        ((HttpClient)Mockito.verify((Object)httpClient, (VerificationMode)Mockito.times((int)1))).execute((HttpUriRequest)reqArgs.capture());
        HttpPost httpUriRequest = (HttpPost)reqArgs.getValue();
        Assert.assertNotNull((Object)httpUriRequest);
        String body = IOUtils.toString((InputStream)httpUriRequest.getEntity().getContent(), (String)"UTF-8");
        JSONObject jsonMessage = new JSONObject(body);
        Assert.assertEquals((Object)"token1", (Object)jsonMessage.getString("to"));
        Assert.assertEquals((Object)"My Notification Title", (Object)jsonMessage.getJSONObject("notification").getString("title"));
        Assert.assertEquals((Object)"My Notification Body", (Object)jsonMessage.getJSONObject("notification").getString("body"));
        Assert.assertEquals((Object)"30", (Object)jsonMessage.getString("time_to_live"));
    }
}

