/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.pwa.listener;

import io.meeds.pwa.service.PwaNotificationService;
import jakarta.annotation.PostConstruct;
import java.util.stream.Stream;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.ListenerBase;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class WebNotificationSentListener
implements ListenerBase<Object, Object> {
    private static final Log LOG = ExoLogger.getLogger(WebNotificationSentListener.class);
    private static final String[] EVENT_NAMES = new String[]{"notification.web.saved"};
    @Autowired
    private PwaNotificationService pwaNotificationService;
    @Autowired
    private ListenerService listenerService;

    @PostConstruct
    protected void init() {
        Stream.of(EVENT_NAMES).forEach(eventName -> this.listenerService.addListener(eventName, (ListenerBase)this));
    }

    public void onEvent(Event<Object, Object> event) throws Exception {
        if (event.getEventName() == null) {
            return;
        }
        try {
            Boolean isNew = (Boolean)event.getData();
            String notificationId = (String)event.getSource();
            if (isNew != null && isNew.booleanValue() && notificationId != null) {
                this.pwaNotificationService.create(Long.parseLong(notificationId));
            }
        }
        catch (Exception e) {
            LOG.warn("Error while handling notification event '{}' with id '{}'", new Object[]{event.getEventName(), event.getSource(), e});
        }
    }
}

