/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.pwa.storage;

import io.meeds.pwa.model.UserPushSubscription;
import io.meeds.social.util.JsonUtils;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.exoplatform.commons.api.settings.SettingService;
import org.exoplatform.commons.api.settings.SettingValue;
import org.exoplatform.commons.api.settings.data.Context;
import org.exoplatform.commons.api.settings.data.Scope;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PwaSubscriptionStorage {
    private static final Scope PWA_SUBSCRIPTION_SCOPE = Scope.APPLICATION.id("PWA_PUSH_SUBSCRIPTIONS");
    @Autowired
    private SettingService settingService;

    public List<UserPushSubscription> get(String username) {
        Context context = Context.USER.id(username);
        Map settings = this.settingService.getSettingsByContextAndScope(context.getName(), context.getId(), PWA_SUBSCRIPTION_SCOPE.getName(), PWA_SUBSCRIPTION_SCOPE.getId());
        if (settings == null || settings.isEmpty()) {
            return Collections.emptyList();
        }
        return settings.values().stream().map(v -> v == null || v.getValue() == null ? null : v.getValue().toString()).filter(Objects::nonNull).map(v -> (UserPushSubscription)JsonUtils.fromJsonString((String)v, UserPushSubscription.class)).toList();
    }

    public void create(UserPushSubscription subscription, String username) {
        this.settingService.set(Context.USER.id(username), PWA_SUBSCRIPTION_SCOPE, subscription.getId(), SettingValue.create((String)JsonUtils.toJsonString((Object)subscription)));
    }

    public UserPushSubscription delete(String id, String username) {
        UserPushSubscription subscription = this.get(id, username);
        if (subscription != null) {
            this.settingService.remove(Context.USER.id(username), PWA_SUBSCRIPTION_SCOPE, id);
        }
        return subscription;
    }

    public UserPushSubscription get(String id, String username) {
        SettingValue settingValue = this.settingService.get(Context.USER.id(username), PWA_SUBSCRIPTION_SCOPE, id);
        return settingValue == null || settingValue.getValue() == null ? null : (UserPushSubscription)JsonUtils.fromJsonString((String)settingValue.getValue().toString(), UserPushSubscription.class);
    }
}

