/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.relationship.model;

import org.exoplatform.social.core.identity.model.Identity;

public class Relationship {
    private String id;
    private Identity sender;
    private Identity receiver;
    private boolean isSymetric;
    private Type status;

    public Relationship(Identity sender, Identity receiver) {
        this.sender = sender;
        this.receiver = receiver;
        this.status = Type.PENDING;
    }

    public Relationship(Identity sender, Identity receiver, Type status) {
        this.sender = sender;
        this.receiver = receiver;
        this.status = status;
    }

    public Relationship(String uuid) {
        this.id = uuid;
    }

    public Identity getSender() {
        return this.sender;
    }

    public Identity getReceiver() {
        return this.receiver;
    }

    public void setSender(Identity sender) {
        this.sender = sender;
    }

    public void setReceiver(Identity receiver) {
        this.receiver = receiver;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Type getStatus() {
        return this.status;
    }

    public void setStatus(Type status) {
        this.status = status;
    }

    public void setSymetric(boolean isSymetric) {
        this.isSymetric = isSymetric;
    }

    public boolean isSymetric() {
        return this.isSymetric;
    }

    public String toString() {
        return String.valueOf(this.sender) + "--[" + String.valueOf((Object)this.status) + "]--" + String.valueOf(this.receiver);
    }

    public Identity getPartner(Identity identity) {
        if (identity.equals(this.sender)) {
            return this.receiver;
        }
        if (identity.equals(this.receiver)) {
            return this.sender;
        }
        return null;
    }

    public boolean isSender(Identity identity) {
        return identity.equals(this.sender);
    }

    public boolean isReceiver(Identity identity) {
        return identity.equals(this.receiver);
    }

    public boolean equals(Object obj) {
        if (obj instanceof Relationship) {
            return this.getId().equals(((Relationship)obj).getId());
        }
        return super.equals(obj);
    }

    public int hashCode() {
        return super.hashCode();
    }

    public static enum Type {
        PENDING,
        CONFIRMED,
        ALL,
        IGNORED,
        INCOMING,
        OUTGOING;

    }
}

