/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.space.model;

import java.util.List;
import lombok.Generated;
import org.exoplatform.social.common.Utils;
import org.exoplatform.social.core.CacheEntry;
import org.exoplatform.social.core.model.AvatarAttachment;
import org.exoplatform.social.core.model.BannerAttachment;

public class Space
implements CacheEntry {
    public static final String DEFAULT_SPACE_METADATA_OBJECT_TYPE = "space";
    public static final String ACTIVE_STATUS = "active";
    public static final String DEACTIVE_STATUS = "deactive";
    public static final String INSTALL_STATUS = "installed";
    public static final String PUBLIC = "public";
    public static final String PRIVATE = "private";
    public static final String HIDDEN = "hidden";
    public static final String OPEN = "open";
    public static final String VALIDATION = "validation";
    public static final String CLOSED = "closed";
    public static final String HOME_URL = "home";
    private long id;
    private String displayName;
    private String groupId;
    private boolean hasBindings;
    private String description;
    private String[] pendingUsers;
    private String[] invitedUsers;
    private long templateId;
    private boolean sovereign;
    private String url;
    private String visibility;
    private String registration;
    private AvatarAttachment avatarAttachment;
    private BannerAttachment bannerAttachment;
    private long createdTime;
    private long cacheTime;
    private long publicSiteId;
    private String publicSiteVisibility;
    private long lastUpdatedTime;
    private String prettyName;
    private String avatarUrl;
    private String bannerUrl;
    private String editor;
    private String[] managers;
    private Long avatarLastUpdated;
    private Long bannerLastUpdated;
    private String[] members;
    private String[] redactors;
    private String[] publishers;
    private List<String> layoutPermissions;
    private List<String> deletePermissions;
    private List<String> publicSitePermissions;
    private List<Long> categoryIds;
    private Long parentSpaceId;
    private UpdatedField field;

    public void setId(String id) {
        this.id = id == null ? 0L : Long.parseLong(id);
    }

    public void setId(long id) {
        this.id = id;
    }

    public String getId() {
        return String.valueOf(this.id);
    }

    public long getSpaceId() {
        return this.id;
    }

    public boolean hasBindings() {
        return this.hasBindings;
    }

    public String getShortName() {
        return this.groupId.substring(this.groupId.lastIndexOf("/") + 1);
    }

    public String toString() {
        return this.displayName + " (" + this.groupId + ")";
    }

    public void setAvatarAttachment(AvatarAttachment avatarAttachment) {
        this.avatarAttachment = avatarAttachment;
        if (avatarAttachment != null) {
            this.setAvatarLastUpdated(avatarAttachment.getLastModified());
        } else {
            this.setAvatarLastUpdated(null);
            this.setAvatarUrl(null);
        }
    }

    public void setBannerAttachment(BannerAttachment bannerAttachment) {
        this.bannerAttachment = bannerAttachment;
        if (bannerAttachment != null) {
            this.setBannerLastUpdated(bannerAttachment.getLastModified());
        } else {
            this.setBannerLastUpdated(null);
            this.setBannerUrl(null);
        }
    }

    public void setPrettyName(String prettyName) {
        this.prettyName = Utils.cleanString(prettyName);
    }

    public void setCreatedTime(Long createdTime) {
        this.createdTime = createdTime != null ? createdTime : System.currentTimeMillis();
    }

    public int hashCode() {
        return Long.hashCode(this.id);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Space)) return false;
        Space space = (Space)o;
        if (this.id != space.id) return false;
        return true;
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    @Generated
    public String getGroupId() {
        return this.groupId;
    }

    @Generated
    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    @Generated
    public void setHasBindings(boolean hasBindings) {
        this.hasBindings = hasBindings;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public void setDescription(String description) {
        this.description = description;
    }

    @Generated
    public String[] getPendingUsers() {
        return this.pendingUsers;
    }

    @Generated
    public void setPendingUsers(String[] pendingUsers) {
        this.pendingUsers = pendingUsers;
    }

    @Generated
    public String[] getInvitedUsers() {
        return this.invitedUsers;
    }

    @Generated
    public void setInvitedUsers(String[] invitedUsers) {
        this.invitedUsers = invitedUsers;
    }

    @Generated
    public long getTemplateId() {
        return this.templateId;
    }

    @Generated
    public void setTemplateId(long templateId) {
        this.templateId = templateId;
    }

    @Generated
    public boolean isSovereign() {
        return this.sovereign;
    }

    @Generated
    public void setSovereign(boolean sovereign) {
        this.sovereign = sovereign;
    }

    @Generated
    public void setUrl(String url) {
        this.url = url;
    }

    @Generated
    public String getUrl() {
        return this.url;
    }

    @Generated
    public void setVisibility(String visibility) {
        this.visibility = visibility;
    }

    @Generated
    public String getVisibility() {
        return this.visibility;
    }

    @Generated
    public void setRegistration(String registration) {
        this.registration = registration;
    }

    @Generated
    public String getRegistration() {
        return this.registration;
    }

    @Generated
    public AvatarAttachment getAvatarAttachment() {
        return this.avatarAttachment;
    }

    @Generated
    public BannerAttachment getBannerAttachment() {
        return this.bannerAttachment;
    }

    @Generated
    public long getCreatedTime() {
        return this.createdTime;
    }

    @Override
    @Generated
    public long getCacheTime() {
        return this.cacheTime;
    }

    @Override
    @Generated
    public void setCacheTime(long cacheTime) {
        this.cacheTime = cacheTime;
    }

    @Generated
    public long getPublicSiteId() {
        return this.publicSiteId;
    }

    @Generated
    public void setPublicSiteId(long publicSiteId) {
        this.publicSiteId = publicSiteId;
    }

    @Generated
    public String getPublicSiteVisibility() {
        return this.publicSiteVisibility;
    }

    @Generated
    public void setPublicSiteVisibility(String publicSiteVisibility) {
        this.publicSiteVisibility = publicSiteVisibility;
    }

    @Generated
    public long getLastUpdatedTime() {
        return this.lastUpdatedTime;
    }

    @Generated
    public void setLastUpdatedTime(long lastUpdatedTime) {
        this.lastUpdatedTime = lastUpdatedTime;
    }

    @Generated
    public String getPrettyName() {
        return this.prettyName;
    }

    @Generated
    public void setAvatarUrl(String avatarUrl) {
        this.avatarUrl = avatarUrl;
    }

    @Generated
    public String getAvatarUrl() {
        return this.avatarUrl;
    }

    @Generated
    public void setBannerUrl(String bannerUrl) {
        this.bannerUrl = bannerUrl;
    }

    @Generated
    public String getBannerUrl() {
        return this.bannerUrl;
    }

    @Generated
    public void setEditor(String editor) {
        this.editor = editor;
    }

    @Generated
    public String getEditor() {
        return this.editor;
    }

    @Generated
    public void setManagers(String[] managers) {
        this.managers = managers;
    }

    @Generated
    public String[] getManagers() {
        return this.managers;
    }

    @Generated
    public void setAvatarLastUpdated(Long avatarLastUpdated) {
        this.avatarLastUpdated = avatarLastUpdated;
    }

    @Generated
    public Long getAvatarLastUpdated() {
        return this.avatarLastUpdated;
    }

    @Generated
    public void setBannerLastUpdated(Long bannerLastUpdated) {
        this.bannerLastUpdated = bannerLastUpdated;
    }

    @Generated
    public Long getBannerLastUpdated() {
        return this.bannerLastUpdated;
    }

    @Generated
    public void setMembers(String[] members) {
        this.members = members;
    }

    @Generated
    public String[] getMembers() {
        return this.members;
    }

    @Generated
    public void setRedactors(String[] redactors) {
        this.redactors = redactors;
    }

    @Generated
    public String[] getRedactors() {
        return this.redactors;
    }

    @Generated
    public void setPublishers(String[] publishers) {
        this.publishers = publishers;
    }

    @Generated
    public String[] getPublishers() {
        return this.publishers;
    }

    @Generated
    public List<String> getLayoutPermissions() {
        return this.layoutPermissions;
    }

    @Generated
    public void setLayoutPermissions(List<String> layoutPermissions) {
        this.layoutPermissions = layoutPermissions;
    }

    @Generated
    public List<String> getDeletePermissions() {
        return this.deletePermissions;
    }

    @Generated
    public void setDeletePermissions(List<String> deletePermissions) {
        this.deletePermissions = deletePermissions;
    }

    @Generated
    public List<String> getPublicSitePermissions() {
        return this.publicSitePermissions;
    }

    @Generated
    public void setPublicSitePermissions(List<String> publicSitePermissions) {
        this.publicSitePermissions = publicSitePermissions;
    }

    @Generated
    public List<Long> getCategoryIds() {
        return this.categoryIds;
    }

    @Generated
    public void setCategoryIds(List<Long> categoryIds) {
        this.categoryIds = categoryIds;
    }

    @Generated
    public Long getParentSpaceId() {
        return this.parentSpaceId;
    }

    @Generated
    public void setParentSpaceId(Long parentSpaceId) {
        this.parentSpaceId = parentSpaceId;
    }

    @Generated
    public void setField(UpdatedField field) {
        this.field = field;
    }

    @Generated
    public UpdatedField getField() {
        return this.field;
    }

    public static enum UpdatedField {
        DESCRIPTION(true);

        private boolean type;

        private UpdatedField(boolean type) {
            this.type = type;
        }

        public boolean value() {
            return this.type;
        }
    }
}

