/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.common.router;

import java.util.HashMap;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.common.AbstractCommonTest;
import org.exoplatform.social.common.router.ExoRouter;

public class ExoRouterReserveTest
extends AbstractCommonTest {
    private static final Log LOG = ExoLogger.getLogger(ExoRouterReserveTest.class);
    private ExoRouter exoRouter;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.exoRouter = (ExoRouter)this.getContainer().getComponentInstanceOfType(ExoRouter.class);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testExoRouterConfig() throws Exception {
        ExoRouterReserveTest.assertNotNull((Object)this.exoRouter);
    }

    public void testReserveForActivityShow() throws Exception {
        HashMap<String, String> args = new HashMap<String, String>();
        args.put("activityID", "12345");
        ExoRouter.ActionBuilder builder = ExoRouter.reverse((String)"activity.show", args);
        ExoRouterReserveTest.assertNotNull((Object)builder);
        ExoRouterReserveTest.assertEquals((String)"/activity/12345", (String)builder.toString());
    }

    public void testReserveForForumHome() throws Exception {
        HashMap<String, String> args = new HashMap<String, String>();
        args.put("pageID", "12345");
        ExoRouter.ActionBuilder builder = ExoRouter.reverse((String)"forum.home", args);
        ExoRouterReserveTest.assertNotNull((Object)builder);
        ExoRouterReserveTest.assertEquals((String)"/12345/ForumService", (String)builder.toString());
    }

    public void testReserveForSearch() throws Exception {
        HashMap<String, String> args = new HashMap<String, String>();
        args.put("pageID", "12345");
        ExoRouter.ActionBuilder builder = ExoRouter.reverse((String)"forum.search", args);
        ExoRouterReserveTest.assertNotNull((Object)builder);
        ExoRouterReserveTest.assertEquals((String)"/12345/SearchForum", (String)builder.toString());
    }

    public void testReserveForTag() throws Exception {
        HashMap<String, String> args = new HashMap<String, String>();
        args.put("pageID", "12345");
        ExoRouter.ActionBuilder builder = ExoRouter.reverse((String)"forum.tag", args);
        ExoRouterReserveTest.assertNotNull((Object)builder);
        ExoRouterReserveTest.assertEquals((String)"/12345/Tag", (String)builder.toString());
    }

    public void testReserveForShowTopic() throws Exception {
        HashMap<String, String> args = new HashMap<String, String>();
        args.put("pageID", "12345");
        args.put("topicID", "topic987654321");
        ExoRouter.ActionBuilder builder = ExoRouter.reverse((String)"forum.topic.show", args);
        ExoRouterReserveTest.assertNotNull((Object)builder);
        ExoRouterReserveTest.assertEquals((String)"/12345/topic/topic987654321", (String)builder.toString());
    }

    public void testReserveForShowTopicTrue() throws Exception {
        HashMap<String, String> args = new HashMap<String, String>();
        args.put("pageID", "12345");
        args.put("topicID", "topic987654321");
        ExoRouter.ActionBuilder builder = ExoRouter.reverse((String)"forum.topic.reply", args);
        ExoRouterReserveTest.assertNotNull((Object)builder);
        ExoRouterReserveTest.assertEquals((String)"/12345/topic/topic987654321/reply", (String)builder.toString());
    }

    public void testReserveForShowTopicFalse() throws Exception {
        HashMap<String, String> args = new HashMap<String, String>();
        args.put("pageID", "12345");
        args.put("topicID", "topic987654321");
        ExoRouter.ActionBuilder builder = ExoRouter.reverse((String)"forum.topic.quote", args);
        ExoRouterReserveTest.assertNotNull((Object)builder);
        ExoRouterReserveTest.assertEquals((String)"/12345/topic/topic987654321/quote", (String)builder.toString());
    }

    public void testReserveForShowTopicPage() throws Exception {
        HashMap<String, String> args = new HashMap<String, String>();
        args.put("pageID", "12345");
        args.put("topicID", "topic987654321");
        args.put("pageNo", "3");
        ExoRouter.ActionBuilder builder = ExoRouter.reverse((String)"forum.topic.page", args);
        ExoRouterReserveTest.assertNotNull((Object)builder);
        ExoRouterReserveTest.assertEquals((String)"/12345/topic/topic987654321/page/3", (String)builder.toString());
    }
}

