/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.common.xmlprocessor.filters;

import junit.framework.TestCase;
import org.exoplatform.social.common.xmlprocessor.filters.URLConverterFilterPlugin;

public class URLConverterFilterPluginTest
extends TestCase {
    public void testURLConverterFilterPlugin() {
        URLConverterFilterPlugin urlConverterFilter = new URLConverterFilterPlugin(0);
        URLConverterFilterPluginTest.assertEquals((Object)"<a href=\"http://192.168.1.1/\" target=\"_blank\">http://192.168.1.1/</a>", (Object)urlConverterFilter.doFilter((Object)"http://192.168.1.1/"));
        URLConverterFilterPluginTest.assertEquals((Object)"192.168.1.1", (Object)urlConverterFilter.doFilter((Object)"192.168.1.1"));
        URLConverterFilterPluginTest.assertEquals((Object)"1.1.1.1", (Object)urlConverterFilter.doFilter((Object)"1.1.1.1"));
        URLConverterFilterPluginTest.assertEquals((Object)"1.1.1.1 <a href=\"http://1.1.1.1\" target=\"_blank\">http://1.1.1.1</a>", (Object)urlConverterFilter.doFilter((Object)"1.1.1.1 http://1.1.1.1"));
        URLConverterFilterPluginTest.assertEquals((Object)"<a href=\"http://google.com\" target=\"_blank\">http://google.com</a>", (Object)urlConverterFilter.doFilter((Object)"http://google.com"));
        URLConverterFilterPluginTest.assertEquals((Object)"<a href=\"http://www.exoplatform.com\" target=\"_blank\">www.exoplatform.com</a>", (Object)urlConverterFilter.doFilter((Object)"www.exoplatform.com"));
        URLConverterFilterPluginTest.assertEquals((Object)"<a href=\"http://exoplatform.com\" target=\"_blank\">exoplatform.com</a>", (Object)urlConverterFilter.doFilter((Object)"exoplatform.com"));
        URLConverterFilterPluginTest.assertEquals((Object)"<a href=\"http://google.com/\" target=\"_blank\">http://google.com/</a> <a href=\"http://google.com/##testdup\" target=\"_blank\">http://google.com/##testdup</a>", (Object)urlConverterFilter.doFilter((Object)"http://google.com/ http://google.com/##testdup"));
        URLConverterFilterPluginTest.assertEquals((Object)"<a href=\"http://google.com/\" target=\"_blank\">http://google.com/</a> Test URL URL <a href=\"http://google.com/##testdup\" target=\"_blank\">http://google.com/##testdup</a>", (Object)urlConverterFilter.doFilter((Object)"http://google.com/ Test URL URL http://google.com/##testdup"));
        URLConverterFilterPluginTest.assertEquals((Object)"hello1 <a href=\"http://google.com/\" target=\"_blank\">http://google.com/</a> Test URL URL <a href=\"http://google.com/##testdup\" target=\"_blank\">http://google.com/##testdup</a> hello2", (Object)urlConverterFilter.doFilter((Object)"hello1 http://google.com/ Test URL URL http://google.com/##testdup hello2"));
        URLConverterFilterPluginTest.assertEquals((Object)"<a href=\"http://abc.com:80/abc.jsp?a=1&b=2\" target=\"_blank\">http://abc.com:80/abc.jsp?a=1&amp;b=2</a>", (Object)urlConverterFilter.doFilter((Object)"http://abc.com:80/abc.jsp?a=1&b=2"));
        URLConverterFilterPluginTest.assertEquals((Object)"<a href=\"http://cwks:9090\" target=\"_blank\">http://cwks:9090</a> <a href=\"http://localhost:8080/\" target=\"_blank\">http://localhost:8080/</a> <a href=\"http://phuonglm:gtn@localhost:8080\" target=\"_blank\">http://phuonglm:gtn@localhost:8080</a> <a href=\"http://cwks\" target=\"_blank\">http://cwks</a> <a href=\"HTTP://abc.com\" target=\"_blank\">HTTP://abc.com</a> <a href=\"HTTP://mary:gtn@abc.com:8080\" target=\"_blank\">HTTP://mary:gtn@abc.com:8080</a> <a href=\"HTTP://mary:gtn@abc.com:8080\" target=\"_blank\">HTTP://mary:gtn@abc.com:8080</a> <a href=\"hTTP://mary:gtn@abc.com:8080/abc.php?blabla=/google@cwks\" target=\"_blank\">hTTP://mary:gtn@abc.com:8080/abc.php?blabla=/google@cwks</a> <a href=\"HTTP://mary:gtn@abc.com:8080/abc.php?blabla=/google@cwks#click1\" target=\"_blank\">HTTP://mary:gtn@abc.com:8080/abc.php?blabla=/google@cwks#click1</a> <a href=\"http://abc.com\" target=\"_blank\">abc.com</a> <a href=\"http://mary:gtn@abc.com:8080\" target=\"_blank\">mary:gtn@abc.com:8080</a> <a href=\"http://mary:gtn@abc.com:8080\" target=\"_blank\">mary:gtn@abc.com:8080</a> <a href=\"http://mary:gtn@abc.com:8080/abc.php?blabla=/google@cwks\" target=\"_blank\">mary:gtn@abc.com:8080/abc.php?blabla=/google@cwks</a> <a href=\"http://mary:gtn@abc.com:8080/abc.php?blabla=/google@cwks#click1\" target=\"_blank\">mary:gtn@abc.com:8080/abc.php?blabla=/google@cwks#click1</a> mary*gtn@abc.com:8080/abc.php?blabla=/google@cwks#click1", (Object)urlConverterFilter.doFilter((Object)"http://cwks:9090 http://localhost:8080/ http://phuonglm:gtn@localhost:8080 http://cwks HTTP://abc.com HTTP://mary:gtn@abc.com:8080 HTTP://mary:gtn@abc.com:8080 hTTP://mary:gtn@abc.com:8080/abc.php?blabla=/google@cwks HTTP://mary:gtn@abc.com:8080/abc.php?blabla=/google@cwks#click1 abc.com mary:gtn@abc.com:8080 mary:gtn@abc.com:8080 mary:gtn@abc.com:8080/abc.php?blabla=/google@cwks mary:gtn@abc.com:8080/abc.php?blabla=/google@cwks#click1 mary*gtn@abc.com:8080/abc.php?blabla=/google@cwks#click1"));
        URLConverterFilterPluginTest.assertEquals((String)"Do not convert invalid domain abc.def", (Object)"abc.def", (Object)urlConverterFilter.doFilter((Object)"abc.def"));
        URLConverterFilterPluginTest.assertEquals((String)"Filter should not proccess the text inside <a>", (Object)"<a href=\"abc.com\">http://abc.com</a>", (Object)urlConverterFilter.doFilter((Object)"<a href=\"abc.com\">http://abc.com</a>"));
        URLConverterFilterPluginTest.assertEquals((String)"Filter should not proccess the text inside <a>", (Object)"<a><div>http://abc.com</div> <div>http://def.com</div></a>", (Object)urlConverterFilter.doFilter((Object)"<a><div>http://abc.com</div> <div>http://def.com</div></a>"));
        URLConverterFilterPluginTest.assertEquals((String)"Filter should not proccess the text inside <a>", (Object)"<a><img src=\"x\" alt=\"x\" /> http://xyz.com </a>", (Object)urlConverterFilter.doFilter((Object)"<a><img src=\"x\" alt=\"x\" /> http://xyz.com </a>"));
    }

    public void testURLConverterFilterPluginWithMaxLength() {
        URLConverterFilterPlugin urlConverterFilter = new URLConverterFilterPlugin(15);
        URLConverterFilterPluginTest.assertEquals((Object)"<a href=\"http://google.com\" target=\"_blank\">http://googl...</a>", (Object)urlConverterFilter.doFilter((Object)"http://google.com"));
        URLConverterFilterPluginTest.assertEquals((Object)"<a href=\"http://google.com/\" target=\"_blank\">http://googl...</a> <a href=\"http://google.com/##testdup\" target=\"_blank\">http://googl...</a>", (Object)urlConverterFilter.doFilter((Object)"http://google.com/ http://google.com/##testdup"));
        URLConverterFilterPluginTest.assertEquals((Object)"<a href=\"http://google.com/\" target=\"_blank\">http://googl...</a> Test URL URL <a href=\"http://google.com/##testdup\" target=\"_blank\">http://googl...</a>", (Object)urlConverterFilter.doFilter((Object)"http://google.com/ Test URL URL http://google.com/##testdup"));
        URLConverterFilterPluginTest.assertEquals((Object)"hello1 <a href=\"http://google.com/\" target=\"_blank\">http://googl...</a> Test URL URL <a href=\"http://google.com/##testdup\" target=\"_blank\">http://googl...</a> hello2", (Object)urlConverterFilter.doFilter((Object)"hello1 http://google.com/ Test URL URL http://google.com/##testdup hello2"));
        URLConverterFilterPluginTest.assertEquals((Object)"<a href=\"http://abc.com:80/abc.jsp?a=1&b=2\" target=\"_blank\">http://abc.c...</a>", (Object)urlConverterFilter.doFilter((Object)"http://abc.com:80/abc.jsp?a=1&b=2"));
    }

    public void testURLConverterFilterPluginWithMultiLine() {
        URLConverterFilterPlugin urlConverterFilter = new URLConverterFilterPlugin(0);
        URLConverterFilterPluginTest.assertEquals((Object)"demo <a href=\"http://google.com\" target=\"_blank\">http://google.com</a> test <br />\t\n<a href=\"http://google.com\" target=\"_blank\">http://google.com</a>", (Object)urlConverterFilter.doFilter((Object)"demo http://google.com test <br />\t\nhttp://google.com"));
        URLConverterFilterPluginTest.assertEquals((Object)"demo <a href=\"http://google.com\" target=\"_blank\">http://google.com</a> test <br />\t\n <a href=\"http://google.com\" target=\"_blank\">http://google.com</a>", (Object)urlConverterFilter.doFilter((Object)"demo http://google.com test <br />\t\n http://google.com"));
        URLConverterFilterPluginTest.assertEquals((Object)"demo <a href=\"http://google.com\" target=\"_blank\">http://google.com</a> test\t\n<br />\t\n<a href=\"http://google.com\" target=\"_blank\">http://google.com</a>\n\t", (Object)urlConverterFilter.doFilter((Object)"demo http://google.com test\t\n<br />\t\nhttp://google.com\n\t"));
    }

    public void testShouldReturnNullWhenConvertingNullInput() {
        URLConverterFilterPlugin urlConverterFilterPlugin = new URLConverterFilterPlugin(0);
        Object filteredInput = urlConverterFilterPlugin.doFilter(null);
        URLConverterFilterPluginTest.assertNull((Object)filteredInput);
    }
}

