/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.common.xmlprocessor.model;

import java.util.List;
import junit.framework.TestCase;
import org.exoplatform.social.common.xmlprocessor.DOMParser;
import org.exoplatform.social.common.xmlprocessor.Tokenizer;
import org.exoplatform.social.common.xmlprocessor.model.Attributes;
import org.exoplatform.social.common.xmlprocessor.model.Node;

public class NodeTest
extends TestCase {
    public void testGetParentNode() {
        Node parentNode = new Node();
        Node childNode = new Node();
        childNode.setParentNode(parentNode);
        NodeTest.assertEquals((String)"The childNode.getParentNode() should return parentNode", (Object)parentNode, (Object)childNode.getParentNode());
    }

    public void testNodeToString() {
        Node rootNode = new Node();
        Node childNode = new Node();
        childNode.setTitle("b");
        Attributes attributes = new Attributes();
        attributes.put("style", "header");
        childNode.setAttributes(attributes);
        rootNode.addChildNode(childNode);
        childNode.setParentNode(rootNode);
        NodeTest.assertEquals((String)"rootNode.toString() must be <b style=\"header\" />", (String)"<b style=\"header\"></b>", (String)rootNode.toString());
    }

    public void testConvertToContent() {
        Node rootNode = new Node();
        Node childNode = new Node();
        childNode.setTitle("b");
        Attributes attributes = new Attributes();
        attributes.put("style", "header");
        childNode.setAttributes(attributes);
        rootNode.addChildNode(childNode);
        childNode.setParentNode(rootNode);
        childNode.convertToContent();
        NodeTest.assertEquals((String)"rootNode.toString() must be <b style=\"header\" />", (String)"<b style=\"header\"></b>", (String)rootNode.toString());
    }

    public void testIsTextNode() {
        Node testNode = new Node();
        testNode.setContent("hello");
        NodeTest.assertTrue((String)"testNode.isTextNode() must be true", (boolean)testNode.isTextNode());
        Node testNode2 = new Node();
        Node testNode3 = new Node();
        testNode2.addChildNode(testNode3);
        testNode3.setParentNode(testNode2);
        NodeTest.assertFalse((String)"testNode2.isTextNode() must be false", (boolean)testNode2.isTextNode());
        Node testNode4 = new Node();
        testNode4.setTitle("hello");
        NodeTest.assertFalse((String)"testNode2.isTextNode() must be false", (boolean)testNode4.isTextNode());
    }

    public void testIsRootNode() {
        Node testNode = new Node();
        NodeTest.assertTrue((String)"testNode.isRootNode() must be true", (boolean)testNode.isRootNode());
        Node testNode2 = new Node();
        Node testNode3 = new Node();
        testNode3.setParentNode(testNode2);
        testNode2.addChildNode(testNode3);
        NodeTest.assertFalse((String)"testNode3.testIsRootNode() must be false", (boolean)testNode3.isRootNode());
    }

    public void testIsNotSelfClosedNode() {
        Node testNode = new Node();
        testNode.setTitle("a");
        Attributes testNodeAttribute = new Attributes();
        testNodeAttribute.put("href", "http://google.com");
        NodeTest.assertFalse((String)"testNode.isSelfCloseNode() must be false", (boolean)testNode.isSelfClosedNode());
    }

    public void testIsSelfClosedNode() {
        Node testNode = new Node();
        testNode.setTitle("img");
        Attributes testNodeAttribute = new Attributes();
        testNodeAttribute.put("src", "image.png");
        NodeTest.assertTrue((String)"testNode.isSelfCloseNode() must be true", (boolean)testNode.isSelfClosedNode());
    }

    public void testInsertAfterWithRefNode() {
        Node rootNode = DOMParser.createDOMTree((List)Tokenizer.tokenize((String)"<a>help</a><b>hello</b>"));
        Node nodeToAdd = new Node();
        nodeToAdd.setContent("test Node");
        rootNode.insertAfter((Node)rootNode.getChildNodes().get(0), nodeToAdd);
        NodeTest.assertEquals((String)"nodeToAdd must be inserted after <a> node", (String)"<a>help</a>test Node<b>hello</b>", (String)rootNode.toString());
    }

    public void testInsertAfterWithPosition() {
        Node rootNode = DOMParser.createDOMTree((List)Tokenizer.tokenize((String)"<a>help</a><b>hello</b>"));
        Node nodeToAdd = new Node();
        nodeToAdd.setContent("test Node");
        rootNode.insertAfter(0, nodeToAdd);
        NodeTest.assertEquals((String)"nodeToAdd must be inserted after <a> node", (String)"<a>help</a>test Node<b>hello</b>", (String)rootNode.toString());
    }

    public void testSetGet() {
        Node node = new Node();
        node.setTitle("abc");
        NodeTest.assertEquals((String)"abc", (String)node.getTitle());
        node.setContent("def");
        NodeTest.assertEquals((String)"def", (String)node.getContent());
    }
}

