/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.listeners;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Date;
import org.exoplatform.commons.file.model.FileItem;
import org.exoplatform.services.listener.Event;
import org.exoplatform.social.core.listeners.ThumbnailFileListener;
import org.exoplatform.social.metadata.thumbnail.ImageThumbnailService;
import org.exoplatform.social.metadata.thumbnail.model.ThumbnailObject;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class ThumbnailFileListenerTest {
    @Mock
    private ImageThumbnailService imageThumbnailService;
    private ThumbnailFileListener thumbnailFileListener;

    @Before
    public void setUp() throws Exception {
        this.thumbnailFileListener = new ThumbnailFileListener(this.imageThumbnailService);
    }

    @Test
    public void testOnEvent() throws Exception {
        ThumbnailObject thumbnailObject = new ThumbnailObject("file", "1");
        FileItem fileItem = new FileItem(Long.valueOf(1L), "test", "image/png", "social", (long)"test".getBytes().length, new Date(), "user", false, (InputStream)new ByteArrayInputStream("test".getBytes()));
        Event updateFile = new Event("file.updated", (Object)fileItem.getFileInfo(), null);
        this.thumbnailFileListener.onEvent(updateFile);
        ((ImageThumbnailService)Mockito.verify((Object)this.imageThumbnailService, (VerificationMode)Mockito.times((int)1))).deleteThumbnails(Long.valueOf(1L));
        Event deleteFile = new Event("file.deleted", (Object)fileItem.getFileInfo(), null);
        this.thumbnailFileListener.onEvent(deleteFile);
        ((ImageThumbnailService)Mockito.verify((Object)this.imageThumbnailService, (VerificationMode)Mockito.times((int)2))).deleteThumbnails(Long.valueOf(1L));
    }
}

