/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.social.core.richeditor;

import io.meeds.social.core.richeditor.RichEditorConfigurationService;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.IOUtils;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.social.core.test.AbstractCoreTest;

public class RichEditorConfigurationServiceTest
extends AbstractCoreTest {
    public void testGetRichEditorConfiguration() {
        RichEditorConfigurationService richEditorConfigurationService = (RichEditorConfigurationService)this.getContainer().getComponentInstanceOfType(RichEditorConfigurationService.class);
        RichEditorConfigurationServiceTest.assertEquals((String)"// Test Default JS\n", (String)richEditorConfigurationService.getRichEditorConfiguration(""));
        RichEditorConfigurationServiceTest.assertEquals((String)"// Test Default JS\n", (String)richEditorConfigurationService.getRichEditorConfiguration(null));
        RichEditorConfigurationServiceTest.assertEquals((String)"// Test Default JS\n", (String)richEditorConfigurationService.getRichEditorConfiguration("not-extended-config"));
        RichEditorConfigurationServiceTest.assertEquals((String)"// Test Default JS\n// Test Extension JS\n".trim(), (String)richEditorConfigurationService.getRichEditorConfiguration("test-extension").trim());
    }

    public void testGetRichEditorConfigurationWithJSVariables() throws IOException, Exception {
        RichEditorConfigurationService richEditorConfigurationService = (RichEditorConfigurationService)this.getContainer().getComponentInstanceOfType(RichEditorConfigurationService.class);
        String jsConfiguration = richEditorConfigurationService.getRichEditorConfiguration("js-variable-test");
        jsConfiguration = jsConfiguration.replace("// Test Default JS\n", "");
        jsConfiguration = jsConfiguration.replaceAll("\n", "");
        ConfigurationManager configurationManager = (ConfigurationManager)this.getContainer().getComponentInstanceOfType(ConfigurationManager.class);
        String expectedConfiguration = IOUtils.toString((InputStream)configurationManager.getInputStream("jar:/ckeditor-config-js-variable-test.js"), (Charset)StandardCharsets.UTF_8);
        RichEditorConfigurationServiceTest.assertEquals((String)expectedConfiguration, (String)jsConfiguration);
    }

    public void testGetRichEditorConfigurationWithJavaVariables() {
        String value = "test-value";
        System.setProperty("io.meeds.test.key", value);
        RichEditorConfigurationService richEditorConfigurationService = (RichEditorConfigurationService)this.getContainer().getComponentInstanceOfType(RichEditorConfigurationService.class);
        String jsConfiguration = richEditorConfigurationService.getRichEditorConfiguration("java-variable-test");
        jsConfiguration = jsConfiguration.replace("// Test Default JS\n", "");
        jsConfiguration = jsConfiguration.replaceAll("\n", "");
        RichEditorConfigurationServiceTest.assertEquals((String)("const javaProp = '" + value + "';"), (String)jsConfiguration);
    }
}

