/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.space;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.exoplatform.commons.file.model.FileItem;
import org.exoplatform.portal.mop.page.PageContext;
import org.exoplatform.portal.mop.page.PageService;
import org.exoplatform.portal.mop.user.UserNode;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;
import org.exoplatform.social.common.Utils;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.SpaceUtils;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.storage.api.IdentityStorage;
import org.exoplatform.social.core.test.AbstractCoreTest;
import org.junit.Assert;

public class SpaceUtilsTest
extends AbstractCoreTest {
    private static final Log LOG = ExoLogger.getLogger(SpaceUtilsTest.class);
    private List<Space> tearDown = new ArrayList<Space>();
    private Identity identity;
    private org.exoplatform.social.core.identity.model.Identity rootIdentity;
    private IdentityManager identityManager;
    private IdentityStorage identityStorage;
    private PageService pageService;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        Set roles = Collections.emptySet();
        HashSet memberships = new HashSet();
        this.identity = new Identity("root", memberships, roles);
        this.identityManager = (IdentityManager)this.getContainer().getComponentInstanceOfType(IdentityManager.class);
        this.identityStorage = (IdentityStorage)this.getContainer().getComponentInstanceOfType(IdentityStorage.class);
        this.rootIdentity = this.identityManager.getOrCreateIdentity("organization", "root", false);
        String spaceDisplayName = "Space1";
        Space space1 = new Space();
        space1.setApp("Members:true,Contact:true");
        space1.setDisplayName(spaceDisplayName);
        space1.setPrettyName(space1.getDisplayName());
        String shortName = Utils.cleanString((String)spaceDisplayName);
        space1.setGroupId("/spaces/" + shortName);
        space1.setUrl(shortName);
        space1.setRegistration("validation");
        space1.setDescription("This is my first space for testing");
        space1.setType("classic");
        space1.setVisibility("public");
        space1.setPriority("2");
        String[] manager = new String[]{"root"};
        String[] members = new String[]{"root", "demo", "john", "mary"};
        space1.setManagers(manager);
        space1.setMembers(members);
        this.spaceService.createSpace(space1, "root");
        this.tearDown.add(space1);
    }

    @Override
    protected void tearDown() throws Exception {
        for (Space space : this.tearDown) {
            this.spaceService.deleteSpace(space);
        }
        this.identityManager.deleteIdentity(this.rootIdentity);
        super.tearDown();
    }

    public void testGetDisplayAppName() throws Exception {
        String inputPortlet = "ABCPortlet";
        String outputPortlet = "ABC";
        String inputPortlet2 = "hello world portlet";
        String outputPortlet2 = "hello world";
        SpaceUtilsTest.assertEquals((String)"ABC", (String)SpaceUtils.getDisplayAppName((String)"ABCPortlet"));
        SpaceUtilsTest.assertEquals((String)"hello world", (String)SpaceUtils.getDisplayAppName((String)"hello world portlet"));
    }

    public void testRemoveSpecialCharacter() {
        SpaceUtilsTest.assertEquals((String)"The filter should only filter special characters only", (String)"script alert 'Hello' script 100", (String)Utils.removeSpecialCharacterInSpaceFilter((String)"<script>alert('Hello');</script> 100"));
        SpaceUtilsTest.assertEquals((String)"The filter should keep wildcard *,? and %", (String)"% * '?", (String)Utils.removeSpecialCharacterInSpaceFilter((String)"( ) %{ } * [ ] '? \""));
    }

    public void testIsInstalledApp() {
        Space space = new Space();
        String apps = "ForumPortlet:Forums:true:active,WikiPortlet:Wiki:true:active,FileExplorerPortlet:Documents:true:active,CalendarPortlet:Agenda:true:active,SpaceSettingPortlet:Space Settings:false:active,AnswersPortlet:Answer:true:active,FAQPortlet:FAQ:true:active,MembersPortlet:Members:true:active";
        space.setApp(apps);
        boolean isInstalledApp = SpaceUtils.isInstalledApp((Space)space, (String)"Agenda");
        SpaceUtilsTest.assertTrue((boolean)isInstalledApp);
        isInstalledApp = SpaceUtils.isInstalledApp((Space)space, (String)"CalendarPortlet");
        SpaceUtilsTest.assertTrue((boolean)isInstalledApp);
    }

    public void testProcessUnifiedSearchCondition() {
        String input = "spa~ce~0.5";
        SpaceUtilsTest.assertEquals((String)"spa~ce", (String)Utils.processUnifiedSearchCondition((String)input));
        input = "space~0.5";
        SpaceUtilsTest.assertEquals((String)"space", (String)Utils.processUnifiedSearchCondition((String)input));
        input = "space~0.5 test~0.5";
        SpaceUtilsTest.assertEquals((String)"space test", (String)Utils.processUnifiedSearchCondition((String)input));
    }

    public void testchangeAppPageTitle() throws Exception {
        Space space1 = this.tearDown.get(0);
        ConversationState.setCurrent((ConversationState)new ConversationState(this.identity));
        List childNodes = SpaceUtils.getSpaceUserNodeChildren((Space)space1);
        PageService pageService = (PageService)this.getContainer().getComponentInstanceOfType(PageService.class);
        PageContext pc = null;
        String AppName = "";
        for (UserNode childNode : childNodes) {
            if (childNode.getPageRef() == null) continue;
            pc = pageService.loadPage(childNode.getPageRef());
            AppName = pc.getState().getDisplayName().split("-")[0].trim();
            SpaceUtilsTest.assertEquals((String)"Space1", (String)AppName);
            SpaceUtils.changeAppPageTitle((UserNode)childNode, (String)"newspacetitle");
            pc = pageService.loadPage(childNode.getPageRef());
            AppName = pc.getState().getDisplayName().split("-")[0].trim();
            SpaceUtilsTest.assertEquals((String)"newspacetitle", (String)AppName);
        }
    }

    public void testUpdateDefaultSpaceAvatar() throws Exception {
        Space space = this.tearDown.get(0);
        org.exoplatform.social.core.identity.model.Identity identity = new org.exoplatform.social.core.identity.model.Identity("space", space.getPrettyName());
        this.identityStorage.saveIdentity(identity);
        Profile profile = new Profile(identity);
        profile.setProperty("fullName", (Object)space.getDisplayName());
        this.identityStorage.saveProfile(profile);
        identity.setProfile(profile);
        String identityId = identity.getId();
        SpaceUtilsTest.assertNotNull((Object)identityId);
        FileItem avatarFile = this.identityStorage.getAvatarFile(identity);
        profile = this.identityStorage.loadProfile(profile);
        SpaceUtilsTest.assertEquals((String)"DEFAULT_AVATAR", (String)avatarFile.getFileInfo().getName());
        SpaceUtilsTest.assertTrue((boolean)profile.isDefaultAvatar());
        Long avatarFileId = avatarFile.getFileInfo().getId();
        SpaceUtilsTest.assertNotNull((Object)avatarFileId);
        profile.setProperty("test", (Object)"test");
        this.identityStorage.updateProfile(profile);
        profile = this.identityStorage.loadProfile(profile);
        SpaceUtilsTest.assertEquals((String)"DEFAULT_AVATAR", (String)avatarFile.getFileInfo().getName());
        SpaceUtilsTest.assertTrue((boolean)profile.isDefaultAvatar());
        SpaceUtilsTest.assertEquals((String)"Avatar File shouldn't change if Space not renamed", (Object)avatarFileId, (Object)avatarFile.getFileInfo().getId());
        String JOHN = "john";
        String newSpaceName = "newname";
        this.spaceService.renameSpace(JOHN, space, newSpaceName);
        space = this.spaceService.getSpaceById(space.getId());
        SpaceUtilsTest.assertEquals((String)newSpaceName, (String)space.getDisplayName());
        SpaceUtils.updateDefaultSpaceAvatar((Space)space);
        identity = this.identityManager.getOrCreateIdentity("space", space.getDisplayName());
        avatarFile = this.identityManager.getAvatarFile(identity);
        Long updatedAvatarId = avatarFile.getFileInfo().getId();
        SpaceUtilsTest.assertNotNull((Object)updatedAvatarId);
        Assert.assertNotEquals((Object)avatarFileId, (Object)updatedAvatarId);
    }

    public void testUpdateDefaultUserAvatar() throws Exception {
        FileItem avatarFile = this.identityStorage.getAvatarFile(this.rootIdentity);
        Profile profile = this.identityStorage.loadProfile(this.rootIdentity.getProfile());
        SpaceUtilsTest.assertEquals((String)"DEFAULT_AVATAR", (String)avatarFile.getFileInfo().getName());
        SpaceUtilsTest.assertTrue((boolean)profile.isDefaultAvatar());
        Long avatarFileId = avatarFile.getFileInfo().getId();
        SpaceUtilsTest.assertNotNull((Object)avatarFileId);
        profile.setProperty("test", (Object)"test");
        this.identityStorage.updateProfile(profile);
        profile = this.identityStorage.loadProfile(profile);
        SpaceUtilsTest.assertEquals((String)"DEFAULT_AVATAR", (String)avatarFile.getFileInfo().getName());
        SpaceUtilsTest.assertTrue((boolean)profile.isDefaultAvatar());
        SpaceUtilsTest.assertEquals((String)"Avatar File shouldn't change if User not renamed", (Object)avatarFileId, (Object)avatarFile.getFileInfo().getId());
    }

    public void testIsRedactor() throws Exception {
        String JOHN = "john";
        String DEMO = "demo";
        Space space = this.tearDown.get(0);
        try {
            SpaceUtilsTest.assertTrue((boolean)SpaceUtils.isRedactor((String)JOHN, (String)space.getGroupId()));
        }
        catch (Exception e) {
            LOG.error((Object)"Problem executing Test", (Throwable)e);
            SpaceUtilsTest.fail();
        }
        this.spaceService.addRedactor(space, DEMO);
        SpaceUtilsTest.assertFalse((boolean)SpaceUtils.isRedactor((String)JOHN, (String)space.getGroupId()));
        this.spaceService.addRedactor(space, JOHN);
        SpaceUtilsTest.assertTrue((boolean)SpaceUtils.isRedactor((String)JOHN, (String)space.getGroupId()));
    }

    public void testIsSpaceManagerOrSuperManager() throws Exception {
        String JOHN = "john";
        Space space = this.tearDown.get(0);
        this.spaceService.setManager(space, JOHN, true);
        try {
            SpaceUtilsTest.assertTrue((boolean)SpaceUtils.isSpaceManagerOrSuperManager((String)JOHN, (String)space.getGroupId()));
        }
        catch (Exception e) {
            LOG.error((Object)"Problem executing Test", (Throwable)e);
            SpaceUtilsTest.fail();
        }
        this.spaceService.setManager(space, JOHN, false);
        SpaceUtilsTest.assertFalse((boolean)SpaceUtils.isSpaceManagerOrSuperManager((String)JOHN, (String)space.getGroupId()));
        SpaceUtilsTest.assertTrue((boolean)SpaceUtils.isSpaceManagerOrSuperManager((String)"root", (String)space.getGroupId()));
    }
}

