/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.feature;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.activity.model.ExoSocialActivityImpl;
import org.exoplatform.social.core.application.RelationshipPublisher;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.RelationshipManager;
import org.exoplatform.social.core.manager.RelationshipManagerImpl;
import org.exoplatform.social.core.relationship.RelationshipListener;
import org.exoplatform.social.core.relationship.RelationshipListenerPlugin;
import org.exoplatform.social.core.relationship.model.Relationship;
import org.exoplatform.social.core.storage.api.ActivityStorage;
import org.exoplatform.social.core.storage.api.IdentityStorage;
import org.exoplatform.social.core.test.AbstractCoreTest;

public class WhatsHotTest
extends AbstractCoreTest {
    private IdentityStorage identityStorage;
    private ActivityStorage activityStorage;
    private RelationshipManagerImpl relationshipManager;
    private RelationshipPublisher publisher;
    private List<ExoSocialActivity> tearDownActivityList;
    private List<Relationship> tearDownRelationshipList;
    private Identity rootIdentity;
    private Identity johnIdentity;
    private Identity maryIdentity;
    private Identity demoIdentity;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.identityStorage = (IdentityStorage)this.getContainer().getComponentInstanceOfType(IdentityStorage.class);
        this.activityStorage = (ActivityStorage)this.getContainer().getComponentInstanceOfType(ActivityStorage.class);
        this.relationshipManager = (RelationshipManagerImpl)this.getContainer().getComponentInstanceOfType(RelationshipManager.class);
        WhatsHotTest.assertNotNull((Object)this.identityStorage);
        WhatsHotTest.assertNotNull((Object)this.activityStorage);
        WhatsHotTest.assertNotNull((Object)this.relationshipManager);
        this.rootIdentity = new Identity("organization", "root");
        this.johnIdentity = new Identity("organization", "john");
        this.maryIdentity = new Identity("organization", "mary");
        this.demoIdentity = new Identity("organization", "demo");
        this.identityStorage.saveIdentity(this.rootIdentity);
        this.identityStorage.saveIdentity(this.johnIdentity);
        this.identityStorage.saveIdentity(this.maryIdentity);
        this.identityStorage.saveIdentity(this.demoIdentity);
        WhatsHotTest.assertNotNull((Object)this.rootIdentity.getId());
        WhatsHotTest.assertNotNull((Object)this.johnIdentity.getId());
        WhatsHotTest.assertNotNull((Object)this.maryIdentity.getId());
        WhatsHotTest.assertNotNull((Object)this.demoIdentity.getId());
        this.tearDownActivityList = new ArrayList<ExoSocialActivity>();
        this.tearDownRelationshipList = new ArrayList<Relationship>();
    }

    @Override
    protected void tearDown() throws Exception {
        for (ExoSocialActivity activity : this.tearDownActivityList) {
            this.activityStorage.deleteActivity(activity.getId());
        }
        for (Relationship relationship : this.tearDownRelationshipList) {
            this.relationshipManager.delete(relationship);
        }
        this.identityStorage.deleteIdentity(this.rootIdentity);
        this.identityStorage.deleteIdentity(this.johnIdentity);
        this.identityStorage.deleteIdentity(this.maryIdentity);
        this.identityStorage.deleteIdentity(this.demoIdentity);
        super.tearDown();
    }

    public void testAllActivityTab() throws Exception {
        for (int i = 0; i < 5; ++i) {
            ExoSocialActivityImpl activity = new ExoSocialActivityImpl();
            activity.setTitle("title " + i);
            this.activityStorage.saveActivity(this.rootIdentity, (ExoSocialActivity)activity);
        }
        Iterator it = this.activityStorage.getActivityFeed(this.rootIdentity, 0, 5).iterator();
        for (int i = 0; i < 10; ++i) {
            ExoSocialActivityImpl activity = new ExoSocialActivityImpl();
            activity.setTitle("title " + i);
            this.activityStorage.saveActivity(this.rootIdentity, (ExoSocialActivity)activity);
            this.tearDownActivityList.add((ExoSocialActivity)activity);
        }
        while (it.hasNext()) {
            ExoSocialActivity activity = (ExoSocialActivity)it.next();
            this.createComment(activity, this.rootIdentity, 1);
            this.tearDownActivityList.add(activity);
        }
        List activityies = this.activityStorage.getActivityFeed(this.rootIdentity, 0, 15);
        int i = 0;
        int[] values = new int[]{0, 1, 2, 3, 4, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0};
        for (ExoSocialActivity activity : activityies) {
            WhatsHotTest.assertEquals((String)("title " + values[i]), (String)activity.getTitle());
            ++i;
        }
    }

    public void testMySpaceTab() throws Exception {
        for (int i = 0; i < 5; ++i) {
            ExoSocialActivityImpl activity = new ExoSocialActivityImpl();
            activity.setTitle("title " + i);
            this.activityStorage.saveActivity(this.rootIdentity, (ExoSocialActivity)activity);
        }
        Iterator it = this.activityStorage.getUserActivities(this.rootIdentity).iterator();
        for (int i = 0; i < 10; ++i) {
            ExoSocialActivityImpl activity = new ExoSocialActivityImpl();
            activity.setTitle("title " + i);
            this.activityStorage.saveActivity(this.rootIdentity, (ExoSocialActivity)activity);
            this.tearDownActivityList.add((ExoSocialActivity)activity);
        }
        while (it.hasNext()) {
            ExoSocialActivity activity = (ExoSocialActivity)it.next();
            this.createComment(activity, this.rootIdentity, 1);
            this.tearDownActivityList.add(activity);
        }
        List activityies = this.activityStorage.getUserActivities(this.rootIdentity);
        int i = 0;
        int[] values = new int[]{0, 1, 2, 3, 4, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0};
        for (ExoSocialActivity activity : activityies) {
            WhatsHotTest.assertEquals((String)("title " + values[i]), (String)activity.getTitle());
            ++i;
        }
    }

    public void testConnectionsTab() throws Exception {
        this.publisher = (RelationshipPublisher)this.getContainer().getComponentInstanceOfType(RelationshipPublisher.class);
        WhatsHotTest.assertNotNull((Object)this.publisher);
        this.relationshipManager.addListenerPlugin((RelationshipListenerPlugin)this.publisher);
        this.connectIdentities(this.demoIdentity, this.johnIdentity, true);
        List list = this.activityStorage.getActivitiesOfConnections(this.demoIdentity, 0, 2);
        WhatsHotTest.assertEquals((int)1, (int)list.size());
        ExoSocialActivity firstActivity = (ExoSocialActivity)list.get(0);
        list = this.activityStorage.getActivitiesOfConnections(this.demoIdentity, 0, 2);
        WhatsHotTest.assertEquals((int)1, (int)list.size());
        WhatsHotTest.assertEquals((String)firstActivity.getTitle(), (String)((ExoSocialActivity)list.get(0)).getTitle());
        this.tearDownActivityList.add(firstActivity);
        this.relationshipManager.unregisterListener((RelationshipListener)this.publisher);
    }

    private void createComment(ExoSocialActivity existingActivity, Identity posterIdentity, int number) {
        for (int i = 0; i < number; ++i) {
            ExoSocialActivityImpl comment = new ExoSocialActivityImpl();
            comment.setTitle("comment " + i);
            comment.setUserId(posterIdentity.getId());
            this.activityStorage.saveComment(existingActivity, (ExoSocialActivity)comment);
        }
    }

    private void connectIdentities(Identity senderIdentity, Identity receiverIdentity, boolean beConfirmed) {
        this.relationshipManager.inviteToConnect(senderIdentity, receiverIdentity);
        if (beConfirmed) {
            this.relationshipManager.confirm(receiverIdentity, senderIdentity);
        }
        this.tearDownRelationshipList.add(this.relationshipManager.get(senderIdentity, receiverIdentity));
    }
}

