/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.space.impl;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.GroupHandler;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.security.Authenticator;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.security.IdentityConstants;
import org.exoplatform.services.security.IdentityRegistry;
import org.exoplatform.social.common.lifecycle.LifeCycleListener;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.model.SpaceExternalInvitation;
import org.exoplatform.social.core.space.SpaceException;
import org.exoplatform.social.core.space.SpaceFilter;
import org.exoplatform.social.core.space.SpaceLifecycle;
import org.exoplatform.social.core.space.SpaceListAccess;
import org.exoplatform.social.core.space.SpaceListenerPlugin;
import org.exoplatform.social.core.space.SpaceTemplate;
import org.exoplatform.social.core.space.SpaceUtils;
import org.exoplatform.social.core.space.SpacesAdministrationService;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceApplicationHandler;
import org.exoplatform.social.core.space.spi.SpaceLifeCycleEvent;
import org.exoplatform.social.core.space.spi.SpaceLifeCycleListener;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.core.space.spi.SpaceTemplateService;
import org.exoplatform.social.core.storage.api.SpaceStorage;
import org.exoplatform.web.security.security.RemindPasswordTokenService;

public class SpaceServiceImpl
implements SpaceService {
    private static final Log LOG = ExoLogger.getLogger((String)SpaceServiceImpl.class.getName());
    public static final String MEMBER = "member";
    public static final String MANAGER = "manager";
    public static final String DEFAULT_APP_CATEGORY = "spacesApplications";
    private SpaceStorage spaceStorage;
    private IdentityManager identityManager;
    private OrganizationService organizationService = null;
    private UserACL userACL = null;
    private IdentityRegistry identityRegistry;
    private Authenticator authenticator;
    private SpaceLifecycle spaceLifeCycle = new SpaceLifecycle();
    private static final int OFFSET = 0;
    private static final int LIMIT = 200;
    private SpacesAdministrationService spacesAdministrationService;
    private SpaceTemplateService spaceTemplateService;

    public SpaceServiceImpl(SpaceStorage spaceStorage, IdentityManager identityManager, UserACL userACL, IdentityRegistry identityRegistry, Authenticator authenticator, SpacesAdministrationService spacesAdministrationService, SpaceTemplateService spaceTemplateService) {
        this.spaceStorage = spaceStorage;
        this.identityManager = identityManager;
        this.identityRegistry = identityRegistry;
        this.userACL = userACL;
        this.authenticator = authenticator;
        this.spacesAdministrationService = spacesAdministrationService;
        this.spaceTemplateService = spaceTemplateService;
    }

    public ListAccess<Space> getAllSpacesWithListAccess() {
        return new SpaceListAccess(this.spaceStorage, SpaceListAccess.Type.ALL);
    }

    public Space getSpaceByDisplayName(String spaceDisplayName) {
        return this.spaceStorage.getSpaceByDisplayName(spaceDisplayName);
    }

    public Space getSpaceByPrettyName(String spacePrettyName) {
        return this.spaceStorage.getSpaceByPrettyName(spacePrettyName);
    }

    public Instant getSpaceMembershipDate(long spaceId, String username) {
        return this.spaceStorage.getSpaceMembershipDate(spaceId, username);
    }

    public Space getSpaceByGroupId(String groupId) {
        return this.spaceStorage.getSpaceByGroupId(groupId);
    }

    public Space getSpaceById(String id) {
        return this.spaceStorage.getSpaceById(id);
    }

    public Space getSpaceByUrl(String url) {
        return this.spaceStorage.getSpaceByUrl(url);
    }

    public SpaceListAccess getAccessibleSpacesWithListAccess(String username) {
        return new SpaceListAccess(this.spaceStorage, username, SpaceListAccess.Type.ACCESSIBLE);
    }

    public List<Space> getVisibleSpaces(String username, SpaceFilter spaceFilter) throws SpaceException {
        try {
            return Arrays.asList(this.getVisibleSpacesWithListAccess(username, spaceFilter).load(0, 200));
        }
        catch (Exception e) {
            throw new SpaceException(SpaceException.Code.ERROR_DATASTORE, (Throwable)e);
        }
    }

    public SpaceListAccess getVisibleSpacesWithListAccess(String username, SpaceFilter spaceFilter) {
        if (this.isSuperManager(username)) {
            if (spaceFilter == null) {
                return new SpaceListAccess(this.spaceStorage, username, spaceFilter, SpaceListAccess.Type.ALL);
            }
            return new SpaceListAccess(this.spaceStorage, username, spaceFilter, SpaceListAccess.Type.ALL_FILTER);
        }
        return new SpaceListAccess(this.spaceStorage, username, spaceFilter, SpaceListAccess.Type.VISIBLE);
    }

    public SpaceListAccess getUnifiedSearchSpacesWithListAccess(String username, SpaceFilter spaceFilter) {
        return new SpaceListAccess(this.spaceStorage, username, spaceFilter, SpaceListAccess.Type.UNIFIED_SEARCH);
    }

    public SpaceListAccess getPublicSpacesWithListAccess(String username) {
        if (this.isSuperManager(username)) {
            return new SpaceListAccess(this.spaceStorage, SpaceListAccess.Type.PUBLIC_SUPER_USER);
        }
        return new SpaceListAccess(this.spaceStorage, username, SpaceListAccess.Type.PUBLIC);
    }

    public SpaceListAccess getPendingSpacesWithListAccess(String username) {
        return new SpaceListAccess(this.spaceStorage, username, SpaceListAccess.Type.PENDING);
    }

    public Space createSpace(Space space, String creator) {
        return this.createSpace(space, creator, null);
    }

    public Space createSpace(Space space, String username, List<org.exoplatform.social.core.identity.model.Identity> identitiesToInvite) throws SpaceException {
        if (!this.spacesAdministrationService.canCreateSpace(username)) {
            throw new SpaceException(SpaceException.Code.SPACE_PERMISSION);
        }
        if (space.getDisplayName().length() > 200) {
            throw new IllegalArgumentException("Error while creating the space " + space.getDisplayName() + ": space name cannot exceed 200 characters");
        }
        SpaceTemplate spaceTemplate = this.getSpaceTemplateOrDefault(space.getTemplate());
        if (spaceTemplate == null) {
            throw new SpaceException(SpaceException.Code.UNKNOWN_SPACE_TEMPLATE);
        }
        Object[] managers = space.getManagers();
        Object[] members = space.getMembers();
        managers = (String[])ArrayUtils.add((Object[])managers, (Object)username);
        members = (String[])ArrayUtils.add((Object[])members, (Object)username);
        space.setManagers((String[])managers);
        space.setMembers((String[])members);
        String groupId = SpaceUtils.createGroup(space.getDisplayName(), space.getPrettyName(), username);
        String prettyName = groupId.split("/")[2];
        if (!prettyName.equals(space.getPrettyName())) {
            space.setPrettyName(groupId.split("/")[2]);
        }
        space.setGroupId(groupId);
        space.setUrl(space.getPrettyName());
        space.setTemplate(spaceTemplate.getName());
        this.spaceLifeCycle.setCurrentEvent(SpaceLifeCycleEvent.Type.SPACE_CREATED);
        try {
            this.spaceTemplateService.initSpaceApplications(space, this.getSpaceApplicationHandler(space));
            this.saveSpace(space, true);
            this.spaceLifeCycle.spaceCreated(space, username);
        }
        catch (Exception e) {
            throw new SpaceException(SpaceException.Code.UNABLE_TO_INIT_APP, "Failed to init apps for space " + space.getPrettyName(), (Throwable)e);
        }
        finally {
            this.spaceLifeCycle.resetCurrentEvent(SpaceLifeCycleEvent.Type.SPACE_CREATED);
        }
        if (CollectionUtils.isNotEmpty(identitiesToInvite)) {
            try {
                this.inviteIdentities(space, identitiesToInvite);
            }
            catch (Exception e) {
                LOG.warn("Error inviting identities {} to space {}", new Object[]{identitiesToInvite, space.getDisplayName(), e});
            }
        }
        return this.getSpaceById(space.getId());
    }

    public void inviteIdentities(Space space, List<org.exoplatform.social.core.identity.model.Identity> identitiesToInvite) {
        if (identitiesToInvite == null || identitiesToInvite.isEmpty()) {
            return;
        }
        Set<String> usernames = this.getUsersToInvite(identitiesToInvite);
        for (String username : usernames) {
            if (this.isMember(space, username) || this.isInvited(space, username)) continue;
            this.inviteMember(space, username);
        }
    }

    public boolean isSpaceContainsExternals(Long spaceId) {
        return this.spaceStorage.countExternalMembers(spaceId) != 0;
    }

    public void saveSpace(Space space, boolean isNew) {
        Space oldSpace = this.getSpaceById(space.getId());
        this.spaceStorage.saveSpace(space, isNew);
        if (!isNew) {
            this.triggerSpaceUpdate(space, oldSpace);
        }
    }

    public void renameSpace(Space space, String newDisplayName) {
        this.spaceLifeCycle.setCurrentEvent(SpaceLifeCycleEvent.Type.SPACE_RENAMED);
        try {
            this.spaceStorage.renameSpace(space, newDisplayName);
            this.spaceLifeCycle.spaceRenamed(space, space.getEditor());
        }
        finally {
            this.spaceLifeCycle.resetCurrentEvent(SpaceLifeCycleEvent.Type.SPACE_RENAMED);
        }
    }

    public void renameSpace(Space space, String newDisplayName, String username) throws SpaceException {
        if (username == null || !this.canManageSpace(this.getSpaceById(space.getId()), username)) {
            throw new SpaceException(SpaceException.Code.UNAUTHORIZED_TO_RENAME_SPACE);
        }
        this.renameSpace(space, newDisplayName);
    }

    public void deleteSpace(Space space) {
        this.deleteSpace(space, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteSpace(Space space, boolean deleteGroup) {
        this.spaceLifeCycle.setCurrentEvent(SpaceLifeCycleEvent.Type.SPACE_REMOVED);
        try {
            try {
                SpaceUtils.removeMembershipFromGroup(space);
                org.exoplatform.social.core.identity.model.Identity spaceIdentity = null;
                if (this.identityManager.identityExisted("space", space.getPrettyName())) {
                    spaceIdentity = this.identityManager.getOrCreateSpaceIdentity(space.getPrettyName());
                }
                this.spaceStorage.deleteSpace(space.getId());
                if (spaceIdentity != null) {
                    this.identityManager.hardDeleteIdentity(spaceIdentity);
                }
                if (deleteGroup) {
                    UserACL acl = this.getUserACL();
                    GroupHandler groupHandler = this.getOrgService().getGroupHandler();
                    Group deletedGroup = groupHandler.findGroupById(space.getGroupId());
                    List mandatories = acl.getMandatoryGroups();
                    if (deletedGroup != null && !this.isMandatory(groupHandler, deletedGroup, mandatories)) {
                        SpaceUtils.removeGroup(space);
                    }
                    SpaceUtils.removePagesAndGroupNavigation(space);
                }
            }
            catch (Exception e) {
                LOG.error("Unable delete space: {}. Cause: {}", new Object[]{space.getPrettyName(), e.getMessage()});
            }
            this.spaceLifeCycle.spaceRemoved(space, space.getEditor());
        }
        finally {
            this.spaceLifeCycle.resetCurrentEvent(SpaceLifeCycleEvent.Type.SPACE_REMOVED);
        }
    }

    public void deleteSpace(String spaceId) {
        this.deleteSpace(this.getSpaceById(spaceId));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMember(Space space, String username) {
        this.spaceLifeCycle.setCurrentEvent(SpaceLifeCycleEvent.Type.JOINED);
        try {
            Object[] members = space.getMembers();
            space = this.removeInvited(space, username);
            space = this.removePending(space, username);
            if (!ArrayUtils.contains((Object[])members, (Object)username)) {
                members = (String[])ArrayUtils.add((Object[])members, (Object)username);
                space.setMembers((String[])members);
                this.updateSpace(space);
                SpaceUtils.addUserToGroupWithMemberMembership(username, space.getGroupId());
                this.spaceLifeCycle.memberJoined(space, username);
            }
        }
        finally {
            this.spaceLifeCycle.resetCurrentEvent(SpaceLifeCycleEvent.Type.JOINED);
        }
    }

    public void addMember(String spaceId, String username) {
        this.addMember(this.getSpaceById(spaceId), username);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMember(Space space, String username) {
        if (this.isManager(space, username)) {
            this.setManager(space, username, false);
        }
        if (this.isRedactor(space, username)) {
            this.removeRedactor(space, username);
        }
        if (this.isPublisher(space, username)) {
            this.removePublisher(space, username);
        }
        this.spaceLifeCycle.setCurrentEvent(SpaceLifeCycleEvent.Type.LEFT);
        try {
            org.exoplatform.social.core.identity.model.Identity spaceIdentity = this.identityManager.getOrCreateSpaceIdentity(space.getPrettyName());
            if (spaceIdentity != null && spaceIdentity.isDeleted()) {
                return;
            }
            Object[] members = space.getMembers();
            List disabledMembers = this.identityManager.getDisabledSpaceMembers(Long.parseLong(space.getId()));
            if (disabledMembers != null && !disabledMembers.isEmpty()) {
                members = (String[])ArrayUtils.addAll((Object[])members, (Object[])((String[])disabledMembers.toArray(String[]::new)));
            }
            if (ArrayUtils.contains((Object[])members, (Object)username)) {
                members = (String[])ArrayUtils.removeAllOccurrences((Object[])members, (Object)username);
                space.setMembers((String[])members);
                this.updateSpace(space);
                SpaceUtils.removeUserFromGroupWithMemberMembership(username, space.getGroupId());
                this.setManager(space, username, false);
                this.removeRedactor(space, username);
                SpaceUtils.removeUserFromGroupWithAnyMembership(username, space.getGroupId());
                this.spaceLifeCycle.memberLeft(space, username);
            }
        }
        finally {
            this.spaceLifeCycle.resetCurrentEvent(SpaceLifeCycleEvent.Type.LEFT);
        }
    }

    public void removeMember(String spaceId, String username) {
        this.removeMember(this.getSpaceById(spaceId), username);
    }

    public List<String> getMembers(Space space) {
        if (space.getMembers() != null) {
            return Arrays.asList(space.getMembers());
        }
        return Collections.emptyList();
    }

    public List<String> getMembers(String spaceId) {
        return this.getMembers(this.getSpaceById(spaceId));
    }

    public boolean isMember(Space space, String username) {
        return space != null && ArrayUtils.contains((Object[])space.getMembers(), (Object)username);
    }

    public boolean isMember(String spaceId, String username) {
        return this.isMember(this.getSpaceById(spaceId), username);
    }

    public boolean hasAccessPermission(Space space, String username) {
        return this.canViewSpace(space, username);
    }

    public boolean hasAccessPermission(String spaceId, String username) {
        return this.hasAccessPermission(this.getSpaceById(spaceId), username);
    }

    public boolean hasEditPermission(Space space, String username) {
        return this.hasSettingPermission(space, username);
    }

    public boolean hasEditPermission(String spaceId, String username) {
        return this.hasSettingPermission(this.getSpaceById(spaceId), username);
    }

    public boolean isInvited(Space space, String username) {
        return this.isInvitedUser(space, username);
    }

    public boolean isInvited(String spaceId, String username) {
        return this.isInvitedUser(this.getSpaceById(spaceId), username);
    }

    public boolean isPending(Space space, String username) {
        return this.isPendingUser(space, username);
    }

    public boolean isPending(String spaceId, String username) {
        return this.isPendingUser(this.getSpaceById(spaceId), username);
    }

    public boolean isIgnored(Space space, String username) {
        return this.spaceStorage.isSpaceIgnored(space.getId(), username);
    }

    public void setIgnored(String spaceId, String username) {
        this.spaceLifeCycle.setCurrentEvent(SpaceLifeCycleEvent.Type.DENY_INVITED_USER);
        try {
            this.spaceStorage.ignoreSpace(spaceId, username);
            this.spaceLifeCycle.removeInvitedUser(this.getSpaceById(spaceId), username);
        }
        finally {
            this.spaceLifeCycle.resetCurrentEvent(SpaceLifeCycleEvent.Type.DENY_INVITED_USER);
        }
    }

    public void restoreSpacePageLayout(String spaceId, String appId, Identity identity) throws IllegalAccessException, SpaceException {
        if (identity == null || !this.isSuperManager(identity.getUserId())) {
            throw new IllegalAccessException("User is not allowed to change page layout of spaces");
        }
        Space space = this.getSpaceById(spaceId);
        SpaceApplicationHandler appHandler = this.getSpaceApplicationHandler(space);
        try {
            appHandler.restoreApplicationLayout(space, appId);
        }
        catch (SpaceException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SpaceException(SpaceException.Code.UNABLE_TO_RESTORE_APPLICATION_LAYOUT, (Throwable)e);
        }
    }

    public void moveApplication(String spaceId, String appId, int transition) throws SpaceException {
        Space space = this.getSpaceById(spaceId);
        SpaceApplicationHandler appHandler = this.getSpaceApplicationHandler(space);
        try {
            appHandler.moveApplication(space, appId, transition);
        }
        catch (Exception e) {
            throw new SpaceException(SpaceException.Code.UNABLE_TO_MOVE_APPLICATION, (Throwable)e);
        }
    }

    public void installApplication(Space space, String appId) throws SpaceException {
        this.spaceLifeCycle.setCurrentEvent(SpaceLifeCycleEvent.Type.APP_ADDED);
        try {
            this.spaceLifeCycle.addApplication(space, this.getPortletId(appId));
        }
        finally {
            this.spaceLifeCycle.resetCurrentEvent(SpaceLifeCycleEvent.Type.APP_ADDED);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void activateApplication(Space space, String appId) throws SpaceException {
        this.spaceLifeCycle.setCurrentEvent(SpaceLifeCycleEvent.Type.APP_ACTIVATED);
        try {
            Object appName = null;
            appName = SpaceUtils.isInstalledApp(space, appId) ? appId + System.currentTimeMillis() : appId;
            SpaceApplicationHandler appHandler = this.getSpaceApplicationHandler(space);
            appHandler.activateApplication(space, appId, (String)appName);
            this.spaceTemplateService.setApp(space, appId, (String)appName, true, "active");
            this.saveSpace(space, false);
            this.spaceLifeCycle.activateApplication(space, this.getPortletId(appId));
        }
        finally {
            this.spaceLifeCycle.resetCurrentEvent(SpaceLifeCycleEvent.Type.APP_ACTIVATED);
        }
    }

    public void activateApplication(String spaceId, String appId) throws SpaceException {
        this.activateApplication(this.getSpaceById(spaceId), appId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deactivateApplication(Space space, String appId) throws SpaceException {
        String appStatus = SpaceUtils.getAppStatus(space, appId);
        if (appStatus == null) {
            LOG.warn((Object)"appStatus is null!");
            return;
        }
        if (appStatus.equals("deactive")) {
            return;
        }
        this.spaceLifeCycle.setCurrentEvent(SpaceLifeCycleEvent.Type.APP_DEACTIVATED);
        try {
            SpaceApplicationHandler appHandler = this.getSpaceApplicationHandler(space);
            appHandler.deactiveApplication(space, appId);
            this.spaceTemplateService.setApp(space, appId, appId, SpaceUtils.isRemovableApp(space, appId), "deactive");
            this.saveSpace(space, false);
            this.spaceLifeCycle.deactivateApplication(space, this.getPortletId(appId));
        }
        finally {
            this.spaceLifeCycle.resetCurrentEvent(SpaceLifeCycleEvent.Type.APP_DEACTIVATED);
        }
    }

    public void deactivateApplication(String spaceId, String appId) throws SpaceException {
        this.deactivateApplication(this.getSpaceById(spaceId), appId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeApplication(Space space, String appId, String appName) throws SpaceException {
        String appStatus = SpaceUtils.getAppStatus(space, appId);
        if (appStatus == null) {
            return;
        }
        this.spaceLifeCycle.setCurrentEvent(SpaceLifeCycleEvent.Type.APP_REMOVED);
        try {
            SpaceApplicationHandler appHandler = this.getSpaceApplicationHandler(space);
            appHandler.removeApplication(space, appId, appName);
            this.removeApp(space, appName);
            this.spaceLifeCycle.removeApplication(space, this.getPortletId(appId));
        }
        finally {
            this.spaceLifeCycle.resetCurrentEvent(SpaceLifeCycleEvent.Type.APP_REMOVED);
        }
    }

    public void removeApplication(String spaceId, String appId, String appName) throws SpaceException {
        this.removeApplication(this.getSpaceById(spaceId), appId, appName);
    }

    public void requestJoin(String spaceId, String username) {
        this.addPendingUser(this.getSpaceById(spaceId), username);
    }

    public void requestJoin(Space space, String username) {
        this.addPendingUser(space, username);
    }

    public void revokeRequestJoin(Space space, String username) {
        this.removePendingUser(space, username);
    }

    public void revokeRequestJoin(String spaceId, String username) {
        Space space = this.getSpaceById(spaceId);
        this.removePending(space, username);
        this.spaceLifeCycle.removePendingUser(space, username);
    }

    public void inviteMember(Space space, String username) {
        this.addInvitedUser(space, username);
    }

    public void inviteMember(String spaceId, String username) {
        this.addInvitedUser(this.getSpaceById(spaceId), username);
    }

    public void revokeInvitation(Space space, String username) {
        this.removeInvitedUser(space, username);
    }

    public void revokeInvitation(String spaceId, String username) {
        this.removeInvitedUser(this.getSpaceById(spaceId), username);
    }

    public void acceptInvitation(Space space, String username) throws SpaceException {
        this.addMember(space, username);
    }

    public void acceptInvitation(String spaceId, String username) throws SpaceException {
        this.addMember(this.getSpaceById(spaceId), username);
    }

    public void denyInvitation(String spaceId, String username) {
        this.removeInvitedUser(this.getSpaceById(spaceId), username);
    }

    public void denyInvitation(Space space, String username) {
        this.removeInvitedUser(space, username);
    }

    public void validateRequest(Space space, String username) {
        this.addMember(space, username);
    }

    public void validateRequest(String spaceId, String username) {
        this.addMember(this.getSpaceById(spaceId), username);
    }

    public void declineRequest(Space space, String username) {
        this.removePendingUser(space, username);
    }

    public void declineRequest(String spaceId, String username) {
        this.removePendingUser(this.getSpaceById(spaceId), username);
    }

    public void registerSpaceLifeCycleListener(SpaceLifeCycleListener listener) {
        this.spaceLifeCycle.addListener((LifeCycleListener)listener);
    }

    public void unregisterSpaceLifeCycleListener(SpaceLifeCycleListener listener) {
        this.spaceLifeCycle.removeListener((LifeCycleListener)listener);
    }

    public void addInvitedUser(Space space, String username) {
        if (ArrayUtils.contains((Object[])space.getMembers(), (Object)username)) {
            return;
        }
        if (this.isPending(space, username)) {
            this.removePending(space, username);
            this.addMember(space, username);
        } else {
            this.addInvited(space, username);
        }
        this.updateSpace(space);
        this.spaceLifeCycle.addInvitedUser(space, username);
    }

    public void addPendingUser(Space space, String username) {
        if (ArrayUtils.contains((Object[])space.getMembers(), (Object)username)) {
            return;
        }
        if (ArrayUtils.contains((Object[])space.getPendingUsers(), (Object)username)) {
            return;
        }
        if (ArrayUtils.contains((Object[])space.getInvitedUsers(), (Object)username)) {
            this.addMember(space, username);
            this.removeInvited(space, username);
            this.updateSpace(space);
            return;
        }
        String registration = space.getRegistration();
        String visibility = space.getVisibility();
        if (visibility.equals("hidden") && registration.equals("closed")) {
            LOG.warn((Object)"Unable request to join hidden");
            return;
        }
        if (registration.equals("open")) {
            this.addMember(space, username);
        } else if (registration.equals("validation")) {
            this.addPending(space, username);
            this.saveSpace(space, false);
        } else {
            LOG.warn((Object)"Unable request to join");
        }
        this.spaceLifeCycle.addPendingUser(space, username);
    }

    public ListAccess<Space> getAccessibleSpacesByFilter(String username, SpaceFilter spaceFilter) {
        if (this.isSuperManager(username) && (spaceFilter == null || spaceFilter.getAppId() == null)) {
            if (spaceFilter == null) {
                return new SpaceListAccess(this.spaceStorage, spaceFilter, SpaceListAccess.Type.ALL);
            }
            return new SpaceListAccess(this.spaceStorage, spaceFilter, SpaceListAccess.Type.ALL_FILTER);
        }
        return new SpaceListAccess(this.spaceStorage, username, spaceFilter, SpaceListAccess.Type.ACCESSIBLE_FILTER);
    }

    public ListAccess<Space> getAllSpacesByFilter(SpaceFilter spaceFilter) {
        return new SpaceListAccess(this.spaceStorage, spaceFilter, SpaceListAccess.Type.ALL_FILTER);
    }

    public ListAccess<Space> getInvitedSpacesByFilter(String username, SpaceFilter spaceFilter) {
        return new SpaceListAccess(this.spaceStorage, username, spaceFilter, SpaceListAccess.Type.INVITED_FILTER);
    }

    public ListAccess<Space> getMemberSpaces(String username) {
        return new SpaceListAccess(this.spaceStorage, username, SpaceListAccess.Type.MEMBER);
    }

    public List<String> getMemberSpacesIds(String username, int offset, int limit) {
        org.exoplatform.social.core.identity.model.Identity identity = this.identityManager.getOrCreateUserIdentity(username);
        if (identity == null) {
            return Collections.emptyList();
        }
        return this.spaceStorage.getMemberRoleSpaceIds(identity.getId(), offset, limit);
    }

    public List<String> getManagerSpacesIds(String username, int offset, int limit) {
        org.exoplatform.social.core.identity.model.Identity identity = this.identityManager.getOrCreateUserIdentity(username);
        if (identity == null) {
            return Collections.emptyList();
        }
        return this.spaceStorage.getManagerRoleSpaceIds(identity.getId(), offset, limit);
    }

    public ListAccess<Space> getManagerSpacesByFilter(String username, SpaceFilter spaceFilter) {
        return new SpaceListAccess(this.spaceStorage, username, spaceFilter, SpaceListAccess.Type.MANAGER_FILTER);
    }

    public ListAccess<Space> getManagerSpaces(String username) {
        return new SpaceListAccess(this.spaceStorage, username, SpaceListAccess.Type.MANAGER);
    }

    public ListAccess<Space> getMemberSpacesByFilter(String username, SpaceFilter spaceFilter) {
        return new SpaceListAccess(this.spaceStorage, username, spaceFilter, SpaceListAccess.Type.MEMBER_FILTER);
    }

    public ListAccess<Space> getFavoriteSpacesByFilter(String username, SpaceFilter spaceFilter) {
        return new SpaceListAccess(this.spaceStorage, username, spaceFilter, SpaceListAccess.Type.FAVORITE_FILTER);
    }

    public ListAccess<Space> getPendingSpacesByFilter(String username, SpaceFilter spaceFilter) {
        return new SpaceListAccess(this.spaceStorage, username, spaceFilter, SpaceListAccess.Type.PENDING_FILTER);
    }

    public ListAccess<Space> getPublicSpacesByFilter(String username, SpaceFilter spaceFilter) {
        if (this.isSuperManager(username)) {
            return new SpaceListAccess(this.spaceStorage, SpaceListAccess.Type.PUBLIC_SUPER_USER);
        }
        return new SpaceListAccess(this.spaceStorage, username, spaceFilter, SpaceListAccess.Type.PUBLIC_FILTER);
    }

    public ListAccess<Space> getSettingableSpaces(String username) {
        if (this.isSuperManager(username)) {
            return new SpaceListAccess(this.spaceStorage, SpaceListAccess.Type.ALL);
        }
        return new SpaceListAccess(this.spaceStorage, username, SpaceListAccess.Type.SETTING);
    }

    public ListAccess<Space> getSettingabledSpacesByFilter(String username, SpaceFilter spaceFilter) {
        if (this.isSuperManager(username)) {
            return new SpaceListAccess(this.spaceStorage, spaceFilter, SpaceListAccess.Type.ALL_FILTER);
        }
        return new SpaceListAccess(this.spaceStorage, username, spaceFilter, SpaceListAccess.Type.SETTING_FILTER);
    }

    public boolean hasSettingPermission(Space space, String username) {
        return this.canManageSpace(space, username);
    }

    public boolean isInvitedUser(Space space, String username) {
        return space != null && ArrayUtils.contains((Object[])space.getInvitedUsers(), (Object)username);
    }

    public boolean isManager(Space space, String username) {
        return space != null && ArrayUtils.contains((Object[])space.getManagers(), (Object)username);
    }

    public boolean isRedactor(Space space, String username) {
        return space != null && ArrayUtils.contains((Object[])space.getRedactors(), (Object)username);
    }

    public boolean isPublisher(Space space, String username) {
        return space != null && ArrayUtils.contains((Object[])space.getPublishers(), (Object)username);
    }

    public boolean hasRedactor(Space space) {
        return space != null && space.getRedactors() != null && space.getRedactors().length > 0;
    }

    public boolean isOnlyManager(Space space, String username) {
        return space.getManagers() != null && space.getManagers().length == 1 && StringUtils.equals((CharSequence)space.getManagers()[0], (CharSequence)username);
    }

    public boolean isPendingUser(Space space, String username) {
        return ArrayUtils.contains((Object[])space.getPendingUsers(), (Object)username);
    }

    public void registerSpaceListenerPlugin(SpaceListenerPlugin spaceListenerPlugin) {
        this.spaceLifeCycle.addListener((LifeCycleListener)spaceListenerPlugin);
    }

    public void removeInvitedUser(Space space, String username) {
        if (ArrayUtils.contains((Object[])space.getInvitedUsers(), (Object)username)) {
            this.spaceLifeCycle.setCurrentEvent(SpaceLifeCycleEvent.Type.DENY_INVITED_USER);
            try {
                space = this.removeInvited(space, username);
                this.updateSpace(space);
                this.spaceLifeCycle.removeInvitedUser(space, username);
            }
            finally {
                this.spaceLifeCycle.resetCurrentEvent(SpaceLifeCycleEvent.Type.DENY_INVITED_USER);
            }
        }
    }

    public void removePendingUser(Space space, String username) {
        if (ArrayUtils.contains((Object[])space.getPendingUsers(), (Object)username)) {
            this.removePending(space, username);
            space = this.updateSpace(space);
            this.spaceLifeCycle.removePendingUser(space, username);
        }
    }

    public void addRedactor(Space space, String username) {
        Object[] redactors = space.getRedactors();
        if (!ArrayUtils.contains((Object[])redactors, (Object)username)) {
            redactors = (String[])ArrayUtils.add((Object[])redactors, (Object)username);
            space.setRedactors((String[])redactors);
            this.updateSpace(space);
            SpaceUtils.addUserToGroupWithRedactorMembership(username, space.getGroupId());
        }
    }

    public void removeRedactor(Space space, String username) {
        Object[] redactors = space.getRedactors();
        if (ArrayUtils.contains((Object[])redactors, (Object)username)) {
            redactors = (String[])ArrayUtils.removeAllOccurrences((Object[])redactors, (Object)username);
            space.setRedactors((String[])redactors);
            this.updateSpace(space);
            SpaceUtils.removeUserFromGroupWithRedactorMembership(username, space.getGroupId());
        }
    }

    public void addPublisher(Space space, String username) {
        Object[] publishers = space.getPublishers();
        if (!ArrayUtils.contains((Object[])publishers, (Object)username)) {
            publishers = (String[])ArrayUtils.add((Object[])publishers, (Object)username);
            space.setPublishers((String[])publishers);
            this.updateSpace(space);
            SpaceUtils.addUserToGroupWithPublisherMembership(username, space.getGroupId());
        }
    }

    public void removePublisher(Space space, String username) {
        Object[] publishers = space.getPublishers();
        if (ArrayUtils.contains((Object[])publishers, (Object)username)) {
            publishers = (String[])ArrayUtils.removeAllOccurrences((Object[])publishers, (Object)username);
            space.setPublishers((String[])publishers);
            this.updateSpace(space);
            SpaceUtils.removeUserFromGroupWithPublisherMembership(username, space.getGroupId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setManager(Space space, String username, boolean isManager) {
        Object[] managers = space.getManagers();
        if (isManager) {
            if (!ArrayUtils.contains((Object[])managers, (Object)username)) {
                this.spaceLifeCycle.setCurrentEvent(SpaceLifeCycleEvent.Type.GRANTED_LEAD);
                try {
                    managers = (String[])ArrayUtils.add((Object[])managers, (Object)username);
                    space.setManagers((String[])managers);
                    this.updateSpace(space);
                    SpaceUtils.addUserToGroupWithManagerMembership(username, space.getGroupId());
                    this.spaceLifeCycle.grantedLead(space, username);
                }
                finally {
                    this.spaceLifeCycle.resetCurrentEvent(SpaceLifeCycleEvent.Type.GRANTED_LEAD);
                }
            }
        } else if (ArrayUtils.contains((Object[])managers, (Object)username)) {
            this.spaceLifeCycle.setCurrentEvent(SpaceLifeCycleEvent.Type.REVOKED_LEAD);
            try {
                managers = (String[])ArrayUtils.removeAllOccurrences((Object[])managers, (Object)username);
                space.setManagers((String[])managers);
                this.updateSpace(space);
                SpaceUtils.removeUserFromGroupWithManagerMembership(username, space.getGroupId());
                Space updatedSpace = this.getSpaceById(space.getId());
                if (this.isMember(updatedSpace, username)) {
                    this.spaceLifeCycle.revokedLead(space, username);
                }
            }
            finally {
                this.spaceLifeCycle.resetCurrentEvent(SpaceLifeCycleEvent.Type.REVOKED_LEAD);
            }
        }
    }

    public void unregisterSpaceListenerPlugin(SpaceListenerPlugin spaceListenerPlugin) {
        this.spaceLifeCycle.removeListener((LifeCycleListener)spaceListenerPlugin);
    }

    public Space updateSpace(Space space, List<org.exoplatform.social.core.identity.model.Identity> identitiesToInvite) {
        Space storedSpace = this.spaceStorage.getSpaceById(space.getId());
        this.spaceStorage.saveSpace(space, false);
        this.triggerSpaceUpdate(space, storedSpace);
        this.inviteIdentities(space, identitiesToInvite);
        return this.getSpaceById(space.getId());
    }

    public Space updateSpace(Space existingSpace) {
        return this.updateSpace(existingSpace, null);
    }

    public Space updateSpaceAvatar(Space existingSpace, String username) {
        existingSpace.setEditor(username);
        this.checkSpaceEditorPermissions(existingSpace);
        org.exoplatform.social.core.identity.model.Identity spaceIdentity = this.identityManager.getOrCreateSpaceIdentity(existingSpace.getPrettyName());
        Profile profile = spaceIdentity.getProfile();
        if (existingSpace.getAvatarAttachment() != null) {
            profile.setProperty("avatar", (Object)existingSpace.getAvatarAttachment());
        } else {
            profile.removeProperty("avatar");
            profile.setAvatarUrl(null);
            profile.setAvatarLastUpdated(null);
        }
        this.identityManager.updateProfile(profile);
        this.spaceLifeCycle.spaceAvatarEdited(existingSpace, existingSpace.getEditor());
        existingSpace = this.spaceStorage.getSpaceById(existingSpace.getId());
        existingSpace.setAvatarLastUpdated(Long.valueOf(System.currentTimeMillis()));
        this.spaceStorage.saveSpace(existingSpace, false);
        return existingSpace;
    }

    public Space updateSpaceBanner(Space existingSpace, String username) {
        Profile profile;
        existingSpace.setEditor(username);
        this.checkSpaceEditorPermissions(existingSpace);
        org.exoplatform.social.core.identity.model.Identity spaceIdentity = this.identityManager.getOrCreateSpaceIdentity(existingSpace.getPrettyName());
        if (spaceIdentity != null) {
            profile = spaceIdentity.getProfile();
            if (existingSpace.getBannerAttachment() != null) {
                profile.setProperty("banner", (Object)existingSpace.getBannerAttachment());
            } else {
                profile.removeProperty("banner");
            }
        } else {
            throw new IllegalStateException("Can not update space banner. Space identity " + existingSpace.getPrettyName() + " not found");
        }
        this.identityManager.updateProfile(profile);
        existingSpace = this.spaceStorage.getSpaceById(existingSpace.getId());
        existingSpace.setAvatarLastUpdated(Long.valueOf(System.currentTimeMillis()));
        this.spaceStorage.saveSpace(existingSpace, false);
        this.spaceLifeCycle.spaceBannerEdited(existingSpace, existingSpace.getEditor());
        return existingSpace;
    }

    public ListAccess<Space> getInvitedSpacesWithListAccess(String username) {
        return new SpaceListAccess(this.spaceStorage, username, SpaceListAccess.Type.INVITED);
    }

    public void updateSpaceAccessed(String remoteId, Space space) throws SpaceException {
        if (this.isMember(space, remoteId)) {
            this.spaceStorage.updateSpaceAccessed(remoteId, space);
        }
    }

    public List<Space> getLastAccessedSpace(String remoteId, String appId, int offset, int limit) throws SpaceException {
        SpaceFilter filter = new SpaceFilter(remoteId, appId);
        return this.spaceStorage.getLastAccessedSpace(filter, offset, limit);
    }

    public List<Space> getLastSpaces(int limit) {
        return this.spaceStorage.getLastSpaces(limit);
    }

    public ListAccess<Space> getLastAccessedSpace(String remoteId, String appId) {
        return new SpaceListAccess(this.spaceStorage, remoteId, appId, SpaceListAccess.Type.LASTEST_ACCESSED);
    }

    public ListAccess<Space> getVisitedSpaces(String remoteId, String appId) {
        return new SpaceListAccess(this.spaceStorage, remoteId, appId, SpaceListAccess.Type.VISITED);
    }

    public ListAccess<Space> getPendingSpaceRequestsToManage(String remoteId) {
        return new SpaceListAccess(this.spaceStorage, remoteId, SpaceListAccess.Type.PENDING_REQUESTS);
    }

    public List<SpaceExternalInvitation> findSpaceExternalInvitationsBySpaceId(String spaceId) {
        return this.spaceStorage.findSpaceExternalInvitationsBySpaceId(spaceId);
    }

    public void saveSpaceExternalInvitation(String spaceId, String email, String tokenId) {
        this.spaceStorage.saveSpaceExternalInvitation(spaceId, email, tokenId);
    }

    public SpaceExternalInvitation getSpaceExternalInvitationById(String invitationId) {
        return this.spaceStorage.findSpaceExternalInvitationById(invitationId);
    }

    public void deleteSpaceExternalInvitation(String invitationId) {
        SpaceExternalInvitation spaceExternalInvitation = this.spaceStorage.findSpaceExternalInvitationById(invitationId);
        this.spaceStorage.deleteSpaceExternalInvitation(spaceExternalInvitation);
        RemindPasswordTokenService remindPasswordTokenService = (RemindPasswordTokenService)CommonsUtils.getService(RemindPasswordTokenService.class);
        if (remindPasswordTokenService != null) {
            remindPasswordTokenService.deleteToken(spaceExternalInvitation.getTokenId(), "external-registration");
        }
    }

    public List<String> findExternalInvitationsSpacesByEmail(String email) {
        return this.spaceStorage.findExternalInvitationsSpacesByEmail(email);
    }

    public void deleteExternalUserInvitations(String email) {
        this.spaceStorage.deleteExternalUserInvitations(email);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isSuperManager(String username) {
        if (StringUtils.isBlank((CharSequence)username)) return false;
        if (IdentityConstants.ANONIM.equals(username)) return false;
        if (IdentityConstants.SYSTEM.equals(username)) {
            return false;
        }
        if (username.equals(this.getUserACL().getSuperUser())) {
            return true;
        }
        Identity identity = this.getIdentity(username);
        if (identity == null) return false;
        if (identity.isMemberOf(this.userACL.getAdminGroups())) return true;
        if (!this.spacesAdministrationService.getSpacesAdministratorsMemberships().stream().anyMatch(arg_0 -> ((Identity)identity).isMemberOf(arg_0))) return false;
        return true;
    }

    public boolean isContentManager(String username) {
        if (StringUtils.isBlank((CharSequence)username) || IdentityConstants.ANONIM.equals(username) || IdentityConstants.SYSTEM.equals(username)) {
            return false;
        }
        if (username.equals(this.getUserACL().getSuperUser())) {
            return true;
        }
        Identity identity = this.getIdentity(username);
        return identity != null && identity.isMemberOf("/platform/web-contributors", MANAGER);
    }

    public boolean isContentPublisher(String username) {
        if (StringUtils.isBlank((CharSequence)username) || IdentityConstants.ANONIM.equals(username) || IdentityConstants.SYSTEM.equals(username)) {
            return false;
        }
        if (username.equals(this.getUserACL().getSuperUser())) {
            return true;
        }
        Identity identity = this.getIdentity(username);
        return identity != null && identity.isMemberOf("/platform/web-contributors", "publisher");
    }

    public ListAccess<Space> getCommonSpaces(String username, String otherUserId) {
        return new SpaceListAccess(this.spaceStorage, SpaceListAccess.Type.COMMON, username, otherUserId);
    }

    public void addSpaceListener(SpaceListenerPlugin plugin) {
        this.registerSpaceLifeCycleListener((SpaceLifeCycleListener)plugin);
    }

    private String checkSpaceEditorPermissions(Space space) {
        String editor = space.getEditor();
        if (StringUtils.isBlank((CharSequence)editor) || !this.hasEditPermission(space, editor)) {
            throw new IllegalStateException("User " + editor + " is not authorized to change space.");
        }
        return editor;
    }

    private String getPortletId(String appId) {
        int SEPARATOR = 46;
        if (appId.indexOf(46) != -1) {
            int beginIndex = appId.lastIndexOf(46) + 1;
            int endIndex = appId.length();
            return appId.substring(beginIndex, endIndex);
        }
        return appId;
    }

    private void triggerSpaceUpdate(Space newSpace, Space oldSpace) {
        if (oldSpace != null) {
            if (!StringUtils.equals((CharSequence)oldSpace.getDescription(), (CharSequence)newSpace.getDescription())) {
                this.spaceLifeCycle.spaceDescriptionEdited(newSpace, newSpace.getEditor());
            }
            if (!oldSpace.getVisibility().equals(newSpace.getVisibility())) {
                this.spaceLifeCycle.spaceAccessEdited(newSpace, newSpace.getEditor());
            }
            String oldRegistration = oldSpace.getRegistration();
            String registration = newSpace.getRegistration();
            if (oldRegistration == null && registration != null || oldRegistration != null && !oldRegistration.equals(registration)) {
                this.spaceLifeCycle.spaceRegistrationEdited(newSpace, newSpace.getEditor());
            }
        }
    }

    private OrganizationService getOrgService() {
        if (this.organizationService == null) {
            this.organizationService = (OrganizationService)ExoContainerContext.getService(OrganizationService.class);
        }
        return this.organizationService;
    }

    private UserACL getUserACL() {
        return this.userACL;
    }

    private SpaceApplicationHandler getSpaceApplicationHandler(Space space) throws SpaceException {
        String spaceTemplate = space.getTemplate();
        SpaceApplicationHandler appHandler = (SpaceApplicationHandler)this.spaceTemplateService.getSpaceApplicationHandlers().get(spaceTemplate);
        if (appHandler == null) {
            LOG.debug("No space application handler was defined for template with name {}. Default will be used.", new Object[]{spaceTemplate});
            String defaultTemplate = this.spaceTemplateService.getDefaultSpaceTemplate();
            appHandler = (SpaceApplicationHandler)this.spaceTemplateService.getSpaceApplicationHandlers().get(defaultTemplate);
            if (appHandler == null) {
                throw new SpaceException(SpaceException.Code.UNKNOWN_SPACE_TEMPLATE);
            }
        }
        return appHandler;
    }

    private void removeApp(Space space, String appName) {
        String apps = space.getApp();
        StringBuilder remainApp = new StringBuilder();
        String[] listApp = apps.split(",");
        for (int idx = 0; idx < listApp.length; ++idx) {
            String app = listApp[idx];
            String[] appPart = app.split(":");
            if (appPart[1].equals(appName)) continue;
            if (remainApp.length() != 0) {
                remainApp.append(",");
            }
            remainApp.append(app);
        }
        space.setApp(remainApp.toString());
        this.saveSpace(space, false);
    }

    private Set<String> getUsersToInvite(List<org.exoplatform.social.core.identity.model.Identity> identities) {
        HashSet<String> invitedUserIds = new HashSet<String>();
        for (org.exoplatform.social.core.identity.model.Identity identity : identities) {
            if (identity == null || StringUtils.isBlank((CharSequence)identity.getRemoteId()) || StringUtils.isBlank((CharSequence)identity.getProviderId()) || (identity = this.identityManager.getOrCreateIdentity(identity.getProviderId(), identity.getRemoteId())) == null || identity.isDeleted() || !identity.isEnable()) continue;
            String remoteId = identity.getRemoteId();
            if (identity.isSpace()) {
                Space space = this.getSpaceByPrettyName(remoteId);
                if (space == null) continue;
                String[] users = space.getMembers();
                invitedUserIds.addAll(Arrays.asList(users));
                continue;
            }
            if (!identity.isUser()) continue;
            invitedUserIds.add(remoteId);
        }
        return invitedUserIds;
    }

    private boolean isMandatory(GroupHandler groupHandler, Group group, List<String> mandatories) throws Exception {
        if (mandatories.contains(group.getId())) {
            return true;
        }
        Collection children = groupHandler.findGroups(group);
        for (Group g : children) {
            if (!this.isMandatory(groupHandler, g, mandatories)) continue;
            return true;
        }
        return false;
    }

    private Space addPending(Space space, String username) {
        Object[] pendingUsers = space.getPendingUsers();
        if (!ArrayUtils.contains((Object[])pendingUsers, (Object)username)) {
            pendingUsers = (String[])ArrayUtils.add((Object[])pendingUsers, (Object)username);
            space.setPendingUsers((String[])pendingUsers);
        }
        return space;
    }

    private Space removePending(Space space, String username) {
        Object[] pendingUsers = space.getPendingUsers();
        if (ArrayUtils.contains((Object[])pendingUsers, (Object)username)) {
            pendingUsers = (String[])ArrayUtils.removeAllOccurrences((Object[])pendingUsers, (Object)username);
            space.setPendingUsers((String[])pendingUsers);
        }
        return space;
    }

    private Space addInvited(Space space, String username) {
        Object[] invitedUsers = space.getInvitedUsers();
        if (!ArrayUtils.contains((Object[])invitedUsers, (Object)username)) {
            invitedUsers = (String[])ArrayUtils.add((Object[])invitedUsers, (Object)username);
            space.setInvitedUsers((String[])invitedUsers);
        }
        return space;
    }

    private Space removeInvited(Space space, String username) {
        Object[] invitedUsers = space.getInvitedUsers();
        if (ArrayUtils.contains((Object[])invitedUsers, (Object)username)) {
            invitedUsers = (String[])ArrayUtils.removeAllOccurrences((Object[])invitedUsers, (Object)username);
            space.setInvitedUsers((String[])invitedUsers);
        }
        return space;
    }

    private Identity getIdentity(String username) {
        Identity identity = this.identityRegistry.getIdentity(username);
        if (identity == null) {
            try {
                identity = this.authenticator.createIdentity(username);
                this.identityRegistry.register(identity);
                return identity;
            }
            catch (Exception e) {
                LOG.warn("Error while retrieving user {} ACL identity", new Object[]{username, e});
                return null;
            }
        }
        return identity;
    }

    private SpaceTemplate getSpaceTemplateOrDefault(String templaceName) {
        SpaceTemplate spaceTemplate = this.spaceTemplateService.getSpaceTemplateByName(templaceName);
        if (spaceTemplate == null) {
            LOG.warn("could not find space template of type {}, will use Default template", new Object[]{templaceName});
            String defaultTemplate = this.spaceTemplateService.getDefaultSpaceTemplate();
            spaceTemplate = this.spaceTemplateService.getSpaceTemplateByName(defaultTemplate);
        }
        return spaceTemplate;
    }
}

