/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.jpa.storage;

import java.util.List;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.jpa.test.AbstractCoreTest;
import org.exoplatform.social.core.profileproperty.model.ProfilePropertySetting;
import org.exoplatform.social.core.profileproperty.storage.ProfileSettingStorage;

public class ProfileSettingStorageTest
extends AbstractCoreTest {
    private final Log LOG = ExoLogger.getLogger(ProfileSettingStorageTest.class);
    private ProfileSettingStorage profileSettingStorage;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.profileSettingStorage = (ProfileSettingStorage)this.getContainer().getComponentInstanceOfType(ProfileSettingStorage.class);
        ProfileSettingStorageTest.assertNotNull((Object)this.profileSettingStorage);
    }

    public void testSaveProfilePropertySetting() {
        ProfilePropertySetting profilePropertySetting = this.createProfileSettingInstance("test");
        profilePropertySetting = this.profileSettingStorage.saveProfilePropertySetting(profilePropertySetting, true);
        profilePropertySetting = this.profileSettingStorage.findProfileSettingByName(profilePropertySetting.getPropertyName());
        ProfileSettingStorageTest.assertNotNull((Object)profilePropertySetting.getId());
    }

    public void testDeleteProfilePropertySetting() {
        ProfilePropertySetting profilePropertySetting = this.createProfileSettingInstance("test");
        profilePropertySetting = this.profileSettingStorage.saveProfilePropertySetting(profilePropertySetting, true);
        profilePropertySetting = this.profileSettingStorage.findProfileSettingByName(profilePropertySetting.getPropertyName());
        ProfileSettingStorageTest.assertNotNull((Object)profilePropertySetting.getId());
        this.profileSettingStorage.deleteProfilePropertySetting(profilePropertySetting.getId());
        profilePropertySetting = this.profileSettingStorage.findProfileSettingByName(profilePropertySetting.getPropertyName());
        ProfileSettingStorageTest.assertNull((Object)profilePropertySetting);
    }

    public void testupdateProfilePropertySetting() {
        ProfilePropertySetting profilePropertySetting = this.createProfileSettingInstance("test");
        profilePropertySetting = this.profileSettingStorage.saveProfilePropertySetting(profilePropertySetting, true);
        profilePropertySetting = this.profileSettingStorage.findProfileSettingByName(profilePropertySetting.getPropertyName());
        ProfileSettingStorageTest.assertTrue((boolean)profilePropertySetting.isActive());
        profilePropertySetting.setActive(false);
        profilePropertySetting = this.profileSettingStorage.saveProfilePropertySetting(profilePropertySetting, false);
        profilePropertySetting = this.profileSettingStorage.findProfileSettingByName(profilePropertySetting.getPropertyName());
        ProfileSettingStorageTest.assertFalse((boolean)profilePropertySetting.isActive());
    }

    public void testGetProfilePropertySettings() {
        ProfileSettingStorageTest.assertEquals((int)0, (int)this.profileSettingStorage.getPropertySettings().size());
        ProfilePropertySetting profilePropertySetting1 = this.createProfileSettingInstance("test10");
        ProfilePropertySetting profilePropertySetting2 = this.createProfileSettingInstance("test20");
        ProfilePropertySetting profilePropertySetting3 = this.createProfileSettingInstance("test30");
        ProfilePropertySetting profilePropertySetting4 = this.createProfileSettingInstance("test40");
        ProfilePropertySetting profilePropertySetting5 = this.createProfileSettingInstance("test50");
        ProfilePropertySetting profilePropertySetting6 = this.createProfileSettingInstance("test60");
        this.profileSettingStorage.saveProfilePropertySetting(profilePropertySetting1, true);
        this.profileSettingStorage.saveProfilePropertySetting(profilePropertySetting2, true);
        this.profileSettingStorage.saveProfilePropertySetting(profilePropertySetting3, true);
        this.profileSettingStorage.saveProfilePropertySetting(profilePropertySetting4, true);
        this.profileSettingStorage.saveProfilePropertySetting(profilePropertySetting5, true);
        this.profileSettingStorage.saveProfilePropertySetting(profilePropertySetting6, true);
        List profilePropertySettings = this.profileSettingStorage.getPropertySettings();
        ProfileSettingStorageTest.assertEquals((int)6, (int)profilePropertySettings.size());
        ProfileSettingStorageTest.assertEquals((String)"test30", (String)((ProfilePropertySetting)profilePropertySettings.get(2)).getPropertyName());
        ProfileSettingStorageTest.assertEquals((String)"test40", (String)((ProfilePropertySetting)profilePropertySettings.get(3)).getPropertyName());
    }

    public void testGetSynchronizedProperties() {
        ProfilePropertySetting profilePropertySetting = this.createProfileSettingInstance("testProp");
        profilePropertySetting.setGroupSynchronized(true);
        this.profileSettingStorage.saveProfilePropertySetting(profilePropertySetting, true);
        ProfileSettingStorageTest.assertEquals((int)1, (int)this.profileSettingStorage.getSynchronizedPropertySettings().size());
    }

    @Override
    protected void tearDown() throws Exception {
        this.deleteAllSettings();
        super.tearDown();
    }

    protected void deleteAllSettings() {
        for (ProfilePropertySetting p : this.profileSettingStorage.getPropertySettings()) {
            this.profileSettingStorage.deleteProfilePropertySetting(p.getId());
        }
    }

    private ProfilePropertySetting createProfileSettingInstance(String propertyName) {
        ProfilePropertySetting profilePropertySetting = new ProfilePropertySetting();
        profilePropertySetting.setActive(true);
        profilePropertySetting.setEditable(true);
        profilePropertySetting.setVisible(true);
        profilePropertySetting.setPropertyName(propertyName);
        profilePropertySetting.setGroupSynchronized(false);
        profilePropertySetting.setMultiValued(false);
        profilePropertySetting.setParentId(Long.valueOf(0L));
        profilePropertySetting.setOrder(Long.valueOf(0L));
        return profilePropertySetting;
    }
}

