/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.thumbnail;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.nio.file.Files;
import java.util.Date;
import java.util.List;
import org.exoplatform.commons.file.model.FileInfo;
import org.exoplatform.commons.file.model.FileItem;
import org.exoplatform.commons.file.services.FileService;
import org.exoplatform.services.thumbnail.ImageResizeService;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.test.AbstractCoreTest;
import org.exoplatform.social.core.thumbnail.ImageThumbnailServiceImpl;
import org.exoplatform.social.metadata.MetadataService;
import org.exoplatform.social.metadata.model.MetadataObject;
import org.exoplatform.social.metadata.model.MetadataType;
import org.exoplatform.social.metadata.thumbnail.model.ThumbnailObject;

public class ImageThumbnailServiceImplTest
extends AbstractCoreTest {
    private MetadataService metadataService;
    private FileService fileService;
    private ImageThumbnailServiceImpl imageThumbnailService;
    private Identity userIdentity;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.metadataService = (MetadataService)this.getContainer().getComponentInstanceOfType(MetadataService.class);
        this.fileService = (FileService)this.getContainer().getComponentInstanceOfType(FileService.class);
        this.identityManager = (IdentityManager)this.getContainer().getComponentInstanceOfType(IdentityManager.class);
        this.imageThumbnailService = new ImageThumbnailServiceImpl(this.metadataService, this.fileService, (ImageResizeService)this.getContainer().getComponentInstanceOfType(ImageResizeService.class));
        this.userIdentity = this.identityManager.getOrCreateIdentity("organization", "john");
    }

    public void testGetOrCreateThumbnail() throws Exception {
        MetadataType metadataType = new MetadataType(5L, "thumbnail");
        File file = new File(((Object)((Object)this)).getClass().getClassLoader().getResource("test.png").getFile());
        byte[] content = Files.readAllBytes(file.toPath());
        FileItem fileThumbnail = new FileItem(null, "testAvatar", "image/png", "social", (long)content.length, new Date(), this.userIdentity.getRemoteId(), false, (InputStream)new ByteArrayInputStream(content));
        fileThumbnail = this.fileService.writeFile(fileThumbnail);
        FileInfo fileInfo = fileThumbnail.getFileInfo();
        ThumbnailObject thumbnailObject = new ThumbnailObject("file", Long.toString(fileInfo.getId()));
        List metadataItemList = this.metadataService.getMetadataItemsByMetadataTypeAndObject(metadataType.getName(), (MetadataObject)thumbnailObject);
        ImageThumbnailServiceImplTest.assertEquals((int)0, (int)metadataItemList.size());
        FileItem thumbnail = this.imageThumbnailService.getOrCreateThumbnail(fileThumbnail, 45, 45);
        ImageThumbnailServiceImplTest.assertNotNull((Object)thumbnail);
        metadataItemList = this.metadataService.getMetadataItemsByMetadataTypeAndObject(metadataType.getName(), (MetadataObject)thumbnailObject);
        ImageThumbnailServiceImplTest.assertEquals((int)1, (int)metadataItemList.size());
        thumbnail = this.imageThumbnailService.getOrCreateThumbnail(fileThumbnail, 45, 45);
        ImageThumbnailServiceImplTest.assertNotNull((Object)thumbnail);
        metadataItemList = this.metadataService.getMetadataItemsByMetadataTypeAndObject(metadataType.getName(), (MetadataObject)thumbnailObject);
        ImageThumbnailServiceImplTest.assertEquals((int)1, (int)metadataItemList.size());
    }
}

