/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.binding.spi;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.organization.MembershipHandler;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.idm.UserDAOImpl;
import org.exoplatform.services.organization.idm.UserImpl;
import org.exoplatform.social.core.binding.impl.GroupSpaceBindingServiceImpl;
import org.exoplatform.social.core.binding.model.GroupSpaceBinding;
import org.exoplatform.social.core.binding.model.GroupSpaceBindingQueue;
import org.exoplatform.social.core.binding.model.GroupSpaceBindingReportAction;
import org.exoplatform.social.core.binding.model.GroupSpaceBindingReportUser;
import org.exoplatform.social.core.binding.model.UserSpaceBinding;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.core.storage.api.GroupSpaceBindingStorage;
import org.exoplatform.social.core.test.AbstractCoreTest;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class GroupSpaceBindingServiceTest
extends AbstractCoreTest {
    @Mock
    private GroupSpaceBindingStorage groupSpaceBindingStorage;
    @Mock
    private InitParams initParams;
    @Mock
    private SpaceService spaceService;
    @Mock
    private OrganizationService orgService;
    @Mock
    private MembershipHandler membershipHandler;

    @Test
    public void testFindSpaceBindings() throws Exception {
        LinkedList<GroupSpaceBinding> groupSpaceBindings = new LinkedList<GroupSpaceBinding>();
        GroupSpaceBinding binding1 = new GroupSpaceBinding();
        binding1.setId(1L);
        binding1.setGroup("/platform/administrators");
        binding1.setSpaceId("1");
        groupSpaceBindings.add(binding1);
        GroupSpaceBinding binding2 = new GroupSpaceBinding();
        binding2.setId(2L);
        binding2.setGroup("/platform/web-contributors");
        binding2.setSpaceId("1");
        groupSpaceBindings.add(binding2);
        Mockito.when((Object)this.groupSpaceBindingStorage.findGroupSpaceBindingsBySpace((String)Mockito.eq((Object)"1"))).thenReturn(groupSpaceBindings);
        GroupSpaceBindingServiceImpl groupSpaceBindingService = new GroupSpaceBindingServiceImpl(this.initParams, this.groupSpaceBindingStorage, this.orgService, this.spaceService);
        List results = groupSpaceBindingService.findGroupSpaceBindingsBySpace("1");
        GroupSpaceBinding result1 = (GroupSpaceBinding)results.get(0);
        GroupSpaceBinding result2 = (GroupSpaceBinding)results.get(1);
        GroupSpaceBindingServiceTest.assertEquals((int)2, (int)results.size());
        GroupSpaceBindingServiceTest.assertEquals((long)1L, (long)result1.getId());
        GroupSpaceBindingServiceTest.assertEquals((String)"/platform/administrators", (String)result1.getGroup());
        GroupSpaceBindingServiceTest.assertEquals((String)"1", (String)result1.getSpaceId());
        GroupSpaceBindingServiceTest.assertEquals((long)2L, (long)result2.getId());
        GroupSpaceBindingServiceTest.assertEquals((String)"/platform/web-contributors", (String)result2.getGroup());
        GroupSpaceBindingServiceTest.assertEquals((String)"1", (String)result2.getSpaceId());
    }

    @Test
    public void testFindUserBindings() throws Exception {
        GroupSpaceBinding binding1 = new GroupSpaceBinding();
        binding1.setId(1L);
        binding1.setGroup("/platform/administrators");
        binding1.setSpaceId("1");
        GroupSpaceBinding binding2 = new GroupSpaceBinding();
        binding2.setId(1L);
        binding2.setGroup("/platform/users");
        binding2.setSpaceId("1");
        LinkedList<UserSpaceBinding> userSpaceBindings = new LinkedList<UserSpaceBinding>();
        UserSpaceBinding ub1 = new UserSpaceBinding();
        ub1.setId(1L);
        ub1.setGroupBinding(binding1);
        ub1.setUser("john");
        userSpaceBindings.add(ub1);
        UserSpaceBinding ub2 = new UserSpaceBinding();
        ub2.setId(2L);
        ub2.setGroupBinding(binding2);
        ub2.setUser("john");
        userSpaceBindings.add(ub2);
        Mockito.when((Object)this.groupSpaceBindingStorage.findUserSpaceBindingsBySpace((String)Mockito.eq((Object)"1"), (String)Mockito.eq((Object)"john"))).thenReturn(userSpaceBindings);
        GroupSpaceBindingServiceImpl groupSpaceBindingService = new GroupSpaceBindingServiceImpl(this.initParams, this.groupSpaceBindingStorage, this.orgService, this.spaceService);
        List results = groupSpaceBindingService.findUserSpaceBindingsBySpace("1", "john");
        UserSpaceBinding result1 = (UserSpaceBinding)results.get(0);
        UserSpaceBinding result2 = (UserSpaceBinding)results.get(1);
        GroupSpaceBindingServiceTest.assertEquals((int)2, (int)results.size());
        GroupSpaceBindingServiceTest.assertEquals((long)1L, (long)result1.getId());
        GroupSpaceBindingServiceTest.assertEquals((String)"/platform/administrators", (String)result1.getGroupBinding().getGroup());
        GroupSpaceBindingServiceTest.assertEquals((long)2L, (long)result2.getId());
        GroupSpaceBindingServiceTest.assertEquals((String)"/platform/users", (String)result2.getGroupBinding().getGroup());
    }

    @Test
    public void deleteUserBinding() throws Exception {
        GroupSpaceBinding binding1 = new GroupSpaceBinding();
        binding1.setId(1L);
        binding1.setGroup("/platform/administrators");
        binding1.setSpaceId("1");
        GroupSpaceBinding binding2 = new GroupSpaceBinding();
        binding2.setId(2L);
        binding2.setGroup("/platform/developers");
        binding2.setSpaceId("1");
        LinkedList<UserSpaceBinding> userSpaceBindings = new LinkedList<UserSpaceBinding>();
        UserSpaceBinding ub1 = new UserSpaceBinding();
        ub1.setId(1L);
        ub1.setIsMemberBefore(Boolean.valueOf(false));
        ub1.setGroupBinding(binding1);
        ub1.setUser("john");
        userSpaceBindings.add(ub1);
        UserSpaceBinding ub2 = new UserSpaceBinding();
        ub2.setId(2L);
        ub2.setIsMemberBefore(Boolean.valueOf(false));
        ub2.setGroupBinding(binding2);
        ub2.setUser("john");
        userSpaceBindings.add(ub2);
        Mockito.when((Object)this.groupSpaceBindingStorage.findUserSpaceBindingsBySpace("1", "john")).thenReturn(Arrays.asList(ub2), (Object[])new List[]{new ArrayList()});
        GroupSpaceBindingServiceImpl groupSpaceBindingService = new GroupSpaceBindingServiceImpl(this.initParams, this.groupSpaceBindingStorage, this.orgService, this.spaceService);
        GroupSpaceBindingReportAction report = new GroupSpaceBindingReportAction(ub1.getGroupBinding().getId(), Long.parseLong(ub1.getGroupBinding().getSpaceId()), ub1.getGroupBinding().getGroup(), "REMOVE");
        groupSpaceBindingService.deleteUserBinding(ub1, report);
        ArgumentCaptor idCaptor = ArgumentCaptor.forClass(Long.class);
        ((GroupSpaceBindingStorage)Mockito.verify((Object)this.groupSpaceBindingStorage)).deleteUserBinding(((Long)idCaptor.capture()).longValue());
        long id = (Long)idCaptor.getValue();
        GroupSpaceBindingServiceTest.assertEquals((long)1L, (long)id);
        ArgumentCaptor reportCaptur = ArgumentCaptor.forClass(GroupSpaceBindingReportUser.class);
        ((GroupSpaceBindingStorage)Mockito.verify((Object)this.groupSpaceBindingStorage)).saveGroupSpaceBindingReportUser((GroupSpaceBindingReportUser)reportCaptur.capture());
        GroupSpaceBindingReportUser capturedReport = (GroupSpaceBindingReportUser)reportCaptur.getValue();
        GroupSpaceBindingServiceTest.assertEquals((String)"REMOVE_USER", (String)capturedReport.getAction());
        GroupSpaceBindingServiceTest.assertEquals((boolean)true, (boolean)capturedReport.isStillInSpace());
        GroupSpaceBindingServiceTest.assertEquals((boolean)false, (boolean)capturedReport.isWasPresentBefore());
        GroupSpaceBindingReportAction report1 = new GroupSpaceBindingReportAction(ub2.getGroupBinding().getId(), Long.parseLong(ub2.getGroupBinding().getSpaceId()), ub2.getGroupBinding().getGroup(), "REMOVE");
        groupSpaceBindingService.deleteUserBinding(ub2, report1);
        ArgumentCaptor idCaptor2 = ArgumentCaptor.forClass(Long.class);
        ((GroupSpaceBindingStorage)Mockito.verify((Object)this.groupSpaceBindingStorage, (VerificationMode)Mockito.times((int)2))).deleteUserBinding(((Long)idCaptor2.capture()).longValue());
        long id2 = (Long)idCaptor2.getValue();
        GroupSpaceBindingServiceTest.assertEquals((long)2L, (long)id2);
        ArgumentCaptor reportCaptur2 = ArgumentCaptor.forClass(GroupSpaceBindingReportUser.class);
        ((GroupSpaceBindingStorage)Mockito.verify((Object)this.groupSpaceBindingStorage, (VerificationMode)Mockito.times((int)2))).saveGroupSpaceBindingReportUser((GroupSpaceBindingReportUser)reportCaptur2.capture());
        GroupSpaceBindingReportUser capturedReport2 = (GroupSpaceBindingReportUser)reportCaptur2.getValue();
        GroupSpaceBindingServiceTest.assertEquals((String)"REMOVE_USER", (String)capturedReport2.getAction());
        GroupSpaceBindingServiceTest.assertEquals((boolean)false, (boolean)capturedReport2.isStillInSpace());
        GroupSpaceBindingServiceTest.assertEquals((boolean)false, (boolean)capturedReport2.isWasPresentBefore());
    }

    @Test
    public void deleteSpaceBinding() throws Exception {
        GroupSpaceBinding binding1 = new GroupSpaceBinding();
        binding1.setId(1L);
        binding1.setGroup("/platform/administrators");
        binding1.setSpaceId("1");
        Space space = new Space();
        space.setId("1");
        space.setDisplayName("space1");
        space.setPrettyName("space1");
        space.setMembers(new String[]{"root"});
        Mockito.when((Object)this.spaceService.getSpaceById((String)Mockito.any())).thenReturn((Object)space);
        Mockito.when((Object)this.groupSpaceBindingStorage.countBoundUsers((String)Mockito.any())).thenReturn((Object)0L);
        UserSpaceBinding userSpaceBinding1 = new UserSpaceBinding();
        userSpaceBinding1.setId(1L);
        userSpaceBinding1.setGroupBinding(binding1);
        userSpaceBinding1.setUser("user1");
        userSpaceBinding1.setIsMemberBefore(Boolean.valueOf(false));
        UserSpaceBinding userSpaceBinding2 = new UserSpaceBinding();
        userSpaceBinding2.setId(2L);
        userSpaceBinding2.setGroupBinding(binding1);
        userSpaceBinding2.setIsMemberBefore(Boolean.valueOf(false));
        userSpaceBinding2.setUser("user2");
        ArrayList<UserSpaceBinding> userSpaceBindings = new ArrayList<UserSpaceBinding>();
        userSpaceBindings.add(userSpaceBinding1);
        userSpaceBindings.add(userSpaceBinding2);
        Mockito.when((Object)this.groupSpaceBindingStorage.findUserAllBindingsByGroupBinding(binding1)).thenReturn(userSpaceBindings);
        GroupSpaceBindingReportAction report = new GroupSpaceBindingReportAction(binding1.getId(), Long.parseLong(binding1.getSpaceId()), binding1.getGroup(), "REMOVE");
        Mockito.when((Object)this.groupSpaceBindingStorage.saveGroupSpaceBindingReport((GroupSpaceBindingReportAction)Mockito.any())).thenReturn((Object)report);
        GroupSpaceBindingServiceImpl groupSpaceBindingService = new GroupSpaceBindingServiceImpl(this.initParams, this.groupSpaceBindingStorage, this.orgService, this.spaceService);
        groupSpaceBindingService.deleteGroupSpaceBinding(binding1);
        ArgumentCaptor idCaptor = ArgumentCaptor.forClass(Long.class);
        ((GroupSpaceBindingStorage)Mockito.verify((Object)this.groupSpaceBindingStorage, (VerificationMode)Mockito.times((int)1))).deleteGroupBinding(((Long)idCaptor.capture()).longValue());
        long id = (Long)idCaptor.getValue();
        GroupSpaceBindingServiceTest.assertEquals((long)1L, (long)id);
        ArgumentCaptor reportActionCaptor = ArgumentCaptor.forClass(GroupSpaceBindingReportAction.class);
        ((GroupSpaceBindingStorage)Mockito.verify((Object)this.groupSpaceBindingStorage, (VerificationMode)Mockito.times((int)1))).saveGroupSpaceBindingReport((GroupSpaceBindingReportAction)reportActionCaptor.capture());
        GroupSpaceBindingServiceTest.assertEquals((String)"REMOVE", (String)((GroupSpaceBindingReportAction)reportActionCaptor.getValue()).getAction());
        ArgumentCaptor reportUserCaptor = ArgumentCaptor.forClass(GroupSpaceBindingReportUser.class);
        ((GroupSpaceBindingStorage)Mockito.verify((Object)this.groupSpaceBindingStorage, (VerificationMode)Mockito.times((int)2))).saveGroupSpaceBindingReportUser((GroupSpaceBindingReportUser)reportUserCaptor.capture());
        GroupSpaceBindingServiceTest.assertEquals((String)"REMOVE_USER", (String)((GroupSpaceBindingReportUser)reportUserCaptor.getAllValues().get(0)).getAction());
        GroupSpaceBindingServiceTest.assertEquals((String)"user1", (String)((GroupSpaceBindingReportUser)reportUserCaptor.getAllValues().get(0)).getUsername());
        GroupSpaceBindingServiceTest.assertEquals((String)"REMOVE_USER", (String)((GroupSpaceBindingReportUser)reportUserCaptor.getAllValues().get(1)).getAction());
        GroupSpaceBindingServiceTest.assertEquals((String)"user2", (String)((GroupSpaceBindingReportUser)reportUserCaptor.getAllValues().get(1)).getUsername());
    }

    @Test
    public void deleteAllSpaceBindings() throws Exception {
        LinkedList<GroupSpaceBinding> groupSpaceBindings = new LinkedList<GroupSpaceBinding>();
        LinkedList<GroupSpaceBinding> resultSpaceBindings = new LinkedList<GroupSpaceBinding>();
        GroupSpaceBinding binding1 = new GroupSpaceBinding();
        binding1.setId(1L);
        binding1.setGroup("/platform/administrators");
        binding1.setSpaceId("1");
        groupSpaceBindings.add(binding1);
        resultSpaceBindings.add(binding1);
        GroupSpaceBinding binding2 = new GroupSpaceBinding();
        binding2.setId(2L);
        binding2.setGroup("/platform/web-contributors");
        binding2.setSpaceId("2");
        groupSpaceBindings.add(binding2);
        GroupSpaceBinding binding3 = new GroupSpaceBinding();
        binding3.setId(3L);
        binding3.setGroup("/platform/web-contributors");
        binding3.setSpaceId("3");
        groupSpaceBindings.add(binding3);
        GroupSpaceBinding binding4 = new GroupSpaceBinding();
        binding4.setId(4L);
        binding4.setGroup("/platform/web-contributors");
        binding4.setSpaceId("1");
        groupSpaceBindings.add(binding4);
        resultSpaceBindings.add(binding4);
        Mockito.when((Object)this.groupSpaceBindingStorage.findGroupSpaceBindingsBySpace((String)Mockito.eq((Object)"1"))).thenReturn(resultSpaceBindings);
        Space space = new Space();
        space.setId("1");
        space.setDisplayName("space1");
        space.setPrettyName("space1");
        space.setMembers(new String[]{"root"});
        Mockito.when((Object)this.spaceService.getSpaceById((String)Mockito.any())).thenReturn((Object)space);
        Mockito.when((Object)this.groupSpaceBindingStorage.countBoundUsers((String)Mockito.any())).thenReturn((Object)0L);
        GroupSpaceBindingReportAction report1 = new GroupSpaceBindingReportAction(binding1.getId(), Long.parseLong(binding1.getSpaceId()), binding1.getGroup(), "REMOVE");
        GroupSpaceBindingReportAction report2 = new GroupSpaceBindingReportAction(binding4.getId(), Long.parseLong(binding4.getSpaceId()), binding4.getGroup(), "REMOVE");
        Mockito.when((Object)this.groupSpaceBindingStorage.saveGroupSpaceBindingReport((GroupSpaceBindingReportAction)Mockito.any())).thenReturn((Object)report1, (Object[])new GroupSpaceBindingReportAction[]{report2});
        GroupSpaceBindingServiceImpl groupSpaceBindingService = new GroupSpaceBindingServiceImpl(this.initParams, this.groupSpaceBindingStorage, this.orgService, this.spaceService);
        groupSpaceBindingService.deleteAllSpaceBindingsBySpace("1");
        ArgumentCaptor idCaptor = ArgumentCaptor.forClass(Long.class);
        ((GroupSpaceBindingStorage)Mockito.verify((Object)this.groupSpaceBindingStorage, (VerificationMode)Mockito.times((int)2))).deleteGroupBinding(((Long)idCaptor.capture()).longValue());
        long id = (Long)idCaptor.getValue();
        GroupSpaceBindingServiceTest.assertTrue((id == 1L || id == 4L ? 1 : 0) != 0);
    }

    @Test
    public void testSaveGroupSpaceBindings() throws Exception {
        LinkedList<GroupSpaceBinding> groupSpaceBindings = new LinkedList<GroupSpaceBinding>();
        GroupSpaceBinding binding1 = new GroupSpaceBinding();
        binding1.setGroup("/platform/administrators");
        binding1.setSpaceId("1");
        groupSpaceBindings.add(binding1);
        GroupSpaceBinding binding2 = new GroupSpaceBinding();
        binding2.setGroup("/platform/web-contributors");
        binding2.setSpaceId("2");
        groupSpaceBindings.add(binding2);
        GroupSpaceBinding binding3 = new GroupSpaceBinding();
        binding3.setGroup("/platform/web-contributors");
        binding3.setSpaceId("3");
        groupSpaceBindings.add(binding3);
        GroupSpaceBinding binding4 = new GroupSpaceBinding();
        binding4.setGroup("/platform/web-contributors");
        binding4.setSpaceId("1");
        groupSpaceBindings.add(binding4);
        GroupSpaceBindingServiceImpl groupSpaceBindingService = new GroupSpaceBindingServiceImpl(this.initParams, this.groupSpaceBindingStorage, this.orgService, this.spaceService);
        Mockito.when((Object)this.groupSpaceBindingStorage.saveGroupSpaceBinding((GroupSpaceBinding)Mockito.any())).thenReturn((Object)binding1, (Object[])new GroupSpaceBinding[]{binding2, binding3, binding4});
        groupSpaceBindingService.saveGroupSpaceBindings(groupSpaceBindings);
        ((GroupSpaceBindingStorage)Mockito.verify((Object)this.groupSpaceBindingStorage, (VerificationMode)Mockito.times((int)4))).saveGroupSpaceBinding((GroupSpaceBinding)Mockito.any());
        ((GroupSpaceBindingStorage)Mockito.verify((Object)this.groupSpaceBindingStorage, (VerificationMode)Mockito.times((int)4))).createGroupSpaceBindingQueue((GroupSpaceBindingQueue)Mockito.any());
    }

    @Test
    public void testSaveGroupSpaceBinding() throws Exception {
        GroupSpaceBinding binding1 = new GroupSpaceBinding();
        binding1.setGroup("/platform/administrators");
        binding1.setSpaceId("1");
        GroupSpaceBindingServiceImpl groupSpaceBindingService = new GroupSpaceBindingServiceImpl(this.initParams, this.groupSpaceBindingStorage, this.orgService, this.spaceService);
        Mockito.when((Object)this.groupSpaceBindingStorage.saveGroupSpaceBinding((GroupSpaceBinding)Mockito.any())).thenReturn((Object)binding1);
        groupSpaceBindingService.saveGroupSpaceBinding(binding1);
        ((GroupSpaceBindingStorage)Mockito.verify((Object)this.groupSpaceBindingStorage, (VerificationMode)Mockito.times((int)1))).saveGroupSpaceBinding((GroupSpaceBinding)Mockito.any());
        ((GroupSpaceBindingStorage)Mockito.verify((Object)this.groupSpaceBindingStorage, (VerificationMode)Mockito.times((int)1))).saveGroupSpaceBindingReport((GroupSpaceBindingReportAction)Mockito.any());
    }

    @Test
    public void hasUserBindings() throws Exception {
        GroupSpaceBinding binding1 = new GroupSpaceBinding();
        binding1.setId(1L);
        binding1.setGroup("/platform/administrators");
        binding1.setSpaceId("1");
        ArrayList<UserSpaceBinding> userSpaceBindings = new ArrayList<UserSpaceBinding>();
        userSpaceBindings.add(new UserSpaceBinding());
        Mockito.when((Object)this.groupSpaceBindingStorage.findUserSpaceBindingsBySpace((String)Mockito.eq((Object)"1"), (String)Mockito.eq((Object)"john"))).thenReturn(userSpaceBindings);
        GroupSpaceBindingServiceImpl groupSpaceBindingService = new GroupSpaceBindingServiceImpl(this.initParams, this.groupSpaceBindingStorage, this.orgService, this.spaceService);
        GroupSpaceBindingServiceTest.assertEquals((boolean)true, (groupSpaceBindingService.findUserSpaceBindingsBySpace("1", "john").size() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void countUserBindings() throws Exception {
        GroupSpaceBinding binding1 = new GroupSpaceBinding();
        binding1.setId(1L);
        binding1.setGroup("/platform/administrators");
        binding1.setSpaceId("1");
        ArrayList<UserSpaceBinding> userSpaceBindings = new ArrayList<UserSpaceBinding>();
        userSpaceBindings.add(new UserSpaceBinding());
        Mockito.when((Object)this.groupSpaceBindingStorage.countUserBindings((String)Mockito.eq((Object)"1"), (String)Mockito.eq((Object)"john"))).thenReturn((Object)1L);
        GroupSpaceBindingServiceImpl groupSpaceBindingService = new GroupSpaceBindingServiceImpl(this.initParams, this.groupSpaceBindingStorage, this.orgService, this.spaceService);
        GroupSpaceBindingServiceTest.assertEquals((long)1L, (long)groupSpaceBindingService.countUserBindings("1", "john"));
    }

    @Test
    public void testFindFirstGroupSpaceBindingQueue() throws Exception {
        GroupSpaceBinding binding1 = new GroupSpaceBinding();
        binding1.setId(1L);
        binding1.setGroup("/platform/administrators");
        binding1.setSpaceId("1");
        GroupSpaceBinding binding2 = new GroupSpaceBinding();
        binding1.setId(1L);
        binding1.setGroup("/platform/administrators");
        binding1.setSpaceId("2");
        GroupSpaceBindingQueue bindingQueue1 = new GroupSpaceBindingQueue();
        bindingQueue1.setId(1L);
        bindingQueue1.setGroupSpaceBinding(binding1);
        bindingQueue1.setAction(GroupSpaceBindingQueue.ACTION_CREATE);
        GroupSpaceBindingQueue bindingQueue2 = new GroupSpaceBindingQueue();
        bindingQueue2.setId(2L);
        bindingQueue2.setGroupSpaceBinding(binding2);
        bindingQueue2.setAction(GroupSpaceBindingQueue.ACTION_CREATE);
        GroupSpaceBindingServiceImpl groupSpaceBindingService = new GroupSpaceBindingServiceImpl(this.initParams, this.groupSpaceBindingStorage, this.orgService, this.spaceService);
        groupSpaceBindingService.createGroupSpaceBindingQueue(bindingQueue1);
        groupSpaceBindingService.createGroupSpaceBindingQueue(bindingQueue2);
        Mockito.when((Object)this.groupSpaceBindingStorage.findFirstGroupSpaceBindingQueue()).thenReturn((Object)bindingQueue1, (Object[])new GroupSpaceBindingQueue[]{bindingQueue2});
        GroupSpaceBindingQueue firstGroupSpaceBindingQueue = groupSpaceBindingService.findFirstGroupSpaceBindingQueue();
        GroupSpaceBindingServiceTest.assertNotNull((Object)firstGroupSpaceBindingQueue);
        GroupSpaceBindingServiceTest.assertEquals((long)1L, (long)firstGroupSpaceBindingQueue.getId());
        GroupSpaceBindingQueue secondGroupSpaceBindingQueue = groupSpaceBindingService.findFirstGroupSpaceBindingQueue();
        GroupSpaceBindingServiceTest.assertNotNull((Object)secondGroupSpaceBindingQueue);
        GroupSpaceBindingServiceTest.assertEquals((long)2L, (long)secondGroupSpaceBindingQueue.getId());
    }

    @Test
    public void testBindUsersFromGroupSpaceBindingCheckUserNotMemberAndNotBoundBefore() throws Exception {
        GroupSpaceBinding binding1 = new GroupSpaceBinding();
        binding1.setId(1L);
        binding1.setGroup("/platform/administrators");
        binding1.setSpaceId("1");
        Space space1 = new Space();
        space1.setPrettyName("space1");
        space1.setId("1");
        space1.setGroupId("/spaces/space1");
        space1.setMembers(new String[]{"root"});
        Mockito.when((Object)this.spaceService.getSpaceById("1")).thenReturn((Object)space1);
        UserImpl user1 = new UserImpl("user1");
        user1.setFirstName("user1");
        user1.setLastName("user1");
        user1.setEmail("user1@acme.com");
        ListAccess<User> userListAccess = new ListAccess<User>(){
            final /* synthetic */ User val$user1;
            {
                this.val$user1 = user;
            }

            public User[] load(int index, int length) throws Exception {
                ArrayList<User> users = new ArrayList<User>();
                users.add(this.val$user1);
                User[] result = new User[users.size()];
                return users.toArray(result);
            }

            public int getSize() throws Exception {
                return 1;
            }
        };
        UserDAOImpl userDAO = (UserDAOImpl)Mockito.mock(UserDAOImpl.class);
        Mockito.when((Object)userDAO.findUsersByGroupId("/platform/administrators")).thenReturn((Object)userListAccess);
        Mockito.when((Object)this.orgService.getUserHandler()).thenReturn((Object)userDAO);
        Mockito.lenient().when((Object)this.groupSpaceBindingStorage.isUserBoundAndMemberBefore(Mockito.anyString(), Mockito.anyString())).thenReturn((Object)false);
        GroupSpaceBindingReportAction report = new GroupSpaceBindingReportAction(binding1.getId(), Long.parseLong(binding1.getSpaceId()), binding1.getGroup(), "ADD");
        Mockito.when((Object)this.groupSpaceBindingStorage.saveGroupSpaceBindingReport((GroupSpaceBindingReportAction)Mockito.any())).thenReturn((Object)report);
        GroupSpaceBindingServiceImpl groupSpaceBindingService = new GroupSpaceBindingServiceImpl(this.initParams, this.groupSpaceBindingStorage, this.orgService, this.spaceService);
        groupSpaceBindingService.bindUsersFromGroupSpaceBinding(binding1);
        ArgumentCaptor argument = ArgumentCaptor.forClass(UserSpaceBinding.class);
        ((GroupSpaceBindingStorage)Mockito.verify((Object)this.groupSpaceBindingStorage)).saveUserBinding((UserSpaceBinding)argument.capture());
        GroupSpaceBindingServiceTest.assertEquals((boolean)false, (boolean)((UserSpaceBinding)argument.getValue()).isMemberBefore());
        ArgumentCaptor reportCaptur = ArgumentCaptor.forClass(GroupSpaceBindingReportAction.class);
        ((GroupSpaceBindingStorage)Mockito.verify((Object)this.groupSpaceBindingStorage, (VerificationMode)Mockito.times((int)1))).saveGroupSpaceBindingReport((GroupSpaceBindingReportAction)reportCaptur.capture());
        GroupSpaceBindingReportAction capturedReport = (GroupSpaceBindingReportAction)reportCaptur.getValue();
        GroupSpaceBindingServiceTest.assertEquals((String)"ADD", (String)capturedReport.getAction());
        ArgumentCaptor reportUserCaptur = ArgumentCaptor.forClass(GroupSpaceBindingReportUser.class);
        ((GroupSpaceBindingStorage)Mockito.verify((Object)this.groupSpaceBindingStorage, (VerificationMode)Mockito.times((int)1))).saveGroupSpaceBindingReportUser((GroupSpaceBindingReportUser)reportUserCaptur.capture());
        GroupSpaceBindingReportUser capturedUserReport = (GroupSpaceBindingReportUser)reportUserCaptur.getValue();
        GroupSpaceBindingServiceTest.assertEquals((String)"ADD_USER", (String)capturedUserReport.getAction());
        GroupSpaceBindingServiceTest.assertEquals((boolean)false, (boolean)capturedUserReport.isWasPresentBefore());
        GroupSpaceBindingServiceTest.assertEquals((boolean)false, (boolean)capturedUserReport.isStillInSpace());
    }

    @Test
    public void testBindUsersFromGroupSpaceBindingCheckUserIsMemberAndNotBound() throws Exception {
        GroupSpaceBinding binding1 = new GroupSpaceBinding();
        binding1.setId(1L);
        binding1.setGroup("/platform/administrators");
        binding1.setSpaceId("1");
        Space space1 = new Space();
        space1.setPrettyName("space1");
        space1.setId("1");
        space1.setGroupId("/spaces/space1");
        space1.setMembers(new String[]{"user1"});
        Mockito.when((Object)this.spaceService.getSpaceById("1")).thenReturn((Object)space1);
        UserImpl user1 = new UserImpl("user1");
        user1.setFirstName("user1");
        user1.setLastName("user1");
        user1.setEmail("user1@acme.com");
        ListAccess<User> userListAccess = new ListAccess<User>(){
            final /* synthetic */ User val$user1;
            {
                this.val$user1 = user;
            }

            public User[] load(int index, int length) throws Exception {
                ArrayList<User> users = new ArrayList<User>();
                users.add(this.val$user1);
                User[] result = new User[users.size()];
                return users.toArray(result);
            }

            public int getSize() throws Exception {
                return 1;
            }
        };
        UserDAOImpl userDAO = (UserDAOImpl)Mockito.mock(UserDAOImpl.class);
        Mockito.when((Object)userDAO.findUsersByGroupId("/platform/administrators")).thenReturn((Object)userListAccess);
        Mockito.when((Object)this.orgService.getUserHandler()).thenReturn((Object)userDAO);
        Mockito.lenient().when((Object)this.groupSpaceBindingStorage.isUserBoundAndMemberBefore(Mockito.anyString(), Mockito.anyString())).thenReturn((Object)false);
        Mockito.when((Object)this.groupSpaceBindingStorage.countUserBindings(Mockito.anyString(), Mockito.anyString())).thenReturn((Object)0L);
        GroupSpaceBindingReportAction report = new GroupSpaceBindingReportAction(binding1.getId(), Long.parseLong(binding1.getSpaceId()), binding1.getGroup(), "ADD");
        Mockito.when((Object)this.groupSpaceBindingStorage.saveGroupSpaceBindingReport((GroupSpaceBindingReportAction)Mockito.any())).thenReturn((Object)report);
        GroupSpaceBindingServiceImpl groupSpaceBindingService = new GroupSpaceBindingServiceImpl(this.initParams, this.groupSpaceBindingStorage, this.orgService, this.spaceService);
        groupSpaceBindingService.bindUsersFromGroupSpaceBinding(binding1);
        ArgumentCaptor argument = ArgumentCaptor.forClass(UserSpaceBinding.class);
        ((GroupSpaceBindingStorage)Mockito.verify((Object)this.groupSpaceBindingStorage)).saveUserBinding((UserSpaceBinding)argument.capture());
        GroupSpaceBindingServiceTest.assertEquals((boolean)true, (boolean)((UserSpaceBinding)argument.getValue()).isMemberBefore());
        ArgumentCaptor reportCaptur = ArgumentCaptor.forClass(GroupSpaceBindingReportAction.class);
        ((GroupSpaceBindingStorage)Mockito.verify((Object)this.groupSpaceBindingStorage, (VerificationMode)Mockito.times((int)1))).saveGroupSpaceBindingReport((GroupSpaceBindingReportAction)reportCaptur.capture());
        GroupSpaceBindingReportAction capturedReport = (GroupSpaceBindingReportAction)reportCaptur.getValue();
        GroupSpaceBindingServiceTest.assertEquals((String)"ADD", (String)capturedReport.getAction());
        ArgumentCaptor reportUserCaptur = ArgumentCaptor.forClass(GroupSpaceBindingReportUser.class);
        ((GroupSpaceBindingStorage)Mockito.verify((Object)this.groupSpaceBindingStorage, (VerificationMode)Mockito.times((int)1))).saveGroupSpaceBindingReportUser((GroupSpaceBindingReportUser)reportUserCaptur.capture());
        GroupSpaceBindingReportUser capturedUserReport = (GroupSpaceBindingReportUser)reportUserCaptur.getValue();
        GroupSpaceBindingServiceTest.assertEquals((String)"ADD_USER", (String)capturedUserReport.getAction());
        GroupSpaceBindingServiceTest.assertEquals((boolean)true, (boolean)capturedUserReport.isWasPresentBefore());
        GroupSpaceBindingServiceTest.assertEquals((boolean)false, (boolean)capturedUserReport.isStillInSpace());
    }

    @Test
    public void testBindUsersFromGroupSpaceBindingCheckUserIsBoundButNotMemberBefore() throws Exception {
        GroupSpaceBinding binding1 = new GroupSpaceBinding();
        binding1.setId(1L);
        binding1.setGroup("/platform/administrators");
        binding1.setSpaceId("1");
        Space space1 = new Space();
        space1.setPrettyName("space1");
        space1.setId("1");
        space1.setGroupId("/spaces/space1");
        space1.setMembers(new String[]{"user1"});
        Mockito.when((Object)this.spaceService.getSpaceById("1")).thenReturn((Object)space1);
        UserImpl user1 = new UserImpl("user1");
        user1.setFirstName("user1");
        user1.setLastName("user1");
        user1.setEmail("user1@acme.com");
        ListAccess<User> userListAccess = new ListAccess<User>(){
            final /* synthetic */ User val$user1;
            {
                this.val$user1 = user;
            }

            public User[] load(int index, int length) throws Exception {
                ArrayList<User> users = new ArrayList<User>();
                users.add(this.val$user1);
                User[] result = new User[users.size()];
                return users.toArray(result);
            }

            public int getSize() throws Exception {
                return 1;
            }
        };
        UserDAOImpl userDAO = (UserDAOImpl)Mockito.mock(UserDAOImpl.class);
        Mockito.when((Object)userDAO.findUsersByGroupId("/platform/administrators")).thenReturn((Object)userListAccess);
        Mockito.when((Object)this.orgService.getUserHandler()).thenReturn((Object)userDAO);
        Mockito.when((Object)this.groupSpaceBindingStorage.isUserBoundAndMemberBefore(Mockito.anyString(), Mockito.anyString())).thenReturn((Object)false);
        Mockito.when((Object)this.groupSpaceBindingStorage.countUserBindings(Mockito.anyString(), Mockito.anyString())).thenReturn((Object)1L);
        GroupSpaceBindingReportAction report = new GroupSpaceBindingReportAction(binding1.getId(), Long.parseLong(binding1.getSpaceId()), binding1.getGroup(), "ADD");
        Mockito.when((Object)this.groupSpaceBindingStorage.saveGroupSpaceBindingReport((GroupSpaceBindingReportAction)Mockito.any())).thenReturn((Object)report);
        GroupSpaceBindingServiceImpl groupSpaceBindingService = new GroupSpaceBindingServiceImpl(this.initParams, this.groupSpaceBindingStorage, this.orgService, this.spaceService);
        groupSpaceBindingService.bindUsersFromGroupSpaceBinding(binding1);
        ArgumentCaptor argument = ArgumentCaptor.forClass(UserSpaceBinding.class);
        ((GroupSpaceBindingStorage)Mockito.verify((Object)this.groupSpaceBindingStorage)).saveUserBinding((UserSpaceBinding)argument.capture());
        GroupSpaceBindingServiceTest.assertEquals((boolean)false, (boolean)((UserSpaceBinding)argument.getValue()).isMemberBefore());
        ArgumentCaptor reportCaptur = ArgumentCaptor.forClass(GroupSpaceBindingReportAction.class);
        ((GroupSpaceBindingStorage)Mockito.verify((Object)this.groupSpaceBindingStorage, (VerificationMode)Mockito.times((int)1))).saveGroupSpaceBindingReport((GroupSpaceBindingReportAction)reportCaptur.capture());
        GroupSpaceBindingReportAction capturedReport = (GroupSpaceBindingReportAction)reportCaptur.getValue();
        GroupSpaceBindingServiceTest.assertEquals((String)"ADD", (String)capturedReport.getAction());
        ArgumentCaptor reportUserCaptur = ArgumentCaptor.forClass(GroupSpaceBindingReportUser.class);
        ((GroupSpaceBindingStorage)Mockito.verify((Object)this.groupSpaceBindingStorage, (VerificationMode)Mockito.times((int)1))).saveGroupSpaceBindingReportUser((GroupSpaceBindingReportUser)reportUserCaptur.capture());
        GroupSpaceBindingReportUser capturedUserReport = (GroupSpaceBindingReportUser)reportUserCaptur.getValue();
        GroupSpaceBindingServiceTest.assertEquals((String)"ADD_USER", (String)capturedUserReport.getAction());
        GroupSpaceBindingServiceTest.assertEquals((boolean)false, (boolean)capturedUserReport.isWasPresentBefore());
        GroupSpaceBindingServiceTest.assertEquals((boolean)false, (boolean)capturedUserReport.isStillInSpace());
    }

    @Test
    public void testBindUsersFromGroupSpaceBindingCheckUserIsBoundButAndMemberBefore() throws Exception {
        GroupSpaceBinding binding1 = new GroupSpaceBinding();
        binding1.setId(1L);
        binding1.setGroup("/platform/administrators");
        binding1.setSpaceId("1");
        Space space1 = new Space();
        space1.setPrettyName("space1");
        space1.setId("1");
        space1.setGroupId("/spaces/space1");
        space1.setMembers(new String[]{"user1"});
        Mockito.when((Object)this.spaceService.getSpaceById("1")).thenReturn((Object)space1);
        UserImpl user1 = new UserImpl("user1");
        user1.setFirstName("user1");
        user1.setLastName("user1");
        user1.setEmail("user1@acme.com");
        ListAccess<User> userListAccess = new ListAccess<User>(){
            final /* synthetic */ User val$user1;
            {
                this.val$user1 = user;
            }

            public User[] load(int index, int length) throws Exception {
                ArrayList<User> users = new ArrayList<User>();
                users.add(this.val$user1);
                User[] result = new User[users.size()];
                return users.toArray(result);
            }

            public int getSize() throws Exception {
                return 1;
            }
        };
        UserDAOImpl userDAO = (UserDAOImpl)Mockito.mock(UserDAOImpl.class);
        Mockito.when((Object)userDAO.findUsersByGroupId("/platform/administrators")).thenReturn((Object)userListAccess);
        Mockito.when((Object)this.orgService.getUserHandler()).thenReturn((Object)userDAO);
        Mockito.when((Object)this.groupSpaceBindingStorage.isUserBoundAndMemberBefore(Mockito.anyString(), Mockito.anyString())).thenReturn((Object)true);
        Mockito.when((Object)this.groupSpaceBindingStorage.countUserBindings(Mockito.anyString(), Mockito.anyString())).thenReturn((Object)1L);
        GroupSpaceBindingReportAction report = new GroupSpaceBindingReportAction(binding1.getId(), Long.parseLong(binding1.getSpaceId()), binding1.getGroup(), "ADD");
        Mockito.when((Object)this.groupSpaceBindingStorage.saveGroupSpaceBindingReport((GroupSpaceBindingReportAction)Mockito.any())).thenReturn((Object)report);
        GroupSpaceBindingServiceImpl groupSpaceBindingService = new GroupSpaceBindingServiceImpl(this.initParams, this.groupSpaceBindingStorage, this.orgService, this.spaceService);
        groupSpaceBindingService.bindUsersFromGroupSpaceBinding(binding1);
        ArgumentCaptor argument = ArgumentCaptor.forClass(UserSpaceBinding.class);
        ((GroupSpaceBindingStorage)Mockito.verify((Object)this.groupSpaceBindingStorage)).saveUserBinding((UserSpaceBinding)argument.capture());
        GroupSpaceBindingServiceTest.assertEquals((boolean)true, (boolean)((UserSpaceBinding)argument.getValue()).isMemberBefore());
        ArgumentCaptor reportCaptur = ArgumentCaptor.forClass(GroupSpaceBindingReportAction.class);
        ((GroupSpaceBindingStorage)Mockito.verify((Object)this.groupSpaceBindingStorage, (VerificationMode)Mockito.times((int)1))).saveGroupSpaceBindingReport((GroupSpaceBindingReportAction)reportCaptur.capture());
        GroupSpaceBindingReportAction capturedReport = (GroupSpaceBindingReportAction)reportCaptur.getValue();
        GroupSpaceBindingServiceTest.assertEquals((String)"ADD", (String)capturedReport.getAction());
        ArgumentCaptor reportUserCaptur = ArgumentCaptor.forClass(GroupSpaceBindingReportUser.class);
        ((GroupSpaceBindingStorage)Mockito.verify((Object)this.groupSpaceBindingStorage, (VerificationMode)Mockito.times((int)1))).saveGroupSpaceBindingReportUser((GroupSpaceBindingReportUser)reportUserCaptur.capture());
        GroupSpaceBindingReportUser capturedUserReport = (GroupSpaceBindingReportUser)reportUserCaptur.getValue();
        GroupSpaceBindingServiceTest.assertEquals((String)"ADD_USER", (String)capturedUserReport.getAction());
        GroupSpaceBindingServiceTest.assertEquals((boolean)true, (boolean)capturedUserReport.isWasPresentBefore());
        GroupSpaceBindingServiceTest.assertEquals((boolean)false, (boolean)capturedUserReport.isStillInSpace());
    }

    public void testBindUsersFromGroupSpaceBinding() throws Exception {
        GroupSpaceBinding binding1 = new GroupSpaceBinding();
        binding1.setId(1L);
        binding1.setGroup("/platform/administrators");
        binding1.setSpaceId("1");
        Space space1 = new Space();
        space1.setPrettyName("space1");
        space1.setId("1");
        space1.setGroupId("/spaces/space1");
        space1.setMembers(new String[]{"user1"});
        Mockito.when((Object)this.spaceService.getSpaceById("1")).thenReturn((Object)space1);
        UserImpl user2 = new UserImpl("user2");
        user2.setFirstName("user2");
        user2.setLastName("user2");
        user2.setEmail("user2@acme.com");
        UserImpl user3 = new UserImpl("user3");
        user3.setFirstName("user3");
        user3.setLastName("user3");
        user3.setEmail("user3@acme.com");
        ListAccess<User> userListAccess = new ListAccess<User>(){
            final /* synthetic */ User val$user2;
            final /* synthetic */ User val$user3;
            {
                this.val$user2 = user;
                this.val$user3 = user2;
            }

            public User[] load(int index, int length) throws Exception {
                ArrayList<User> users = new ArrayList<User>();
                users.add(this.val$user2);
                users.add(this.val$user3);
                User[] result = new User[users.size()];
                return users.toArray(result);
            }

            public int getSize() throws Exception {
                return 2;
            }
        };
        UserDAOImpl userDAO = (UserDAOImpl)Mockito.mock(UserDAOImpl.class);
        Mockito.when((Object)userDAO.findUsersByGroupId("/platform/administrators")).thenReturn((Object)userListAccess);
        Mockito.when((Object)this.orgService.getUserHandler()).thenReturn((Object)userDAO);
        GroupSpaceBindingReportAction report = new GroupSpaceBindingReportAction(binding1.getId(), Long.parseLong(binding1.getSpaceId()), binding1.getGroup(), "ADD");
        Mockito.when((Object)this.groupSpaceBindingStorage.saveGroupSpaceBindingReport((GroupSpaceBindingReportAction)Mockito.any())).thenReturn((Object)report);
        GroupSpaceBindingServiceImpl groupSpaceBindingService = new GroupSpaceBindingServiceImpl(this.initParams, this.groupSpaceBindingStorage, this.orgService, this.spaceService);
        groupSpaceBindingService.bindUsersFromGroupSpaceBinding(binding1);
        GroupSpaceBindingServiceTest.assertEquals((Object)2, (Object)groupSpaceBindingService.findReportsForCsv(Long.parseLong(space1.getId()), binding1.getId(), binding1.getGroup(), "ADD"));
    }

    private Space getSpaceInstance(int number) {
        Space space = new Space();
        space.setApp("app1,app2");
        space.setDisplayName("myspacetestbinding" + number);
        space.setPrettyName(space.getDisplayName());
        space.setRegistration("open");
        space.setDescription("add new space " + number);
        space.setType("classic");
        space.setVisibility("public");
        space.setPriority("2");
        space.setGroupId("/spaces/space" + number);
        String[] managers = new String[]{"demo"};
        String[] members = new String[]{"john", "root"};
        String[] invitedUsers = new String[]{"mary"};
        String[] pendingUsers = new String[]{"jame"};
        space.setInvitedUsers(invitedUsers);
        space.setPendingUsers(pendingUsers);
        space.setManagers(managers);
        space.setMembers(members);
        space.setUrl(space.getPrettyName());
        return space;
    }

    @Test
    public void testSaveUserBinding() throws Exception {
        GroupSpaceBinding binding1 = new GroupSpaceBinding();
        binding1.setId(1L);
        binding1.setGroup("/platform/administrators");
        binding1.setSpaceId("1");
        GroupSpaceBindingReportAction report = new GroupSpaceBindingReportAction(binding1.getId(), Long.parseLong(binding1.getSpaceId()), binding1.getGroup(), "ADD");
        Space space = new Space();
        space.setId("1");
        space.setDisplayName("space1");
        space.setPrettyName("space1");
        space.setMembers(new String[]{"root"});
        Mockito.lenient().when((Object)this.spaceService.getSpaceById((String)Mockito.any())).thenReturn((Object)space);
        Mockito.lenient().when((Object)this.groupSpaceBindingStorage.countBoundUsers((String)Mockito.any())).thenReturn((Object)0L);
        GroupSpaceBindingServiceImpl groupSpaceBindingService = new GroupSpaceBindingServiceImpl(this.initParams, this.groupSpaceBindingStorage, this.orgService, this.spaceService);
        groupSpaceBindingService.saveUserBinding("user1", binding1, space, report);
        ArgumentCaptor argument = ArgumentCaptor.forClass(UserSpaceBinding.class);
        ((GroupSpaceBindingStorage)Mockito.verify((Object)this.groupSpaceBindingStorage)).saveUserBinding((UserSpaceBinding)argument.capture());
        GroupSpaceBindingServiceTest.assertEquals((boolean)false, (boolean)((UserSpaceBinding)argument.getValue()).isMemberBefore());
        GroupSpaceBindingServiceTest.assertEquals((String)"user1", (String)((UserSpaceBinding)argument.getValue()).getUser());
        ArgumentCaptor reportUserCaptur = ArgumentCaptor.forClass(GroupSpaceBindingReportUser.class);
        ((GroupSpaceBindingStorage)Mockito.verify((Object)this.groupSpaceBindingStorage, (VerificationMode)Mockito.times((int)1))).saveGroupSpaceBindingReportUser((GroupSpaceBindingReportUser)reportUserCaptur.capture());
        GroupSpaceBindingReportUser capturedUserReport = (GroupSpaceBindingReportUser)reportUserCaptur.getValue();
        GroupSpaceBindingServiceTest.assertEquals((String)"ADD_USER", (String)capturedUserReport.getAction());
    }
}

