/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.listeners;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ObjectParameter;
import org.exoplatform.container.xml.Parameter;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.Identity;
import org.exoplatform.social.common.ObjectAlreadyExistsException;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.activity.model.ExoSocialActivityImpl;
import org.exoplatform.social.core.jpa.storage.dao.jpa.MetadataDAO;
import org.exoplatform.social.core.manager.ActivityManager;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.test.AbstractCoreTest;
import org.exoplatform.social.metadata.MetadataService;
import org.exoplatform.social.metadata.MetadataTypePlugin;
import org.exoplatform.social.metadata.model.MetadataItem;
import org.exoplatform.social.metadata.model.MetadataKey;
import org.exoplatform.social.metadata.model.MetadataObject;
import org.exoplatform.social.metadata.model.MetadataType;
import org.junit.Assert;

public class ActivityMetadataListenerTest
extends AbstractCoreTest {
    private static final Log LOG = ExoLogger.getLogger(ActivityMetadataListenerTest.class);
    private static final String METADATA_TYPE_NAME = "testMetadataListener";
    private org.exoplatform.social.core.identity.model.Identity rootIdentity;
    private org.exoplatform.social.core.identity.model.Identity johnIdentity;
    private org.exoplatform.social.core.identity.model.Identity maryIdentity;
    private ActivityManager activityManager;
    private IdentityManager identityManager;
    private MetadataService metadataService;
    private MetadataDAO metadataDAO;
    private List<ExoSocialActivity> tearDownActivityList;
    private List<Space> tearDownSpaceList;

    @Override
    public void setUp() throws Exception {
        try {
            super.setUp();
        }
        catch (Exception e) {
            LOG.error((Object)"Error initializing parent Test class", (Throwable)e);
        }
        this.identityManager = (IdentityManager)this.getContainer().getComponentInstanceOfType(IdentityManager.class);
        this.activityManager = (ActivityManager)this.getContainer().getComponentInstanceOfType(ActivityManager.class);
        this.metadataService = (MetadataService)this.getContainer().getComponentInstanceOfType(MetadataService.class);
        this.metadataDAO = (MetadataDAO)this.getContainer().getComponentInstanceOfType(MetadataDAO.class);
        if (this.metadataService.getMetadataTypeByName(METADATA_TYPE_NAME) == null) {
            MetadataTypePlugin userMetadataTypePlugin = new MetadataTypePlugin(this, this.newParam(2654L, METADATA_TYPE_NAME)){

                public boolean isAllowMultipleItemsPerObject() {
                    return true;
                }

                public boolean isShareable() {
                    return true;
                }
            };
            this.metadataService.addMetadataTypePlugin(userMetadataTypePlugin);
        }
        this.rootIdentity = this.identityManager.getOrCreateUserIdentity("root");
        this.johnIdentity = this.identityManager.getOrCreateUserIdentity("john");
        this.maryIdentity = this.identityManager.getOrCreateUserIdentity("mary");
        this.tearDownActivityList = new ArrayList<ExoSocialActivity>();
        this.tearDownSpaceList = new ArrayList<Space>();
    }

    @Override
    public void tearDown() throws Exception {
        this.end();
        this.begin();
        this.identityManager.deleteIdentity(this.rootIdentity);
        this.identityManager.deleteIdentity(this.johnIdentity);
        this.identityManager.deleteIdentity(this.maryIdentity);
        this.metadataDAO.deleteAll();
        for (ExoSocialActivity activity : this.tearDownActivityList) {
            try {
                this.activityManager.deleteActivity(activity.getId());
            }
            catch (Exception e) {
                LOG.warn((Object)("can not delete activity with id: " + activity.getId()));
            }
        }
        for (Space space : this.tearDownSpaceList) {
            org.exoplatform.social.core.identity.model.Identity spaceIdentity = this.identityManager.getOrCreateIdentity("space", space.getPrettyName());
            if (spaceIdentity != null) {
                this.identityManager.deleteIdentity(spaceIdentity);
            }
            this.spaceService.deleteSpace(space);
        }
        super.tearDown();
    }

    public void testDeleteActivity() throws ObjectAlreadyExistsException {
        long creatorId;
        String activityTitle = "activity title";
        String userId = this.johnIdentity.getId();
        ExoSocialActivityImpl activity = new ExoSocialActivityImpl();
        activity.setTitle(activityTitle);
        activity.setUserId(userId);
        this.activityManager.saveActivityNoReturn(this.johnIdentity, (ExoSocialActivity)activity);
        long audienceId = creatorId = Long.parseLong(this.johnIdentity.getId());
        MetadataKey metadataKey = new MetadataKey(METADATA_TYPE_NAME, "testMetadata2", audienceId);
        MetadataObject metadataObject = new MetadataObject("activity", activity.getId());
        MetadataItem metadataItem = this.metadataService.createMetadataItem(metadataObject, metadataKey, creatorId);
        ActivityMetadataListenerTest.assertNotNull((Object)metadataItem);
        ActivityMetadataListenerTest.assertTrue((metadataItem.getId() > 0L ? 1 : 0) != 0);
        List metadataItems = this.metadataService.getMetadataItemsByObject(metadataObject);
        ActivityMetadataListenerTest.assertNotNull((Object)metadataItem);
        ActivityMetadataListenerTest.assertEquals((int)1, (int)metadataItems.size());
        this.activityManager.deleteActivity((ExoSocialActivity)activity);
        this.restartTransaction();
        metadataItems = this.metadataService.getMetadataItemsByObject(metadataObject);
        ActivityMetadataListenerTest.assertNotNull((Object)metadataItem);
        ActivityMetadataListenerTest.assertEquals((int)0, (int)metadataItems.size());
    }

    public void testDeleteComment() throws ObjectAlreadyExistsException {
        long creatorId;
        String activityTitle = "activity title";
        String userId = this.johnIdentity.getId();
        ExoSocialActivityImpl activity = new ExoSocialActivityImpl();
        activity.setTitle(activityTitle);
        activity.setUserId(userId);
        this.activityManager.saveActivityNoReturn(this.johnIdentity, (ExoSocialActivity)activity);
        ExoSocialActivityImpl comment = new ExoSocialActivityImpl();
        comment.setTitle(activityTitle);
        comment.setUserId(userId);
        comment.setPosterId(userId);
        this.activityManager.saveComment((ExoSocialActivity)activity, (ExoSocialActivity)comment);
        long audienceId = creatorId = Long.parseLong(this.johnIdentity.getId());
        MetadataKey metadataKey = new MetadataKey(METADATA_TYPE_NAME, "testMetadata2", audienceId);
        MetadataObject metadataObject = new MetadataObject("activity", comment.getId());
        MetadataItem metadataItem = this.metadataService.createMetadataItem(metadataObject, metadataKey, creatorId);
        ActivityMetadataListenerTest.assertNotNull((Object)metadataItem);
        ActivityMetadataListenerTest.assertTrue((metadataItem.getId() > 0L ? 1 : 0) != 0);
        List metadataItems = this.metadataService.getMetadataItemsByObject(metadataObject);
        ActivityMetadataListenerTest.assertNotNull((Object)metadataItem);
        ActivityMetadataListenerTest.assertEquals((int)1, (int)metadataItems.size());
        this.activityManager.deleteComment((ExoSocialActivity)activity, (ExoSocialActivity)comment);
        this.restartTransaction();
        metadataItems = this.metadataService.getMetadataItemsByObject(metadataObject);
        ActivityMetadataListenerTest.assertNotNull((Object)metadataItem);
        ActivityMetadataListenerTest.assertEquals((int)0, (int)metadataItems.size());
    }

    public void testShareActivity() throws Exception {
        Space originalSpace = this.createSpace("OriginalSpace", this.johnIdentity.getRemoteId(), this.johnIdentity.getRemoteId(), this.maryIdentity.getRemoteId());
        org.exoplatform.social.core.identity.model.Identity spaceIdentity = this.identityManager.getOrCreateSpaceIdentity(originalSpace.getPrettyName());
        ExoSocialActivityImpl originalActivity = new ExoSocialActivityImpl();
        originalActivity.setTitle("TestSourceActivitySpace");
        originalActivity.setUserId(this.johnIdentity.getId());
        this.activityManager.saveActivityNoReturn(spaceIdentity, (ExoSocialActivity)originalActivity);
        MetadataObject metadataObject = new MetadataObject("activity", originalActivity.getId());
        MetadataKey metadataKey = new MetadataKey(METADATA_TYPE_NAME, "testMetadata2", Long.parseLong(spaceIdentity.getId()));
        MetadataItem metadataItem = this.metadataService.createMetadataItem(metadataObject, metadataKey, Long.parseLong(this.johnIdentity.getId()));
        ActivityMetadataListenerTest.assertNotNull((Object)metadataItem);
        ActivityMetadataListenerTest.assertTrue((metadataItem.getId() > 0L ? 1 : 0) != 0);
        List metadataItems = this.metadataService.getMetadataItemsByObject(metadataObject);
        ActivityMetadataListenerTest.assertNotNull((Object)metadataItem);
        ActivityMetadataListenerTest.assertEquals((int)1, (int)metadataItems.size());
        originalActivity = this.activityManager.getActivity(originalActivity.getId());
        ActivityMetadataListenerTest.assertTrue((boolean)CollectionUtils.isEmpty((Collection)originalActivity.getShareActions()));
        Space targetSpace = this.createSpace("TargetSharedActivitySpace", this.maryIdentity.getRemoteId(), this.johnIdentity.getRemoteId(), this.maryIdentity.getRemoteId());
        org.exoplatform.social.core.identity.model.Identity targetSpaceIdentity = this.identityManager.getOrCreateSpaceIdentity(targetSpace.getPrettyName());
        this.restartTransaction();
        Identity marySecurityIdentity = new Identity("mary");
        ExoSocialActivityImpl shareActivityTemplate = new ExoSocialActivityImpl();
        shareActivityTemplate.setTitle("Shared Activity");
        shareActivityTemplate.setUserId(this.maryIdentity.getId());
        List sharedActivities = this.activityManager.shareActivity((ExoSocialActivity)shareActivityTemplate, originalActivity.getId(), Collections.singletonList(targetSpace.getPrettyName()), marySecurityIdentity);
        ActivityMetadataListenerTest.assertNotNull((Object)sharedActivities);
        ActivityMetadataListenerTest.assertEquals((int)1, (int)sharedActivities.size());
        ExoSocialActivity sharedActivity = (ExoSocialActivity)sharedActivities.get(0);
        Assert.assertNotEquals((Object)originalActivity.getId(), (Object)sharedActivity.getId());
        this.restartTransaction();
        MetadataObject sharedActivityMetadataObject = new MetadataObject("activity", sharedActivity.getId());
        metadataItems = this.metadataService.getMetadataItemsByObject(sharedActivityMetadataObject);
        ActivityMetadataListenerTest.assertNotNull((Object)metadataItem);
        ActivityMetadataListenerTest.assertEquals((int)1, (int)metadataItems.size());
        MetadataItem sharedMetadataItem = (MetadataItem)metadataItems.get(0);
        Assert.assertNotEquals((long)metadataItem.getId(), (long)sharedMetadataItem.getId());
        ActivityMetadataListenerTest.assertEquals((Object)sharedActivityMetadataObject, (Object)sharedMetadataItem.getObject());
        ActivityMetadataListenerTest.assertEquals((long)Long.parseLong(targetSpaceIdentity.getId()), (long)sharedMetadataItem.getMetadata().getAudienceId());
        ActivityMetadataListenerTest.assertEquals((long)Long.parseLong(this.maryIdentity.getId()), (long)sharedMetadataItem.getMetadata().getCreatorId());
        ActivityMetadataListenerTest.assertEquals((String)metadataKey.getName(), (String)sharedMetadataItem.getMetadata().getName());
        ActivityMetadataListenerTest.assertEquals((String)metadataKey.getType(), (String)sharedMetadataItem.getMetadata().getTypeName());
        ActivityMetadataListenerTest.assertEquals((long)Long.parseLong(this.maryIdentity.getId()), (long)sharedMetadataItem.getCreatorId());
    }

    private InitParams newParam(long id, String name) {
        InitParams params = new InitParams();
        MetadataType metadataType = new MetadataType(id, name);
        ObjectParameter parameter = new ObjectParameter();
        parameter.setName("metadataType");
        parameter.setObject((Object)metadataType);
        params.addParameter((Parameter)parameter);
        return params;
    }

    private Space createSpace(String spaceName, String manager, String ... members) throws Exception {
        String[] stringArray;
        Space space = new Space();
        space.setDisplayName(spaceName);
        space.setPrettyName(spaceName);
        space.setGroupId("/spaces/" + space.getPrettyName());
        space.setRegistration("open");
        space.setDescription("description of space" + spaceName);
        space.setVisibility("private");
        space.setRegistration("open");
        space.setPriority("2");
        String[] managers = new String[]{manager};
        space.setManagers(managers);
        if (members == null) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = manager;
        } else {
            stringArray = (String[])ArrayUtils.add((Object[])members, (Object)manager);
        }
        space.setMembers(stringArray);
        this.spaceService.createSpace(space);
        this.tearDownSpaceList.add(space);
        return space;
    }
}

