/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.processor;

import java.util.LinkedHashMap;
import java.util.Map;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.activity.model.ExoSocialActivityImpl;
import org.exoplatform.social.core.processor.OSHtmlSanitizerProcessor;
import org.exoplatform.social.core.test.AbstractCoreTest;

public class OSHtmlSanitizerProcessorTest
extends AbstractCoreTest {
    private OSHtmlSanitizerProcessor processor;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.processor = (OSHtmlSanitizerProcessor)PortalContainer.getInstance().getComponentInstanceOfType(OSHtmlSanitizerProcessor.class);
    }

    @Override
    public void tearDown() throws Exception {
        super.tearDown();
    }

    public void testProcessActivity() throws Exception {
        System.setProperty("gatein.email.domain.url", "test.com");
        ExoSocialActivityImpl activity = new ExoSocialActivityImpl();
        String sample = "this is a <strong> tag to keep</strong>";
        activity.setTitle(sample);
        activity.setBody(sample);
        this.processor.processActivity((ExoSocialActivity)activity);
        OSHtmlSanitizerProcessorTest.assertEquals((String)sample, (String)activity.getTitle());
        OSHtmlSanitizerProcessorTest.assertEquals((String)sample, (String)activity.getBody());
        sample = "text <a href='test.com'>bar</a> zed";
        activity.setTitle(sample);
        this.processor.processActivity((ExoSocialActivity)activity);
        OSHtmlSanitizerProcessorTest.assertEquals((String)"text <a href=\"test.com\" rel=\"nofollow\" target=\"_self\">bar</a> zed", (String)activity.getTitle());
        sample = "<strong> only open!!!";
        activity.setTitle(sample);
        this.processor.processActivity((ExoSocialActivity)activity);
        OSHtmlSanitizerProcessorTest.assertEquals((String)"<strong> only open!!!</strong>", (String)activity.getTitle());
        sample = "<script href='#' />bar</a>";
        activity.setTitle(sample);
        this.processor.processActivity((ExoSocialActivity)activity);
        OSHtmlSanitizerProcessorTest.assertEquals((String)"bar&lt;/a&gt;", (String)activity.getTitle());
        sample = "<script>foo</script>";
        activity.setTitle(sample);
        this.processor.processActivity((ExoSocialActivity)activity);
        OSHtmlSanitizerProcessorTest.assertEquals((String)"", (String)activity.getTitle());
        sample = "<span><strong>foo</strong>bar<script>zed</script></span>";
        activity.setTitle(sample);
        this.processor.processActivity((ExoSocialActivity)activity);
        OSHtmlSanitizerProcessorTest.assertEquals((String)"<strong>foo</strong>bar", (String)activity.getTitle());
        System.clearProperty("gatein.email.domain.url");
    }

    public void testProcessActivityWithTemplateParam() throws Exception {
        System.setProperty("gatein.email.domain.url", "test.com");
        ExoSocialActivityImpl activity = new ExoSocialActivityImpl();
        String sample = "this is a <strong> tag to keep</strong>";
        activity.setTitle(sample);
        activity.setBody(sample);
        String keysToProcess = "a|b|c";
        Map templateParams = new LinkedHashMap<String, String>();
        templateParams.put("a", "a\nb");
        templateParams.put("b", "test.com");
        templateParams.put("d", "test.com");
        templateParams.put("registeredKeysForProcessor", keysToProcess);
        activity.setTemplateParams(templateParams);
        this.processor.processActivity((ExoSocialActivity)activity);
        templateParams = activity.getTemplateParams();
        OSHtmlSanitizerProcessorTest.assertEquals((String)"a\nb", (String)((String)templateParams.get("a")));
        OSHtmlSanitizerProcessorTest.assertEquals((String)"<a href=\"http://test.com\" target=\"_self\" rel=\"nofollow noopener noreferrer\">test.com</a>", (String)((String)templateParams.get("b")));
        OSHtmlSanitizerProcessorTest.assertEquals((String)"test.com", (String)((String)templateParams.get("d")));
        System.clearProperty("gatein.email.domain.url");
    }
}

