/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.space.spi;

import io.meeds.social.space.constant.SpaceRegistration;
import io.meeds.social.space.constant.SpaceVisibility;
import io.meeds.social.space.service.SpaceLayoutService;
import io.meeds.social.space.template.entity.SpaceTemplateEntity;
import io.meeds.social.space.template.model.SpaceTemplate;
import io.meeds.social.space.template.service.SpaceTemplateService;
import io.meeds.social.space.template.storage.SpaceTemplateStorage;
import io.meeds.social.space.template.utils.EntityMapper;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.exoplatform.commons.file.model.FileItem;
import org.exoplatform.commons.persistence.impl.GenericDAOJPAImpl;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.GroupHandler;
import org.exoplatform.services.organization.Membership;
import org.exoplatform.services.organization.MembershipType;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.UserHandler;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.security.IdentityConstants;
import org.exoplatform.services.security.MembershipEntry;
import org.exoplatform.social.common.Utils;
import org.exoplatform.social.core.binding.model.GroupSpaceBinding;
import org.exoplatform.social.core.binding.spi.GroupSpaceBindingService;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.mock.SpaceListenerPluginMock;
import org.exoplatform.social.core.model.AvatarAttachment;
import org.exoplatform.social.core.model.SpaceExternalInvitation;
import org.exoplatform.social.core.space.SpaceException;
import org.exoplatform.social.core.space.SpaceFilter;
import org.exoplatform.social.core.space.SpaceListenerPlugin;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceLifeCycleEvent;
import org.exoplatform.social.core.storage.api.IdentityStorage;
import org.exoplatform.social.core.test.AbstractCoreTest;
import org.exoplatform.social.metadata.favorite.FavoriteService;
import org.exoplatform.social.metadata.favorite.model.Favorite;
import org.junit.Assert;

public class SpaceServiceTest
extends AbstractCoreTest {
    private static final String EXTERNAL3_USER_EMAIL = "external3@external3.com";
    private static final String EXTERNAL2_USER_EMAIL = "external2@external2.com";
    private static final String EXTERNAL1_USER_EMAIL = "external1@external1.com";
    private static final String EXTERNAL_USER_EMAIL = "external@external.com";
    private static final String OTHER_USER_NAME = "otherUser";
    private static final String MY_SPACE_0_PRETTY_NAME = "my_space_0";
    private static final String MY_SPACE_DISPLAY_NAME_PREFIX = "my space ";
    private static final String TEST_SPACE_DESCRIPTION = "Space Description for Testing";
    private static final String TEST_SPACE_DISPLAY_NAME = "testSpace";
    private static final String SPACES_GROUP_PREFIX = "/spaces/";
    private static final String SPACE_DESCRIPTION = "add new space ";
    private static final String SPACE2_DISPLAY_NAME = "Space2";
    private static final String SPACE1_DISPLAY_NAME = "Space1";
    private static final String SPACE1_NAME = "space1";
    private static final String JAMES_NAME = "james";
    private static final String PLATFORM_ADMINISTRATORS = "/platform/administrators";
    private static final String MEMBER3_NAME = "member3";
    private static final String NEW_PENDING_USER_NAME = "newPendingUser";
    private static final String NEW_INVITED_USER_NAME = "newInvitedUser";
    private static final String HEAR_BREAKER_NAME = "hearBreaker";
    private static final String PAUL_NAME = "paul";
    private static final String JAME_NAME = "jame";
    private static final String ROOT_NAME = "root";
    private static final String JOHN_NAME = "john";
    private static final String MARY_NAME = "mary";
    private static final String REGISTER1_NAME = "register1";
    private static final String DRAGON_NAME = "dragon";
    private static final String GHOST_NAME = "ghost";
    private static final String RAUL_NAME = "raul";
    private static final String TOM_NAME = "tom";
    private static final String DEMO_NAME = "demo";
    private static final String USER_DOT_NEW_NAME = "user.new";
    private static final String USER_NEW_1_NAME = "user-new.1";
    private static final String USER_NEW_NAME = "user-new";
    private static final String MEMBER2_NAME = "member2";
    private static final String MEMBER1_NAME = "member1";
    private static final String MANAGER_NAME = "manager";
    private static final String HACKER_NAME = "hacker";
    private static final String EXTERNAL_USER_NAME = "externalUser";
    private IdentityStorage identityStorage;
    private OrganizationService organizationService;
    private SpaceLayoutService spaceLayoutService;
    private org.exoplatform.social.core.identity.model.Identity tom;
    private org.exoplatform.social.core.identity.model.Identity dragon;
    private org.exoplatform.social.core.identity.model.Identity john;
    private org.exoplatform.social.core.identity.model.Identity mary;
    private org.exoplatform.social.core.identity.model.Identity root;
    private org.exoplatform.social.core.identity.model.Identity hearBreaker;
    private org.exoplatform.social.core.identity.model.Identity newInvitedUser;
    private org.exoplatform.social.core.identity.model.Identity newPendingUser;
    private org.exoplatform.social.core.identity.model.Identity externalUser;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.identityStorage = (IdentityStorage)this.getContainer().getComponentInstanceOfType(IdentityStorage.class);
        this.organizationService = (OrganizationService)this.getContainer().getComponentInstanceOfType(OrganizationService.class);
        this.spaceLayoutService = (SpaceLayoutService)this.getContainer().getComponentInstanceOfType(SpaceLayoutService.class);
        org.exoplatform.social.core.identity.model.Identity userNew = new org.exoplatform.social.core.identity.model.Identity("organization", USER_NEW_NAME);
        org.exoplatform.social.core.identity.model.Identity userNew1 = new org.exoplatform.social.core.identity.model.Identity("organization", USER_NEW_1_NAME);
        org.exoplatform.social.core.identity.model.Identity userNewDot = new org.exoplatform.social.core.identity.model.Identity("organization", USER_DOT_NEW_NAME);
        org.exoplatform.social.core.identity.model.Identity demo = new org.exoplatform.social.core.identity.model.Identity("organization", DEMO_NAME);
        this.tom = new org.exoplatform.social.core.identity.model.Identity("organization", TOM_NAME);
        org.exoplatform.social.core.identity.model.Identity raul = new org.exoplatform.social.core.identity.model.Identity("organization", RAUL_NAME);
        org.exoplatform.social.core.identity.model.Identity ghost = new org.exoplatform.social.core.identity.model.Identity("organization", GHOST_NAME);
        this.dragon = new org.exoplatform.social.core.identity.model.Identity("organization", DRAGON_NAME);
        org.exoplatform.social.core.identity.model.Identity register1 = new org.exoplatform.social.core.identity.model.Identity("organization", REGISTER1_NAME);
        this.mary = new org.exoplatform.social.core.identity.model.Identity("organization", MARY_NAME);
        this.john = new org.exoplatform.social.core.identity.model.Identity("organization", JOHN_NAME);
        this.root = new org.exoplatform.social.core.identity.model.Identity("organization", ROOT_NAME);
        org.exoplatform.social.core.identity.model.Identity jame = new org.exoplatform.social.core.identity.model.Identity("organization", JAME_NAME);
        org.exoplatform.social.core.identity.model.Identity paul = new org.exoplatform.social.core.identity.model.Identity("organization", PAUL_NAME);
        org.exoplatform.social.core.identity.model.Identity hacker = new org.exoplatform.social.core.identity.model.Identity("organization", HACKER_NAME);
        this.hearBreaker = new org.exoplatform.social.core.identity.model.Identity("organization", HEAR_BREAKER_NAME);
        this.newInvitedUser = new org.exoplatform.social.core.identity.model.Identity("organization", NEW_INVITED_USER_NAME);
        this.newPendingUser = new org.exoplatform.social.core.identity.model.Identity("organization", NEW_PENDING_USER_NAME);
        org.exoplatform.social.core.identity.model.Identity manager = new org.exoplatform.social.core.identity.model.Identity("organization", MANAGER_NAME);
        org.exoplatform.social.core.identity.model.Identity member1 = new org.exoplatform.social.core.identity.model.Identity("organization", MEMBER1_NAME);
        org.exoplatform.social.core.identity.model.Identity member2 = new org.exoplatform.social.core.identity.model.Identity("organization", MEMBER2_NAME);
        org.exoplatform.social.core.identity.model.Identity member3 = new org.exoplatform.social.core.identity.model.Identity("organization", MEMBER3_NAME);
        this.externalUser = new org.exoplatform.social.core.identity.model.Identity("organization", EXTERNAL_USER_NAME);
        this.checkExternalUserMemberships();
        this.identityStorage.saveIdentity(demo);
        this.identityStorage.saveIdentity(this.tom);
        this.identityStorage.saveIdentity(raul);
        this.identityStorage.saveIdentity(ghost);
        this.identityStorage.saveIdentity(this.dragon);
        this.identityStorage.saveIdentity(register1);
        this.identityStorage.saveIdentity(this.mary);
        this.identityStorage.saveIdentity(this.john);
        this.identityStorage.saveIdentity(this.root);
        this.identityStorage.saveIdentity(jame);
        this.identityStorage.saveIdentity(paul);
        this.identityStorage.saveIdentity(hacker);
        this.identityStorage.saveIdentity(this.hearBreaker);
        this.identityStorage.saveIdentity(this.newInvitedUser);
        this.identityStorage.saveIdentity(this.newPendingUser);
        this.identityStorage.saveIdentity(userNew1);
        this.identityStorage.saveIdentity(userNew);
        this.identityStorage.saveIdentity(userNewDot);
        this.identityStorage.saveIdentity(manager);
        this.identityStorage.saveIdentity(member1);
        this.identityStorage.saveIdentity(member2);
        this.identityStorage.saveIdentity(member3);
        this.begin();
    }

    public void testGetAllSpacesWithListAccess() throws Exception {
        int count = 5;
        for (int i = 0; i < count; ++i) {
            this.getSpaceInstance(i);
        }
        ListAccess allSpaces = this.spaceService.getAllSpacesWithListAccess();
        SpaceServiceTest.assertNotNull((String)"allSpaces must not be null", (Object)allSpaces);
        SpaceServiceTest.assertEquals((String)("allSpaces.getSize() must return: " + count), (int)count, (int)allSpaces.getSize());
        SpaceServiceTest.assertEquals((String)"allSpaces.load(0, 1).length must return: 1", (int)1, (int)((Space[])allSpaces.load(0, 1)).length);
        SpaceServiceTest.assertEquals((String)("allSpaces.load(0, count).length must return: " + count), (int)count, (int)((Space[])allSpaces.load(0, count)).length);
    }

    public void testGetVisibleSpacesWithSpaceTemplateAdmin() throws Exception {
        SpaceTemplate spaceTemplate = this.mockSpaceTemplate();
        int count = 5;
        Space firstSpace = null;
        for (int i = 0; i < count; ++i) {
            Space space = this.getSpaceInstance(i);
            if (i == 0) {
                firstSpace = space;
                this.spaceService.removeMember(space, TOM_NAME);
                spaceTemplate.setAdminPermissions(Collections.singletonList(space.getGroupId()));
                continue;
            }
            if (i % 2 != 0) continue;
            space.setVisibility("hidden");
            space.setTemplateId(spaceTemplate.getId());
            space = this.spaceService.updateSpace(space);
            this.spaceService.removeMember(space, DEMO_NAME);
            this.spaceService.removeMember(space, TOM_NAME);
        }
        ListAccess allSpaces = this.spaceService.getVisibleSpacesWithListAccess(DEMO_NAME, new SpaceFilter());
        SpaceServiceTest.assertEquals((int)count, (int)allSpaces.getSize());
        allSpaces = this.spaceService.getVisibleSpacesWithListAccess(TOM_NAME, new SpaceFilter());
        SpaceServiceTest.assertEquals((int)3, (int)allSpaces.getSize());
        firstSpace.setVisibility("hidden");
        this.spaceService.updateSpace(firstSpace);
        allSpaces = this.spaceService.getVisibleSpacesWithListAccess(DEMO_NAME, new SpaceFilter());
        SpaceServiceTest.assertEquals((int)count, (int)allSpaces.getSize());
        allSpaces = this.spaceService.getVisibleSpacesWithListAccess(null, new SpaceFilter());
        SpaceServiceTest.assertEquals((int)2, (int)allSpaces.getSize());
    }

    public void testGetMemberSpacesWithSpaceTemplateAdmin() throws Exception {
        SpaceTemplate spaceTemplate = this.mockSpaceTemplate();
        int count = 5;
        Space firstSpace = null;
        for (int i = 0; i < count; ++i) {
            Space space = this.getSpaceInstance(i);
            if (i == 0) {
                firstSpace = space;
                this.spaceService.removeMember(space, TOM_NAME);
                spaceTemplate.setAdminPermissions(Collections.singletonList(space.getGroupId()));
                continue;
            }
            if (i % 2 != 0) continue;
            space.setVisibility("hidden");
            space.setTemplateId(spaceTemplate.getId());
            space = this.spaceService.updateSpace(space);
            this.spaceService.removeMember(space, DEMO_NAME);
            this.spaceService.removeMember(space, TOM_NAME);
        }
        ListAccess allSpaces = this.spaceService.getMemberSpacesByFilter(DEMO_NAME, new SpaceFilter());
        SpaceServiceTest.assertEquals((int)3, (int)allSpaces.getSize());
        allSpaces = this.spaceService.getMemberSpacesByFilter(TOM_NAME, new SpaceFilter());
        SpaceServiceTest.assertEquals((int)2, (int)allSpaces.getSize());
        firstSpace.setVisibility("hidden");
        this.spaceService.updateSpace(firstSpace);
        allSpaces = this.spaceService.getMemberSpacesByFilter(DEMO_NAME, new SpaceFilter());
        SpaceServiceTest.assertEquals((int)3, (int)allSpaces.getSize());
        allSpaces = this.spaceService.getMemberSpacesByFilter(null, new SpaceFilter());
        SpaceServiceTest.assertEquals((int)0, (int)allSpaces.getSize());
    }

    public void testGetAccessibleSpacesWithSpaceTemplateAdmin() throws Exception {
        SpaceTemplate spaceTemplate = this.mockSpaceTemplate();
        int count = 5;
        Space firstSpace = null;
        for (int i = 0; i < count; ++i) {
            Space space = this.getSpaceInstance(i);
            if (i == 0) {
                firstSpace = space;
                this.spaceService.removeMember(space, TOM_NAME);
                spaceTemplate.setAdminPermissions(Collections.singletonList(space.getGroupId()));
                continue;
            }
            if (i % 2 != 0) continue;
            space.setVisibility("hidden");
            space.setTemplateId(spaceTemplate.getId());
            space = this.spaceService.updateSpace(space);
            this.spaceService.removeMember(space, DEMO_NAME);
            this.spaceService.removeMember(space, TOM_NAME);
        }
        ListAccess allSpaces = this.spaceService.getAccessibleSpacesByFilter(DEMO_NAME, new SpaceFilter());
        SpaceServiceTest.assertEquals((int)count, (int)allSpaces.getSize());
        allSpaces = this.spaceService.getAccessibleSpacesByFilter(TOM_NAME, new SpaceFilter());
        SpaceServiceTest.assertEquals((int)2, (int)allSpaces.getSize());
        firstSpace.setVisibility("hidden");
        this.spaceService.updateSpace(firstSpace);
        allSpaces = this.spaceService.getAccessibleSpacesByFilter(DEMO_NAME, new SpaceFilter());
        SpaceServiceTest.assertEquals((int)count, (int)allSpaces.getSize());
        allSpaces = this.spaceService.getAccessibleSpacesByFilter(null, new SpaceFilter());
        SpaceServiceTest.assertEquals((int)0, (int)allSpaces.getSize());
    }

    public void testGetManagerSpacesWithSpaceTemplateAdmin() throws Exception {
        SpaceTemplate spaceTemplate = this.mockSpaceTemplate();
        int count = 5;
        Space firstSpace = null;
        for (int i = 0; i < count; ++i) {
            Space space = this.getSpaceInstance(i);
            if (i == 0) {
                firstSpace = space;
                this.spaceService.removeMember(space, TOM_NAME);
                spaceTemplate.setAdminPermissions(Collections.singletonList(space.getGroupId()));
                continue;
            }
            if (i % 2 == 0) {
                space.setVisibility("hidden");
                space.setTemplateId(spaceTemplate.getId());
                space = this.spaceService.updateSpace(space);
                this.spaceService.removeMember(space, DEMO_NAME);
                this.spaceService.removeMember(space, TOM_NAME);
                continue;
            }
            this.spaceService.setManager(space, TOM_NAME, false);
        }
        ListAccess allSpaces = this.spaceService.getManagerSpacesByFilter(DEMO_NAME, new SpaceFilter());
        SpaceServiceTest.assertEquals((int)3, (int)allSpaces.getSize());
        allSpaces = this.spaceService.getManagerSpacesByFilter(TOM_NAME, new SpaceFilter());
        SpaceServiceTest.assertEquals((int)0, (int)allSpaces.getSize());
        firstSpace.setVisibility("hidden");
        this.spaceService.updateSpace(firstSpace);
        allSpaces = this.spaceService.getManagerSpacesByFilter(DEMO_NAME, new SpaceFilter());
        SpaceServiceTest.assertEquals((int)3, (int)allSpaces.getSize());
        allSpaces = this.spaceService.getManagerSpacesByFilter(null, new SpaceFilter());
        SpaceServiceTest.assertEquals((int)0, (int)allSpaces.getSize());
    }

    public void testGetVisibleSpacesWithNoSpaceTemplateAsAdmin() throws Exception {
        SpaceTemplate spaceTemplate = this.mockSpaceTemplate();
        int count = 5;
        Space firstSpace = null;
        for (int i = 0; i < count; ++i) {
            Space space = this.getSpaceInstance(i);
            if (i == 0) {
                firstSpace = space;
                this.spaceService.removeMember(space, TOM_NAME);
                spaceTemplate.setAdminPermissions(Collections.singletonList(space.getGroupId()));
                continue;
            }
            if (i % 2 != 0) continue;
            space.setVisibility("hidden");
            space.setTemplateId(spaceTemplate.getId());
            space = this.spaceService.updateSpace(space);
            this.spaceService.removeMember(space, DEMO_NAME);
            this.spaceService.removeMember(space, TOM_NAME);
        }
        ListAccess allSpaces = this.spaceService.getVisibleSpacesWithListAccess(ROOT_NAME, new SpaceFilter());
        SpaceServiceTest.assertEquals((int)count, (int)allSpaces.getSize());
        SpaceServiceTest.assertNotNull((Object)firstSpace);
        firstSpace.setTemplateId(0L);
        firstSpace.setVisibility("hidden");
        this.spaceService.updateSpace(firstSpace);
        allSpaces = this.spaceService.getVisibleSpacesWithListAccess(ROOT_NAME, new SpaceFilter());
        SpaceServiceTest.assertEquals((int)count, (int)allSpaces.getSize());
    }

    public void testGetEditableSpacesWithSpaceTemplateAdmin() throws Exception {
        SpaceTemplate spaceTemplate = this.mockSpaceTemplate();
        int count = 5;
        Space firstSpace = null;
        for (int i = 0; i < count; ++i) {
            Space space = this.getSpaceInstance(i);
            if (i == 0) {
                firstSpace = space;
                this.spaceService.removeMember(space, TOM_NAME);
                spaceTemplate.setAdminPermissions(Collections.singletonList(space.getGroupId()));
                continue;
            }
            if (i % 2 == 0) {
                space.setVisibility("hidden");
                space.setTemplateId(spaceTemplate.getId());
                space = this.spaceService.updateSpace(space);
                this.spaceService.removeMember(space, DEMO_NAME);
                this.spaceService.removeMember(space, TOM_NAME);
                continue;
            }
            this.spaceService.setManager(space, TOM_NAME, false);
        }
        ListAccess allSpaces = this.spaceService.getEditableSpacesByFilter(DEMO_NAME, new SpaceFilter());
        SpaceServiceTest.assertEquals((int)count, (int)allSpaces.getSize());
        allSpaces = this.spaceService.getEditableSpacesByFilter(TOM_NAME, new SpaceFilter());
        SpaceServiceTest.assertEquals((int)0, (int)allSpaces.getSize());
        firstSpace.setVisibility("hidden");
        this.spaceService.updateSpace(firstSpace);
        allSpaces = this.spaceService.getEditableSpacesByFilter(DEMO_NAME, new SpaceFilter());
        SpaceServiceTest.assertEquals((int)count, (int)allSpaces.getSize());
        allSpaces = this.spaceService.getEditableSpacesByFilter(null, new SpaceFilter());
        SpaceServiceTest.assertEquals((int)0, (int)allSpaces.getSize());
    }

    public void testGetVisibleSpacesByRegistration() throws Exception {
        int count = 5;
        for (int i = 0; i < count; ++i) {
            Space space = this.getSpaceInstance(i);
            if (i == 0) {
                space.setRegistration("open");
                this.spaceService.updateSpace(space);
                continue;
            }
            if (i % 2 == 0) {
                space.setRegistration("validation");
                this.spaceService.updateSpace(space);
                continue;
            }
            space.setRegistration("closed");
            this.spaceService.updateSpace(space);
        }
        SpaceFilter spaceFilter = new SpaceFilter();
        spaceFilter.setRegistration(SpaceRegistration.CLOSED);
        ListAccess allSpaces = this.spaceService.getVisibleSpacesWithListAccess(DEMO_NAME, spaceFilter);
        SpaceServiceTest.assertEquals((int)2, (int)allSpaces.getSize());
        spaceFilter.setRegistration(SpaceRegistration.VALIDATION);
        allSpaces = this.spaceService.getVisibleSpacesWithListAccess(TOM_NAME, spaceFilter);
        SpaceServiceTest.assertEquals((int)2, (int)allSpaces.getSize());
        spaceFilter.setRegistration(SpaceRegistration.OPEN);
        allSpaces = this.spaceService.getVisibleSpacesWithListAccess(TOM_NAME, spaceFilter);
        SpaceServiceTest.assertEquals((int)1, (int)allSpaces.getSize());
    }

    public void testGetVisibleSpacesByVisibility() throws Exception {
        int count = 5;
        for (int i = 0; i < count; ++i) {
            Space space = this.getSpaceInstance(i);
            if (i % 2 == 0) {
                space.setVisibility("private");
                this.spaceService.updateSpace(space);
                continue;
            }
            space.setVisibility("hidden");
            this.spaceService.updateSpace(space);
        }
        SpaceFilter spaceFilter = new SpaceFilter();
        spaceFilter.setVisibility(SpaceVisibility.HIDDEN);
        ListAccess allSpaces = this.spaceService.getVisibleSpacesWithListAccess(DEMO_NAME, spaceFilter);
        SpaceServiceTest.assertEquals((int)2, (int)allSpaces.getSize());
        spaceFilter.setVisibility(SpaceVisibility.PRIVATE);
        allSpaces = this.spaceService.getVisibleSpacesWithListAccess(TOM_NAME, spaceFilter);
        SpaceServiceTest.assertEquals((int)3, (int)allSpaces.getSize());
    }

    public void testGetSpaceMembershipDate() {
        Space space = this.populateData();
        SpaceServiceTest.assertNotNull((Object)this.spaceService.getSpaceMembershipDate(Long.parseLong(space.getId()), ROOT_NAME));
        SpaceServiceTest.assertNotNull((Object)this.spaceService.getSpaceMembershipDate(Long.parseLong(space.getId()), JOHN_NAME));
        SpaceServiceTest.assertNull((Object)this.spaceService.getSpaceMembershipDate(Long.parseLong(space.getId()), "notExistingUser"));
    }

    public void testGetSpaceByPrettyName() {
        int count = 5;
        for (int i = 0; i < count; ++i) {
            this.getSpaceInstance(i);
        }
        Space foundSpace = this.spaceService.getSpaceByPrettyName("my_space_4");
        SpaceServiceTest.assertNotNull((String)"foundSpace must not be null", (Object)foundSpace);
        SpaceServiceTest.assertEquals((String)"foundSpace.getDisplayName() must return: my space 4", (String)"my space 4", (String)foundSpace.getDisplayName());
        SpaceServiceTest.assertEquals((String)"foundSpace.getPrettyName() must return: my_space_4", (String)"my_space_4", (String)foundSpace.getPrettyName());
        foundSpace = this.spaceService.getSpaceByPrettyName(MY_SPACE_0_PRETTY_NAME);
        SpaceServiceTest.assertNotNull((String)"foundSpace must not be null", (Object)foundSpace);
        SpaceServiceTest.assertEquals((String)"foundSpace.getDisplayName() must return: my space 0", (String)"my space 0", (String)foundSpace.getDisplayName());
        SpaceServiceTest.assertEquals((String)"foundSpace.getPrettyName() must return: my_space_0", (String)MY_SPACE_0_PRETTY_NAME, (String)foundSpace.getPrettyName());
        foundSpace = this.spaceService.getSpaceByPrettyName("my_space_5");
        SpaceServiceTest.assertNull((String)"foundSpace must be null", (Object)foundSpace);
    }

    public void testDefaultSpaceAvatar() {
        this.getSpaceInstance(0);
        Space space = this.spaceService.getSpaceByPrettyName(MY_SPACE_0_PRETTY_NAME);
        SpaceServiceTest.assertNotNull((String)"space must not be null", (Object)space);
        org.exoplatform.social.core.identity.model.Identity identity = new org.exoplatform.social.core.identity.model.Identity("space", space.getPrettyName());
        this.identityStorage.saveIdentity(identity);
        Profile profile = new Profile(identity);
        profile.setProperty("fullName", (Object)space.getDisplayName());
        this.identityStorage.saveProfile(profile);
        identity.setProfile(profile);
        String identityId = identity.getId();
        SpaceServiceTest.assertNotNull((Object)identityId);
        FileItem avatarFile = this.identityStorage.getAvatarFile(identity);
        SpaceServiceTest.assertNotNull((Object)avatarFile);
        Long avatarFileId = avatarFile.getFileInfo().getId();
        SpaceServiceTest.assertNotNull((Object)avatarFileId);
        SpaceServiceTest.assertEquals((String)"DEFAULT_AVATAR", (String)avatarFile.getFileInfo().getName());
        profile = this.identityStorage.loadProfile(profile);
        SpaceServiceTest.assertTrue((boolean)profile.isDefaultAvatar());
    }

    public void testGetSpacesWithExcludedIds() throws Exception {
        SpaceFilter spaceFilter = new SpaceFilter();
        ArrayList<Long> excludedIds = new ArrayList<Long>();
        for (int i = 0; i < 6; ++i) {
            Space space = this.getSpaceInstance(i);
            if (i % 2 != 0) continue;
            excludedIds.add(Long.parseLong(space.getId()));
        }
        ListAccess spaces = this.spaceService.getAllSpacesByFilter(spaceFilter);
        int size = spaces.getSize();
        spaceFilter.setExcludedIds(excludedIds);
        spaces = this.spaceService.getAllSpacesByFilter(spaceFilter);
        SpaceServiceTest.assertEquals((int)(size - 3), (int)spaces.getSize());
    }

    public void testUpdateSpaceAvatar() throws IOException {
        this.getSpaceInstance(0);
        Space space = this.spaceService.getSpaceByPrettyName(MY_SPACE_0_PRETTY_NAME);
        SpaceServiceTest.assertNotNull((String)"space must not be null", (Object)space);
        org.exoplatform.social.core.identity.model.Identity identity = new org.exoplatform.social.core.identity.model.Identity("space", space.getPrettyName());
        this.identityStorage.saveIdentity(identity);
        FileItem avatarFile = this.identityStorage.getAvatarFile(identity);
        SpaceServiceTest.assertNotNull((Object)avatarFile);
        SpaceServiceTest.assertEquals((String)"DEFAULT_AVATAR", (String)avatarFile.getFileInfo().getName());
        Profile profile = new Profile(identity);
        identity.setProfile(profile);
        profile = this.identityStorage.loadProfile(profile);
        SpaceServiceTest.assertTrue((boolean)profile.isDefaultAvatar());
        InputStream inputStream = ((Object)((Object)this)).getClass().getResourceAsStream("/eXo-Social.png");
        AvatarAttachment avatarAttachment = new AvatarAttachment(null, "space-avatar", "png", inputStream, System.currentTimeMillis());
        space.setAvatarAttachment(avatarAttachment);
        this.spaceService.updateSpaceAvatar(space, space.getManagers()[0]);
        profile = new Profile(identity);
        profile.setProperty("avatar", (Object)space.getAvatarAttachment());
        this.identityStorage.saveProfile(profile);
        FileItem newAvatarFile = this.identityStorage.getAvatarFile(identity);
        SpaceServiceTest.assertNotNull((Object)avatarFile);
        Assert.assertNotEquals((Object)"DEFAULT_AVATAR", (Object)newAvatarFile.getFileInfo().getName());
        profile = this.identityStorage.loadProfile(profile);
        SpaceServiceTest.assertFalse((boolean)profile.isDefaultAvatar());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRenameSpaceWithDefaultAvatar() throws SpaceException {
        Space space = this.getSpaceInstance(0);
        SpaceServiceTest.assertNotNull((Object)space);
        org.exoplatform.social.core.identity.model.Identity identity = new org.exoplatform.social.core.identity.model.Identity("space", space.getPrettyName());
        SpaceServiceTest.assertNotNull((Object)identity);
        this.identityStorage.saveIdentity(identity);
        String newDisplayName = "new display name";
        SpaceListenerPluginMock spaceListenerPlugin = new SpaceListenerPluginMock();
        this.spaceService.registerSpaceListenerPlugin((SpaceListenerPlugin)spaceListenerPlugin);
        try {
            this.spaceService.renameSpace(space, newDisplayName, this.root.getRemoteId());
        }
        finally {
            this.spaceService.unregisterSpaceListenerPlugin((SpaceListenerPlugin)spaceListenerPlugin);
        }
        Space got = this.spaceService.getSpaceById(space.getId());
        SpaceServiceTest.assertEquals((String)newDisplayName, (String)got.getDisplayName());
        SpaceServiceTest.assertEquals((Object)SpaceLifeCycleEvent.Type.SPACE_RENAMED, (Object)spaceListenerPlugin.getEvents().get(0));
    }

    public void testGetBookmarkedSpace() throws Exception {
        Space space1 = this.createSpace(SPACE1_DISPLAY_NAME, this.john.getRemoteId());
        this.createSpace(SPACE2_DISPLAY_NAME, this.john.getRemoteId());
        Space space3 = this.createSpace("Space3", this.john.getRemoteId());
        this.createSpace("Space4", this.john.getRemoteId());
        FavoriteService favoriteService = (FavoriteService)ExoContainerContext.getService(FavoriteService.class);
        Favorite space1Favorite = new Favorite("space", space1.getId(), null, Long.parseLong(this.john.getId()));
        favoriteService.createFavorite(space1Favorite);
        Favorite space2Favorite = new Favorite("space", space3.getId(), null, Long.parseLong(this.john.getId()));
        favoriteService.createFavorite(space2Favorite);
        SpaceFilter spaceFilter = new SpaceFilter();
        SpaceServiceTest.assertEquals((int)4, (int)this.spaceService.getAccessibleSpacesByFilter(this.john.getRemoteId(), spaceFilter).getSize());
        spaceFilter.setRemoteId(this.john.getRemoteId());
        ListAccess listAccess = this.spaceService.getAllSpacesByFilter(spaceFilter);
        SpaceServiceTest.assertEquals((int)4, (int)listAccess.getSize());
        Space[] spacesList = (Space[])listAccess.load(0, 10);
        SpaceServiceTest.assertEquals((int)4, (int)spacesList.length);
        SpaceServiceTest.assertEquals((int)4, (int)this.spaceService.getAccessibleSpacesByFilter(this.john.getRemoteId(), spaceFilter).getSize());
        spaceFilter.setFavorite(true);
        listAccess = this.spaceService.getAllSpacesByFilter(spaceFilter);
        SpaceServiceTest.assertEquals((int)2, (int)listAccess.getSize());
        spacesList = (Space[])listAccess.load(0, 10);
        SpaceServiceTest.assertEquals((int)2, (int)spacesList.length);
        SpaceServiceTest.assertEquals((int)2, (int)this.spaceService.getAccessibleSpacesByFilter(this.john.getRemoteId(), spaceFilter).getSize());
        favoriteService.deleteFavorite(space1Favorite);
        listAccess = this.spaceService.getAllSpacesByFilter(spaceFilter);
        SpaceServiceTest.assertEquals((int)1, (int)listAccess.getSize());
        spacesList = (Space[])listAccess.load(0, 10);
        SpaceServiceTest.assertEquals((int)1, (int)spacesList.length);
        SpaceServiceTest.assertEquals((int)1, (int)this.spaceService.getAccessibleSpacesByFilter(this.john.getRemoteId(), spaceFilter).getSize());
        favoriteService.deleteFavorite(space2Favorite);
        listAccess = this.spaceService.getAllSpacesByFilter(spaceFilter);
        SpaceServiceTest.assertEquals((int)0, (int)listAccess.getSize());
        spacesList = (Space[])listAccess.load(0, 10);
        SpaceServiceTest.assertEquals((int)0, (int)spacesList.length);
        SpaceServiceTest.assertEquals((int)0, (int)this.spaceService.getAccessibleSpacesByFilter(this.john.getRemoteId(), spaceFilter).getSize());
    }

    public void testGetFavoriteSpacesByFilter() throws Exception {
        Space space1 = this.createSpace(SPACE1_DISPLAY_NAME, this.john.getRemoteId());
        this.createSpace(SPACE2_DISPLAY_NAME, this.john.getRemoteId());
        Space space3 = this.createSpace("Space3", this.john.getRemoteId());
        this.createSpace("Space4", this.john.getRemoteId());
        FavoriteService favoriteService = (FavoriteService)ExoContainerContext.getService(FavoriteService.class);
        Favorite space1Favorite = new Favorite("space", space1.getId(), null, Long.parseLong(this.john.getId()));
        favoriteService.createFavorite(space1Favorite);
        Favorite space3Favorite = new Favorite("space", space3.getId(), null, Long.parseLong(this.john.getId()));
        favoriteService.createFavorite(space3Favorite);
        favoriteService.createFavorite(new Favorite("space", space3.getId(), null, Long.parseLong(this.root.getId())));
        SpaceFilter spaceFilter = new SpaceFilter();
        SpaceServiceTest.assertEquals((int)4, (int)this.spaceService.getAccessibleSpacesByFilter(this.john.getRemoteId(), spaceFilter).getSize());
        SpaceServiceTest.assertEquals((int)2, (int)this.spaceService.getFavoriteSpacesByFilter(this.john.getRemoteId(), spaceFilter).getSize());
        SpaceServiceTest.assertEquals((int)1, (int)this.spaceService.getFavoriteSpacesByFilter(this.root.getRemoteId(), spaceFilter).getSize());
        SpaceServiceTest.assertEquals((int)0, (int)this.spaceService.getFavoriteSpacesByFilter(this.mary.getRemoteId(), spaceFilter).getSize());
        ListAccess listAccess = this.spaceService.getFavoriteSpacesByFilter(this.john.getRemoteId(), spaceFilter);
        Space[] spacesList = (Space[])listAccess.load(0, 10);
        SpaceServiceTest.assertEquals((int)2, (int)spacesList.length);
        favoriteService.deleteFavorite(space1Favorite);
        listAccess = this.spaceService.getFavoriteSpacesByFilter(this.john.getRemoteId(), spaceFilter);
        SpaceServiceTest.assertEquals((int)1, (int)listAccess.getSize());
        spacesList = (Space[])listAccess.load(0, 10);
        SpaceServiceTest.assertEquals((int)1, (int)spacesList.length);
        this.spaceService.deleteSpace(space3);
        listAccess = this.spaceService.getFavoriteSpacesByFilter(this.john.getRemoteId(), spaceFilter);
        SpaceServiceTest.assertEquals((int)0, (int)listAccess.getSize());
        spacesList = (Space[])listAccess.load(0, 10);
        SpaceServiceTest.assertEquals((int)0, (int)spacesList.length);
    }

    public void testGetSpaceById() {
        Space space = this.populateData();
        this.createMoreSpace(SPACE2_DISPLAY_NAME);
        SpaceServiceTest.assertEquals((String)space.getDisplayName(), (String)this.spaceService.getSpaceById(space.getId()).getDisplayName());
    }

    public void testCanRedact() {
        Identity rootACLIdentity = new Identity(ROOT_NAME);
        Identity johnACLIdentity = new Identity(JOHN_NAME, Collections.singleton(new MembershipEntry(PLATFORM_ADMINISTRATORS, "*")));
        Identity demoACLIdentity = new Identity(DEMO_NAME);
        Identity jamesACLIdentity = new Identity(JAMES_NAME);
        Identity maryACLIdentity = new Identity(MARY_NAME);
        Identity raulACLIdentity = new Identity(RAUL_NAME);
        ConversationState.setCurrent((ConversationState)new ConversationState(demoACLIdentity));
        Space space = this.createSpace("spaceTestRedact", DEMO_NAME);
        Arrays.stream(new String[]{DEMO_NAME, JAMES_NAME, RAUL_NAME}).forEach(u -> this.spaceService.addMember(space, u));
        if (ArrayUtils.isNotEmpty((Object[])space.getRedactors())) {
            Arrays.stream(space.getRedactors()).forEach(u -> this.spaceService.removeRedactor(space, u));
        }
        SpaceServiceTest.assertTrue((boolean)this.spaceService.canRedactOnSpace(space, rootACLIdentity));
        SpaceServiceTest.assertTrue((boolean)this.spaceService.canRedactOnSpace(space, johnACLIdentity));
        SpaceServiceTest.assertTrue((boolean)this.spaceService.canRedactOnSpace(space, demoACLIdentity));
        SpaceServiceTest.assertTrue((boolean)this.spaceService.canRedactOnSpace(space, jamesACLIdentity));
        SpaceServiceTest.assertTrue((boolean)this.spaceService.canRedactOnSpace(space, raulACLIdentity));
        SpaceServiceTest.assertFalse((boolean)this.spaceService.canRedactOnSpace(space, maryACLIdentity));
        this.spaceService.addMember(space, MARY_NAME);
        this.spaceService.addRedactor(space, JAMES_NAME);
        this.spaceService.addPublisher(space, MARY_NAME);
        SpaceServiceTest.assertTrue((boolean)this.spaceService.canRedactOnSpace(space, rootACLIdentity));
        SpaceServiceTest.assertTrue((boolean)this.spaceService.canRedactOnSpace(space, johnACLIdentity));
        SpaceServiceTest.assertTrue((boolean)this.spaceService.canRedactOnSpace(space, demoACLIdentity));
        SpaceServiceTest.assertTrue((boolean)this.spaceService.canRedactOnSpace(space, jamesACLIdentity));
        SpaceServiceTest.assertFalse((boolean)this.spaceService.canRedactOnSpace(space, maryACLIdentity));
        SpaceServiceTest.assertFalse((boolean)this.spaceService.canRedactOnSpace(space, raulACLIdentity));
    }

    public void testCanView() {
        Identity rootACLIdentity = new Identity(ROOT_NAME);
        Identity johnACLIdentity = new Identity(JOHN_NAME, Collections.singleton(new MembershipEntry(PLATFORM_ADMINISTRATORS, "*")));
        Identity demoACLIdentity = new Identity(DEMO_NAME);
        Identity jamesACLIdentity = new Identity(JAMES_NAME);
        Identity maryACLIdentity = new Identity(MARY_NAME);
        ConversationState.setCurrent((ConversationState)new ConversationState(demoACLIdentity));
        Space space = this.createSpace("spaceTestView", DEMO_NAME);
        space.setMembers(new String[]{DEMO_NAME, JAMES_NAME});
        this.spaceService.updateSpace(space);
        SpaceServiceTest.assertTrue((boolean)this.spaceService.canViewSpace(space, rootACLIdentity.getUserId()));
        SpaceServiceTest.assertTrue((boolean)this.spaceService.canViewSpace(space, johnACLIdentity.getUserId()));
        SpaceServiceTest.assertTrue((boolean)this.spaceService.canViewSpace(space, jamesACLIdentity.getUserId()));
        SpaceServiceTest.assertFalse((boolean)this.spaceService.canViewSpace(space, maryACLIdentity.getUserId()));
    }

    public void testCanManage() {
        Identity rootACLIdentity = new Identity(ROOT_NAME);
        Identity johnACLIdentity = new Identity(JOHN_NAME, Collections.singleton(new MembershipEntry(PLATFORM_ADMINISTRATORS, "*")));
        Identity demoACLIdentity = new Identity(DEMO_NAME);
        Identity jamesACLIdentity = new Identity(JAMES_NAME);
        Identity maryACLIdentity = new Identity(MARY_NAME);
        Identity raulACLIdentity = new Identity(RAUL_NAME);
        Identity paulACLIdentity = new Identity(PAUL_NAME);
        ConversationState.setCurrent((ConversationState)new ConversationState(demoACLIdentity));
        Space space = this.createSpace("spaceTestManage", DEMO_NAME);
        space.setMembers(new String[]{DEMO_NAME, JAMES_NAME, MARY_NAME, RAUL_NAME});
        space.setManagers(new String[]{MARY_NAME});
        space.setPublishers(new String[]{RAUL_NAME});
        space.setRedactors(new String[]{JAMES_NAME});
        this.spaceService.updateSpace(space);
        SpaceServiceTest.assertTrue((boolean)this.spaceService.canManageSpace(space, rootACLIdentity.getUserId()));
        SpaceServiceTest.assertTrue((boolean)this.spaceService.canManageSpace(space, johnACLIdentity.getUserId()));
        SpaceServiceTest.assertTrue((boolean)this.spaceService.canManageSpace(space, maryACLIdentity.getUserId()));
        SpaceServiceTest.assertFalse((boolean)this.spaceService.canManageSpace(space, raulACLIdentity.getUserId()));
        SpaceServiceTest.assertFalse((boolean)this.spaceService.canManageSpace(space, jamesACLIdentity.getUserId()));
        SpaceServiceTest.assertFalse((boolean)this.spaceService.canManageSpace(space, demoACLIdentity.getUserId()));
        SpaceServiceTest.assertFalse((boolean)this.spaceService.canManageSpace(space, paulACLIdentity.getUserId()));
    }

    public void testCanPublish() {
        Identity rootACLIdentity = new Identity(ROOT_NAME);
        Identity johnACLIdentity = new Identity(JOHN_NAME, Collections.singleton(new MembershipEntry(PLATFORM_ADMINISTRATORS, "*")));
        Identity demoACLIdentity = new Identity(DEMO_NAME);
        Identity jamesACLIdentity = new Identity(JAMES_NAME);
        Identity maryACLIdentity = new Identity(MARY_NAME);
        Identity raulACLIdentity = new Identity(RAUL_NAME);
        Identity paulACLIdentity = new Identity(PAUL_NAME);
        ConversationState.setCurrent((ConversationState)new ConversationState(demoACLIdentity));
        Space space = this.createSpace("spaceTestPublish", DEMO_NAME);
        space.setMembers(new String[]{DEMO_NAME, JAMES_NAME, MARY_NAME, RAUL_NAME});
        space.setManagers(new String[]{MARY_NAME});
        space.setPublishers(new String[]{RAUL_NAME});
        space.setRedactors(new String[]{JAMES_NAME});
        this.spaceService.updateSpace(space);
        SpaceServiceTest.assertTrue((boolean)this.spaceService.canPublishOnSpace(space, rootACLIdentity.getUserId()));
        SpaceServiceTest.assertTrue((boolean)this.spaceService.canPublishOnSpace(space, johnACLIdentity.getUserId()));
        SpaceServiceTest.assertTrue((boolean)this.spaceService.canPublishOnSpace(space, maryACLIdentity.getUserId()));
        SpaceServiceTest.assertTrue((boolean)this.spaceService.canPublishOnSpace(space, raulACLIdentity.getUserId()));
        SpaceServiceTest.assertFalse((boolean)this.spaceService.canPublishOnSpace(space, jamesACLIdentity.getUserId()));
        SpaceServiceTest.assertFalse((boolean)this.spaceService.canPublishOnSpace(space, demoACLIdentity.getUserId()));
        SpaceServiceTest.assertFalse((boolean)this.spaceService.canPublishOnSpace(space, paulACLIdentity.getUserId()));
    }

    public void testGetInvitedSpacesWithListAccess() throws Exception {
        int count = 5;
        for (int i = 0; i < count; ++i) {
            this.getSpaceInstance(i);
        }
        ListAccess invitedSpaces = this.spaceService.getInvitedSpacesWithListAccess(REGISTER1_NAME);
        SpaceServiceTest.assertNotNull((Object)invitedSpaces);
        SpaceServiceTest.assertEquals((int)count, (int)invitedSpaces.getSize());
        SpaceServiceTest.assertEquals((int)1, (int)((Space[])invitedSpaces.load(0, 1)).length);
        SpaceServiceTest.assertEquals((int)count, (int)((Space[])invitedSpaces.load(0, count)).length);
        invitedSpaces = this.spaceService.getInvitedSpacesWithListAccess(MARY_NAME);
        SpaceServiceTest.assertNotNull((Object)invitedSpaces);
        SpaceServiceTest.assertEquals((int)count, (int)invitedSpaces.getSize());
        invitedSpaces = this.spaceService.getInvitedSpacesWithListAccess(DEMO_NAME);
        SpaceServiceTest.assertNotNull((Object)invitedSpaces);
        SpaceServiceTest.assertEquals((int)0, (int)invitedSpaces.getSize());
    }

    public void testCountPendingSpaceRequestsToManage() throws Exception {
        Space space = this.populateData();
        this.spaceService.addPendingUser(space, PAUL_NAME);
        this.spaceService.addPendingUser(space, JAMES_NAME);
        ListAccess listAccess = this.spaceService.getPendingSpaceRequestsToManage(ROOT_NAME);
        SpaceServiceTest.assertNotNull((Object)listAccess);
        SpaceServiceTest.assertEquals((int)2, (int)listAccess.getSize());
        SpaceServiceTest.assertEquals((int)2, (int)((Space[])listAccess.load(0, 10)).length);
        Space[] pendingSpaceRequestsToManage = (Space[])listAccess.load(0, 1);
        SpaceServiceTest.assertEquals((int)1, (int)pendingSpaceRequestsToManage.length);
        Space spaceToManage = pendingSpaceRequestsToManage[0];
        String[] pendingUsers = spaceToManage.getPendingUsers();
        SpaceServiceTest.assertEquals((int)1, (int)pendingUsers.length);
        pendingSpaceRequestsToManage = (Space[])listAccess.load(0, 10);
        SpaceServiceTest.assertEquals((int)2, (int)pendingSpaceRequestsToManage.length);
        boolean hasPaul = pendingSpaceRequestsToManage[0].getPendingUsers()[0].equals(PAUL_NAME) || pendingSpaceRequestsToManage[1].getPendingUsers()[0].equals(PAUL_NAME);
        boolean hasJames = pendingSpaceRequestsToManage[0].getPendingUsers()[0].equals(JAMES_NAME) || pendingSpaceRequestsToManage[1].getPendingUsers()[0].equals(JAMES_NAME);
        SpaceServiceTest.assertTrue((hasJames && hasPaul ? 1 : 0) != 0);
    }

    public void testGetPendingSpacesWithListAccess() throws Exception {
        int count = 5;
        for (int i = 0; i < count; ++i) {
            this.getSpaceInstance(i);
        }
        ListAccess foundSpaces = this.spaceService.getPendingSpacesWithListAccess(JAME_NAME);
        SpaceServiceTest.assertNotNull((Object)foundSpaces);
        SpaceServiceTest.assertEquals((int)count, (int)foundSpaces.getSize());
        SpaceServiceTest.assertEquals((int)1, (int)((Space[])foundSpaces.load(0, 1)).length);
        SpaceServiceTest.assertEquals((int)count, (int)((Space[])foundSpaces.load(0, count)).length);
        foundSpaces = this.spaceService.getPendingSpacesWithListAccess(PAUL_NAME);
        SpaceServiceTest.assertNotNull((Object)foundSpaces);
        SpaceServiceTest.assertEquals((int)count, (int)foundSpaces.getSize());
        foundSpaces = this.spaceService.getPendingSpacesWithListAccess(HACKER_NAME);
        SpaceServiceTest.assertNotNull((Object)foundSpaces);
        SpaceServiceTest.assertEquals((int)count, (int)foundSpaces.getSize());
        foundSpaces = this.spaceService.getPendingSpacesWithListAccess(GHOST_NAME);
        SpaceServiceTest.assertNotNull((Object)foundSpaces);
        SpaceServiceTest.assertEquals((int)0, (int)foundSpaces.getSize());
        foundSpaces = this.spaceService.getPendingSpacesWithListAccess("hellgate");
        SpaceServiceTest.assertNotNull((Object)foundSpaces);
        SpaceServiceTest.assertEquals((int)0, (int)foundSpaces.getSize());
    }

    public void testCreateSpace() throws Exception {
        this.populateData();
        this.createMoreSpace(SPACE2_DISPLAY_NAME);
        ListAccess spaceListAccess = this.spaceService.getAllSpacesWithListAccess();
        SpaceServiceTest.assertNotNull((String)"spaceListAccess must not be null", (Object)spaceListAccess);
        SpaceServiceTest.assertEquals((String)"spaceListAccess.getSize() must return: 2", (int)2, (int)spaceListAccess.getSize());
    }

    public void testCreateSpaceWithManagersAndMembers() {
        Space space = new Space();
        space.setDisplayName(TEST_SPACE_DISPLAY_NAME);
        space.setDescription(TEST_SPACE_DESCRIPTION);
        String shortName = Utils.cleanString((String)space.getDisplayName());
        space.setPrettyName(space.getDisplayName());
        space.setRegistration("validation");
        space.setUrl(shortName);
        space.setVisibility("public");
        Space createdSpace = this.spaceService.createSpace(space, ROOT_NAME);
        String[] managers = new String[]{JOHN_NAME};
        String[] members = new String[]{JOHN_NAME, MARY_NAME, PAUL_NAME, JAME_NAME};
        Arrays.stream(members).forEach(u -> this.spaceService.addMember(createdSpace, u));
        Arrays.stream(managers).forEach(u -> this.spaceService.setManager(createdSpace, u, true));
        space = this.spaceService.getSpaceById(createdSpace.getId());
        SpaceServiceTest.assertEquals((int)2, (int)space.getManagers().length);
        SpaceServiceTest.assertEquals((int)5, (int)space.getMembers().length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCreateSpaceEvent() throws SpaceException {
        String[] managers = new String[]{MANAGER_NAME};
        String creator = ROOT_NAME;
        ArrayList<org.exoplatform.social.core.identity.model.Identity> invitedIdentities = new ArrayList<org.exoplatform.social.core.identity.model.Identity>(Arrays.asList(this.tom, this.dragon, this.hearBreaker));
        Space space = new Space();
        space.setDisplayName(TEST_SPACE_DISPLAY_NAME);
        space.setDescription(TEST_SPACE_DESCRIPTION);
        String shortName = Utils.cleanString((String)space.getDisplayName());
        space.setManagers(managers);
        space.setPrettyName(space.getDisplayName());
        space.setRegistration("validation");
        space.setUrl(shortName);
        space.setVisibility("public");
        SpaceListenerPluginMock spaceListenerPlugin = new SpaceListenerPluginMock();
        this.spaceService.registerSpaceListenerPlugin((SpaceListenerPlugin)spaceListenerPlugin);
        try {
            this.spaceService.createSpace(space, creator, invitedIdentities);
        }
        finally {
            this.spaceService.unregisterSpaceListenerPlugin((SpaceListenerPlugin)spaceListenerPlugin);
        }
        SpaceServiceTest.assertEquals((int)4, (int)spaceListenerPlugin.getEvents().size());
        SpaceServiceTest.assertEquals((Object)SpaceLifeCycleEvent.Type.SPACE_CREATED, (Object)spaceListenerPlugin.getEvents().get(0));
        SpaceServiceTest.assertEquals((Object)SpaceLifeCycleEvent.Type.ADD_INVITED_USER, (Object)spaceListenerPlugin.getEvents().get(1));
        SpaceServiceTest.assertEquals((Object)SpaceLifeCycleEvent.Type.ADD_INVITED_USER, (Object)spaceListenerPlugin.getEvents().get(2));
        SpaceServiceTest.assertEquals((Object)SpaceLifeCycleEvent.Type.ADD_INVITED_USER, (Object)spaceListenerPlugin.getEvents().get(3));
    }

    public void testUpdateSpaceDescription() {
        Space space = this.createSpace("spaceUpdateDescription", DEMO_NAME);
        SpaceListenerPluginMock spaceListenerPlugin = new SpaceListenerPluginMock();
        this.spaceService.registerSpaceListenerPlugin((SpaceListenerPlugin)spaceListenerPlugin);
        try {
            space.setDescription("Updated Description");
            this.spaceService.updateSpace(space);
        }
        finally {
            this.spaceService.unregisterSpaceListenerPlugin((SpaceListenerPlugin)spaceListenerPlugin);
        }
        SpaceServiceTest.assertEquals((int)1, (int)spaceListenerPlugin.getEvents().size());
        SpaceServiceTest.assertEquals((Object)SpaceLifeCycleEvent.Type.SPACE_DESCRIPTION_EDITED, (Object)spaceListenerPlugin.getEvents().get(0));
    }

    public void testUpdateSpaceAccess() {
        Space space = this.createSpace("spaceUpdateAccess", DEMO_NAME);
        SpaceListenerPluginMock spaceListenerPlugin = new SpaceListenerPluginMock();
        this.spaceService.registerSpaceListenerPlugin((SpaceListenerPlugin)spaceListenerPlugin);
        try {
            space.setVisibility("hidden");
            this.spaceService.updateSpace(space);
        }
        finally {
            this.spaceService.unregisterSpaceListenerPlugin((SpaceListenerPlugin)spaceListenerPlugin);
        }
        SpaceServiceTest.assertEquals((int)1, (int)spaceListenerPlugin.getEvents().size());
        SpaceServiceTest.assertEquals((Object)SpaceLifeCycleEvent.Type.SPACE_HIDDEN, (Object)spaceListenerPlugin.getEvents().get(0));
    }

    public void testUpdateSpaceRegistration() {
        Space space = this.createSpace("spaceUpdateRegistration", DEMO_NAME);
        SpaceListenerPluginMock spaceListenerPlugin = new SpaceListenerPluginMock();
        this.spaceService.registerSpaceListenerPlugin((SpaceListenerPlugin)spaceListenerPlugin);
        try {
            space.setRegistration("validation");
            this.spaceService.updateSpace(space);
        }
        finally {
            this.spaceService.unregisterSpaceListenerPlugin((SpaceListenerPlugin)spaceListenerPlugin);
        }
        SpaceServiceTest.assertEquals((int)1, (int)spaceListenerPlugin.getEvents().size());
        SpaceServiceTest.assertEquals((Object)SpaceLifeCycleEvent.Type.SPACE_REGISTRATION, (Object)spaceListenerPlugin.getEvents().get(0));
    }

    public void testSpaceUserInvitation() {
        Space space = this.createSpace("spaceUserInvitation", DEMO_NAME);
        SpaceListenerPluginMock spaceListenerPlugin = new SpaceListenerPluginMock();
        this.spaceService.registerSpaceListenerPlugin((SpaceListenerPlugin)spaceListenerPlugin);
        try {
            this.spaceService.addInvitedUser(space, this.john.getRemoteId());
        }
        finally {
            this.spaceService.unregisterSpaceListenerPlugin((SpaceListenerPlugin)spaceListenerPlugin);
        }
        SpaceServiceTest.assertEquals((int)1, (int)spaceListenerPlugin.getEvents().size());
        SpaceServiceTest.assertEquals((Object)SpaceLifeCycleEvent.Type.ADD_INVITED_USER, (Object)spaceListenerPlugin.getEvents().get(0));
    }

    public void testSpaceUserInvitationDeny() {
        Space space = this.createSpace("spaceUserInvitationDeny", DEMO_NAME);
        this.spaceService.addInvitedUser(space, this.john.getRemoteId());
        SpaceListenerPluginMock spaceListenerPlugin = new SpaceListenerPluginMock();
        this.spaceService.registerSpaceListenerPlugin((SpaceListenerPlugin)spaceListenerPlugin);
        try {
            this.spaceService.removeInvitedUser(space, this.john.getRemoteId());
        }
        finally {
            this.spaceService.unregisterSpaceListenerPlugin((SpaceListenerPlugin)spaceListenerPlugin);
        }
        SpaceServiceTest.assertEquals((int)1, (int)spaceListenerPlugin.getEvents().size());
        SpaceServiceTest.assertEquals((Object)SpaceLifeCycleEvent.Type.DENY_INVITED_USER, (Object)spaceListenerPlugin.getEvents().get(0));
    }

    public void testCreateSpaceWithInvitation() throws SpaceException {
        String[] managers = new String[]{MANAGER_NAME};
        Space spaceCreated = this.createMoreSpace("invitedSpace");
        String[] users = new String[]{MEMBER1_NAME, MEMBER2_NAME};
        spaceCreated.setMembers(users);
        this.spaceService.updateSpace(spaceCreated);
        org.exoplatform.social.core.identity.model.Identity spaceIdentity = this.getService(IdentityManager.class).getOrCreateSpaceIdentity("invitedspace");
        ArrayList<org.exoplatform.social.core.identity.model.Identity> invitedIdentities = new ArrayList<org.exoplatform.social.core.identity.model.Identity>(Arrays.asList(this.tom, this.dragon, this.hearBreaker, spaceIdentity));
        Space space = new Space();
        space.setDisplayName(TEST_SPACE_DISPLAY_NAME);
        space.setDescription(TEST_SPACE_DESCRIPTION);
        String shortName = Utils.cleanString((String)space.getDisplayName());
        space.setManagers(managers);
        space.setPrettyName(space.getDisplayName());
        space.setRegistration("validation");
        space.setUrl(shortName);
        space.setVisibility("public");
        space = this.spaceService.createSpace(space, ROOT_NAME, invitedIdentities);
        SpaceServiceTest.assertEquals((int)5, (int)space.getInvitedUsers().length);
    }

    public void testCreateSpaceExceedingNameLimit() {
        Space space = new Space();
        String spaceDisplayName = "zzz0123456791011121314151617181920012345679101112131415161718192001234567910111213141516171819200123456791011121314151617181920012345679101112131415161718192001234567910111213141516171819200123456791011121314151617181920012345679101112131415161718192001234567910111213141516171819200123456791011121314151617181920";
        space.setDisplayName(spaceDisplayName);
        space.setRegistration("open");
        space.setDescription(SPACE_DESCRIPTION);
        space.setVisibility("public");
        space.setRegistration("validation");
        Assert.assertThrows(SpaceException.class, () -> this.spaceService.createSpace(space, ROOT_NAME));
    }

    public void testCreateSpaceNameTooShort() {
        Space space = new Space();
        String spaceDisplayName = "zz";
        space.setDisplayName(spaceDisplayName);
        space.setRegistration("open");
        space.setDescription(SPACE_DESCRIPTION);
        space.setVisibility("public");
        space.setRegistration("validation");
        Assert.assertThrows(SpaceException.class, () -> this.spaceService.createSpace(space, ROOT_NAME));
    }

    public void testCreateSpaceWithNoName() {
        Space space = new Space();
        space.setRegistration("open");
        space.setDescription(SPACE_DESCRIPTION);
        space.setVisibility("public");
        space.setRegistration("validation");
        Space createdSpace = this.spaceService.createSpace(space, DRAGON_NAME);
        SpaceServiceTest.assertNotNull((Object)createdSpace);
        SpaceServiceTest.assertEquals((String)"Dragon Ball", (String)createdSpace.getDisplayName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCreateSpaceWithTemplateCharacteristics() throws ObjectNotFoundException, SpaceException {
        SpaceTemplateService spaceTemplateService = this.getService(SpaceTemplateService.class);
        SpaceTemplate spaceTemplate = (SpaceTemplate)spaceTemplateService.getSpaceTemplates().getFirst();
        List originalSpaceFields = spaceTemplate.getSpaceFields();
        spaceTemplate.setSpaceFields(Collections.singletonList("invitation"));
        spaceTemplateService.updateSpaceTemplate(spaceTemplate);
        try {
            Space createdSpace = this.spaceService.createSpace(new Space(), RAUL_NAME, Arrays.asList(this.dragon, this.john));
            SpaceServiceTest.assertNotNull((Object)createdSpace);
            SpaceServiceTest.assertTrue((boolean)createdSpace.getDisplayName().contains("Dragon Ball"));
            SpaceServiceTest.assertTrue((boolean)createdSpace.getDisplayName().contains("and 1 more"));
            SpaceServiceTest.assertTrue((boolean)createdSpace.getDisplayName().contains(", "));
            SpaceServiceTest.assertEquals((String)spaceTemplate.getSpaceDefaultVisibility().name().toLowerCase(), (String)createdSpace.getVisibility());
            SpaceServiceTest.assertEquals((String)spaceTemplate.getSpaceDefaultRegistration().name().toLowerCase(), (String)createdSpace.getRegistration());
            SpaceServiceTest.assertEquals((String)("manager:" + createdSpace.getGroupId()), (String)((String)createdSpace.getDeletePermissions().get(0)));
            SpaceServiceTest.assertEquals((String)("manager:" + createdSpace.getGroupId()), (String)((String)createdSpace.getLayoutPermissions().get(0)));
            SpaceServiceTest.assertEquals((String)("manager:" + createdSpace.getGroupId()), (String)((String)createdSpace.getPublicSitePermissions().get(0)));
        }
        finally {
            spaceTemplate.setSpaceFields(originalSpaceFields);
            spaceTemplateService.updateSpaceTemplate(spaceTemplate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testIsSuperManagerBySpaceTemplate() throws ObjectNotFoundException {
        Space raulSpace = this.createSpace("raulSpace", RAUL_NAME);
        Space rootSpace = this.createSpace("rootSpace", ROOT_NAME);
        SpaceServiceTest.assertFalse((boolean)this.spaceService.isSuperManager(rootSpace.getSpaceId(), RAUL_NAME));
        SpaceTemplateService spaceTemplateService = this.getService(SpaceTemplateService.class);
        SpaceTemplate spaceTemplate = (SpaceTemplate)spaceTemplateService.getSpaceTemplates().getFirst();
        List originalSpaceAdminPermissions = spaceTemplate.getAdminPermissions();
        spaceTemplate.setAdminPermissions(Collections.singletonList(raulSpace.getGroupId()));
        spaceTemplateService.updateSpaceTemplate(spaceTemplate);
        try {
            SpaceServiceTest.assertFalse((boolean)this.spaceService.isSuperManager(rootSpace, RAUL_NAME));
            SpaceServiceTest.assertFalse((boolean)this.spaceService.canManageSpace(rootSpace, RAUL_NAME));
            SpaceServiceTest.assertFalse((boolean)this.spaceService.canDeleteSpace(rootSpace, RAUL_NAME));
            SpaceServiceTest.assertFalse((boolean)this.spaceService.canManageSpaceLayout(rootSpace, RAUL_NAME));
            SpaceServiceTest.assertFalse((boolean)this.spaceService.canPublishOnSpace(rootSpace, RAUL_NAME));
            SpaceServiceTest.assertFalse((boolean)this.spaceService.canRedactOnSpace(rootSpace, RAUL_NAME));
            SpaceServiceTest.assertFalse((boolean)this.spaceService.canViewSpace(rootSpace, RAUL_NAME));
            SpaceServiceTest.assertFalse((boolean)this.spaceService.isMember(rootSpace, RAUL_NAME));
            SpaceServiceTest.assertFalse((boolean)this.spaceService.isManager(rootSpace, RAUL_NAME));
            this.restartTransaction();
            rootSpace = this.spaceService.getSpaceById(rootSpace.getSpaceId());
            rootSpace.setTemplateId(spaceTemplate.getId());
            SpaceServiceTest.assertTrue((boolean)this.spaceService.isSuperManager(rootSpace, RAUL_NAME));
            SpaceServiceTest.assertTrue((boolean)this.spaceService.canManageSpace(rootSpace, RAUL_NAME));
            SpaceServiceTest.assertTrue((boolean)this.spaceService.canDeleteSpace(rootSpace, RAUL_NAME));
            SpaceServiceTest.assertTrue((boolean)this.spaceService.canManageSpaceLayout(rootSpace, RAUL_NAME));
            SpaceServiceTest.assertTrue((boolean)this.spaceService.canPublishOnSpace(rootSpace, RAUL_NAME));
            SpaceServiceTest.assertTrue((boolean)this.spaceService.canRedactOnSpace(rootSpace, RAUL_NAME));
            SpaceServiceTest.assertTrue((boolean)this.spaceService.canViewSpace(rootSpace, RAUL_NAME));
            SpaceServiceTest.assertFalse((boolean)this.spaceService.isMember(rootSpace, RAUL_NAME));
            SpaceServiceTest.assertFalse((boolean)this.spaceService.isManager(rootSpace, RAUL_NAME));
        }
        finally {
            spaceTemplate.setAdminPermissions(originalSpaceAdminPermissions);
            spaceTemplateService.updateSpaceTemplate(spaceTemplate);
        }
    }

    public void testCreateSpaceWithInvalidSpaceName() {
        Space space = new Space();
        String spaceDisplayName = "%zzz:^!/<>\ud83d\ude01";
        space.setDisplayName(spaceDisplayName);
        String creator = ROOT_NAME;
        String shortName = "zzz";
        space.setDisplayName(spaceDisplayName);
        space.setPrettyName(shortName);
        space.setRegistration("open");
        space.setDescription(SPACE_DESCRIPTION);
        space.setVisibility("public");
        space.setRegistration("validation");
        space = this.spaceService.createSpace(space, creator);
        SpaceServiceTest.assertEquals((String)spaceDisplayName, (String)space.getDisplayName());
        SpaceServiceTest.assertFalse((boolean)space.getPrettyName().contains("%"));
        SpaceServiceTest.assertFalse((boolean)space.getPrettyName().contains("^"));
        SpaceServiceTest.assertFalse((boolean)space.getPrettyName().contains(":"));
        SpaceServiceTest.assertFalse((boolean)space.getPrettyName().contains("!"));
        SpaceServiceTest.assertFalse((boolean)space.getPrettyName().contains("/"));
        SpaceServiceTest.assertFalse((boolean)space.getPrettyName().contains("<"));
        SpaceServiceTest.assertFalse((boolean)space.getPrettyName().contains(">"));
        SpaceServiceTest.assertFalse((boolean)space.getPrettyName().contains("\ud83d\ude01"));
    }

    public void testCreateSpaceNoUser() {
        Space space = this.getSpaceInstance(0);
        String spaceDisplayName = space.getDisplayName();
        String spaceDescription = space.getDescription();
        String groupId = space.getGroupId();
        Space savedSpace = this.spaceService.getSpaceById(space.getId());
        SpaceServiceTest.assertNotNull((Object)savedSpace);
        SpaceServiceTest.assertEquals((String)spaceDisplayName, (String)savedSpace.getDisplayName());
        SpaceServiceTest.assertEquals((String)spaceDescription, (String)savedSpace.getDescription());
        SpaceServiceTest.assertEquals((String)groupId, (String)savedSpace.getGroupId());
        SpaceServiceTest.assertNotNull((Object)savedSpace.getAvatarUrl());
    }

    public void testRenameSpace() throws SpaceException {
        Space space = this.getSpaceInstance(0);
        org.exoplatform.social.core.identity.model.Identity identity = new org.exoplatform.social.core.identity.model.Identity("space", space.getPrettyName());
        this.identityStorage.saveIdentity(identity);
        String newDisplayName = "new display name";
        this.spaceService.renameSpace(space, newDisplayName);
        Space got = this.spaceService.getSpaceById(space.getId());
        SpaceServiceTest.assertEquals((String)newDisplayName, (String)got.getDisplayName());
        newDisplayName = "new display name with super admin";
        this.spaceService.renameSpace(space, newDisplayName, this.root.getRemoteId());
        got = this.spaceService.getSpaceById(space.getId());
        SpaceServiceTest.assertEquals((String)newDisplayName, (String)got.getDisplayName());
        Assert.assertThrows(SpaceException.class, () -> this.spaceService.renameSpace(space, "new display name with normal admin", this.mary.getRemoteId()));
        SpaceServiceTest.assertNotNull((Object)this.identityManager.getOrCreateSpaceIdentity(space.getPrettyName()));
        String oldPrettyName = space.getPrettyName();
        newDisplayName = "new display name with null remoteId";
        this.spaceService.renameSpace(space, newDisplayName);
        got = this.spaceService.getSpaceById(space.getId());
        SpaceServiceTest.assertEquals((String)newDisplayName, (String)got.getDisplayName());
        SpaceServiceTest.assertNotNull((Object)this.identityManager.getOrCreateSpaceIdentity(space.getPrettyName()));
        SpaceServiceTest.assertNull((Object)this.identityManager.getOrCreateSpaceIdentity(oldPrettyName));
    }

    public void testDeleteSpace() throws Exception {
        Space space = this.getSpaceInstance(0);
        String spaceDisplayName = space.getDisplayName();
        String spaceDescription = space.getDescription();
        String groupId = space.getGroupId();
        Space savedSpace = this.spaceService.getSpaceById(space.getId());
        SpaceServiceTest.assertNotNull((Object)savedSpace);
        SpaceServiceTest.assertEquals((String)spaceDisplayName, (String)savedSpace.getDisplayName());
        SpaceServiceTest.assertEquals((String)spaceDescription, (String)savedSpace.getDescription());
        SpaceServiceTest.assertEquals((String)groupId, (String)savedSpace.getGroupId());
        SpaceServiceTest.assertNotNull((Object)this.organizationService.getGroupHandler().findGroupById(groupId));
        this.spaceService.deleteSpace(space);
        savedSpace = this.spaceService.getSpaceById(space.getId());
        SpaceServiceTest.assertNull((String)"savedSpace must be null", (Object)savedSpace);
        SpaceServiceTest.assertNull((String)("the group " + groupId + " must be deleted after space deletion "), (Object)this.organizationService.getGroupHandler().findGroupById(groupId));
    }

    public void testDeleteSpaceWithoutDeletingGroup() throws Exception {
        Space space = this.getSpaceInstance(0);
        String spaceDisplayName = space.getDisplayName();
        String spaceDescription = space.getDescription();
        String groupId = space.getGroupId();
        Space savedSpace = this.spaceService.getSpaceById(space.getId());
        SpaceServiceTest.assertNotNull((Object)savedSpace);
        SpaceServiceTest.assertEquals((String)spaceDisplayName, (String)savedSpace.getDisplayName());
        SpaceServiceTest.assertEquals((String)spaceDescription, (String)savedSpace.getDescription());
        SpaceServiceTest.assertEquals((String)groupId, (String)savedSpace.getGroupId());
        SpaceServiceTest.assertNotNull((Object)this.organizationService.getGroupHandler().findGroupById(groupId));
        this.spaceService.deleteSpace(space, false);
        savedSpace = this.spaceService.getSpaceById(space.getId());
        SpaceServiceTest.assertNull((String)"savedSpace must be null", (Object)savedSpace);
        SpaceServiceTest.assertNotNull((String)("the group " + groupId + " must exist after space deletion"), (Object)this.organizationService.getGroupHandler().findGroupById(groupId));
        Group group = this.organizationService.getGroupHandler().findGroupById(groupId);
        this.organizationService.getGroupHandler().removeGroup(group, true);
    }

    public void testUpdateSpacePermissions() {
        Space space = this.getSpaceInstance(0);
        try {
            this.spaceService.updateSpaceBanner(space, RAUL_NAME);
            SpaceServiceTest.fail((String)"Space member shouldn't be able to update space banner");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.spaceService.updateSpaceAvatar(space, RAUL_NAME);
            SpaceServiceTest.fail((String)"Space member shouldn't be able to update space avatar");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testUpdateSpace() {
        Space space = this.getSpaceInstance(0);
        String spaceDisplayName = space.getDisplayName();
        String spaceDescription = space.getDescription();
        String groupId = space.getGroupId();
        Space savedSpace = this.spaceService.getSpaceById(space.getId());
        SpaceServiceTest.assertNotNull((Object)savedSpace);
        SpaceServiceTest.assertEquals((String)spaceDisplayName, (String)savedSpace.getDisplayName());
        SpaceServiceTest.assertEquals((String)spaceDescription, (String)savedSpace.getDescription());
        SpaceServiceTest.assertEquals((String)groupId, (String)savedSpace.getGroupId());
        String updateSpaceDisplayName = "update new space display name";
        space.setDisplayName(updateSpaceDisplayName);
        space.setPrettyName(space.getDisplayName());
        this.spaceService.updateSpace(space);
        savedSpace = this.spaceService.getSpaceById(space.getId());
        SpaceServiceTest.assertNotNull((Object)savedSpace);
        SpaceServiceTest.assertEquals((String)("savedSpace.getDisplayName() must return: " + updateSpaceDisplayName), (String)updateSpaceDisplayName, (String)savedSpace.getDisplayName());
        SpaceServiceTest.assertEquals((String)spaceDescription, (String)savedSpace.getDescription());
        SpaceServiceTest.assertEquals((String)groupId, (String)savedSpace.getGroupId());
    }

    public void testAddPendingUser() {
        Space space = this.getSpaceInstance(0);
        int pendingUsersCount = space.getPendingUsers().length;
        SpaceServiceTest.assertFalse((String)"ArrayUtils.contains(space.getPendingUsers(), newPendingUser.getRemoteId()) must be false", (boolean)ArrayUtils.contains((Object[])space.getPendingUsers(), (Object)this.newPendingUser.getRemoteId()));
        this.spaceService.addPendingUser(space, this.newPendingUser.getRemoteId());
        space = this.spaceService.getSpaceById(space.getId());
        SpaceServiceTest.assertEquals((int)(pendingUsersCount + 1), (int)space.getPendingUsers().length);
        SpaceServiceTest.assertTrue((boolean)ArrayUtils.contains((Object[])space.getPendingUsers(), (Object)this.newPendingUser.getRemoteId()));
    }

    public void testRemovePendingUser() {
        Space space = this.getSpaceInstance(0);
        int pendingUsersCount = space.getPendingUsers().length;
        SpaceServiceTest.assertFalse((String)"ArrayUtils.contains(space.getPendingUsers(), newPendingUser.getRemoteId()) must be false", (boolean)ArrayUtils.contains((Object[])space.getPendingUsers(), (Object)this.newPendingUser.getRemoteId()));
        this.spaceService.addPendingUser(space, this.newPendingUser.getRemoteId());
        space = this.spaceService.getSpaceById(space.getId());
        SpaceServiceTest.assertEquals((int)(pendingUsersCount + 1), (int)space.getPendingUsers().length);
        SpaceServiceTest.assertTrue((boolean)ArrayUtils.contains((Object[])space.getPendingUsers(), (Object)this.newPendingUser.getRemoteId()));
        this.spaceService.removePendingUser(space, this.newPendingUser.getRemoteId());
        space = this.spaceService.getSpaceById(space.getId());
        SpaceServiceTest.assertEquals((String)("space.getPendingUsers().length must return: " + pendingUsersCount), (int)pendingUsersCount, (int)space.getPendingUsers().length);
        SpaceServiceTest.assertFalse((boolean)ArrayUtils.contains((Object[])space.getPendingUsers(), (Object)this.newPendingUser.getRemoteId()));
    }

    public void testIsPendingUser() {
        Space space = this.getSpaceInstance(0);
        Space savedSpace = this.spaceService.getSpaceById(space.getId());
        SpaceServiceTest.assertNotNull((Object)savedSpace);
        SpaceServiceTest.assertTrue((String)"spaceService.isPendingUser(savedSpace, \"jame\") must return true", (boolean)this.spaceService.isPendingUser(savedSpace, JAME_NAME));
        SpaceServiceTest.assertTrue((String)"spaceService.isPendingUser(savedSpace, \"paul\") must return true", (boolean)this.spaceService.isPendingUser(savedSpace, PAUL_NAME));
        SpaceServiceTest.assertTrue((String)"spaceService.isPendingUser(savedSpace, \"hacker\") must return true", (boolean)this.spaceService.isPendingUser(savedSpace, HACKER_NAME));
        SpaceServiceTest.assertFalse((String)"spaceService.isPendingUser(savedSpace, \"newpendinguser\") must return false", (boolean)this.spaceService.isPendingUser(savedSpace, "newpendinguser"));
    }

    public void testAddInvitedUser() {
        Space space = this.getSpaceInstance(0);
        Space savedSpace = this.spaceService.getSpaceById(space.getId());
        SpaceServiceTest.assertNotNull((Object)savedSpace);
        int invitedUsersCount = savedSpace.getInvitedUsers().length;
        SpaceServiceTest.assertFalse((boolean)ArrayUtils.contains((Object[])savedSpace.getInvitedUsers(), (Object)this.newInvitedUser.getRemoteId()));
        this.spaceService.addInvitedUser(savedSpace, this.newInvitedUser.getRemoteId());
        savedSpace = this.spaceService.getSpaceById(space.getId());
        SpaceServiceTest.assertEquals((int)(invitedUsersCount + 1), (int)savedSpace.getInvitedUsers().length);
        SpaceServiceTest.assertTrue((String)"ArrayUtils.contains(savedSpace.getInvitedUsers(), newInvitedUser.getRemoteId()) must return true", (boolean)ArrayUtils.contains((Object[])savedSpace.getInvitedUsers(), (Object)this.newInvitedUser.getRemoteId()));
    }

    public void testRemoveInvitedUser() {
        Space space = this.getSpaceInstance(0);
        Space savedSpace = this.spaceService.getSpaceById(space.getId());
        SpaceServiceTest.assertNotNull((Object)savedSpace);
        int invitedUsersCount = savedSpace.getInvitedUsers().length;
        SpaceServiceTest.assertFalse((boolean)ArrayUtils.contains((Object[])savedSpace.getInvitedUsers(), (Object)this.newInvitedUser.getRemoteId()));
        this.spaceService.addInvitedUser(savedSpace, this.newInvitedUser.getRemoteId());
        savedSpace = this.spaceService.getSpaceById(space.getId());
        SpaceServiceTest.assertEquals((int)(invitedUsersCount + 1), (int)savedSpace.getInvitedUsers().length);
        SpaceServiceTest.assertTrue((String)"ArrayUtils.contains(savedSpace.getInvitedUsers(), newInvitedUser.getRemoteId()) must return true", (boolean)ArrayUtils.contains((Object[])savedSpace.getInvitedUsers(), (Object)this.newInvitedUser.getRemoteId()));
        this.spaceService.removeInvitedUser(savedSpace, this.newInvitedUser.getRemoteId());
        savedSpace = this.spaceService.getSpaceById(space.getId());
        SpaceServiceTest.assertEquals((String)("savedSpace.getInvitedUsers().length must return: " + invitedUsersCount), (int)invitedUsersCount, (int)savedSpace.getInvitedUsers().length);
        SpaceServiceTest.assertFalse((boolean)ArrayUtils.contains((Object[])savedSpace.getInvitedUsers(), (Object)this.newInvitedUser.getRemoteId()));
    }

    public void testIsInvitedUser() {
        Space space = this.getSpaceInstance(0);
        Space savedSpace = this.spaceService.getSpaceById(space.getId());
        SpaceServiceTest.assertNotNull((Object)savedSpace);
        SpaceServiceTest.assertTrue((String)"spaceService.isInvitedUser(savedSpace, \"register1\") must return true", (boolean)this.spaceService.isInvitedUser(savedSpace, REGISTER1_NAME));
        SpaceServiceTest.assertTrue((String)"spaceService.isInvitedUser(savedSpace, \"mary\") must return true", (boolean)this.spaceService.isInvitedUser(savedSpace, MARY_NAME));
        SpaceServiceTest.assertFalse((String)"spaceService.isInvitedUser(savedSpace, \"hacker\") must return false", (boolean)this.spaceService.isInvitedUser(savedSpace, HACKER_NAME));
        SpaceServiceTest.assertFalse((String)"spaceService.isInvitedUser(savedSpace, \"nobody\") must return false", (boolean)this.spaceService.isInvitedUser(savedSpace, "nobody"));
    }

    public void testSetManager() {
        int number = 0;
        Space space = new Space();
        space.setDisplayName(MY_SPACE_DISPLAY_NAME_PREFIX + number);
        space.setPrettyName(space.getDisplayName());
        space.setRegistration("open");
        space.setDescription(SPACE_DESCRIPTION + number);
        space.setVisibility("public");
        space.setRegistration("validation");
        space.setUrl(space.getPrettyName());
        String[] spaceManagers = new String[]{DEMO_NAME, TOM_NAME};
        String[] members = new String[]{DEMO_NAME, TOM_NAME, RAUL_NAME, GHOST_NAME, DRAGON_NAME};
        String[] invitedUsers = new String[]{REGISTER1_NAME, MARY_NAME};
        String[] pendingUsers = new String[]{JAME_NAME, PAUL_NAME, HACKER_NAME};
        space.setInvitedUsers(invitedUsers);
        space.setPendingUsers(pendingUsers);
        space.setManagers(spaceManagers);
        space.setMembers(members);
        space = this.createSpaceNonInitApps(space, DEMO_NAME, null);
        Space savedSpace = this.spaceService.getSpaceById(space.getId());
        SpaceServiceTest.assertNotNull((Object)savedSpace);
        int managers = savedSpace.getManagers().length;
        this.spaceService.setManager(savedSpace, DEMO_NAME, true);
        savedSpace = this.spaceService.getSpaceById(space.getId());
        SpaceServiceTest.assertEquals((int)managers, (int)savedSpace.getManagers().length);
        this.spaceService.setManager(savedSpace, JOHN_NAME, true);
        savedSpace = this.spaceService.getSpaceById(space.getId());
        SpaceServiceTest.assertEquals((String)("savedSpace.getManagers().length must return: " + managers + "1"), (int)(managers + 1), (int)savedSpace.getManagers().length);
        this.spaceService.setManager(savedSpace, DEMO_NAME, false);
        savedSpace = this.spaceService.getSpaceById(space.getId());
        SpaceServiceTest.assertEquals((int)managers, (int)savedSpace.getManagers().length);
    }

    public void testIsManager() {
        Space space = this.getSpaceInstance(0);
        Space savedSpace = this.spaceService.getSpaceById(space.getId());
        SpaceServiceTest.assertNotNull((Object)savedSpace);
        SpaceServiceTest.assertTrue((String)"spaceService.isManager(savedSpace, \"demo\") must return true", (boolean)this.spaceService.isManager(savedSpace, DEMO_NAME));
        SpaceServiceTest.assertTrue((String)"spaceService.isManager(savedSpace, \"tom\") must return true", (boolean)this.spaceService.isManager(savedSpace, TOM_NAME));
        SpaceServiceTest.assertFalse((String)"spaceService.isManager(savedSpace, \"mary\") must return false", (boolean)this.spaceService.isManager(savedSpace, MARY_NAME));
        SpaceServiceTest.assertFalse((String)"spaceService.isManager(savedSpace, \"john\") must return false", (boolean)this.spaceService.isManager(savedSpace, JOHN_NAME));
    }

    public void testSetRedactor() {
        Space space = new Space();
        space.setDisplayName(SPACE1_NAME);
        space.setPrettyName(space.getDisplayName());
        space.setRegistration("open");
        space.setDescription("add new space1");
        space.setVisibility("public");
        space.setRegistration("validation");
        Space createdSpace = this.spaceService.createSpace(space, ROOT_NAME);
        String[] members = new String[]{GHOST_NAME, JOHN_NAME};
        Arrays.stream(members).forEach(u -> this.spaceService.addMember(createdSpace, u));
        SpaceServiceTest.assertEquals((int)0, (int)createdSpace.getRedactors().length);
        MembershipType redactorMembershipType = this.organizationService.getMembershipTypeHandler().createMembershipTypeInstance();
        redactorMembershipType.setName("redactor");
        this.spaceService.addRedactor(createdSpace, GHOST_NAME);
        this.spaceService.addRedactor(createdSpace, JOHN_NAME);
        space = this.spaceService.getSpaceById(createdSpace.getId());
        SpaceServiceTest.assertEquals((int)2, (int)space.getRedactors().length);
        this.spaceService.removeRedactor(createdSpace, JOHN_NAME);
        space = this.spaceService.getSpaceById(createdSpace.getId());
        SpaceServiceTest.assertEquals((int)1, (int)space.getRedactors().length);
        SpaceServiceTest.assertTrue((boolean)this.spaceService.isRedactor(createdSpace, GHOST_NAME));
        SpaceServiceTest.assertFalse((boolean)this.spaceService.isRedactor(createdSpace, JOHN_NAME));
    }

    public void testSetPublisher() {
        Space space = new Space();
        space.setDisplayName(SPACE1_NAME);
        space.setPrettyName(space.getDisplayName());
        space.setRegistration("open");
        space.setDescription("add new space1");
        space.setVisibility("public");
        space.setRegistration("validation");
        space.setUrl(space.getPrettyName());
        Space createdSpace = this.spaceService.createSpace(space, ROOT_NAME);
        String[] members = new String[]{GHOST_NAME, JOHN_NAME};
        Arrays.stream(members).forEach(u -> this.spaceService.addMember(createdSpace, u));
        MembershipType publisherMembershipType = this.organizationService.getMembershipTypeHandler().createMembershipTypeInstance();
        publisherMembershipType.setName("publisher");
        this.spaceService.addPublisher(createdSpace, GHOST_NAME);
        this.spaceService.addPublisher(createdSpace, JOHN_NAME);
        SpaceServiceTest.assertEquals((int)2, (int)createdSpace.getPublishers().length);
        this.spaceService.removePublisher(createdSpace, JOHN_NAME);
        SpaceServiceTest.assertEquals((int)1, (int)createdSpace.getPublishers().length);
        SpaceServiceTest.assertTrue((boolean)this.spaceService.isPublisher(createdSpace, GHOST_NAME));
        SpaceServiceTest.assertFalse((boolean)this.spaceService.isPublisher(createdSpace, JOHN_NAME));
    }

    public void testIsOnlyManager() {
        Space space = this.getSpaceInstance(0);
        Space savedSpace = this.spaceService.getSpaceById(space.getId());
        SpaceServiceTest.assertNotNull((Object)savedSpace);
        SpaceServiceTest.assertFalse((String)"spaceService.isOnlyManager(savedSpace, \"tom\") must return false", (boolean)this.spaceService.isOnlyManager(savedSpace, TOM_NAME));
        SpaceServiceTest.assertFalse((String)"spaceService.isOnlyManager(savedSpace, \"demo\") must return false", (boolean)this.spaceService.isOnlyManager(savedSpace, DEMO_NAME));
        savedSpace.setManagers(new String[]{DEMO_NAME});
        this.spaceService.updateSpace(savedSpace);
        SpaceServiceTest.assertTrue((String)"spaceService.isOnlyManager(savedSpace, \"demo\") must return true", (boolean)this.spaceService.isOnlyManager(savedSpace, DEMO_NAME));
        SpaceServiceTest.assertFalse((String)"spaceService.isOnlyManager(savedSpace, \"tom\") must return false", (boolean)this.spaceService.isOnlyManager(savedSpace, TOM_NAME));
        savedSpace.setManagers(new String[]{TOM_NAME});
        this.spaceService.updateSpace(savedSpace);
        SpaceServiceTest.assertFalse((String)"spaceService.isOnlyManager(savedSpace, \"demo\") must return false", (boolean)this.spaceService.isOnlyManager(savedSpace, DEMO_NAME));
        SpaceServiceTest.assertTrue((String)"spaceService.isOnlyManager(savedSpace, \"tom\") must return true", (boolean)this.spaceService.isOnlyManager(savedSpace, TOM_NAME));
    }

    public void testAddMember() {
        int number = 0;
        Space space = new Space();
        space.setDisplayName(MY_SPACE_DISPLAY_NAME_PREFIX + number);
        space.setPrettyName(space.getDisplayName());
        space.setRegistration("open");
        space.setDescription(SPACE_DESCRIPTION + number);
        space.setVisibility("public");
        space.setRegistration("validation");
        space.setUrl(space.getPrettyName());
        String[] spaceManagers = new String[]{DEMO_NAME};
        String[] members = new String[]{};
        String[] invitedUsers = new String[]{REGISTER1_NAME, MARY_NAME};
        String[] pendingUsers = new String[]{JAME_NAME, PAUL_NAME, HACKER_NAME};
        space.setInvitedUsers(invitedUsers);
        space.setPendingUsers(pendingUsers);
        space.setManagers(spaceManagers);
        space.setMembers(members);
        space = this.createSpaceNonInitApps(space, DEMO_NAME, null);
        Space savedSpace = this.spaceService.getSpaceById(space.getId());
        SpaceServiceTest.assertNotNull((Object)savedSpace);
        this.spaceService.addMember(savedSpace, ROOT_NAME);
        this.spaceService.addMember(savedSpace, MARY_NAME);
        this.spaceService.addMember(savedSpace, JOHN_NAME);
        savedSpace = this.spaceService.getSpaceById(space.getId());
        SpaceServiceTest.assertEquals((String)"savedSpace.getMembers().length must return 4", (int)4, (int)savedSpace.getMembers().length);
    }

    public void testAddMemberSpecialCharacter() throws Exception {
        String reg = "^\\p{L}[\\p{L}\\d\\s._,-]+$";
        Pattern pattern = Pattern.compile(reg);
        SpaceServiceTest.assertTrue((boolean)pattern.matcher(USER_NEW_1_NAME).matches());
        SpaceServiceTest.assertTrue((boolean)pattern.matcher(USER_DOT_NEW_NAME).matches());
        SpaceServiceTest.assertTrue((boolean)pattern.matcher(USER_NEW_NAME).matches());
        int number = 0;
        Space space = new Space();
        space.setDisplayName(MY_SPACE_DISPLAY_NAME_PREFIX + number);
        space.setPrettyName(space.getDisplayName());
        space.setRegistration("open");
        space.setDescription(SPACE_DESCRIPTION + number);
        space.setVisibility("public");
        space.setRegistration("validation");
        space.setUrl(space.getPrettyName());
        String[] spaceManagers = new String[]{DEMO_NAME};
        String[] members = new String[]{};
        String[] invitedUsers = new String[]{REGISTER1_NAME, MARY_NAME};
        String[] pendingUsers = new String[]{JAME_NAME, PAUL_NAME, HACKER_NAME};
        space.setInvitedUsers(invitedUsers);
        space.setPendingUsers(pendingUsers);
        space.setManagers(spaceManagers);
        space.setMembers(members);
        space = this.createSpaceNonInitApps(space, DEMO_NAME, null);
        Space savedSpace = this.spaceService.getSpaceById(space.getId());
        SpaceServiceTest.assertNotNull((Object)savedSpace);
        User user = this.organizationService.getUserHandler().createUserInstance(USER_NEW_1_NAME);
        this.organizationService.getUserHandler().createUser(user, false);
        user = this.organizationService.getUserHandler().createUserInstance(USER_DOT_NEW_NAME);
        this.organizationService.getUserHandler().createUser(user, false);
        user = this.organizationService.getUserHandler().createUserInstance(USER_NEW_NAME);
        this.organizationService.getUserHandler().createUser(user, false);
        this.spaceService.addMember(savedSpace, USER_NEW_1_NAME);
        this.spaceService.addMember(savedSpace, USER_DOT_NEW_NAME);
        this.spaceService.addMember(savedSpace, USER_NEW_NAME);
        savedSpace = this.spaceService.getSpaceById(space.getId());
        SpaceServiceTest.assertEquals((int)4, (int)savedSpace.getMembers().length);
    }

    public void testRemoveMember() throws Exception {
        int number = 0;
        Space space = new Space();
        space.setDisplayName(MY_SPACE_DISPLAY_NAME_PREFIX + number);
        space.setPrettyName(space.getDisplayName());
        space.setRegistration("open");
        space.setDescription(SPACE_DESCRIPTION + number);
        space.setVisibility("public");
        space.setRegistration("validation");
        space.setUrl(space.getPrettyName());
        String[] spaceManagers = new String[]{DEMO_NAME};
        String[] members = new String[]{};
        String[] invitedUsers = new String[]{REGISTER1_NAME, MARY_NAME};
        String[] pendingUsers = new String[]{JAME_NAME, PAUL_NAME, HACKER_NAME};
        space.setInvitedUsers(invitedUsers);
        space.setPendingUsers(pendingUsers);
        space.setManagers(spaceManagers);
        space.setMembers(members);
        space = this.createSpaceNonInitApps(space, DEMO_NAME, null);
        Space savedSpace = this.spaceService.getSpaceById(space.getId());
        SpaceServiceTest.assertNotNull((Object)savedSpace);
        this.spaceService.addMember(savedSpace, ROOT_NAME);
        this.spaceService.addMember(savedSpace, MARY_NAME);
        this.spaceService.addMember(savedSpace, JOHN_NAME);
        this.spaceService.setManager(savedSpace, JOHN_NAME, true);
        this.spaceService.addRedactor(savedSpace, JOHN_NAME);
        GroupHandler groupHandler = this.organizationService.getGroupHandler();
        UserHandler userHandler = this.organizationService.getUserHandler();
        MembershipType mbShipTypeMember = this.organizationService.getMembershipTypeHandler().findMembershipType("*");
        User user = userHandler.findUserByName(JOHN_NAME);
        this.organizationService.getMembershipHandler().linkMembership(user, groupHandler.findGroupById(space.getGroupId()), mbShipTypeMember, true);
        savedSpace = this.spaceService.getSpaceById(space.getId());
        SpaceServiceTest.assertEquals((String)"savedSpace.getMembers().length must return 4", (int)4, (int)savedSpace.getMembers().length);
        this.spaceService.removeMember(savedSpace, ROOT_NAME);
        this.spaceService.removeMember(savedSpace, MARY_NAME);
        this.spaceService.removeMember(savedSpace, JOHN_NAME);
        Membership any = this.organizationService.getMembershipHandler().findMembershipByUserGroupAndType(JOHN_NAME, space.getGroupId(), "*");
        SpaceServiceTest.assertNull((Object)any);
        SpaceServiceTest.assertFalse((boolean)this.spaceService.isManager(savedSpace, JOHN_NAME));
        SpaceServiceTest.assertFalse((boolean)this.spaceService.isRedactor(savedSpace, JOHN_NAME));
        SpaceServiceTest.assertFalse((boolean)this.spaceService.isMember(savedSpace, JOHN_NAME));
        SpaceServiceTest.assertEquals((String)"savedSpace.getMembers().length must return 1", (int)1, (int)savedSpace.getMembers().length);
    }

    public void testDeleteSpaceWithBoundMember() throws Exception {
        String userToBind = PAUL_NAME;
        int number = 17;
        Space space = new Space();
        space.setDisplayName(MY_SPACE_DISPLAY_NAME_PREFIX + number);
        space.setPrettyName(space.getDisplayName());
        space.setRegistration("open");
        space.setDescription(SPACE_DESCRIPTION + number);
        space.setVisibility("public");
        space.setRegistration("validation");
        space.setUrl(space.getPrettyName());
        space.setMembers(new String[]{JOHN_NAME, MARY_NAME});
        space = this.createSpaceNonInitApps(space, JOHN_NAME, null);
        Space savedSpace = this.spaceService.getSpaceById(space.getId());
        this.spaceService.addMember(savedSpace, userToBind);
        Group groupToBind = this.organizationService.getGroupHandler().createGroupInstance();
        String groupName = "groupForSpaceToBind";
        String groupId = "/" + groupName;
        groupToBind.setId(groupId);
        groupToBind.setGroupName(groupName);
        groupToBind.setLabel(groupName);
        this.organizationService.getGroupHandler().addChild(null, groupToBind, true);
        MembershipType membershipType = this.organizationService.getMembershipTypeHandler().findMembershipType("member");
        User user = this.organizationService.getUserHandler().findUserByName(userToBind);
        this.organizationService.getMembershipHandler().linkMembership(user, groupToBind, membershipType, true);
        Membership membership = this.organizationService.getMembershipHandler().findMembershipByUserGroupAndType(user.getUserName(), groupToBind.getId(), membershipType.getName());
        SpaceServiceTest.assertNotNull((Object)membership);
        this.restartTransaction();
        GroupSpaceBindingService groupSpaceBindingService = (GroupSpaceBindingService)this.getContainer().getComponentInstanceOfType(GroupSpaceBindingService.class);
        GroupSpaceBinding groupSpaceBinding = new GroupSpaceBinding(space.getId(), groupToBind.getId());
        groupSpaceBindingService.saveGroupSpaceBinding(groupSpaceBinding);
        this.restartTransaction();
        List groupSpaceBindings = groupSpaceBindingService.findGroupSpaceBindingsBySpace(savedSpace.getId());
        SpaceServiceTest.assertNotNull((Object)groupSpaceBindings);
        SpaceServiceTest.assertEquals((int)1, (int)groupSpaceBindings.size());
        SpaceServiceTest.assertTrue((boolean)this.spaceService.isMember(savedSpace, userToBind));
        this.spaceService.deleteSpace(savedSpace);
        this.restartTransaction();
        SpaceServiceTest.assertNull((Object)this.spaceService.getSpaceById(savedSpace.getId()));
        membership = this.organizationService.getMembershipHandler().findMembershipByUserGroupAndType(user.getUserName(), groupToBind.getId(), membershipType.getName());
        SpaceServiceTest.assertNotNull((Object)membership);
        membership = this.organizationService.getMembershipHandler().findMembershipByUserGroupAndType(user.getUserName(), savedSpace.getGroupId(), "member");
        SpaceServiceTest.assertNull((Object)membership);
    }

    public void testRemoveBoundMember() throws Exception {
        String userToBind = PAUL_NAME;
        int number = 0;
        Space space = new Space();
        space.setDisplayName(MY_SPACE_DISPLAY_NAME_PREFIX + number);
        space.setPrettyName(space.getDisplayName());
        space.setRegistration("open");
        space.setDescription(SPACE_DESCRIPTION + number);
        space.setVisibility("public");
        space.setRegistration("validation");
        space.setUrl(space.getPrettyName());
        space.setMembers(new String[]{JOHN_NAME, MARY_NAME});
        space = this.createSpaceNonInitApps(space, JOHN_NAME, null);
        Space savedSpace = this.spaceService.getSpaceById(space.getId());
        this.spaceService.addMember(savedSpace, userToBind);
        Group groupToBind = this.organizationService.getGroupHandler().createGroupInstance();
        String groupName = "groupForSpaceToBind";
        String groupId = "/" + groupName;
        groupToBind.setId(groupId);
        groupToBind.setGroupName(groupName);
        groupToBind.setLabel(groupName);
        this.organizationService.getGroupHandler().addChild(null, groupToBind, true);
        MembershipType membershipType = this.organizationService.getMembershipTypeHandler().findMembershipType("member");
        User user = this.organizationService.getUserHandler().findUserByName(userToBind);
        this.organizationService.getMembershipHandler().linkMembership(user, groupToBind, membershipType, true);
        Membership membership = this.organizationService.getMembershipHandler().findMembershipByUserGroupAndType(user.getUserName(), groupToBind.getId(), membershipType.getName());
        SpaceServiceTest.assertNotNull((Object)membership);
        this.restartTransaction();
        GroupSpaceBindingService groupSpaceBindingService = (GroupSpaceBindingService)this.getContainer().getComponentInstanceOfType(GroupSpaceBindingService.class);
        GroupSpaceBinding groupSpaceBinding = new GroupSpaceBinding(space.getId(), groupToBind.getId());
        groupSpaceBindingService.saveGroupSpaceBinding(groupSpaceBinding);
        this.restartTransaction();
        List groupSpaceBindings = groupSpaceBindingService.findGroupSpaceBindingsBySpace(savedSpace.getId());
        SpaceServiceTest.assertNotNull((Object)groupSpaceBindings);
        SpaceServiceTest.assertEquals((int)1, (int)groupSpaceBindings.size());
        groupSpaceBinding = (GroupSpaceBinding)groupSpaceBindings.get(0);
        groupSpaceBindingService.bindUsersFromGroupSpaceBinding(groupSpaceBinding);
        this.restartTransaction();
        Assert.assertThrows(IllegalStateException.class, () -> this.spaceService.removeMember(savedSpace, userToBind));
        Assert.assertThrows(IllegalStateException.class, () -> this.organizationService.getMembershipHandler().removeMembership(String.format("%s:%s:%s", "member", userToBind, savedSpace.getGroupId()), true));
        membership = this.organizationService.getMembershipHandler().findMembershipByUserGroupAndType(user.getUserName(), groupToBind.getId(), membershipType.getName());
        SpaceServiceTest.assertNotNull((Object)membership);
        membership = this.organizationService.getMembershipHandler().findMembershipByUserGroupAndType(user.getUserName(), savedSpace.getGroupId(), "member");
        SpaceServiceTest.assertNotNull((Object)membership);
        SpaceServiceTest.assertTrue((boolean)this.spaceService.isMember(savedSpace, userToBind));
        groupSpaceBindingService.deleteAllSpaceBindingsBySpace(savedSpace.getId());
        this.restartTransaction();
        this.spaceService.removeMember(savedSpace, userToBind);
        SpaceServiceTest.assertFalse((boolean)this.spaceService.isMember(savedSpace, userToBind));
        membership = this.organizationService.getMembershipHandler().findMembershipByUserGroupAndType(user.getUserName(), groupToBind.getId(), membershipType.getName());
        SpaceServiceTest.assertNotNull((Object)membership);
        membership = this.organizationService.getMembershipHandler().findMembershipByUserGroupAndType(user.getUserName(), savedSpace.getGroupId(), "member");
        SpaceServiceTest.assertNull((Object)membership);
    }

    public void testGetMemberSpaces() {
        Space[] listSpace = new Space[10];
        for (int i = 0; i < listSpace.length; ++i) {
            listSpace[i] = this.getSpaceInstance(i);
        }
        this.restartTransaction();
        String raulUsername = RAUL_NAME;
        String jameUsername = JAME_NAME;
        List spaceIds = this.spaceService.getMemberSpacesIds(raulUsername, 0, -1);
        SpaceServiceTest.assertNotNull((Object)spaceIds);
        SpaceServiceTest.assertEquals((int)listSpace.length, (int)spaceIds.size());
        spaceIds = this.spaceService.getMemberSpacesIds(raulUsername, 0, listSpace.length);
        SpaceServiceTest.assertNotNull((Object)spaceIds);
        SpaceServiceTest.assertEquals((int)listSpace.length, (int)spaceIds.size());
        spaceIds = this.spaceService.getMemberSpacesIds(raulUsername, 0, listSpace.length / 2);
        SpaceServiceTest.assertNotNull((Object)spaceIds);
        SpaceServiceTest.assertEquals((int)(listSpace.length / 2), (int)spaceIds.size());
        spaceIds = this.spaceService.getMemberSpacesIds(raulUsername, listSpace.length / 2, listSpace.length / 2);
        SpaceServiceTest.assertNotNull((Object)spaceIds);
        SpaceServiceTest.assertEquals((int)(listSpace.length / 2), (int)spaceIds.size());
        Space space0 = this.spaceService.getSpaceById((String)spaceIds.get(0));
        SpaceServiceTest.assertNotNull((Object)space0);
        this.spaceService.removeMember(space0, raulUsername);
        this.restartTransaction();
        spaceIds = this.spaceService.getMemberSpacesIds(raulUsername, 0, -1);
        SpaceServiceTest.assertNotNull((Object)spaceIds);
        SpaceServiceTest.assertEquals((int)(listSpace.length - 1), (int)spaceIds.size());
        spaceIds = this.spaceService.getMemberSpacesIds(jameUsername, 0, -1);
        SpaceServiceTest.assertNotNull((Object)spaceIds);
        SpaceServiceTest.assertEquals((int)0, (int)spaceIds.size());
    }

    public void testIsMember() {
        Space space = this.getSpaceInstance(0);
        Space savedSpace = this.spaceService.getSpaceById(space.getId());
        SpaceServiceTest.assertNotNull((Object)savedSpace);
        SpaceServiceTest.assertTrue((String)"spaceService.isMember(savedSpace, \"raul\") must return true", (boolean)this.spaceService.isMember(savedSpace, RAUL_NAME));
        SpaceServiceTest.assertTrue((String)"spaceService.isMember(savedSpace, \"ghost\") must return true", (boolean)this.spaceService.isMember(savedSpace, GHOST_NAME));
        SpaceServiceTest.assertTrue((String)"spaceService.isMember(savedSpace, \"dragon\") must return true", (boolean)this.spaceService.isMember(savedSpace, DRAGON_NAME));
        SpaceServiceTest.assertFalse((String)"spaceService.isMember(savedSpace, \"stranger\") must return true", (boolean)this.spaceService.isMember(savedSpace, "stranger"));
    }

    public void testRevokeRequestJoin() {
        Space space = this.getSpaceInstance(0);
        int pendingUsersCount = space.getPendingUsers().length;
        SpaceServiceTest.assertFalse((String)"ArrayUtils.contains(space.getPendingUsers(), newPendingUser) must be false", (boolean)ArrayUtils.contains((Object[])space.getPendingUsers(), (Object)this.newPendingUser.getRemoteId()));
        this.spaceService.addPendingUser(space, this.newPendingUser.getRemoteId());
        space = this.spaceService.getSpaceById(space.getId());
        SpaceServiceTest.assertEquals((int)(pendingUsersCount + 1), (int)space.getPendingUsers().length);
        SpaceServiceTest.assertTrue((boolean)ArrayUtils.contains((Object[])space.getPendingUsers(), (Object)this.newPendingUser.getRemoteId()));
        this.spaceService.removePendingUser(space, this.newPendingUser.getRemoteId());
        space = this.spaceService.getSpaceById(space.getId());
        SpaceServiceTest.assertEquals((String)("space.getPendingUsers().length must return: " + pendingUsersCount), (int)pendingUsersCount, (int)space.getPendingUsers().length);
        SpaceServiceTest.assertFalse((boolean)ArrayUtils.contains((Object[])space.getPendingUsers(), (Object)this.newPendingUser.getRemoteId()));
    }

    public void testDenyInvitation() {
        Space space = this.getSpaceInstance(0);
        Space savedSpace = this.spaceService.getSpaceById(space.getId());
        SpaceServiceTest.assertNotNull((Object)savedSpace);
        this.spaceService.removeInvitedUser(savedSpace, "new member 1");
        this.spaceService.removeInvitedUser(savedSpace, "new member 2");
        this.spaceService.removeInvitedUser(savedSpace, "new member 3");
        SpaceServiceTest.assertEquals((String)"savedSpace.getMembers().length must return 2", (int)2, (int)savedSpace.getInvitedUsers().length);
        this.spaceService.removeInvitedUser(savedSpace, RAUL_NAME);
        this.spaceService.removeInvitedUser(savedSpace, GHOST_NAME);
        this.spaceService.removeInvitedUser(savedSpace, DRAGON_NAME);
        SpaceServiceTest.assertEquals((String)"savedSpace.getMembers().length must return 2", (int)2, (int)savedSpace.getInvitedUsers().length);
        this.spaceService.removeInvitedUser(savedSpace, REGISTER1_NAME);
        this.spaceService.removeInvitedUser(savedSpace, MARY_NAME);
        SpaceServiceTest.assertEquals((String)"savedSpace.getMembers().length must return 0", (int)0, (int)savedSpace.getInvitedUsers().length);
    }

    public void testGetVisibleSpaces() throws Exception {
        int countSpace = 10;
        Space[] listSpace = new Space[10];
        for (int i = 0; i < countSpace; ++i) {
            listSpace[i] = i < 6 ? this.getSpaceInstance(i, "private", "open", DEMO_NAME, new String[0]) : this.getSpaceInstance(i, "hidden", "open", DEMO_NAME, new String[0]);
            this.spaceService.createSpace(listSpace[i]);
        }
        Space[] visibleAllSpaces = (Space[])this.spaceService.getVisibleSpacesWithListAccess(DEMO_NAME, null).load(0, countSpace * 2);
        SpaceServiceTest.assertNotNull((Object)visibleAllSpaces);
        SpaceServiceTest.assertEquals((int)countSpace, (int)visibleAllSpaces.length);
    }

    public void testGetVisibleSpacesCloseRegistration() throws Exception {
        int countSpace = 10;
        Space[] listSpace = new Space[10];
        for (int i = 0; i < countSpace; ++i) {
            listSpace[i] = i < 6 ? this.getSpaceInstance(i, "private", "closed", DEMO_NAME, new String[0]) : this.getSpaceInstance(i, "hidden", "closed", DEMO_NAME, new String[0]);
            this.spaceService.createSpace(listSpace[i]);
        }
        Space[] visibleAllSpaces = (Space[])this.spaceService.getVisibleSpacesWithListAccess(DEMO_NAME, null).load(0, countSpace * 2);
        SpaceServiceTest.assertNotNull((Object)visibleAllSpaces);
        SpaceServiceTest.assertEquals((int)countSpace, (int)visibleAllSpaces.length);
        int registrationCloseSpaceCount = 6;
        visibleAllSpaces = (Space[])this.spaceService.getVisibleSpacesWithListAccess(MARY_NAME, null).load(0, registrationCloseSpaceCount * 2);
        SpaceServiceTest.assertNotNull((String)"registrationCloseSpaces must not be  null", (Object)visibleAllSpaces);
        SpaceServiceTest.assertEquals((String)("registrationCloseSpaces must return: " + registrationCloseSpaceCount), (int)registrationCloseSpaceCount, (int)visibleAllSpaces.length);
    }

    public void testGetVisibleSpacesInvitedMember() throws Exception {
        int countSpace = 10;
        Space[] listSpace = new Space[10];
        for (int i = 0; i < countSpace; ++i) {
            listSpace[i] = i < 6 ? this.getSpaceInstanceInvitedMember(i, "private", "closed", new String[]{MARY_NAME, HACKER_NAME}, DEMO_NAME, new String[0]) : this.getSpaceInstance(i, "hidden", "closed", DEMO_NAME, new String[0]);
            this.spaceService.createSpace(listSpace[i]);
        }
        Space[] visibleAllSpaces = (Space[])this.spaceService.getVisibleSpacesWithListAccess(DEMO_NAME, null).load(0, countSpace * 2);
        SpaceServiceTest.assertNotNull((Object)visibleAllSpaces);
        SpaceServiceTest.assertEquals((int)countSpace, (int)visibleAllSpaces.length);
        int invitedSpaceCount1 = 6;
        Space[] invitedSpaces1 = (Space[])this.spaceService.getVisibleSpacesWithListAccess(MARY_NAME, null).load(0, invitedSpaceCount1 * 2);
        SpaceServiceTest.assertNotNull((Object)invitedSpaces1);
        SpaceServiceTest.assertEquals((int)invitedSpaceCount1, (int)invitedSpaces1.length);
        invitedSpaceCount1 = 6;
        invitedSpaces1 = (Space[])this.spaceService.getVisibleSpacesWithListAccess(HACKER_NAME, null).load(0, invitedSpaceCount1 * 2);
        SpaceServiceTest.assertNotNull((Object)invitedSpaces1);
        SpaceServiceTest.assertEquals((int)invitedSpaceCount1, (int)invitedSpaces1.length);
        int invitedSpaceCount2 = 6;
        Space[] invitedSpaces2 = (Space[])this.spaceService.getVisibleSpacesWithListAccess(PAUL_NAME, null).load(0, invitedSpaceCount2 * 2);
        SpaceServiceTest.assertNotNull((Object)invitedSpaces2);
        SpaceServiceTest.assertEquals((int)invitedSpaceCount2, (int)invitedSpaces2.length);
    }

    public void testGetLastSpaces() throws SpaceException {
        this.populateData();
        this.createMoreSpace(SPACE2_DISPLAY_NAME);
        List lastSpaces = this.spaceService.getLastSpaces(1);
        SpaceServiceTest.assertEquals((int)1, (int)lastSpaces.size());
        Space sp1 = (Space)lastSpaces.get(0);
        lastSpaces = this.spaceService.getLastSpaces(1);
        SpaceServiceTest.assertEquals((int)1, (int)lastSpaces.size());
        SpaceServiceTest.assertEquals((Object)sp1, lastSpaces.get(0));
        lastSpaces = this.spaceService.getLastSpaces(5);
        SpaceServiceTest.assertEquals((int)2, (int)lastSpaces.size());
        SpaceServiceTest.assertEquals((Object)sp1, lastSpaces.get(0));
        Space newSp1 = this.createMoreSpace("newSp1");
        lastSpaces = this.spaceService.getLastSpaces(1);
        SpaceServiceTest.assertEquals((int)1, (int)lastSpaces.size());
        SpaceServiceTest.assertEquals((Object)newSp1, lastSpaces.get(0));
        lastSpaces = this.spaceService.getLastSpaces(5);
        SpaceServiceTest.assertEquals((int)3, (int)lastSpaces.size());
        SpaceServiceTest.assertEquals((Object)newSp1, lastSpaces.get(0));
        Space newSp2 = this.createMoreSpace("newSp2");
        lastSpaces = this.spaceService.getLastSpaces(1);
        SpaceServiceTest.assertEquals((int)1, (int)lastSpaces.size());
        SpaceServiceTest.assertEquals((Object)newSp2, lastSpaces.get(0));
        lastSpaces = this.spaceService.getLastSpaces(5);
        SpaceServiceTest.assertEquals((int)4, (int)lastSpaces.size());
        SpaceServiceTest.assertEquals((Object)newSp2, lastSpaces.get(0));
        SpaceServiceTest.assertEquals((Object)newSp1, lastSpaces.get(1));
        this.spaceService.deleteSpace(newSp1);
        lastSpaces = this.spaceService.getLastSpaces(5);
        SpaceServiceTest.assertEquals((int)3, (int)lastSpaces.size());
        SpaceServiceTest.assertEquals((Object)newSp2, lastSpaces.get(0));
        SpaceServiceTest.assertFalse((boolean)newSp1.equals(lastSpaces.get(1)));
        this.spaceService.deleteSpace(newSp2);
        lastSpaces = this.spaceService.getLastSpaces(5);
        SpaceServiceTest.assertEquals((int)2, (int)lastSpaces.size());
        SpaceServiceTest.assertEquals((Object)sp1, lastSpaces.get(0));
    }

    public void testInviteSuperManager() throws Exception {
        String username = "ali";
        User superManager = this.organizationService.getUserHandler().createUserInstance(username);
        this.organizationService.getUserHandler().createUser(superManager, false);
        org.exoplatform.social.core.identity.model.Identity superManagerIdentity = this.identityManager.getOrCreateUserIdentity(username);
        SpaceServiceTest.assertFalse((boolean)this.spaceService.isSuperManager(username));
        Group group = this.organizationService.getGroupHandler().findGroupById(PLATFORM_ADMINISTRATORS);
        MembershipType msType = this.organizationService.getMembershipTypeHandler().findMembershipType(MANAGER_NAME);
        this.organizationService.getMembershipHandler().linkMembership(superManager, group, msType, true);
        this.restartTransaction();
        SpaceServiceTest.assertTrue((boolean)this.spaceService.isSuperManager(username));
        Space space = this.createSpace("spacename1", ROOT_NAME);
        this.spaceService.inviteIdentities(space, Collections.singletonList(superManagerIdentity));
        space = this.spaceService.getSpaceById(space.getId());
        SpaceServiceTest.assertTrue((boolean)this.spaceService.isInvitedUser(space, username));
    }

    public void testExternalSpaceInvitations() {
        this.spaceService.saveSpaceExternalInvitation("5", EXTERNAL_USER_EMAIL, "test");
        this.spaceService.saveSpaceExternalInvitation("5", EXTERNAL1_USER_EMAIL, "test");
        this.spaceService.saveSpaceExternalInvitation("6", EXTERNAL_USER_EMAIL, "test");
        this.spaceService.saveSpaceExternalInvitation("7", EXTERNAL2_USER_EMAIL, "test");
        this.spaceService.saveSpaceExternalInvitation("7", EXTERNAL3_USER_EMAIL, "test");
        List spaceExternalInvitationEntities = this.spaceService.findSpaceExternalInvitationsBySpaceId("5");
        SpaceServiceTest.assertNotNull((Object)spaceExternalInvitationEntities);
        SpaceServiceTest.assertEquals((int)2, (int)spaceExternalInvitationEntities.size());
        List spaceIds = this.spaceService.findExternalInvitationsSpacesByEmail(EXTERNAL_USER_EMAIL);
        SpaceServiceTest.assertNotNull((Object)spaceIds);
        SpaceServiceTest.assertEquals((int)2, (int)spaceExternalInvitationEntities.size());
        this.spaceService.deleteExternalUserInvitations(EXTERNAL_USER_EMAIL);
        List spaceExternalInvitationEntities1 = this.spaceService.findSpaceExternalInvitationsBySpaceId("5");
        SpaceServiceTest.assertNotNull((Object)spaceExternalInvitationEntities);
        SpaceServiceTest.assertEquals((int)1, (int)spaceExternalInvitationEntities1.size());
        List spaceIds2 = this.spaceService.findExternalInvitationsSpacesByEmail(EXTERNAL2_USER_EMAIL);
        SpaceServiceTest.assertEquals((int)1, (int)spaceIds2.size());
    }

    public void testDeleteSpaceExternalInvitation() {
        this.spaceService.saveSpaceExternalInvitation("8", EXTERNAL_USER_EMAIL, "token");
        this.spaceService.saveSpaceExternalInvitation("8", EXTERNAL1_USER_EMAIL, "token1");
        this.spaceService.saveSpaceExternalInvitation("8", EXTERNAL2_USER_EMAIL, "token2");
        List spaceExternalInvitationEntities = this.spaceService.findSpaceExternalInvitationsBySpaceId("8");
        SpaceServiceTest.assertNotNull((Object)spaceExternalInvitationEntities);
        SpaceServiceTest.assertEquals((int)3, (int)spaceExternalInvitationEntities.size());
        this.spaceService.deleteSpaceExternalInvitation(((SpaceExternalInvitation)spaceExternalInvitationEntities.get(0)).getInvitationId().toString());
        List spaceExternalInvitationEntities1 = this.spaceService.findSpaceExternalInvitationsBySpaceId("8");
        SpaceServiceTest.assertNotNull((Object)spaceExternalInvitationEntities1);
        SpaceServiceTest.assertEquals((int)2, (int)spaceExternalInvitationEntities1.size());
        this.spaceService.deleteSpaceExternalInvitation(((SpaceExternalInvitation)spaceExternalInvitationEntities1.get(0)).getInvitationId().toString());
        this.spaceService.deleteSpaceExternalInvitation(((SpaceExternalInvitation)spaceExternalInvitationEntities1.get(1)).getInvitationId().toString());
        List spaceExternalInvitationEntities2 = this.spaceService.findSpaceExternalInvitationsBySpaceId("8");
        SpaceServiceTest.assertNotNull((Object)spaceExternalInvitationEntities2);
        SpaceServiceTest.assertEquals((int)0, (int)spaceExternalInvitationEntities2.size());
    }

    public void testIsSuperManager() throws Exception {
        Space space = this.createSpace("spacename1", ROOT_NAME);
        space.setVisibility("public");
        space.setRegistration("open");
        this.spaceService.updateSpace(space);
        space = this.createSpace("spacename2", ROOT_NAME);
        space.setVisibility("public");
        space.setRegistration("closed");
        this.spaceService.updateSpace(space);
        space = this.createSpace("spacename3", ROOT_NAME);
        space.setVisibility("private");
        space.setRegistration("open");
        this.spaceService.updateSpace(space);
        space = this.createSpace("spacename4", ROOT_NAME);
        space.setVisibility("private");
        space.setRegistration("closed");
        this.spaceService.updateSpace(space);
        space = this.createSpace("spacename5", ROOT_NAME);
        space.setVisibility("hidden");
        space.setRegistration("open");
        this.spaceService.updateSpace(space);
        space = this.createSpace("spacename6", ROOT_NAME);
        space.setVisibility("hidden");
        space.setRegistration("closed");
        this.spaceService.updateSpace(space);
        User user = this.organizationService.getUserHandler().createUserInstance("user-space-admin");
        this.organizationService.getUserHandler().createUser(user, false);
        Group group = this.organizationService.getGroupHandler().findGroupById(PLATFORM_ADMINISTRATORS);
        MembershipType mstype = this.organizationService.getMembershipTypeHandler().findMembershipType(MANAGER_NAME);
        this.organizationService.getMembershipHandler().linkMembership(user, group, mstype, true);
        this.restartTransaction();
        String userName = user.getUserName();
        SpaceServiceTest.assertEquals((int)6, (int)this.spaceService.getAllSpacesWithListAccess().getSize());
        SpaceServiceTest.assertTrue((boolean)this.spaceService.isSuperManager(userName));
    }

    public void testCanAccessSpacePublicSite() {
        this.checkExternalUserMemberships();
        Space space = this.getSpaceInstance(20);
        String spaceId = space.getId();
        SpaceServiceTest.assertFalse((boolean)this.spaceService.canAccessSpacePublicSite(null, DEMO_NAME));
        SpaceServiceTest.assertFalse((boolean)this.spaceService.canAccessSpacePublicSite(space, null));
        SpaceServiceTest.assertFalse((boolean)this.spaceService.canAccessSpacePublicSite(space, DEMO_NAME));
        SpaceServiceTest.assertFalse((boolean)this.spaceService.canAccessSpacePublicSite(space, JOHN_NAME));
        SpaceServiceTest.assertFalse((boolean)this.spaceService.canAccessSpacePublicSite(space, EXTERNAL_USER_NAME));
        SpaceServiceTest.assertFalse((boolean)this.spaceService.canAccessSpacePublicSite(space, IdentityConstants.ANONIM));
        this.spaceLayoutService.saveSpacePublicSite(spaceId, MANAGER_NAME, DEMO_NAME);
        space = this.spaceService.getSpaceById(spaceId);
        SpaceServiceTest.assertTrue((boolean)this.spaceService.canAccessSpacePublicSite(space, JOHN_NAME));
        SpaceServiceTest.assertTrue((boolean)this.spaceService.canAccessSpacePublicSite(space, DEMO_NAME));
        SpaceServiceTest.assertFalse((boolean)this.spaceService.canAccessSpacePublicSite(space, RAUL_NAME));
        SpaceServiceTest.assertFalse((boolean)this.spaceService.canAccessSpacePublicSite(space, MARY_NAME));
        SpaceServiceTest.assertFalse((boolean)this.spaceService.canAccessSpacePublicSite(space, PAUL_NAME));
        SpaceServiceTest.assertFalse((boolean)this.spaceService.canAccessSpacePublicSite(space, EXTERNAL_USER_NAME));
        SpaceServiceTest.assertFalse((boolean)this.spaceService.canAccessSpacePublicSite(space, null));
        SpaceServiceTest.assertFalse((boolean)this.spaceService.canAccessSpacePublicSite(space, IdentityConstants.ANONIM));
        this.spaceLayoutService.saveSpacePublicSite(spaceId, "member", DEMO_NAME);
        space = this.spaceService.getSpaceById(spaceId);
        SpaceServiceTest.assertTrue((boolean)this.spaceService.canAccessSpacePublicSite(space, JOHN_NAME));
        SpaceServiceTest.assertTrue((boolean)this.spaceService.canAccessSpacePublicSite(space, DEMO_NAME));
        SpaceServiceTest.assertTrue((boolean)this.spaceService.canAccessSpacePublicSite(space, RAUL_NAME));
        SpaceServiceTest.assertFalse((boolean)this.spaceService.canAccessSpacePublicSite(space, MARY_NAME));
        SpaceServiceTest.assertFalse((boolean)this.spaceService.canAccessSpacePublicSite(space, PAUL_NAME));
        SpaceServiceTest.assertFalse((boolean)this.spaceService.canAccessSpacePublicSite(space, EXTERNAL_USER_NAME));
        SpaceServiceTest.assertFalse((boolean)this.spaceService.canAccessSpacePublicSite(space, null));
        SpaceServiceTest.assertFalse((boolean)this.spaceService.canAccessSpacePublicSite(space, IdentityConstants.ANONIM));
        this.spaceLayoutService.saveSpacePublicSite(spaceId, "internal", DEMO_NAME);
        space = this.spaceService.getSpaceById(spaceId);
        SpaceServiceTest.assertTrue((boolean)this.spaceService.canAccessSpacePublicSite(space, JOHN_NAME));
        SpaceServiceTest.assertTrue((boolean)this.spaceService.canAccessSpacePublicSite(space, RAUL_NAME));
        SpaceServiceTest.assertTrue((boolean)this.spaceService.canAccessSpacePublicSite(space, MARY_NAME));
        SpaceServiceTest.assertTrue((boolean)this.spaceService.canAccessSpacePublicSite(space, PAUL_NAME));
        SpaceServiceTest.assertFalse((boolean)this.spaceService.canAccessSpacePublicSite(space, EXTERNAL_USER_NAME));
        SpaceServiceTest.assertFalse((boolean)this.spaceService.canAccessSpacePublicSite(space, null));
        SpaceServiceTest.assertFalse((boolean)this.spaceService.canAccessSpacePublicSite(space, IdentityConstants.ANONIM));
        this.spaceLayoutService.saveSpacePublicSite(spaceId, "authenticated", DEMO_NAME);
        space = this.spaceService.getSpaceById(spaceId);
        SpaceServiceTest.assertTrue((boolean)this.spaceService.canAccessSpacePublicSite(space, JOHN_NAME));
        SpaceServiceTest.assertTrue((boolean)this.spaceService.canAccessSpacePublicSite(space, DEMO_NAME));
        SpaceServiceTest.assertTrue((boolean)this.spaceService.canAccessSpacePublicSite(space, RAUL_NAME));
        SpaceServiceTest.assertTrue((boolean)this.spaceService.canAccessSpacePublicSite(space, MARY_NAME));
        SpaceServiceTest.assertTrue((boolean)this.spaceService.canAccessSpacePublicSite(space, PAUL_NAME));
        SpaceServiceTest.assertTrue((boolean)this.spaceService.canAccessSpacePublicSite(space, EXTERNAL_USER_NAME));
        SpaceServiceTest.assertFalse((boolean)this.spaceService.canAccessSpacePublicSite(space, null));
        SpaceServiceTest.assertFalse((boolean)this.spaceService.canAccessSpacePublicSite(space, IdentityConstants.ANONIM));
        this.spaceLayoutService.saveSpacePublicSite(spaceId, "everyone", DEMO_NAME);
        space = this.spaceService.getSpaceById(spaceId);
        SpaceServiceTest.assertTrue((boolean)this.spaceService.canAccessSpacePublicSite(space, ROOT_NAME));
        SpaceServiceTest.assertTrue((boolean)this.spaceService.canAccessSpacePublicSite(space, JOHN_NAME));
        SpaceServiceTest.assertTrue((boolean)this.spaceService.canAccessSpacePublicSite(space, DEMO_NAME));
        SpaceServiceTest.assertTrue((boolean)this.spaceService.canAccessSpacePublicSite(space, RAUL_NAME));
        SpaceServiceTest.assertTrue((boolean)this.spaceService.canAccessSpacePublicSite(space, MARY_NAME));
        SpaceServiceTest.assertTrue((boolean)this.spaceService.canAccessSpacePublicSite(space, PAUL_NAME));
        SpaceServiceTest.assertTrue((boolean)this.spaceService.canAccessSpacePublicSite(space, EXTERNAL_USER_NAME));
        SpaceServiceTest.assertTrue((boolean)this.spaceService.canAccessSpacePublicSite(space, null));
        SpaceServiceTest.assertTrue((boolean)this.spaceService.canAccessSpacePublicSite(space, IdentityConstants.ANONIM));
    }

    private Space populateData() {
        String spaceDisplayName = SPACE1_DISPLAY_NAME;
        Space space1 = new Space();
        space1.setDisplayName(spaceDisplayName);
        space1.setRegistration("validation");
        space1.setDescription("This is my first space for testing");
        space1.setVisibility("public");
        space1.setEditor(ROOT_NAME);
        Space createdSpace = this.spaceService.createSpace(space1);
        String[] members = new String[]{DEMO_NAME, JOHN_NAME, MARY_NAME, TOM_NAME};
        Arrays.stream(members).forEach(u -> this.spaceService.addMember(createdSpace, u));
        return createdSpace;
    }

    private Space createSpace(String spaceName, String username) {
        Space space = new Space();
        space.setDisplayName(spaceName);
        space.setPrettyName(spaceName);
        space.setRegistration("open");
        space.setDescription("description of space" + spaceName);
        space.setVisibility("private");
        return this.spaceService.createSpace(space, username);
    }

    private Space getSpaceInstance(int number) {
        Space space = new Space();
        space.setDisplayName(MY_SPACE_DISPLAY_NAME_PREFIX + number);
        space.setPrettyName(space.getDisplayName());
        space.setDescription(SPACE_DESCRIPTION + number);
        space.setVisibility("public");
        space.setRegistration("validation");
        String[] managers = new String[]{DEMO_NAME, TOM_NAME};
        String[] members = new String[]{DEMO_NAME, RAUL_NAME, GHOST_NAME, DRAGON_NAME};
        String[] invitedUsers = new String[]{REGISTER1_NAME, MARY_NAME};
        String[] pendingUsers = new String[]{JAME_NAME, PAUL_NAME, HACKER_NAME};
        Space createdSpace = this.spaceService.createSpace(space, DEMO_NAME);
        Arrays.stream(pendingUsers).forEach(u -> this.spaceService.addPendingUser(createdSpace, u));
        Arrays.stream(invitedUsers).forEach(u -> this.spaceService.addInvitedUser(createdSpace, u));
        Arrays.stream(members).forEach(u -> this.spaceService.addMember(createdSpace, u));
        Arrays.stream(managers).forEach(u -> this.spaceService.addMember(createdSpace, u));
        Arrays.stream(managers).forEach(u -> this.spaceService.setManager(createdSpace, u, true));
        return createdSpace;
    }

    private Space getSpaceInstanceInvitedMember(int number, String visible, String registration, String[] invitedMember, String manager, String ... members) {
        Space space = new Space();
        space.setDisplayName(MY_SPACE_DISPLAY_NAME_PREFIX + number);
        space.setPrettyName(space.getDisplayName());
        space.setRegistration(registration);
        space.setDescription(SPACE_DESCRIPTION + number);
        space.setVisibility(visible);
        space.setUrl(space.getPrettyName());
        String[] managers = new String[]{manager};
        String[] pendingUsers = new String[]{};
        space.setInvitedUsers(invitedMember);
        space.setPendingUsers(pendingUsers);
        space.setManagers(managers);
        space.setMembers(members);
        return space;
    }

    private Space createMoreSpace(String spaceName) {
        Space space2 = new Space();
        space2.setDisplayName(spaceName);
        space2.setPrettyName(space2.getDisplayName());
        String shortName = Utils.cleanString((String)spaceName);
        space2.setGroupId(SPACES_GROUP_PREFIX + shortName);
        space2.setUrl(shortName);
        space2.setRegistration("open");
        space2.setDescription("This is my second space for testing");
        space2.setVisibility("public");
        space2.setEditor(ROOT_NAME);
        this.spaceService.createSpace(space2);
        Thread.sleep(1L);
        return space2;
    }

    public void testSpaceContainsExternalMembers() {
        this.checkExternalUserMemberships();
        this.externalUser.getProfile().setProperty("external", (Object)"true");
        this.identityStorage.saveIdentity(this.externalUser);
        Space space = this.getSpaceInstance(10);
        SpaceServiceTest.assertFalse((boolean)this.spaceService.isSpaceContainsExternals(Long.valueOf(space.getId())));
        this.spaceService.addMember(space, EXTERNAL_USER_NAME);
        SpaceServiceTest.assertTrue((boolean)this.spaceService.isSpaceContainsExternals(Long.valueOf(space.getId())));
    }

    public void testGetCommonSpaces() throws Exception {
        this.getSpaceInstance(11);
        Space space1 = this.getSpaceInstance(12);
        Space space2 = this.getSpaceInstance(13);
        Space space3 = this.getSpaceInstance(14);
        Space space4 = this.getSpaceInstance(15);
        Space space5 = this.getSpaceInstance(16);
        User otherUser = this.organizationService.getUserHandler().createUserInstance(OTHER_USER_NAME);
        this.organizationService.getUserHandler().createUser(otherUser, false);
        this.spaceService.addMember(space1, OTHER_USER_NAME);
        this.spaceService.addMember(space2, OTHER_USER_NAME);
        this.spaceService.addMember(space3, OTHER_USER_NAME);
        this.spaceService.addMember(space4, OTHER_USER_NAME);
        this.spaceService.addMember(space5, OTHER_USER_NAME);
        ListAccess resultListCommonSpacesAccessList1 = this.spaceService.getCommonSpaces(DEMO_NAME, OTHER_USER_NAME);
        SpaceServiceTest.assertEquals((int)5, (int)resultListCommonSpacesAccessList1.getSize());
        Space[] spaceArray = (Space[])resultListCommonSpacesAccessList1.load(0, 2);
        SpaceServiceTest.assertEquals((int)2, (int)spaceArray.length);
        Space testSpace1 = spaceArray[0];
        SpaceServiceTest.assertEquals((Object)space1, (Object)testSpace1);
        Space testSpace2 = spaceArray[1];
        SpaceServiceTest.assertEquals((Object)space2, (Object)testSpace2);
        spaceArray = (Space[])resultListCommonSpacesAccessList1.load(2, 2);
        SpaceServiceTest.assertEquals((int)2, (int)spaceArray.length);
        Space testSpace3 = spaceArray[0];
        SpaceServiceTest.assertEquals((Object)space3, (Object)testSpace3);
        Space testSpace4 = spaceArray[1];
        SpaceServiceTest.assertEquals((Object)space4, (Object)testSpace4);
        spaceArray = (Space[])resultListCommonSpacesAccessList1.load(4, 2);
        SpaceServiceTest.assertEquals((int)1, (int)spaceArray.length);
        Space testSpace5 = spaceArray[0];
        SpaceServiceTest.assertEquals((Object)space5, (Object)testSpace5);
    }

    private void checkExternalUserMemberships() {
        Collection externalMemberships;
        Collection internalMemberships = this.organizationService.getMembershipHandler().findMembershipsByUserAndGroup(EXTERNAL_USER_NAME, "/platform/users");
        if (CollectionUtils.isNotEmpty((Collection)internalMemberships)) {
            internalMemberships.forEach(this::removeMembership);
        }
        if (CollectionUtils.isEmpty((Collection)(externalMemberships = this.organizationService.getMembershipHandler().findMembershipsByUserAndGroup(EXTERNAL_USER_NAME, "/platform/externals")))) {
            this.organizationService.getMembershipHandler().linkMembership(this.organizationService.getUserHandler().findUserByName(EXTERNAL_USER_NAME), this.organizationService.getGroupHandler().findGroupById("/platform/externals"), this.organizationService.getMembershipTypeHandler().findMembershipType("member"), true);
        }
        this.restartTransaction();
    }

    private Membership removeMembership(Membership m) {
        return this.organizationService.getMembershipHandler().removeMembership(m.getId(), true);
    }

    private SpaceTemplate mockSpaceTemplate() throws ObjectNotFoundException {
        SpaceTemplateService spaceTemplateService = this.getService(SpaceTemplateService.class);
        SpaceTemplateStorage spaceTemplateStorage = this.getService(SpaceTemplateStorage.class);
        SpaceTemplateDAO spaceTemplateDao = new SpaceTemplateDAO();
        SpaceTemplate spaceTemplate = (SpaceTemplate)spaceTemplateService.getSpaceTemplates().getFirst();
        if (spaceTemplateDao.find(Long.valueOf(spaceTemplate.getId())) == null) {
            SpaceTemplateEntity spaceTemplateEntity = EntityMapper.toEntity((SpaceTemplate)spaceTemplate);
            spaceTemplateEntity.setId(null);
            spaceTemplateEntity = (SpaceTemplateEntity)spaceTemplateDao.create(spaceTemplateEntity);
            if (spaceTemplate.getId() != spaceTemplateEntity.getId().longValue()) {
                spaceTemplate.setId(spaceTemplateEntity.getId().longValue());
                spaceTemplateStorage.updateSpaceTemplate(spaceTemplate);
            }
        }
        return spaceTemplate;
    }

    public static class SpaceTemplateDAO
    extends GenericDAOJPAImpl<SpaceTemplateEntity, Long> {
    }
}

