/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.profile;

import io.meeds.social.core.profileproperty.storage.CachedProfileSettingStorage;
import java.util.List;
import org.exoplatform.commons.ObjectAlreadyExistsException;
import org.exoplatform.social.core.jpa.storage.dao.jpa.ProfilePropertySettingDAO;
import org.exoplatform.social.core.profileproperty.ProfilePropertyService;
import org.exoplatform.social.core.profileproperty.model.ProfilePropertySetting;
import org.exoplatform.social.core.test.AbstractCoreTest;
import org.junit.Assert;

public class ProfilePropertyServiceTest
extends AbstractCoreTest {
    private ProfilePropertyService profilePropertyService;
    private ProfilePropertySettingDAO profilePropertySettingDAO;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.profilePropertyService = (ProfilePropertyService)this.getContainer().getComponentInstanceOfType(ProfilePropertyService.class);
        this.profilePropertySettingDAO = (ProfilePropertySettingDAO)this.getContainer().getComponentInstanceOfType(ProfilePropertySettingDAO.class);
        this.getService(CachedProfileSettingStorage.class).clearCaches();
    }

    @Override
    public void tearDown() throws Exception {
        this.restartTransaction();
        this.profilePropertySettingDAO.deleteAll();
        super.tearDown();
    }

    public void testCreateProfilePropertySetting() throws Exception {
        Throwable exception = Assert.assertThrows(IllegalArgumentException.class, () -> this.profilePropertyService.createPropertySetting(null));
        ProfilePropertyServiceTest.assertEquals((String)"Profile property setting Item Object is mandatory", (String)exception.getMessage());
        exception = Assert.assertThrows(IllegalArgumentException.class, () -> this.profilePropertyService.createPropertySetting(new ProfilePropertySetting()));
        ProfilePropertyServiceTest.assertEquals((String)"Profile property name is mandatory", (String)exception.getMessage());
        ProfilePropertySetting profilePropertySetting = this.createProfileSettingInstance("test");
        this.profilePropertyService.createPropertySetting(profilePropertySetting);
        profilePropertySetting = this.profilePropertyService.getProfileSettingByName(profilePropertySetting.getPropertyName());
        ProfilePropertyServiceTest.assertNotNull((Object)profilePropertySetting.getId());
    }

    public void testCreateDuplicatedProfilePropertySetting() throws Exception {
        ProfilePropertySetting profilePropertySetting = this.createProfileSettingInstance("test");
        this.profilePropertyService.createPropertySetting(profilePropertySetting);
        Throwable exception1 = Assert.assertThrows(ObjectAlreadyExistsException.class, () -> this.profilePropertyService.createPropertySetting(profilePropertySetting));
        ProfilePropertyServiceTest.assertEquals((String)"A profile property with provided name already exist", (String)exception1.getMessage());
    }

    public void testDeleteProfilePropertySetting() throws Exception {
        Throwable exception1 = Assert.assertThrows(IllegalArgumentException.class, () -> this.profilePropertyService.deleteProfilePropertySetting(Long.valueOf(0L)));
        ProfilePropertyServiceTest.assertEquals((String)"Profile Property Setting Technical Identifier is mandatory", (String)exception1.getMessage());
        ProfilePropertySetting profilePropertySetting = this.createProfileSettingInstance("test");
        this.profilePropertyService.createPropertySetting(profilePropertySetting);
        profilePropertySetting = this.profilePropertyService.getProfileSettingByName(profilePropertySetting.getPropertyName());
        ProfilePropertyServiceTest.assertNotNull((Object)profilePropertySetting.getId());
        this.profilePropertyService.deleteProfilePropertySetting(profilePropertySetting.getId());
        profilePropertySetting = this.profilePropertyService.getProfileSettingByName(profilePropertySetting.getPropertyName());
        ProfilePropertyServiceTest.assertNull((Object)profilePropertySetting);
    }

    public void testUpdateProfilePropertySetting() throws Exception {
        ProfilePropertySetting profilePropertySetting = this.createProfileSettingInstance("test");
        this.profilePropertyService.createPropertySetting(profilePropertySetting);
        profilePropertySetting = this.profilePropertyService.getProfileSettingByName(profilePropertySetting.getPropertyName());
        ProfilePropertyServiceTest.assertTrue((boolean)profilePropertySetting.isActive());
        profilePropertySetting.setActive(false);
        this.profilePropertyService.updatePropertySetting(profilePropertySetting);
        profilePropertySetting = this.profilePropertyService.getProfileSettingByName(profilePropertySetting.getPropertyName());
        ProfilePropertyServiceTest.assertFalse((boolean)profilePropertySetting.isActive());
        profilePropertySetting = this.profilePropertyService.createPropertySetting(this.createProfileSettingInstance("fullName"));
        ProfilePropertyServiceTest.assertFalse((boolean)profilePropertySetting.isMultiValued());
        profilePropertySetting.setMultiValued(true);
        this.profilePropertyService.updatePropertySetting(profilePropertySetting);
        profilePropertySetting = this.profilePropertyService.getProfileSettingByName(profilePropertySetting.getPropertyName());
        ProfilePropertyServiceTest.assertFalse((boolean)profilePropertySetting.isMultiValued());
        profilePropertySetting = this.createProfileSettingInstance("urls");
        profilePropertySetting.setMultiValued(true);
        profilePropertySetting = this.profilePropertyService.createPropertySetting(profilePropertySetting);
        ProfilePropertyServiceTest.assertTrue((boolean)profilePropertySetting.isMultiValued());
        profilePropertySetting.setMultiValued(false);
        this.profilePropertyService.updatePropertySetting(profilePropertySetting);
        profilePropertySetting = this.profilePropertyService.getProfileSettingByName(profilePropertySetting.getPropertyName());
        ProfilePropertyServiceTest.assertTrue((boolean)profilePropertySetting.isMultiValued());
        profilePropertySetting.setHiddenbale(true);
        this.profilePropertyService.updatePropertySetting(profilePropertySetting);
        profilePropertySetting = this.profilePropertyService.getProfileSettingByName(profilePropertySetting.getPropertyName());
        ProfilePropertyServiceTest.assertTrue((boolean)profilePropertySetting.isHiddenbale());
        ProfilePropertySetting unHiddenableprofilePropertySetting = this.createProfileSettingInstance("fullName");
        unHiddenableprofilePropertySetting.setHiddenbale(true);
        Assert.assertThrows(IllegalArgumentException.class, () -> this.profilePropertyService.updatePropertySetting(unHiddenableprofilePropertySetting));
        ProfilePropertySetting propertySetting = this.createProfileSettingInstance("testProperty");
        propertySetting.setPropertyType("user");
        propertySetting = this.profilePropertyService.createPropertySetting(propertySetting);
        ProfilePropertyServiceTest.assertEquals((String)"user", (String)propertySetting.getPropertyType());
        propertySetting.setPropertyType("text");
        this.profilePropertyService.updatePropertySetting(propertySetting);
        ProfilePropertyServiceTest.assertEquals((String)"user", (String)this.profilePropertyService.getProfileSettingById(propertySetting.getId()).getPropertyType());
    }

    public void testGetUnhiddenableProperties() {
        ProfilePropertyServiceTest.assertNotNull((Object)this.profilePropertyService.getUnhiddenableProfileProperties());
        ProfilePropertyServiceTest.assertFalse((boolean)this.profilePropertyService.getUnhiddenableProfileProperties().isEmpty());
    }

    public void testGetExcludedSearchProperties() {
        ProfilePropertyServiceTest.assertNotNull((Object)this.profilePropertyService.getExcludedQuickSearchProperties());
        ProfilePropertyServiceTest.assertFalse((boolean)this.profilePropertyService.getExcludedQuickSearchProperties().isEmpty());
    }

    public void testIsPropertySettingHiddenable() throws ObjectAlreadyExistsException {
        ProfilePropertySetting unHiddenableprofilePropertySetting = this.createProfileSettingInstance("fullName");
        ProfilePropertySetting hiddenableprofilePropertySetting = this.createProfileSettingInstance("prop");
        hiddenableprofilePropertySetting.setHiddenbale(true);
        ProfilePropertySetting propertySetting = this.profilePropertyService.createPropertySetting(hiddenableprofilePropertySetting);
        ProfilePropertySetting childProp = this.createProfileSettingInstance("childProp");
        ProfilePropertyServiceTest.assertFalse((boolean)this.profilePropertyService.isPropertySettingHiddenable(unHiddenableprofilePropertySetting));
        ProfilePropertyServiceTest.assertTrue((boolean)this.profilePropertyService.isPropertySettingHiddenable(hiddenableprofilePropertySetting));
        ProfilePropertySetting chilePropertySetting = this.profilePropertyService.createPropertySetting(childProp);
        chilePropertySetting.setParentId(propertySetting.getId());
        this.profilePropertyService.updatePropertySetting(chilePropertySetting);
        ProfilePropertyServiceTest.assertFalse((boolean)this.profilePropertyService.isPropertySettingHiddenable(propertySetting));
    }

    public void testHidePropertySetting() throws ObjectAlreadyExistsException {
        ProfilePropertySetting propertySetting = this.createProfileSettingInstance("testProp");
        propertySetting.setHiddenbale(true);
        propertySetting = this.profilePropertyService.createPropertySetting(propertySetting);
        this.profilePropertyService.hidePropertySetting(1L, propertySetting.getId().longValue());
        List Ids = this.profilePropertyService.getHiddenProfilePropertyIds(1L);
        ProfilePropertyServiceTest.assertTrue((boolean)Ids.contains(propertySetting.getId()));
    }

    public void testShowPropertySetting() throws ObjectAlreadyExistsException {
        ProfilePropertySetting propertySetting = this.createProfileSettingInstance("testProp1");
        propertySetting.setHiddenbale(true);
        propertySetting = this.profilePropertyService.createPropertySetting(propertySetting);
        this.profilePropertyService.hidePropertySetting(1L, propertySetting.getId().longValue());
        List Ids = this.profilePropertyService.getHiddenProfilePropertyIds(1L);
        ProfilePropertyServiceTest.assertTrue((boolean)Ids.contains(propertySetting.getId()));
        this.profilePropertyService.showPropertySetting(1L, propertySetting.getId().longValue());
        Ids = this.profilePropertyService.getHiddenProfilePropertyIds(1L);
        ProfilePropertyServiceTest.assertFalse((boolean)Ids.contains(propertySetting.getId()));
    }

    public void testGetHiddenProfilePropertyIds() throws ObjectAlreadyExistsException {
        ProfilePropertySetting propertySetting = this.createProfileSettingInstance("testProp2");
        propertySetting.setHiddenbale(true);
        propertySetting = this.profilePropertyService.createPropertySetting(propertySetting);
        this.profilePropertyService.hidePropertySetting(1L, propertySetting.getId().longValue());
        List Ids = this.profilePropertyService.getHiddenProfilePropertyIds(1L);
        ProfilePropertyServiceTest.assertFalse((boolean)Ids.isEmpty());
    }

    public void testGetProfilePropertySettings() throws Exception {
        ProfilePropertyServiceTest.assertEquals((int)0, (int)this.profilePropertyService.getPropertySettings().size());
        ProfilePropertySetting profilePropertySetting1 = this.createProfileSettingInstance("test10");
        ProfilePropertySetting profilePropertySetting2 = this.createProfileSettingInstance("test20");
        ProfilePropertySetting profilePropertySetting3 = this.createProfileSettingInstance("test30");
        ProfilePropertySetting profilePropertySetting4 = this.createProfileSettingInstance("test40");
        ProfilePropertySetting profilePropertySetting5 = this.createProfileSettingInstance("test50");
        ProfilePropertySetting profilePropertySetting6 = this.createProfileSettingInstance("test60");
        this.profilePropertyService.createPropertySetting(profilePropertySetting1);
        this.profilePropertyService.createPropertySetting(profilePropertySetting2);
        this.profilePropertyService.createPropertySetting(profilePropertySetting3);
        this.profilePropertyService.createPropertySetting(profilePropertySetting4);
        this.profilePropertyService.createPropertySetting(profilePropertySetting5);
        this.profilePropertyService.createPropertySetting(profilePropertySetting6);
        List profilePropertySettings = this.profilePropertyService.getPropertySettings();
        ProfilePropertyServiceTest.assertEquals((int)6, (int)this.profilePropertyService.getPropertySettings().size());
        ProfilePropertyServiceTest.assertEquals((String)"test30", (String)((ProfilePropertySetting)profilePropertySettings.get(2)).getPropertyName());
        ProfilePropertyServiceTest.assertEquals((String)"test40", (String)((ProfilePropertySetting)profilePropertySettings.get(3)).getPropertyName());
    }

    public void testGetSynchronizedProperties() throws ObjectAlreadyExistsException {
        ProfilePropertySetting profilePropertySetting = this.createProfileSettingInstance("postalCode");
        profilePropertySetting.setGroupSynchronized(true);
        this.profilePropertyService.createPropertySetting(profilePropertySetting);
        ProfilePropertyServiceTest.assertEquals((int)1, (int)this.profilePropertyService.getSynchronizedPropertySettings().size());
    }

    private ProfilePropertySetting createProfileSettingInstance(String propertyName) {
        ProfilePropertySetting profilePropertySetting = new ProfilePropertySetting();
        profilePropertySetting.setActive(true);
        profilePropertySetting.setEditable(true);
        profilePropertySetting.setVisible(true);
        profilePropertySetting.setPropertyName(propertyName);
        profilePropertySetting.setGroupSynchronized(false);
        profilePropertySetting.setMultiValued(false);
        profilePropertySetting.setPropertyType("text");
        profilePropertySetting.setParentId(Long.valueOf(0L));
        profilePropertySetting.setOrder(Long.valueOf(0L));
        return profilePropertySetting;
    }
}

