/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.social.navigation.plugin;

import io.meeds.social.navigation.AbstractNavigationConfigurationTest;
import io.meeds.social.navigation.constant.SidebarItemType;
import io.meeds.social.navigation.model.SidebarItem;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.junit.Test;

public class SiteSidebarPluginTest
extends AbstractNavigationConfigurationTest {
    @Test
    public void testGetType() {
        SiteSidebarPluginTest.assertEquals((Object)SidebarItemType.SITE, (Object)this.siteSidebarPlugin.getType());
    }

    @Test
    public void testGetDefaultItems() {
        List defaultItems = this.siteSidebarPlugin.getDefaultItems();
        SiteSidebarPluginTest.assertNotNull((Object)defaultItems);
        SiteSidebarPluginTest.assertFalse((boolean)defaultItems.isEmpty());
        SiteSidebarPluginTest.assertTrue((boolean)defaultItems.stream().anyMatch(item -> StringUtils.equals((CharSequence)item.getName(), (CharSequence)"classic")));
    }

    @Test
    public void testItemExists() {
        SiteSidebarPluginTest.assertFalse((boolean)this.siteSidebarPlugin.itemExists(null, null));
        SiteSidebarPluginTest.assertFalse((boolean)this.siteSidebarPlugin.itemExists(new SidebarItem(), null));
        SidebarItem item = new SidebarItem(SidebarItemType.SITE);
        HashMap<String, String> properties = new HashMap<String, String>();
        item.setProperties(properties);
        properties.put("siteType", "portal");
        properties.put("siteName", "notfound");
        SiteSidebarPluginTest.assertFalse((boolean)this.siteSidebarPlugin.itemExists(item, null));
        properties.put("siteName", "contribute");
        SiteSidebarPluginTest.assertTrue((boolean)this.siteSidebarPlugin.itemExists(item, null));
    }

    @Test
    public void testResolveProperties() {
        SidebarItem item = new SidebarItem(SidebarItemType.SITE);
        HashMap<String, String> properties = new HashMap<String, String>();
        item.setProperties(properties);
        properties.put("siteType", "portal");
        properties.put("siteName", "contribute");
        this.siteSidebarPlugin.resolveProperties(item, this.userAcl.getSuperUser(), Locale.ENGLISH);
        SiteSidebarPluginTest.assertEquals((String)"contribute", (String)item.getName());
        SiteSidebarPluginTest.assertEquals((String)"/portal/contribute", (String)item.getUrl());
        SiteSidebarPluginTest.assertNull((Object)item.getTarget());
        SiteSidebarPluginTest.assertNull((Object)item.getAvatar());
        SiteSidebarPluginTest.assertNull((Object)item.getItems());
        SiteSidebarPluginTest.assertEquals((String)"a-icon", (String)item.getIcon());
    }
}

