/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.social.core.profileproperty.storage;

import java.util.Collections;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.exoplatform.commons.cache.future.FutureCache;
import org.exoplatform.commons.cache.future.FutureExoCache;
import org.exoplatform.services.cache.CacheService;
import org.exoplatform.services.cache.ExoCache;
import org.exoplatform.social.core.jpa.storage.dao.jpa.ProfilePropertySettingDAO;
import org.exoplatform.social.core.profileproperty.model.ProfilePropertySetting;
import org.exoplatform.social.core.profileproperty.storage.ProfileSettingStorage;

public class CachedProfileSettingStorage
extends ProfileSettingStorage {
    private ExoCache<Long, ProfilePropertySetting> cache;
    private FutureCache<Long, ProfilePropertySetting, Object> futureCache;
    private ExoCache<String, Long> idByNameCache;
    private FutureCache<String, Long, Object> idByNameFutureCache;
    private List<Long> profileSettingIds;

    public CachedProfileSettingStorage(CacheService cacheService, ProfilePropertySettingDAO profilePropertySettingDAO) {
        super(profilePropertySettingDAO);
        this.cache = cacheService.getCacheInstance("social.profileSettings");
        this.idByNameCache = cacheService.getCacheInstance("social.profileSettingIdsByName");
        this.futureCache = new FutureExoCache((c, id) -> super.getProfileSettingById((Long)id), this.cache);
        this.idByNameFutureCache = new FutureExoCache((c, name) -> {
            ProfilePropertySetting s = super.findProfileSettingByName((String)name);
            return s == null ? 0L : s.getId();
        }, this.idByNameCache);
    }

    @Override
    public List<ProfilePropertySetting> getPropertySettings() {
        if (this.profileSettingIds == null) {
            List<ProfilePropertySetting> propertySettings = super.getPropertySettings();
            this.profileSettingIds = CollectionUtils.isEmpty(propertySettings) ? Collections.emptyList() : propertySettings.stream().map(ProfilePropertySetting::getId).toList();
        }
        return this.profileSettingIds.stream().map(this::getProfileSettingById).toList();
    }

    @Override
    public ProfilePropertySetting findProfileSettingByName(String name) {
        long id = (Long)this.idByNameFutureCache.get(null, (Object)name);
        return id == 0L ? null : this.getProfileSettingById(id);
    }

    @Override
    public ProfilePropertySetting getProfileSettingById(Long id) {
        return (ProfilePropertySetting)this.futureCache.get(null, (Object)id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ProfilePropertySetting saveProfilePropertySetting(ProfilePropertySetting profilePropertySetting, boolean isNew) {
        try {
            ProfilePropertySetting profilePropertySetting2 = super.saveProfilePropertySetting(profilePropertySetting, isNew);
            return profilePropertySetting2;
        }
        finally {
            this.clearCaches();
        }
    }

    @Override
    public void deleteProfilePropertySetting(Long id) {
        try {
            super.deleteProfilePropertySetting(id);
        }
        finally {
            this.clearCaches();
        }
    }

    public void clearCaches() {
        this.profileSettingIds = null;
        this.cache.clearCache();
        this.idByNameCache.clearCache();
    }
}

