/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.social.category.service;

import io.meeds.social.category.model.Category;
import io.meeds.social.category.model.CategorySearchFilter;
import io.meeds.social.category.model.CategorySearchResult;
import io.meeds.social.category.service.CategoryServiceImpl;
import io.meeds.social.category.storage.CategoryStorage;
import io.meeds.social.translation.service.TranslationService;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.services.security.Identity;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mockito;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.test.mock.mockito.MockBean;
import org.springframework.test.context.junit4.SpringRunner;

@SpringBootTest(classes={CategoryServiceImpl.class})
@RunWith(value=SpringRunner.class)
public class CategoryServiceUnitTest {
    private static final long CATEGORY_ID = 7L;
    private static final String SPACE_PRETTY_NAME = "prettyName";
    private static final String SPACE_GROUP_ID_1 = "/spaces/space1";
    private static final String SPACE_GROUP_ID_2 = "/spaces/space2";
    private static final String A_GROUP_ID = "/group1";
    private static final long ADMIN_GROUP_IDENTITY_ID = 54456L;
    private static final long SPACE_IDENTITY_ID = 74456L;
    private static final long GROUP_IDENTITY_ID = 34456L;
    private static final boolean SORT_BY_NAME = false;
    private static final boolean LINK_PERMISSION = true;
    private static final int LIMIT = 30;
    private static final int OFFSET = 10;
    private static final long PARENT_ID = 5L;
    private static final long OWNER_ID = 2L;
    private static final String TERM = "term";
    private static final String TEST_USER = "testuser";
    @MockBean
    private IdentityManager identityManager;
    @MockBean
    private TranslationService translationService;
    @MockBean
    private CategoryStorage categoryStorage;
    @MockBean
    private SpaceService spaceService;
    @MockBean
    private UserACL userAcl;
    @Autowired
    private CategoryServiceImpl categoryService;

    @Test
    public void testFindCategories() {
        List categories = this.categoryService.findCategories(new CategorySearchFilter(TERM, 2L, 5L, 10L, 30L, true, false), TEST_USER, Locale.ENGLISH);
        Assert.assertNotNull((Object)categories);
        Assert.assertEquals((long)0L, (long)categories.size());
        Category parentCategory = (Category)Mockito.mock(Category.class);
        Mockito.when((Object)parentCategory.getId()).thenReturn((Object)5L);
        Mockito.when((Object)this.categoryStorage.getCategory(5L)).thenReturn((Object)parentCategory);
        org.exoplatform.social.core.identity.model.Identity adminGroupIdentity = (org.exoplatform.social.core.identity.model.Identity)Mockito.mock(org.exoplatform.social.core.identity.model.Identity.class);
        Mockito.when((Object)adminGroupIdentity.getId()).thenReturn((Object)String.valueOf(54456L));
        Mockito.when((Object)this.identityManager.getOrCreateGroupIdentity("/platform/administrators")).thenReturn((Object)adminGroupIdentity);
        CategorySearchFilter filter = new CategorySearchFilter(TERM, 54456L, 5L, 10L, 30L, true, false);
        categories = this.categoryService.findCategories(filter, TEST_USER, Locale.ENGLISH);
        Assert.assertNotNull((Object)categories);
        Assert.assertEquals((long)0L, (long)categories.size());
        Identity userAclIdentity = (Identity)Mockito.mock(Identity.class);
        Mockito.when((Object)this.userAcl.getUserIdentity(TEST_USER)).thenReturn((Object)userAclIdentity);
        Mockito.when((Object)userAclIdentity.getGroups()).thenReturn(new HashSet<String>(Arrays.asList(SPACE_GROUP_ID_1, SPACE_GROUP_ID_2, A_GROUP_ID)));
        Space space = (Space)Mockito.mock(Space.class);
        Mockito.when((Object)space.getPrettyName()).thenReturn((Object)SPACE_PRETTY_NAME);
        Mockito.when((Object)this.spaceService.getSpaceByGroupId(SPACE_GROUP_ID_1)).thenReturn((Object)space);
        org.exoplatform.social.core.identity.model.Identity spaceIdentity = (org.exoplatform.social.core.identity.model.Identity)Mockito.mock(org.exoplatform.social.core.identity.model.Identity.class);
        Mockito.when((Object)this.identityManager.getOrCreateSpaceIdentity(SPACE_PRETTY_NAME)).thenReturn((Object)spaceIdentity);
        Mockito.when((Object)spaceIdentity.getId()).thenReturn((Object)String.valueOf(74456L));
        org.exoplatform.social.core.identity.model.Identity groupIdentity = (org.exoplatform.social.core.identity.model.Identity)Mockito.mock(org.exoplatform.social.core.identity.model.Identity.class);
        Mockito.when((Object)this.identityManager.getOrCreateGroupIdentity(A_GROUP_ID)).thenReturn((Object)groupIdentity);
        Mockito.when((Object)groupIdentity.getId()).thenReturn((Object)String.valueOf(34456L));
        categories = this.categoryService.findCategories(filter, TEST_USER, Locale.ENGLISH);
        Assert.assertNotNull((Object)categories);
        Assert.assertEquals((long)0L, (long)categories.size());
        Category category = (Category)Mockito.mock(Category.class);
        Mockito.when((Object)category.getId()).thenReturn((Object)7L);
        Mockito.when((Object)category.getParentId()).thenReturn((Object)5L);
        Mockito.when((Object)this.categoryStorage.getCategory(7L)).thenReturn((Object)category);
        Mockito.when((Object)this.categoryStorage.findCategories(filter, Arrays.asList(34456L, 74456L), Locale.ENGLISH)).thenReturn(Collections.singletonList(category));
        categories = this.categoryService.findCategories(filter, TEST_USER, Locale.ENGLISH);
        Assert.assertNotNull((Object)categories);
        Assert.assertEquals((long)1L, (long)categories.size());
        Assert.assertEquals(Collections.singletonList(5L), (Object)((CategorySearchResult)categories.get(0)).getAncestorIds());
    }
}

