/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.space.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.GroupHandler;
import org.exoplatform.services.organization.Membership;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.resources.ResourceBundleService;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.security.IdentityRegistry;
import org.exoplatform.services.security.MembershipEntry;
import org.exoplatform.social.core.space.SpaceApplication;
import org.exoplatform.social.core.space.SpaceException;
import org.exoplatform.social.core.space.SpaceTemplate;
import org.exoplatform.social.core.space.SpaceTemplateConfigPlugin;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceApplicationHandler;
import org.exoplatform.social.core.space.spi.SpaceTemplateService;
import org.picocontainer.Startable;

public class SpaceTemplateServiceImpl
implements SpaceTemplateService,
Startable {
    private static final String DEFAULT_SPACE_TEMPLATE_PARAM = "defaultSpaceTemplate";
    private static final Log LOG = ExoLogger.getLogger(SpaceTemplateServiceImpl.class);
    private Map<String, SpaceApplicationHandler> spaceApplicationHandlers = new HashMap<String, SpaceApplicationHandler>();
    private Map<String, SpaceTemplate> spaceTemplates = new HashMap<String, SpaceTemplate>();
    private Map<String, SpaceTemplate> registeredSpaceTemplates = new HashMap<String, SpaceTemplate>();
    private Map<String, List<SpaceTemplate>> extendedSpaceTemplates = new HashMap<String, List<SpaceTemplate>>();
    private String defaultSpaceTemplate;

    public SpaceTemplateServiceImpl(InitParams params) {
        if (params != null) {
            this.defaultSpaceTemplate = params.getValueParam(DEFAULT_SPACE_TEMPLATE_PARAM).getValue();
        }
    }

    public List<SpaceTemplate> getSpaceTemplates() {
        return Collections.unmodifiableList(new ArrayList(this.spaceTemplates.values().stream().map(SpaceTemplate::clone).sorted(Comparator.comparing(SpaceTemplate::getName)).collect(Collectors.toList())));
    }

    public List<SpaceTemplate> getSpaceTemplates(String userId) throws Exception {
        ArrayList<SpaceTemplate> list = new ArrayList<SpaceTemplate>();
        Identity identity = this.getIdentity(userId);
        block0: for (SpaceTemplate spaceTemplate : this.getSpaceTemplates()) {
            String perms = spaceTemplate.getPermissions();
            if (perms == null) continue;
            Pattern pattern = Pattern.compile(";");
            List permissions = pattern.splitAsStream(perms).collect(Collectors.toList());
            for (String perm : permissions) {
                String membership;
                UserACL.Permission permission = new UserACL.Permission();
                permission.setPermissionExpression(perm);
                String groupId = permission.getGroupId();
                if (!identity.isMemberOf(groupId, membership = permission.getMembership())) continue;
                list.add(spaceTemplate);
                continue block0;
            }
        }
        return list;
    }

    public List<SpaceTemplate> getLabelledSpaceTemplates(String userId, String lang) throws Exception {
        ArrayList<SpaceTemplate> templatelist = new ArrayList<SpaceTemplate>();
        Identity identity = this.getIdentity(userId);
        ResourceBundleService resourceBundleService = (ResourceBundleService)CommonsUtils.getService(ResourceBundleService.class);
        OrganizationService organizationService = (OrganizationService)CommonsUtils.getService(OrganizationService.class);
        for (SpaceTemplate spaceTemplate : this.getSpaceTemplates(userId)) {
            ResourceBundle resourceBundle;
            String perms = spaceTemplate.getPermissions();
            StringBuilder templatePermission = new StringBuilder("");
            if (identity.isMemberOf("/platform/administrators") && perms != null) {
                resourceBundle = resourceBundleService.getResourceBundle("locale.portlet.social.SpacesAdministrationPortlet", new Locale(lang));
                Pattern pattern = Pattern.compile(";");
                List permissions = pattern.splitAsStream(perms).collect(Collectors.toList());
                for (String perm : permissions) {
                    UserACL.Permission permission = new UserACL.Permission();
                    permission.setPermissionExpression(perm);
                    String groupId = permission.getGroupId();
                    String membership = permission.getMembership();
                    membership = "*".equals(membership) ? resourceBundle.getString("social.spaces.templates.any") : StringUtils.capitalize((String)membership);
                    GroupHandler groupHandler1 = organizationService.getGroupHandler();
                    String groupName = groupId;
                    Group group = groupHandler1.findGroupById(groupId);
                    if (group != null) {
                        groupName = group.getGroupName();
                    }
                    groupName = StringUtils.capitalize((String)groupName);
                    String key = resourceBundle.getString("social.spaces.templates.permissionEntry");
                    templatePermission.append(key.replace("{0}", membership).replace("{1}", groupName));
                    templatePermission.append(", ");
                }
                int index = templatePermission.lastIndexOf(", ");
                templatePermission.deleteCharAt(index);
            }
            if ((resourceBundle = resourceBundleService.getResourceBundle(new String[]{"locale.portal.webui", "locale.portlet.social.SpacesAdministrationPortlet"}, new Locale(lang))) != null) {
                try {
                    spaceTemplate.setResolvedLabel(resourceBundle.getString("social.spaces.templates.name." + spaceTemplate.getName()));
                }
                catch (MissingResourceException e) {
                    LOG.debug((Object)e.getMessage());
                }
                try {
                    spaceTemplate.setResolvedDescription(resourceBundle.getString("social.spaces.templates.description." + spaceTemplate.getName()));
                }
                catch (MissingResourceException e) {
                    LOG.debug((Object)e.getMessage());
                }
            }
            spaceTemplate.setPermissionsLabels(templatePermission.toString());
            templatelist.add(spaceTemplate);
        }
        return templatelist;
    }

    public SpaceTemplate getSpaceTemplateByName(String name) {
        SpaceTemplate template;
        if (name == null) {
            name = this.getDefaultSpaceTemplate();
        }
        if ((template = this.spaceTemplates.get(name)) != null) {
            return template.clone();
        }
        SpaceTemplate defaultTemplate = this.spaceTemplates.get(this.getDefaultSpaceTemplate());
        return defaultTemplate.clone();
    }

    public void registerSpaceTemplatePlugin(SpaceTemplateConfigPlugin spaceTemplateConfigPlugin) {
        SpaceTemplate spaceTemplate = spaceTemplateConfigPlugin.getSpaceTemplate();
        if (spaceTemplate == null) {
            LOG.warn((Object)"No space template found !");
            return;
        }
        this.registeredSpaceTemplates.put(spaceTemplate.getName(), spaceTemplate);
    }

    public void extendSpaceTemplatePlugin(SpaceTemplateConfigPlugin spaceTemplateConfigPlugin) {
        SpaceTemplate spaceTemplateExtension = spaceTemplateConfigPlugin.getSpaceTemplate();
        if (spaceTemplateExtension == null || StringUtils.isBlank((CharSequence)spaceTemplateExtension.getName())) {
            LOG.warn("Space template plugin doesn't have mandatory object: {}. The plugin will be ignored.", new Object[]{spaceTemplateConfigPlugin});
            return;
        }
        String templateName = spaceTemplateExtension.getName();
        if (!this.extendedSpaceTemplates.containsKey(templateName)) {
            this.extendedSpaceTemplates.put(templateName, new ArrayList());
        }
        this.extendedSpaceTemplates.get(templateName).add(spaceTemplateExtension);
    }

    public void registerSpaceApplicationHandler(SpaceApplicationHandler spaceApplicationHandler) {
        this.spaceApplicationHandlers.put(spaceApplicationHandler.getName(), spaceApplicationHandler);
    }

    public Map<String, SpaceApplicationHandler> getSpaceApplicationHandlers() {
        return Collections.unmodifiableMap(this.spaceApplicationHandlers);
    }

    public String getDefaultSpaceTemplate() {
        return this.defaultSpaceTemplate;
    }

    public void initSpaceApplications(Space space, SpaceApplicationHandler spaceApplicationHandler) throws SpaceException {
        String type = space.getTemplate();
        SpaceTemplate spaceTemplate = this.getSpaceTemplateByName(type);
        spaceApplicationHandler.initApps(space, spaceTemplate);
        List apps = spaceTemplate.getSpaceApplicationList();
        if (apps != null) {
            for (SpaceApplication spaceApplication : apps) {
                this.setApp(space, spaceApplication.getPortletName(), spaceApplication.getAppTitle(), spaceApplication.isRemovable(), "active");
            }
        }
    }

    public void setApp(Space space, String appId, String appName, boolean isRemovable, String status) {
        Object apps = space.getApp();
        String applicationStatus = appId + ":" + appName;
        applicationStatus = isRemovable ? applicationStatus + ":true" : applicationStatus + ":false";
        applicationStatus = applicationStatus + ":" + status;
        apps = apps == null ? applicationStatus : (String)apps + "," + applicationStatus;
        space.setApp((String)apps);
    }

    public void start() {
        this.spaceTemplates = this.registeredSpaceTemplates;
        for (String spaceTemplateExtensionName : this.extendedSpaceTemplates.keySet()) {
            List<SpaceTemplate> spaceTemplateExtensions = this.extendedSpaceTemplates.get(spaceTemplateExtensionName);
            for (SpaceTemplate spaceTemplateExtension : spaceTemplateExtensions) {
                List apps = spaceTemplateExtension.getSpaceApplicationList();
                SpaceTemplate toExtendSpaceTemplate = this.spaceTemplates.get(spaceTemplateExtensionName);
                if (toExtendSpaceTemplate == null) {
                    LOG.warn("Can't extend Space template '{}' with applications {} because the space template can't be found.", new Object[]{spaceTemplateExtensionName, apps == null ? "" : apps.stream().map(SpaceApplication::getPortletName).collect(Collectors.toList())});
                }
                if (spaceTemplateExtension.getBannerPath() != null) {
                    LOG.warn("Banner path defined in extension of space template {} isn't extensible", new Object[]{spaceTemplateExtensionName});
                }
                if (spaceTemplateExtension.getSpaceHomeApplication() != null) {
                    LOG.warn("Space home defined in extension of space template {} isn't extensible", new Object[]{spaceTemplateExtensionName});
                }
                if (apps == null || toExtendSpaceTemplate == null) continue;
                for (SpaceApplication application : apps) {
                    toExtendSpaceTemplate.addToSpaceApplicationList(application);
                }
            }
        }
    }

    public void stop() {
    }

    private Identity getIdentity(String userId) throws Exception {
        IdentityRegistry identityRegistry = (IdentityRegistry)CommonsUtils.getService(IdentityRegistry.class);
        OrganizationService organizationService = (OrganizationService)CommonsUtils.getService(OrganizationService.class);
        Identity identity = identityRegistry.getIdentity(userId);
        if (identity == null) {
            Collection memberships = new ArrayList();
            memberships = organizationService.getMembershipHandler().findMembershipsByUser(userId);
            ArrayList<MembershipEntry> entries = new ArrayList<MembershipEntry>();
            for (Membership membership : memberships) {
                entries.add(new MembershipEntry(membership.getGroupId(), membership.getMembershipType()));
            }
            identity = new Identity(userId, entries);
        }
        return identity;
    }
}

