/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.processor;

import java.util.HashMap;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.activity.model.ExoSocialActivityImpl;
import org.exoplatform.social.core.processor.TemplateParamsProcessor;
import org.exoplatform.social.core.test.AbstractCoreTest;

public class TemplateParamsProcessorTest
extends AbstractCoreTest {
    @Override
    public void setUp() throws Exception {
        super.setUp();
    }

    @Override
    public void tearDown() throws Exception {
        super.tearDown();
    }

    public void testProcessSimpleTemplate() {
        ExoSocialActivityImpl activity = new ExoSocialActivityImpl();
        String nameKey = "ZUN-NAME";
        String nameValue = "Zuanoc";
        String cityKey = "CITY";
        String cityValue = "Hanoi";
        String templateString = "This is ${" + nameKey + "}. City : ${" + cityKey + "}";
        String resultString = "This is " + nameValue + ". City : " + cityValue;
        activity.setTitle(templateString);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put(nameKey, nameValue);
        params.put(cityKey, cityValue);
        activity.setTemplateParams(params);
        TemplateParamsProcessor processor = (TemplateParamsProcessor)PortalContainer.getComponent(TemplateParamsProcessor.class);
        processor.processActivity((ExoSocialActivity)activity);
        TemplateParamsProcessorTest.assertEquals((String)resultString, (String)activity.getTitle());
    }

    public void testProcessSimpleTemplateWithNullParamValue() {
        ExoSocialActivityImpl activity = new ExoSocialActivityImpl();
        String nameKey = "ZUN-NAME";
        String cityKey = "CITY";
        String templateString = "This is ${" + nameKey + "}. City : ${" + cityKey + "}";
        activity.setTitle(templateString);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(nameKey, null);
        params.put(cityKey, null);
        activity.setTemplateParams(params);
        TemplateParamsProcessor processor = (TemplateParamsProcessor)PortalContainer.getComponent(TemplateParamsProcessor.class);
        processor.processActivity((ExoSocialActivity)activity);
        TemplateParamsProcessorTest.assertEquals((String)templateString, (String)activity.getTitle());
    }

    public void testProcessComplicatedTemplate() throws Exception {
        ExoSocialActivityImpl activity = new ExoSocialActivityImpl();
        String nameKey = "ZUN-NAME";
        String nameValue = "Zuanoc";
        String cityKey = "CITY";
        String cityValue = "Hanoi";
        String templateString = "This is ${" + nameKey + "}. City : ${" + cityKey + "}";
        templateString = templateString + templateString;
        String resultString = "This is " + nameValue + ". City : " + cityValue;
        resultString = resultString + resultString;
        activity.setTitle(templateString);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put(nameKey, nameValue);
        params.put(cityKey, cityValue);
        activity.setTemplateParams(params);
        TemplateParamsProcessor processor = (TemplateParamsProcessor)PortalContainer.getComponent(TemplateParamsProcessor.class);
        processor.processActivity((ExoSocialActivity)activity);
        TemplateParamsProcessorTest.assertEquals((String)resultString, (String)activity.getTitle());
    }
}

