/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.profileproperty;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.ObjectAlreadyExistsException;
import org.exoplatform.commons.api.settings.SettingService;
import org.exoplatform.commons.api.settings.SettingValue;
import org.exoplatform.commons.api.settings.data.Context;
import org.exoplatform.commons.api.settings.data.Scope;
import org.exoplatform.commons.search.index.IndexingService;
import org.exoplatform.container.component.ComponentPlugin;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.profileproperty.ProfilePropertyDatabaseInitializer;
import org.exoplatform.social.core.profileproperty.ProfilePropertyService;
import org.exoplatform.social.core.profileproperty.model.ProfilePropertySetting;
import org.exoplatform.social.core.profileproperty.storage.ProfileSettingStorage;
import org.picocontainer.Startable;

public class ProfilePropertyServiceImpl
implements ProfilePropertyService,
Startable {
    private static final Log LOG = ExoLogger.getLogger(ProfilePropertyServiceImpl.class);
    private final ProfileSettingStorage profileSettingStorage;
    private final SettingService settingService;
    private final IndexingService indexingService;
    private final ListenerService listenerService;
    private static final String SYNCHRONIZED_DISABLED_PROPERTIES = "synchronizationDisabledProperties";
    private static final String UNHIDDENABLE_PROPERTIES_PARAM = "unHiddenableProperties";
    private static final String EXCLUDED_QUICK_SEARCH_PROPERTIES_PARAM = "excludedQuickSearchProperties";
    protected List<ProfilePropertyDatabaseInitializer> profielPropertyPlugins = new ArrayList<ProfilePropertyDatabaseInitializer>();
    private List<String> synchronizedGroupDisabledProperties = new ArrayList<String>();
    private static List<String> nonHiddenableProps = new ArrayList<String>();
    private static List<String> excludedQuickSearchProps = new ArrayList<String>();
    private static final Scope HIDDEN_PROFILE_PROPERTY_SETTINGS_SCOPE = Scope.APPLICATION.id("ProfilePropertySettings");
    private static final String HIDDEN_PROFILE_PROPERTY_SETTINGS_KEY = "HiddenProfilePropertySettings";

    public ProfilePropertyServiceImpl(InitParams params, ProfileSettingStorage profileSettingStorage, SettingService settingService, IndexingService indexingService, ListenerService listenerService) {
        this.profileSettingStorage = profileSettingStorage;
        this.settingService = settingService;
        this.indexingService = indexingService;
        this.listenerService = listenerService;
        if (params != null) {
            try {
                this.synchronizedGroupDisabledProperties = Arrays.asList(params.getValueParam(SYNCHRONIZED_DISABLED_PROPERTIES).getValue().split(","));
                nonHiddenableProps = Arrays.asList(params.getValueParam(UNHIDDENABLE_PROPERTIES_PARAM).getValue().split(","));
                excludedQuickSearchProps = Arrays.asList(params.getValueParam(EXCLUDED_QUICK_SEARCH_PROPERTIES_PARAM).getValue().split(","));
            }
            catch (Exception e) {
                LOG.warn((Object)"List of disabled properties for synchronization not provided, all properties can be synchronized! ");
            }
        }
    }

    public List<ProfilePropertySetting> getPropertySettings() {
        return this.profileSettingStorage.getPropertySettings();
    }

    public List<ProfilePropertySetting> getSynchronizedPropertySettings() {
        return this.profileSettingStorage.getSynchronizedPropertySettings();
    }

    public ProfilePropertySetting getProfileSettingByName(String name) {
        return this.profileSettingStorage.findProfileSettingByName(name);
    }

    public ProfilePropertySetting getProfileSettingById(Long id) {
        return this.profileSettingStorage.getProfileSettingById(id);
    }

    public List<String> getUnhiddenableProfileProperties() {
        return nonHiddenableProps;
    }

    public List<String> getExcludedQuickSearchProperties() {
        return excludedQuickSearchProps;
    }

    public boolean isPropertySettingHiddenable(ProfilePropertySetting propertySetting) {
        if (nonHiddenableProps.contains(propertySetting.getPropertyName()) || this.hasChildProperties(propertySetting)) {
            return false;
        }
        return propertySetting.isHiddenbale();
    }

    public ProfilePropertySetting createPropertySetting(ProfilePropertySetting profilePropertySetting) throws ObjectAlreadyExistsException {
        if (profilePropertySetting == null) {
            throw new IllegalArgumentException("Profile property setting Item Object is mandatory");
        }
        if (StringUtils.isBlank((CharSequence)profilePropertySetting.getPropertyName())) {
            throw new IllegalArgumentException("Profile property name is mandatory");
        }
        ProfilePropertySetting storedProfilePropertySetting = this.profileSettingStorage.findProfileSettingByName(profilePropertySetting.getPropertyName());
        if (storedProfilePropertySetting != null) {
            throw new ObjectAlreadyExistsException((Object)storedProfilePropertySetting, "A profile property with provided name already exist");
        }
        if (!this.isGroupSynchronizedEnabledProperty(profilePropertySetting)) {
            profilePropertySetting.setGroupSynchronized(false);
        }
        profilePropertySetting.setUpdated(Long.valueOf(System.currentTimeMillis()));
        profilePropertySetting = this.profileSettingStorage.saveProfilePropertySetting(profilePropertySetting, true);
        if (profilePropertySetting.getOrder() == null) {
            profilePropertySetting.setOrder(profilePropertySetting.getId());
            profilePropertySetting = this.profileSettingStorage.saveProfilePropertySetting(profilePropertySetting, false);
        }
        try {
            this.listenerService.broadcast("profile-property-setting-created", (Object)this, (Object)profilePropertySetting);
        }
        catch (Exception e) {
            LOG.error("An error occurred when broadcasting the creation event of the property setting {}", new Object[]{profilePropertySetting.getPropertyName(), e});
        }
        return profilePropertySetting;
    }

    public void updatePropertySetting(ProfilePropertySetting profilePropertySetting) {
        ProfilePropertySetting createdProfilePropertySetting;
        if (profilePropertySetting.isHiddenbale() && this.getUnhiddenableProfileProperties().contains(profilePropertySetting.getPropertyName())) {
            throw new IllegalArgumentException(String.format("%s cannot be hidden", profilePropertySetting.getPropertyName()));
        }
        if (!this.isGroupSynchronizedEnabledProperty(profilePropertySetting)) {
            profilePropertySetting.setGroupSynchronized(false);
        }
        if ((createdProfilePropertySetting = this.profileSettingStorage.getProfileSettingById(profilePropertySetting.getId())) != null && this.isDefaultProperties(profilePropertySetting)) {
            profilePropertySetting.setMultiValued(createdProfilePropertySetting.isMultiValued());
        }
        if (createdProfilePropertySetting != null) {
            profilePropertySetting.setPropertyType(createdProfilePropertySetting.getPropertyType());
        }
        profilePropertySetting.setUpdated(Long.valueOf(System.currentTimeMillis()));
        this.profileSettingStorage.saveProfilePropertySetting(profilePropertySetting, false);
        try {
            this.listenerService.broadcast("profile-property-setting-updated", (Object)this, (Object)profilePropertySetting);
        }
        catch (Exception e) {
            LOG.error("An error occurred when broadcasting the update event of the property setting {}", new Object[]{profilePropertySetting.getPropertyName(), e});
        }
    }

    public void deleteProfilePropertySetting(Long id) {
        if (id <= 0L) {
            throw new IllegalArgumentException("Profile Property Setting Technical Identifier is mandatory");
        }
        this.profileSettingStorage.deleteProfilePropertySetting(id);
    }

    public boolean isGroupSynchronizedEnabledProperty(ProfilePropertySetting profilePropertySetting) {
        if (this.synchronizedGroupDisabledProperties.contains(profilePropertySetting.getPropertyName())) {
            return false;
        }
        if (profilePropertySetting.getParentId() != null && profilePropertySetting.getParentId() > 0L) {
            ProfilePropertySetting parent = this.profileSettingStorage.getProfileSettingById(profilePropertySetting.getParentId());
            return parent == null || !this.synchronizedGroupDisabledProperties.contains(parent.getPropertyName());
        }
        return true;
    }

    public List<String> getPropertySettingNames() {
        return this.getPropertySettings().stream().map(ProfilePropertySetting::getPropertyName).toList();
    }

    public void hidePropertySetting(long userIdentityId, long profilePropertyId) {
        List<Long> hiddenProperties = this.getHiddenProfilePropertyIds(userIdentityId);
        hiddenProperties.remove(profilePropertyId);
        hiddenProperties.add(profilePropertyId);
        this.settingService.set(Context.USER.id(String.valueOf(userIdentityId)), HIDDEN_PROFILE_PROPERTY_SETTINGS_SCOPE, HIDDEN_PROFILE_PROPERTY_SETTINGS_KEY, SettingValue.create((String)hiddenProperties.toString()));
        this.indexingService.reindex("profile", String.valueOf(userIdentityId));
    }

    public void showPropertySetting(long userIdentityId, long profilePropertyId) {
        List<Long> hiddenProperties = this.getHiddenProfilePropertyIds(userIdentityId);
        hiddenProperties.remove(profilePropertyId);
        this.settingService.set(Context.USER.id(String.valueOf(userIdentityId)), HIDDEN_PROFILE_PROPERTY_SETTINGS_SCOPE, HIDDEN_PROFILE_PROPERTY_SETTINGS_KEY, SettingValue.create((String)hiddenProperties.toString()));
        this.indexingService.reindex("profile", String.valueOf(userIdentityId));
    }

    public List<Long> getHiddenProfilePropertyIds(long userIdentityId) {
        List<Long> hiddenProfileProperties = new ArrayList<Long>();
        SettingValue settingValue = this.settingService.get(Context.USER.id(String.valueOf(userIdentityId)), HIDDEN_PROFILE_PROPERTY_SETTINGS_SCOPE, HIDDEN_PROFILE_PROPERTY_SETTINGS_KEY);
        if (settingValue == null) {
            return hiddenProfileProperties;
        }
        try {
            ObjectMapper mapper = new ObjectMapper();
            hiddenProfileProperties = (List)mapper.readValue(settingValue.getValue().toString(), (TypeReference)new TypeReference<ArrayList<Long>>(this){});
        }
        catch (Exception e) {
            LOG.error("Error while parsing hidden properties setting of user: {}", new Object[]{userIdentityId, e});
        }
        return hiddenProfileProperties;
    }

    public void start() {
        for (ProfilePropertyDatabaseInitializer plugin : this.profielPropertyPlugins) {
            try {
                plugin.init(this);
            }
            catch (Exception ex) {
                LOG.error("Failed start Profile properties Service , probably because of configuration error. Error occurs when initializing properties for {}", new Object[]{((Object)((Object)plugin)).getClass().getName(), ex});
            }
        }
    }

    public void stop() {
    }

    public void addProfilePropertyPlugin(ComponentPlugin profilePropertyInitPlugin) {
        this.profielPropertyPlugins.add((ProfilePropertyDatabaseInitializer)profilePropertyInitPlugin);
    }

    public boolean hasChildProperties(ProfilePropertySetting propertySetting) {
        return this.profileSettingStorage.hasChildProperties(propertySetting.getId());
    }

    public boolean isDefaultProperties(ProfilePropertySetting propertySetting) {
        for (ProfilePropertyDatabaseInitializer plugin : this.profielPropertyPlugins) {
            if (plugin.getConfig().getProfileProperties() == null || plugin.getConfig().getProfileProperties().isEmpty() || !plugin.getConfig().getProfileProperties().stream().anyMatch(profileProperty -> profileProperty.getPropertyName().equals(propertySetting.getPropertyName()))) continue;
            return true;
        }
        return false;
    }
}

