/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.jpa.storage;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.jpa.test.AbstractCoreTest;
import org.exoplatform.social.core.model.AvatarAttachment;
import org.exoplatform.social.core.model.BannerAttachment;
import org.exoplatform.social.core.profile.ProfileFilter;
import org.exoplatform.social.core.relationship.model.Relationship;
import org.exoplatform.social.core.search.Sorting;
import org.exoplatform.social.core.storage.RelationshipStorageException;
import org.exoplatform.social.core.storage.api.IdentityStorage;
import org.exoplatform.social.core.storage.api.RelationshipStorage;

public class RelationshipStorageTest
extends AbstractCoreTest {
    private final Log LOG = ExoLogger.getLogger(RelationshipStorageTest.class);
    private RelationshipStorage relationshipStorage;
    private IdentityStorage identityStorage;
    private List<Identity> tearDownIdentityList;
    private Identity rootIdentity;
    private Identity johnIdentity;
    private Identity maryIdentity;
    private Identity demoIdentity;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.relationshipStorage = (RelationshipStorage)this.getContainer().getComponentInstanceOfType(RelationshipStorage.class);
        RelationshipStorageTest.assertNotNull((String)"relationshipStorage must not be null", (Object)this.relationshipStorage);
        this.identityStorage = (IdentityStorage)this.getContainer().getComponentInstanceOfType(IdentityStorage.class);
        RelationshipStorageTest.assertNotNull((String)"identityManger must not be null", (Object)this.identityStorage);
        this.rootIdentity = this.createIdentity("root");
        this.johnIdentity = this.createIdentity("john");
        this.maryIdentity = this.createIdentity("mary");
        this.demoIdentity = this.createIdentity("demo");
        this.tearDownIdentityList = new ArrayList<Identity>();
    }

    public void testSaveRelationship() throws RelationshipStorageException {
        Relationship rootToJohnRelationship = new Relationship(this.rootIdentity, this.johnIdentity, Relationship.Type.PENDING);
        rootToJohnRelationship = this.relationshipStorage.saveRelationship(rootToJohnRelationship);
        RelationshipStorageTest.assertNotNull((Object)rootToJohnRelationship.getId());
    }

    public void testRemoveRelationship() {
        Relationship rootToJohnRelationship = new Relationship(this.rootIdentity, this.johnIdentity, Relationship.Type.PENDING);
        try {
            this.relationshipStorage.saveRelationship(rootToJohnRelationship);
            RelationshipStorageTest.assertNotNull((String)"rootToJohnRelationship.getId() must not be null", (Object)rootToJohnRelationship.getId());
            this.relationshipStorage.removeRelationship(rootToJohnRelationship);
            RelationshipStorageTest.assertNull((String)"relationshipStorage.getRelationship(rootToJohnRelationship.getId() must be null", (Object)this.relationshipStorage.getRelationship(rootToJohnRelationship.getId()));
        }
        catch (RelationshipStorageException e) {
            this.LOG.error((Object)e);
        }
    }

    public void testGetRelationship() throws RelationshipStorageException {
        Relationship rootToJohnRelationship = new Relationship(this.rootIdentity, this.johnIdentity, Relationship.Type.PENDING);
        rootToJohnRelationship = this.relationshipStorage.saveRelationship(rootToJohnRelationship);
        rootToJohnRelationship = this.relationshipStorage.getRelationship(rootToJohnRelationship.getId());
        RelationshipStorageTest.assertNotNull((Object)rootToJohnRelationship.getId());
        RelationshipStorageTest.assertEquals((String)this.rootIdentity.getRemoteId(), (String)rootToJohnRelationship.getSender().getRemoteId());
        RelationshipStorageTest.assertEquals((String)this.rootIdentity.getProviderId(), (String)rootToJohnRelationship.getSender().getProviderId());
        RelationshipStorageTest.assertEquals((String)this.johnIdentity.getRemoteId(), (String)rootToJohnRelationship.getReceiver().getRemoteId());
        RelationshipStorageTest.assertEquals((String)this.johnIdentity.getProviderId(), (String)rootToJohnRelationship.getReceiver().getProviderId());
        RelationshipStorageTest.assertEquals((Object)Relationship.Type.PENDING, (Object)rootToJohnRelationship.getStatus());
        rootToJohnRelationship.setStatus(Relationship.Type.CONFIRMED);
        this.relationshipStorage.saveRelationship(rootToJohnRelationship);
        rootToJohnRelationship = this.relationshipStorage.getRelationship(rootToJohnRelationship.getId());
        RelationshipStorageTest.assertNotNull((Object)rootToJohnRelationship.getId());
        RelationshipStorageTest.assertEquals((String)this.rootIdentity.getRemoteId(), (String)rootToJohnRelationship.getSender().getRemoteId());
        RelationshipStorageTest.assertEquals((String)this.rootIdentity.getProviderId(), (String)rootToJohnRelationship.getSender().getProviderId());
        RelationshipStorageTest.assertEquals((String)this.johnIdentity.getRemoteId(), (String)rootToJohnRelationship.getReceiver().getRemoteId());
        RelationshipStorageTest.assertEquals((String)this.johnIdentity.getProviderId(), (String)rootToJohnRelationship.getReceiver().getProviderId());
        RelationshipStorageTest.assertEquals((Object)Relationship.Type.CONFIRMED, (Object)rootToJohnRelationship.getStatus());
    }

    public void testGetConnections() throws Exception {
        Relationship rootToJohnRelationship = new Relationship(this.rootIdentity, this.johnIdentity, Relationship.Type.CONFIRMED);
        rootToJohnRelationship = this.relationshipStorage.saveRelationship(rootToJohnRelationship);
        RelationshipStorageTest.assertNotNull((String)"rootToJohnRelationship.getId() must not be null", (Object)rootToJohnRelationship.getId());
        Relationship maryToRootRelationship = new Relationship(this.maryIdentity, this.rootIdentity, Relationship.Type.CONFIRMED);
        maryToRootRelationship = this.relationshipStorage.saveRelationship(maryToRootRelationship);
        RelationshipStorageTest.assertNotNull((String)"rootToMaryRelationship.getId() must not be null", (Object)maryToRootRelationship.getId());
        Relationship rootToDemoRelationship = new Relationship(this.rootIdentity, this.demoIdentity, Relationship.Type.PENDING);
        rootToDemoRelationship = this.relationshipStorage.saveRelationship(rootToDemoRelationship);
        RelationshipStorageTest.assertNotNull((String)"rootToDemoRelationship.getId() must not be null", (Object)rootToDemoRelationship.getId());
        InputStream inputStream = ((Object)((Object)this)).getClass().getResourceAsStream("/eXo-Social.png");
        AvatarAttachment avatarAttachment = new AvatarAttachment(null, "avatar", "png", inputStream, System.currentTimeMillis());
        RelationshipStorageTest.assertNotNull((Object)avatarAttachment);
        InputStream inputStreamBanner = ((Object)((Object)this)).getClass().getResourceAsStream("/eXo-Social.png");
        BannerAttachment bannerAttachment = new BannerAttachment(null, "banner", "png", inputStreamBanner, System.currentTimeMillis());
        RelationshipStorageTest.assertNotNull((Object)bannerAttachment);
        Profile profile = this.johnIdentity.getProfile();
        profile.setProperty("avatar", (Object)avatarAttachment);
        profile.setProperty("banner", (Object)bannerAttachment);
        this.identityStorage.updateProfile(profile);
        List listIdentities = this.relationshipStorage.getConnections(this.rootIdentity, 0L, 10L);
        RelationshipStorageTest.assertNotNull((String)"listIdentities must not be null", (Object)listIdentities);
        RelationshipStorageTest.assertEquals((String)"listIdentities.size() must return: 2", (int)2, (int)listIdentities.size());
        RelationshipStorageTest.assertNotNull((Object)this.getInList(listIdentities, "john").getProfile());
        RelationshipStorageTest.assertNotNull((Object)this.getInList(listIdentities, "john").getProfile().getAvatarUrl());
        RelationshipStorageTest.assertNotNull((Object)this.getInList(listIdentities, "john").getProfile().getBannerUrl());
        RelationshipStorageTest.assertNotNull((Object)this.getInList(listIdentities, "mary").getProfile());
        RelationshipStorageTest.assertNotNull((Object)this.getInList(listIdentities, "mary").getProfile().getAvatarUrl());
        RelationshipStorageTest.assertNotNull((Object)this.getInList(listIdentities, "mary").getProfile().getBannerUrl());
        for (Identity identity : listIdentities) {
            RelationshipStorageTest.assertNotNull((String)"identity.getProfile() must not be null", (Object)identity.getProfile());
            Identity identityLoadProfile = this.identityStorage.findIdentity("organization", identity.getRemoteId());
            RelationshipStorageTest.assertEquals((String)("identity.getProfile().getFullName() must return: " + identityLoadProfile.getProfile().getFullName()), (String)identityLoadProfile.getProfile().getFullName(), (String)identity.getProfile().getFullName());
        }
    }

    public void testGetConnectionsCount() throws Exception {
        Relationship rootToJohnRelationship = new Relationship(this.rootIdentity, this.johnIdentity, Relationship.Type.CONFIRMED);
        rootToJohnRelationship = this.relationshipStorage.saveRelationship(rootToJohnRelationship);
        RelationshipStorageTest.assertNotNull((String)"rootToJohnRelationship.getId() must not be null", (Object)rootToJohnRelationship.getId());
        Relationship maryToRootRelationship = new Relationship(this.maryIdentity, this.rootIdentity, Relationship.Type.CONFIRMED);
        maryToRootRelationship = this.relationshipStorage.saveRelationship(maryToRootRelationship);
        RelationshipStorageTest.assertNotNull((String)"rootToMaryRelationship.getId() must not be null", (Object)maryToRootRelationship.getId());
        Relationship rootToDemoRelationship = new Relationship(this.rootIdentity, this.demoIdentity, Relationship.Type.PENDING);
        rootToDemoRelationship = this.relationshipStorage.saveRelationship(rootToDemoRelationship);
        RelationshipStorageTest.assertNotNull((String)"rootToDemoRelationship.getId() must not be null", (Object)rootToDemoRelationship.getId());
        List listIdentities = this.relationshipStorage.getConnections(this.rootIdentity, 0L, 10L);
        RelationshipStorageTest.assertNotNull((String)"listIdentities must not be null", (Object)listIdentities);
        RelationshipStorageTest.assertEquals((String)"listIdentities.size() must return: 2", (int)2, (int)listIdentities.size());
        int count = this.relationshipStorage.getConnectionsCount(this.rootIdentity);
        RelationshipStorageTest.assertEquals((String)"count must be: 2", (int)2, (int)count);
    }

    public void testGetRelationshipsWithListCheck() throws Exception {
        Relationship rootToJohnRelationship = new Relationship(this.rootIdentity, this.johnIdentity, Relationship.Type.CONFIRMED);
        rootToJohnRelationship = this.relationshipStorage.saveRelationship(rootToJohnRelationship);
        RelationshipStorageTest.assertNotNull((String)"rootToJohnRelationship.getId() must not be null", (Object)rootToJohnRelationship.getId());
        Relationship maryToRootRelationship = new Relationship(this.maryIdentity, this.rootIdentity, Relationship.Type.PENDING);
        maryToRootRelationship = this.relationshipStorage.saveRelationship(maryToRootRelationship);
        RelationshipStorageTest.assertNotNull((String)"rootToMaryRelationship.getId() must not be null", (Object)maryToRootRelationship.getId());
        Relationship rootToDemoRelationship = new Relationship(this.rootIdentity, this.demoIdentity, Relationship.Type.IGNORED);
        rootToDemoRelationship = this.relationshipStorage.saveRelationship(rootToDemoRelationship);
        RelationshipStorageTest.assertNotNull((String)"rootToDemoRelationship.getId() must not be null", (Object)rootToDemoRelationship.getId());
        ArrayList<Identity> listCheckIdentity = new ArrayList<Identity>();
        listCheckIdentity.add(this.rootIdentity);
        listCheckIdentity.add(this.demoIdentity);
        listCheckIdentity.add(this.maryIdentity);
        listCheckIdentity.add(this.johnIdentity);
        List rootConfirmedRelationships = this.relationshipStorage.getRelationships(this.rootIdentity, Relationship.Type.CONFIRMED, listCheckIdentity);
        RelationshipStorageTest.assertNotNull((String)"rootConfirmedRelationships must not be null", (Object)rootConfirmedRelationships);
        RelationshipStorageTest.assertEquals((String)"rootConfirmedRelationships.size() must return: 1", (int)1, (int)rootConfirmedRelationships.size());
        List johnConfirmedRelationships = this.relationshipStorage.getRelationships(this.johnIdentity, Relationship.Type.CONFIRMED, listCheckIdentity);
        RelationshipStorageTest.assertNotNull((String)"johnConfirmedRelationships must not be null", (Object)johnConfirmedRelationships);
        RelationshipStorageTest.assertEquals((String)"johnConfirmedRelationships.size() must return: 1", (int)1, (int)johnConfirmedRelationships.size());
        List johnPendingRelationships = this.relationshipStorage.getRelationships(this.johnIdentity, Relationship.Type.PENDING, listCheckIdentity);
        RelationshipStorageTest.assertNotNull((String)"johnPendingRelationships must not be null", (Object)johnPendingRelationships);
        RelationshipStorageTest.assertEquals((String)"johnPendingRelationships.size() must return: 0", (int)0, (int)johnPendingRelationships.size());
        List maryPendingRelationships = this.relationshipStorage.getRelationships(this.maryIdentity, Relationship.Type.PENDING, listCheckIdentity);
        RelationshipStorageTest.assertNotNull((String)"maryPendingRelationships must not be null", (Object)maryPendingRelationships);
        RelationshipStorageTest.assertEquals((String)"maryPendingRelationships.size() must return: 1", (int)1, (int)maryPendingRelationships.size());
        List demoIgnoredRelationships = this.relationshipStorage.getRelationships(this.demoIdentity, Relationship.Type.IGNORED, listCheckIdentity);
        RelationshipStorageTest.assertNotNull((String)"demoIgnoredRelationships must not be null", (Object)demoIgnoredRelationships);
        RelationshipStorageTest.assertEquals((String)"demoIgnoredRelationships.size() must return: 1", (int)1, (int)demoIgnoredRelationships.size());
    }

    public void testGetSenderRelationshipsByIdentityAndType() throws RelationshipStorageException {
        Relationship rootToJohnRelationship = new Relationship(this.rootIdentity, this.johnIdentity, Relationship.Type.PENDING);
        Relationship rootToDemoRelationship = new Relationship(this.rootIdentity, this.demoIdentity, Relationship.Type.PENDING);
        this.relationshipStorage.saveRelationship(rootToJohnRelationship);
        this.relationshipStorage.saveRelationship(rootToDemoRelationship);
        List relationships = this.relationshipStorage.getSenderRelationships(this.rootIdentity, Relationship.Type.PENDING, null);
        RelationshipStorageTest.assertNotNull((Object)relationships);
        RelationshipStorageTest.assertEquals((int)2, (int)relationships.size());
        Relationship rootToMaryRelationship = new Relationship(this.rootIdentity, this.maryIdentity, Relationship.Type.CONFIRMED);
        this.relationshipStorage.saveRelationship(rootToMaryRelationship);
        relationships = this.relationshipStorage.getSenderRelationships(this.rootIdentity, Relationship.Type.CONFIRMED, null);
        RelationshipStorageTest.assertNotNull((Object)relationships);
        RelationshipStorageTest.assertEquals((int)1, (int)relationships.size());
        relationships = this.relationshipStorage.getSenderRelationships(this.rootIdentity, null, null);
        RelationshipStorageTest.assertNotNull((Object)relationships);
        RelationshipStorageTest.assertEquals((int)3, (int)relationships.size());
    }

    public void testGetSenderRelationships() throws Exception {
        String rootId = this.rootIdentity.getId();
        Relationship rootToJohnRelationship = new Relationship(this.rootIdentity, this.johnIdentity, Relationship.Type.PENDING);
        Relationship rootToDemoRelationship = new Relationship(this.rootIdentity, this.demoIdentity, Relationship.Type.PENDING);
        this.relationshipStorage.saveRelationship(rootToJohnRelationship);
        this.relationshipStorage.saveRelationship(rootToDemoRelationship);
        List relationships = this.relationshipStorage.getSenderRelationships(rootId, Relationship.Type.PENDING, null);
        RelationshipStorageTest.assertNotNull((Object)relationships);
        RelationshipStorageTest.assertEquals((int)2, (int)relationships.size());
        Relationship rootToMaryRelationship = new Relationship(this.rootIdentity, this.maryIdentity, Relationship.Type.CONFIRMED);
        this.relationshipStorage.saveRelationship(rootToMaryRelationship);
        relationships = this.relationshipStorage.getSenderRelationships(rootId, Relationship.Type.CONFIRMED, null);
        RelationshipStorageTest.assertNotNull((Object)relationships);
        RelationshipStorageTest.assertEquals((int)1, (int)relationships.size());
        relationships = this.relationshipStorage.getSenderRelationships(rootId, null, null);
        RelationshipStorageTest.assertNotNull((Object)relationships);
        RelationshipStorageTest.assertEquals((int)3, (int)relationships.size());
    }

    public void testGetRelationships() throws Exception {
        Relationship rootToJohnRelationship = new Relationship(this.rootIdentity, this.johnIdentity, Relationship.Type.PENDING);
        rootToJohnRelationship = this.relationshipStorage.saveRelationship(rootToJohnRelationship);
        RelationshipStorageTest.assertNotNull((String)"rootToJohnRelationship.getId() must not be null", (Object)rootToJohnRelationship.getId());
        Relationship rootToMaryRelationship = new Relationship(this.rootIdentity, this.maryIdentity, Relationship.Type.CONFIRMED);
        rootToMaryRelationship = this.relationshipStorage.saveRelationship(rootToMaryRelationship);
        RelationshipStorageTest.assertNotNull((String)"rootToMaryRelationship.getId() must not be null", (Object)rootToMaryRelationship.getId());
        Relationship rootToDemoRelationship = new Relationship(this.rootIdentity, this.demoIdentity, Relationship.Type.IGNORED);
        rootToDemoRelationship = this.relationshipStorage.saveRelationship(rootToDemoRelationship);
        RelationshipStorageTest.assertNotNull((String)"rootToDemoRelationship.getId() must not be null", (Object)rootToDemoRelationship.getId());
        List listIdentities = this.relationshipStorage.getRelationships(this.rootIdentity, 0L, 10L);
        RelationshipStorageTest.assertNotNull((String)"listIdentities must not be null", (Object)listIdentities);
        RelationshipStorageTest.assertEquals((String)"listIdentities.size() must return: 3", (int)3, (int)listIdentities.size());
    }

    public void testGetRelationshipsCount() throws Exception {
        Relationship rootToJohnRelationship = new Relationship(this.rootIdentity, this.johnIdentity, Relationship.Type.PENDING);
        rootToJohnRelationship = this.relationshipStorage.saveRelationship(rootToJohnRelationship);
        RelationshipStorageTest.assertNotNull((String)"rootToJohnRelationship.getId() must not be null", (Object)rootToJohnRelationship.getId());
        Relationship rootToMaryRelationship = new Relationship(this.rootIdentity, this.maryIdentity, Relationship.Type.CONFIRMED);
        rootToMaryRelationship = this.relationshipStorage.saveRelationship(rootToMaryRelationship);
        RelationshipStorageTest.assertNotNull((String)"rootToMaryRelationship.getId() must not be null", (Object)rootToMaryRelationship.getId());
        Relationship rootToDemoRelationship = new Relationship(this.rootIdentity, this.demoIdentity, Relationship.Type.IGNORED);
        rootToDemoRelationship = this.relationshipStorage.saveRelationship(rootToDemoRelationship);
        RelationshipStorageTest.assertNotNull((String)"rootToDemoRelationship.getId() must not be null", (Object)rootToDemoRelationship.getId());
        int count = this.relationshipStorage.getRelationshipsCount(this.rootIdentity);
        RelationshipStorageTest.assertEquals((String)"count must be: 3", (int)3, (int)count);
    }

    public void testGetConnectionsByFilterAndSort() {
        this.relationshipStorage.saveRelationship(new Relationship(this.rootIdentity, this.johnIdentity, Relationship.Type.CONFIRMED));
        this.relationshipStorage.saveRelationship(new Relationship(this.rootIdentity, this.maryIdentity, Relationship.Type.CONFIRMED));
        this.relationshipStorage.saveRelationship(new Relationship(this.rootIdentity, this.demoIdentity, Relationship.Type.CONFIRMED));
        ProfileFilter profileFilter = new ProfileFilter();
        profileFilter.setSorting(new Sorting(Sorting.SortBy.LASTNAME, Sorting.OrderBy.ASC));
        List connections = this.relationshipStorage.getConnectionsByFilter(this.rootIdentity, profileFilter, 0L, Integer.MAX_VALUE);
        RelationshipStorageTest.assertEquals((String)"Returned connections count is not consistent", (int)3, (int)connections.size());
        RelationshipStorageTest.assertEquals((String)"Returned connections seems not sorted correctly", (Object)"demo", (Object)((Identity)connections.get(0)).getProfile().getProperty("lastName"));
        RelationshipStorageTest.assertEquals((String)"Returned connections seems not sorted correctly", (Object)"john", (Object)((Identity)connections.get(1)).getProfile().getProperty("lastName"));
        RelationshipStorageTest.assertEquals((String)"Returned connections seems not sorted correctly", (Object)"mary", (Object)((Identity)connections.get(2)).getProfile().getProperty("lastName"));
        profileFilter.setSorting(new Sorting(Sorting.SortBy.LASTNAME, Sorting.OrderBy.DESC));
        connections = this.relationshipStorage.getConnectionsByFilter(this.rootIdentity, profileFilter, 0L, Integer.MAX_VALUE);
        RelationshipStorageTest.assertEquals((String)"Returned connections seems not sorted correctly", (Object)"demo", (Object)((Identity)connections.get(2)).getProfile().getProperty("lastName"));
        RelationshipStorageTest.assertEquals((String)"Returned connections seems not sorted correctly", (Object)"john", (Object)((Identity)connections.get(1)).getProfile().getProperty("lastName"));
        RelationshipStorageTest.assertEquals((String)"Returned connections seems not sorted correctly", (Object)"mary", (Object)((Identity)connections.get(0)).getProfile().getProperty("lastName"));
        connections = this.relationshipStorage.getConnectionsByFilter(this.rootIdentity, profileFilter, 0L, Integer.MAX_VALUE);
        RelationshipStorageTest.assertEquals((String)"Returned connections count is not consistent", (int)3, (int)connections.size());
        RelationshipStorageTest.assertEquals((String)"Returned connections seems not sorted correctly", (Object)"mary", (Object)((Identity)connections.get(0)).getProfile().getProperty("lastName"));
    }

    public void testGetIncomingByFilterAndSort() {
        this.relationshipStorage.saveRelationship(new Relationship(this.johnIdentity, this.rootIdentity, Relationship.Type.PENDING));
        this.relationshipStorage.saveRelationship(new Relationship(this.maryIdentity, this.rootIdentity, Relationship.Type.PENDING));
        this.relationshipStorage.saveRelationship(new Relationship(this.demoIdentity, this.rootIdentity, Relationship.Type.PENDING));
        ProfileFilter profileFilter = new ProfileFilter();
        profileFilter.setSorting(new Sorting(Sorting.SortBy.LASTNAME, Sorting.OrderBy.ASC));
        List connections = this.relationshipStorage.getIncomingByFilter(this.rootIdentity, profileFilter, 0L, Integer.MAX_VALUE);
        RelationshipStorageTest.assertEquals((String)"Returned connections count is not consistent", (int)3, (int)connections.size());
        RelationshipStorageTest.assertEquals((String)"Returned connections seems not sorted correctly", (Object)"demo", (Object)((Identity)connections.get(0)).getProfile().getProperty("lastName"));
        RelationshipStorageTest.assertEquals((String)"Returned connections seems not sorted correctly", (Object)"john", (Object)((Identity)connections.get(1)).getProfile().getProperty("lastName"));
        RelationshipStorageTest.assertEquals((String)"Returned connections seems not sorted correctly", (Object)"mary", (Object)((Identity)connections.get(2)).getProfile().getProperty("lastName"));
        profileFilter.setSorting(new Sorting(Sorting.SortBy.LASTNAME, Sorting.OrderBy.DESC));
        connections = this.relationshipStorage.getIncomingByFilter(this.rootIdentity, profileFilter, 0L, Integer.MAX_VALUE);
        RelationshipStorageTest.assertEquals((String)"Returned connections seems not sorted correctly", (Object)"demo", (Object)((Identity)connections.get(2)).getProfile().getProperty("lastName"));
        RelationshipStorageTest.assertEquals((String)"Returned connections seems not sorted correctly", (Object)"john", (Object)((Identity)connections.get(1)).getProfile().getProperty("lastName"));
        RelationshipStorageTest.assertEquals((String)"Returned connections seems not sorted correctly", (Object)"mary", (Object)((Identity)connections.get(0)).getProfile().getProperty("lastName"));
        connections = this.relationshipStorage.getIncomingByFilter(this.rootIdentity, profileFilter, 0L, Integer.MAX_VALUE);
        RelationshipStorageTest.assertEquals((String)"Returned connections count is not consistent", (int)3, (int)connections.size());
        RelationshipStorageTest.assertEquals((String)"Returned connections seems not sorted correctly", (Object)"mary", (Object)((Identity)connections.get(0)).getProfile().getProperty("lastName"));
    }

    public void testGetOutgoingByFilterAndSort() {
        this.relationshipStorage.saveRelationship(new Relationship(this.rootIdentity, this.johnIdentity, Relationship.Type.PENDING));
        this.relationshipStorage.saveRelationship(new Relationship(this.rootIdentity, this.maryIdentity, Relationship.Type.PENDING));
        this.relationshipStorage.saveRelationship(new Relationship(this.rootIdentity, this.demoIdentity, Relationship.Type.PENDING));
        ProfileFilter profileFilter = new ProfileFilter();
        profileFilter.setSorting(new Sorting(Sorting.SortBy.LASTNAME, Sorting.OrderBy.ASC));
        List connections = this.relationshipStorage.getOutgoingByFilter(this.rootIdentity, profileFilter, 0L, Integer.MAX_VALUE);
        RelationshipStorageTest.assertEquals((String)"Returned connections count is not consistent", (int)3, (int)connections.size());
        RelationshipStorageTest.assertEquals((String)"Returned connections seems not sorted correctly", (Object)"demo", (Object)((Identity)connections.get(0)).getProfile().getProperty("lastName"));
        RelationshipStorageTest.assertEquals((String)"Returned connections seems not sorted correctly", (Object)"john", (Object)((Identity)connections.get(1)).getProfile().getProperty("lastName"));
        RelationshipStorageTest.assertEquals((String)"Returned connections seems not sorted correctly", (Object)"mary", (Object)((Identity)connections.get(2)).getProfile().getProperty("lastName"));
        profileFilter.setSorting(new Sorting(Sorting.SortBy.LASTNAME, Sorting.OrderBy.DESC));
        connections = this.relationshipStorage.getOutgoingByFilter(this.rootIdentity, profileFilter, 0L, Integer.MAX_VALUE);
        RelationshipStorageTest.assertEquals((String)"Returned connections seems not sorted correctly", (Object)"demo", (Object)((Identity)connections.get(2)).getProfile().getProperty("lastName"));
        RelationshipStorageTest.assertEquals((String)"Returned connections seems not sorted correctly", (Object)"john", (Object)((Identity)connections.get(1)).getProfile().getProperty("lastName"));
        RelationshipStorageTest.assertEquals((String)"Returned connections seems not sorted correctly", (Object)"mary", (Object)((Identity)connections.get(0)).getProfile().getProperty("lastName"));
        connections = this.relationshipStorage.getOutgoingByFilter(this.rootIdentity, profileFilter, 0L, Integer.MAX_VALUE);
        RelationshipStorageTest.assertEquals((String)"Returned connections count is not consistent", (int)3, (int)connections.size());
        RelationshipStorageTest.assertEquals((String)"Returned connections seems not sorted correctly", (Object)"mary", (Object)((Identity)connections.get(0)).getProfile().getProperty("lastName"));
    }

    public void testGetIncomingRelationships() throws Exception {
        Relationship rootToJohnRelationship = new Relationship(this.rootIdentity, this.johnIdentity, Relationship.Type.PENDING);
        rootToJohnRelationship = this.relationshipStorage.saveRelationship(rootToJohnRelationship);
        RelationshipStorageTest.assertNotNull((String)"rootToJohnRelationship.getId() must not be null", (Object)rootToJohnRelationship.getId());
        Relationship maryToJohnRelationship = new Relationship(this.maryIdentity, this.johnIdentity, Relationship.Type.PENDING);
        maryToJohnRelationship = this.relationshipStorage.saveRelationship(maryToJohnRelationship);
        RelationshipStorageTest.assertNotNull((String)"rootToMaryRelationship.getId() must not be null", (Object)maryToJohnRelationship.getId());
        Relationship demoToJohnRelationship = new Relationship(this.demoIdentity, this.johnIdentity, Relationship.Type.CONFIRMED);
        demoToJohnRelationship = this.relationshipStorage.saveRelationship(demoToJohnRelationship);
        RelationshipStorageTest.assertNotNull((String)"rootToDemoRelationship.getId() must not be null", (Object)demoToJohnRelationship.getId());
        InputStream inputStream = ((Object)((Object)this)).getClass().getResourceAsStream("/eXo-Social.png");
        AvatarAttachment avatarAttachment = new AvatarAttachment(null, "avatar", "png", inputStream, System.currentTimeMillis());
        RelationshipStorageTest.assertNotNull((Object)avatarAttachment);
        InputStream inputStreamBanner = ((Object)((Object)this)).getClass().getResourceAsStream("/eXo-Social.png");
        BannerAttachment bannerAttachment = new BannerAttachment(null, "banner", "png", inputStreamBanner, System.currentTimeMillis());
        RelationshipStorageTest.assertNotNull((Object)bannerAttachment);
        Profile profile = this.maryIdentity.getProfile();
        profile.setProperty("avatar", (Object)avatarAttachment);
        profile.setProperty("banner", (Object)bannerAttachment);
        this.identityStorage.updateProfile(profile);
        List listIdentities = this.relationshipStorage.getIncomingRelationships(this.johnIdentity, 0L, 10L);
        RelationshipStorageTest.assertNotNull((String)"listIdentities must not be null", (Object)listIdentities);
        RelationshipStorageTest.assertEquals((String)"listIdentities.size() must return: 2", (int)2, (int)listIdentities.size());
        RelationshipStorageTest.assertNotNull((Object)this.getInList(listIdentities, "root").getProfile());
        RelationshipStorageTest.assertNotNull((Object)this.getInList(listIdentities, "root").getProfile().getAvatarUrl());
        RelationshipStorageTest.assertNotNull((Object)this.getInList(listIdentities, "root").getProfile().getBannerUrl());
        RelationshipStorageTest.assertNotNull((Object)this.getInList(listIdentities, "mary").getProfile());
        RelationshipStorageTest.assertNotNull((Object)this.getInList(listIdentities, "mary").getProfile().getAvatarUrl());
        RelationshipStorageTest.assertNotNull((Object)this.getInList(listIdentities, "mary").getProfile().getBannerUrl());
        for (Identity identity : listIdentities) {
            RelationshipStorageTest.assertNotNull((String)"identity.getProfile() must not be null", (Object)identity.getProfile());
            Identity identityLoadProfile = this.identityStorage.findIdentity("organization", identity.getRemoteId());
            RelationshipStorageTest.assertEquals((String)("identity.getProfile().getFullName() must return: " + identityLoadProfile.getProfile().getFullName()), (String)identityLoadProfile.getProfile().getFullName(), (String)identity.getProfile().getFullName());
        }
    }

    public void testGetIncomingRelationshipsCount() throws Exception {
        Relationship rootToJohnRelationship = new Relationship(this.rootIdentity, this.johnIdentity, Relationship.Type.PENDING);
        rootToJohnRelationship = this.relationshipStorage.saveRelationship(rootToJohnRelationship);
        RelationshipStorageTest.assertNotNull((String)"rootToJohnRelationship.getId() must not be null", (Object)rootToJohnRelationship.getId());
        Relationship maryToJohnRelationship = new Relationship(this.maryIdentity, this.johnIdentity, Relationship.Type.PENDING);
        maryToJohnRelationship = this.relationshipStorage.saveRelationship(maryToJohnRelationship);
        RelationshipStorageTest.assertNotNull((String)"rootToMaryRelationship.getId() must not be null", (Object)maryToJohnRelationship.getId());
        Relationship demoToJohnRelationship = new Relationship(this.demoIdentity, this.johnIdentity, Relationship.Type.CONFIRMED);
        demoToJohnRelationship = this.relationshipStorage.saveRelationship(demoToJohnRelationship);
        RelationshipStorageTest.assertNotNull((String)"rootToDemoRelationship.getId() must not be null", (Object)demoToJohnRelationship.getId());
        List listIdentities = this.relationshipStorage.getIncomingRelationships(this.johnIdentity, 0L, 10L);
        RelationshipStorageTest.assertNotNull((String)"listIdentities must not be null", (Object)listIdentities);
        RelationshipStorageTest.assertEquals((String)"listIdentities.size() must return: 2", (int)2, (int)listIdentities.size());
        int count = this.relationshipStorage.getIncomingRelationshipsCount(this.johnIdentity);
        RelationshipStorageTest.assertEquals((String)"count must be: 2", (int)2, (int)count);
    }

    public void testGetOutgoingRelationships() throws Exception {
        Relationship rootToJohnRelationship = new Relationship(this.rootIdentity, this.johnIdentity, Relationship.Type.PENDING);
        rootToJohnRelationship = this.relationshipStorage.saveRelationship(rootToJohnRelationship);
        RelationshipStorageTest.assertNotNull((String)"rootToJohnRelationship.getId() must not be null", (Object)rootToJohnRelationship.getId());
        Relationship rootToMaryRelationship = new Relationship(this.rootIdentity, this.maryIdentity, Relationship.Type.PENDING);
        rootToMaryRelationship = this.relationshipStorage.saveRelationship(rootToMaryRelationship);
        RelationshipStorageTest.assertNotNull((String)"rootToMaryRelationship.getId() must not be null", (Object)rootToMaryRelationship.getId());
        Relationship rootToDemoRelationship = new Relationship(this.rootIdentity, this.demoIdentity, Relationship.Type.IGNORED);
        rootToDemoRelationship = this.relationshipStorage.saveRelationship(rootToDemoRelationship);
        RelationshipStorageTest.assertNotNull((String)"rootToDemoRelationship.getId() must not be null", (Object)rootToDemoRelationship.getId());
        InputStream inputStream = ((Object)((Object)this)).getClass().getResourceAsStream("/eXo-Social.png");
        AvatarAttachment avatarAttachment = new AvatarAttachment(null, "avatar", "png", inputStream, System.currentTimeMillis());
        RelationshipStorageTest.assertNotNull((Object)avatarAttachment);
        InputStream inputStreamBanner = ((Object)((Object)this)).getClass().getResourceAsStream("/eXo-Social.png");
        BannerAttachment bannerAttachment = new BannerAttachment(null, "banner", "png", inputStreamBanner, System.currentTimeMillis());
        RelationshipStorageTest.assertNotNull((Object)bannerAttachment);
        Profile profile = this.johnIdentity.getProfile();
        profile.setProperty("avatar", (Object)avatarAttachment);
        profile.setProperty("banner", (Object)bannerAttachment);
        this.identityStorage.updateProfile(profile);
        List listIdentities = this.relationshipStorage.getOutgoingRelationships(this.rootIdentity, 0L, 10L);
        RelationshipStorageTest.assertNotNull((String)"listIdentities must not be null", (Object)listIdentities);
        RelationshipStorageTest.assertEquals((String)"listIdentities.size() must return: 2", (int)2, (int)listIdentities.size());
        listIdentities = this.relationshipStorage.getOutgoingRelationships(this.rootIdentity, 0L, 10L);
        this.demoIdentity = this.identityStorage.findIdentity("organization", this.demoIdentity.getRemoteId());
        RelationshipStorageTest.assertNotNull((Object)this.getInList(listIdentities, "john").getProfile());
        RelationshipStorageTest.assertNotNull((Object)this.getInList(listIdentities, "john").getProfile().getAvatarUrl());
        RelationshipStorageTest.assertNotNull((Object)this.getInList(listIdentities, "john").getProfile().getBannerUrl());
        RelationshipStorageTest.assertNotNull((Object)this.getInList(listIdentities, "mary").getProfile());
        RelationshipStorageTest.assertNotNull((Object)this.getInList(listIdentities, "mary").getProfile().getAvatarUrl());
        RelationshipStorageTest.assertNotNull((Object)this.getInList(listIdentities, "mary").getProfile().getBannerUrl());
        for (Identity identity : listIdentities) {
            Identity identityLoadProfile = this.identityStorage.findIdentity("organization", identity.getRemoteId());
            RelationshipStorageTest.assertNotNull((String)"identity.getProfile() must not be nul", (Object)identity.getProfile());
            RelationshipStorageTest.assertNotNull((String)"temp must not be null", (Object)identityLoadProfile);
            RelationshipStorageTest.assertEquals((String)("identity.getProfile().getFullName() must return: " + identityLoadProfile.getProfile().getFullName()), (String)identityLoadProfile.getProfile().getFullName(), (String)identity.getProfile().getFullName());
        }
    }

    public void testGetOutgoingRelationshipsCount() throws Exception {
        Relationship rootToJohnRelationship = new Relationship(this.rootIdentity, this.johnIdentity, Relationship.Type.PENDING);
        rootToJohnRelationship = this.relationshipStorage.saveRelationship(rootToJohnRelationship);
        RelationshipStorageTest.assertNotNull((String)"rootToJohnRelationship.getId() must not be null", (Object)rootToJohnRelationship.getId());
        Relationship rootToMaryRelationship = new Relationship(this.rootIdentity, this.maryIdentity, Relationship.Type.PENDING);
        rootToMaryRelationship = this.relationshipStorage.saveRelationship(rootToMaryRelationship);
        RelationshipStorageTest.assertNotNull((String)"rootToMaryRelationship.getId() must not be null", (Object)rootToMaryRelationship.getId());
        Relationship rootToDemoRelationship = new Relationship(this.rootIdentity, this.demoIdentity, Relationship.Type.IGNORED);
        rootToDemoRelationship = this.relationshipStorage.saveRelationship(rootToDemoRelationship);
        RelationshipStorageTest.assertNotNull((String)"rootToDemoRelationship.getId() must not be null", (Object)rootToDemoRelationship.getId());
        List listIdentities = this.relationshipStorage.getOutgoingRelationships(this.rootIdentity, 0L, 10L);
        RelationshipStorageTest.assertNotNull((String)"listIdentities must not be null", (Object)listIdentities);
        RelationshipStorageTest.assertEquals((String)"listIdentities.size() must return: 2", (int)2, (int)listIdentities.size());
        int count = this.relationshipStorage.getOutgoingRelationshipsCount(this.rootIdentity);
        RelationshipStorageTest.assertEquals((String)"count must be: 2", (int)2, (int)count);
    }

    public void testGetConnectionsByFilterEmpty() throws Exception {
        this.populateData();
        ProfileFilter pf = new ProfileFilter();
        pf = this.buildProfileFilterWithExcludeIdentities(pf);
        List identities = this.relationshipStorage.getConnectionsByFilter(this.tearDownIdentityList.get(0), pf, 0L, 20L);
        RelationshipStorageTest.assertEquals((String)("Number of identities must be " + identities.size()), (int)0, (int)identities.size());
    }

    public void testGetConnectionsByFilter() throws Exception {
        this.populateData();
        this.populateRelationshipData(Relationship.Type.CONFIRMED);
        ProfileFilter pf = new ProfileFilter();
        pf = this.buildProfileFilterWithExcludeIdentities(pf);
        List identities = this.relationshipStorage.getConnectionsByFilter(this.tearDownIdentityList.get(0), pf, 0L, 20L);
        RelationshipStorageTest.assertEquals((String)"Number of identities must be 8", (int)8, (int)identities.size());
        pf.setCompany("exo");
        identities = this.relationshipStorage.getConnectionsByFilter(this.tearDownIdentityList.get(0), pf, 0L, 20L);
        RelationshipStorageTest.assertEquals((String)"Number of identities must be 2", (int)2, (int)identities.size());
        pf.setPosition("developer");
        pf.setName("FirstName9");
        pf.setCompany("");
        identities = this.relationshipStorage.getConnectionsByFilter(this.tearDownIdentityList.get(0), pf, 0L, 20L);
        RelationshipStorageTest.assertEquals((String)"Number of identities must be 1", (int)1, (int)identities.size());
    }

    public void testGetConnectionsWithDisabledUser() throws Exception {
        this.populateData();
        this.populateRelationshipData(Relationship.Type.CONFIRMED);
        ProfileFilter pf = new ProfileFilter();
        List identities = this.relationshipStorage.getConnectionsByFilter(this.tearDownIdentityList.get(0), pf, 0L, 20L);
        RelationshipStorageTest.assertEquals((String)"Number of identities must be 8", (int)8, (int)identities.size());
        Identity id1 = (Identity)identities.get(2);
        Identity id2 = (Identity)identities.get(3);
        String disabledUserName = id1.getRemoteId();
        String deletedUserName = id2.getRemoteId();
        id1.setEnable(false);
        this.identityStorage.saveIdentity(id1);
        id2.setDeleted(true);
        this.identityStorage.saveIdentity(id2);
        identities = this.relationshipStorage.getConnectionsByFilter(this.tearDownIdentityList.get(0), pf, 0L, 10L);
        RelationshipStorageTest.assertEquals((String)"Number of identities must be 6", (int)6, (int)identities.size());
        RelationshipStorageTest.assertNull((String)("User " + disabledUserName + " must not be found in connections"), (Object)this.getInList(identities, disabledUserName));
        RelationshipStorageTest.assertNull((String)("User " + deletedUserName + " must not be found in connections"), (Object)this.getInList(identities, deletedUserName));
    }

    public void testGetIncomingByFilter() throws Exception {
        this.populateData();
        this.populateRelationshipIncommingData();
        ProfileFilter pf = new ProfileFilter();
        pf = this.buildProfileFilterWithExcludeIdentities(pf);
        List identities = this.relationshipStorage.getIncomingByFilter(this.tearDownIdentityList.get(0), pf, 0L, 20L);
        RelationshipStorageTest.assertEquals((String)("Number of identities must be " + identities.size()), (int)8, (int)identities.size());
        pf.setPosition("developer");
        pf.setName("FirstName6");
        identities = this.relationshipStorage.getIncomingByFilter(this.tearDownIdentityList.get(0), pf, 0L, 20L);
        RelationshipStorageTest.assertEquals((String)("Number of identities must be " + identities.size()), (int)1, (int)identities.size());
    }

    public void testGetOutgoingByFilter() throws Exception {
        this.populateData();
        this.populateRelationshipData(Relationship.Type.PENDING);
        ProfileFilter pf = new ProfileFilter();
        pf = this.buildProfileFilterWithExcludeIdentities(pf);
        List identities = this.relationshipStorage.getOutgoingByFilter(this.tearDownIdentityList.get(0), pf, 0L, 20L);
        RelationshipStorageTest.assertEquals((String)"Number of identities must be 8", (int)8, (int)identities.size());
        pf.setPosition("developer");
        pf.setName("FirstName8");
        identities = this.relationshipStorage.getOutgoingByFilter(this.tearDownIdentityList.get(0), pf, 0L, 20L);
        RelationshipStorageTest.assertEquals((String)"Number of identities must be 1", (int)1, (int)identities.size());
    }

    public void testGetIncomingCountByFilter() throws Exception {
        this.populateData();
        this.populateRelationshipIncommingData();
        ProfileFilter pf = new ProfileFilter();
        pf = this.buildProfileFilterWithExcludeIdentities(pf);
        int countIdentities = this.relationshipStorage.getIncomingCountByFilter(this.tearDownIdentityList.get(0), pf);
        RelationshipStorageTest.assertEquals((String)"Number of identities must be 8", (int)8, (int)countIdentities);
        pf.setPosition("developer");
        pf.setName("FirstName6");
        countIdentities = this.relationshipStorage.getIncomingCountByFilter(this.tearDownIdentityList.get(0), pf);
        RelationshipStorageTest.assertEquals((String)"Number of identities must be 1", (int)1, (int)countIdentities);
    }

    public void testGetConnectionsCountByFilter() throws Exception {
        this.populateData();
        this.populateRelationshipData(Relationship.Type.CONFIRMED);
        ProfileFilter pf = new ProfileFilter();
        pf = this.buildProfileFilterWithExcludeIdentities(pf);
        int countIdentities = this.relationshipStorage.getConnectionsCountByFilter(this.tearDownIdentityList.get(0), pf);
        RelationshipStorageTest.assertEquals((String)"Number of identities must be 8", (int)8, (int)countIdentities);
        pf.setPosition("developer");
        pf.setName("FirstName6");
        countIdentities = this.relationshipStorage.getConnectionsCountByFilter(this.tearDownIdentityList.get(0), pf);
        RelationshipStorageTest.assertEquals((String)"Number of identities must be 1", (int)1, (int)countIdentities);
    }

    public void testGetOutgoingCountByFilter() throws Exception {
        this.populateData();
        this.populateRelationshipData(Relationship.Type.PENDING);
        ProfileFilter pf = new ProfileFilter();
        pf = this.buildProfileFilterWithExcludeIdentities(pf);
        int countIdentities = this.relationshipStorage.getOutgoingCountByFilter(this.tearDownIdentityList.get(0), pf);
        RelationshipStorageTest.assertEquals((String)"Number of identities must be 8", (int)8, (int)countIdentities);
        pf.setPosition("developer");
        pf.setName("FirstName8");
        countIdentities = this.relationshipStorage.getOutgoingCountByFilter(this.tearDownIdentityList.get(0), pf);
        RelationshipStorageTest.assertEquals((String)"Number of identities must be 1", (int)1, (int)countIdentities);
    }

    private ProfileFilter buildProfileFilterWithExcludeIdentities(ProfileFilter filter) {
        ProfileFilter result = filter;
        if (result == null) {
            result = new ProfileFilter();
        }
        ArrayList<Identity> excludeIdentities = new ArrayList<Identity>();
        if (this.tearDownIdentityList.size() > 1) {
            Identity identity0 = this.tearDownIdentityList.get(0);
            excludeIdentities.add(identity0);
            result.setExcludedIdentityList(excludeIdentities);
        }
        return result;
    }

    private void populateRelationshipData(Relationship.Type type) {
        if (this.tearDownIdentityList.size() > 1) {
            Identity identity0 = this.tearDownIdentityList.get(0);
            Relationship firstToSecondRelationship = null;
            for (int i = 2; i < this.tearDownIdentityList.size(); ++i) {
                firstToSecondRelationship = new Relationship(identity0, this.tearDownIdentityList.get(i), type);
                this.relationshipStorage.saveRelationship(firstToSecondRelationship);
            }
        }
    }

    private void populateRelationshipIncommingData() {
        if (this.tearDownIdentityList.size() > 1) {
            Identity identity0 = this.tearDownIdentityList.get(0);
            Relationship firstToSecondRelationship = null;
            for (int i = 2; i < this.tearDownIdentityList.size(); ++i) {
                firstToSecondRelationship = new Relationship(this.tearDownIdentityList.get(i), identity0, Relationship.Type.PENDING);
                this.relationshipStorage.saveRelationship(firstToSecondRelationship);
            }
        }
    }

    private void populateData() {
        String providerId = "organization";
        int total = 10;
        HashMap<String, String> xp = new HashMap<String, String>();
        ArrayList<HashMap<String, String>> xps = new ArrayList<HashMap<String, String>>();
        xp.put("company", "exo");
        xps.add(xp);
        for (int i = 0; i < total; ++i) {
            String remoteId = "username" + i;
            Identity identity = new Identity(providerId, remoteId);
            this.identityStorage.saveIdentity(identity);
            Profile profile = new Profile(identity);
            profile.setProperty("firstName", (Object)("FirstName" + i));
            profile.setProperty("lastName", (Object)("LastName" + i));
            profile.setProperty("fullName", (Object)("FirstName" + i + " LastName" + i));
            profile.setProperty("position", (Object)"developer");
            profile.setProperty("gender", (Object)"male");
            if (i == 3 || i == 4) {
                profile.setProperty("experiences", xps);
            }
            identity.setProfile(profile);
            this.tearDownIdentityList.add(identity);
            this.identityStorage.saveProfile(profile);
        }
    }

    private Identity getInList(List<Identity> identities, String username) {
        if (identities != null) {
            for (Identity id : identities) {
                if (!id.getRemoteId().equals(username)) continue;
                return id;
            }
        }
        return null;
    }
}

